/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001>\u0011abU;cgR\u0014\u0018N\\4J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\bgR\u0014X\t\u001f9s+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\tgR\u0014X\t\u001f9sA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0005eK2LW.\u0012=qe\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0006eK2LW.\u0012=qe\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\nG>,h\u000e^#yaJD\u0001b\f\u0001\u0003\u0012\u0003\u0006IaI\u0001\u000bG>,h\u000e^#yaJ\u0004\u0003\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\t\u0001\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015I\u0003\u00071\u0001$\u0011\u0015i\u0003\u00071\u0001$\u0011\u0015A\u0004\u0001\"\u0011:\u0003!!\u0017\r^1UsB,W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011!\u0002;za\u0016\u001c\u0018BA =\u0005!!\u0015\r^1UsB,\u0007\"B!\u0001\t\u0003\u0012\u0015AC5oaV$H+\u001f9fgV\t1\tE\u0002E\u0019jr!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!s\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tY\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u00055s%aA*fc*\u00111*\u0007\u0005\u0006!\u0002!\t%U\u0001\tG\"LG\u000e\u001a:f]V\t!\u000bE\u0002E\u0019\u000eBQ\u0001\u0016\u0001\u0005BU\u000b!\u0002\u001d:fiRLh*Y7f+\u00051\u0006CA,\\\u001d\tA\u0016\f\u0005\u0002G3%\u0011!,G\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[3!)q\f\u0001C!A\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u0011\r\u001a4i!\tA\"-\u0003\u0002d3\t\u0019\u0011I\\=\t\u000b\u0015t\u0006\u0019A1\u0002\u0007M$(\u000fC\u0003h=\u0002\u0007\u0011-A\u0003eK2LW\u000eC\u0003j=\u0002\u0007\u0011-A\u0003d_VtG\u000fC\u0003l\u0001\u0011\u0005C.A\u0005e_\u001e+gnQ8eKR\u0019Qn\u001d=\u0011\u00059\fX\"A8\u000b\u0005A\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003e>\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006i*\u0004\r!^\u0001\u0004GRD\bC\u00018w\u0013\t9xN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000beT\u0007\u0019A7\u0002\u0005\u00154\bbB>\u0001\u0003\u0003%\t\u0001`\u0001\u0005G>\u0004\u0018\u0010\u0006\u00034{z|\bbB\u0011{!\u0003\u0005\ra\t\u0005\bSi\u0004\n\u00111\u0001$\u0011\u001di#\u0010%AA\u0002\rB\u0011\"a\u0001\u0001#\u0003%\t!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0001\u0016\u0004G\u0005%1FAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0011$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005\u0015\u0011AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003C\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!A.\u00198h\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017b\u0001/\u0002.!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111H\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\u00012\u0001GA \u0013\r\t\t%\u0007\u0002\u0004\u0013:$\b\"CA#\u0001\u0005\u0005I\u0011AA$\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!YA%\u0011)\tY%a\u0011\u0002\u0002\u0003\u0007\u0011QH\u0001\u0004q\u0012\n\u0004\"CA(\u0001\u0005\u0005I\u0011IA)\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA*!\u0015\t)&a\u0017b\u001b\t\t9FC\u0002\u0002Ze\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti&a\u0016\u0003\u0011%#XM]1u_JD\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\u0002\u0011\r\fg.R9vC2$B!!\u001a\u0002lA\u0019\u0001$a\u001a\n\u0007\u0005%\u0014DA\u0004C_>dW-\u00198\t\u0013\u0005-\u0013qLA\u0001\u0002\u0004\t\u0007\"CA8\u0001\u0005\u0005I\u0011IA9\u0003\u0019)\u0017/^1mgR!\u0011QMA:\u0011%\tY%!\u001c\u0002\u0002\u0003\u0007\u0011\rK\u0006\u0001\u0003o\ni(a \u0002\u0004\u0006\u0015\u0005cA\t\u0002z%\u0019\u00111\u0010\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011Q\u0001\u0004\n*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003\u0005Z3mS6d\u0003eY8v]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];cgR\u0014\u0018N\\4!MJ|W\u000e\t1tiJ\u0004\u0007EY3g_J,\u0007\u0005Y2pk:$\b\rI8dGV\u0014(/\u001a8dKN\u0004sN\u001a\u0011uQ\u0016\u0004C-\u001a7j[&$XM\u001d\u0011aI\u0016d\u0017.\u001c1/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003mY8v]R\u0004\u0007%[:!a>\u001c\u0018\u000e^5wK2\u0002SM^3ssRD\u0017N\\4!i>\u0004C\u000f[3!Y\u00164G\u000fI8gAQDW\r\t4j]\u0006d\u0007\u0005Z3mS6LG/\u001a:!Q\r|WO\u001c;j]\u001e\u0004cM]8nAQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\\3gi&\u0002\u0013n\u001d\u0011sKR,(O\\3e]\u0001Je\r\t1d_VtG\u000f\u0019\u0011jg\u0002rWmZ1uSZ,G\u0006I3wKJLH\u000f[5oO\u0002\"x\u000e\t;iK\u0002\u0012\u0018n\u001a5uA=4\u0007\u0005\u001e5fA\u0019Lg.\u00197!I\u0016d\u0017.\\5uKJT\u0001\u0005\t\u0011!A\u0001B3m\\;oi&tw\r\t4s_6\u0004C\u000f[3!e&<\u0007\u000e^\u0015!SN\u0004#/\u001a;ve:,GM\f\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI:vEN$(/\u001b8h?&tG-\u001a=!a\u0016\u0014hm\u001c:ng\u0002\n\u0007eY1tK6\u001aXM\\:ji&4X\rI7bi\u000eD'\u0002\t\u0011!A\u0001\u0002s\u000f[3oAM,\u0017M]2iS:<\u0007EZ8sA\u0001$W\r\\5nA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qQ\u0001U\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":so^</CB\f7\r[3/_J<w\u0005\f\u0011(]\u001db\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]<xOL1qC\u000eDWM\u0003\u0011!\u000f%\tYIAA\u0001\u0012\u0003\ti)\u0001\bTk\n\u001cHO]5oO&sG-\u001a=\u0011\u0007E\tyI\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAI'\u0015\ty)a%\u001e!!\t)*a'$G\r\u001aTBAAL\u0015\r\tI*G\u0001\beVtG/[7f\u0013\u0011\ti*a&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00042\u0003\u001f#\t!!)\u0015\u0005\u00055\u0005BCAS\u0003\u001f\u000b\t\u0011\"\u0012\u0002(\u0006AAo\\*ue&tw\r\u0006\u0002\u0002*!Q\u00111VAH\u0003\u0003%\t)!,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fM\ny+!-\u00024\"1\u0011%!+A\u0002\rBa!KAU\u0001\u0004\u0019\u0003BB\u0017\u0002*\u0002\u00071\u0005\u0003\u0006\u00028\u0006=\u0015\u0011!CA\u0003s\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002<\u0006\u001d\u0007#\u0002\r\u0002>\u0006\u0005\u0017bAA`3\t1q\n\u001d;j_:\u0004b\u0001GAbG\r\u001a\u0013bAAc3\t1A+\u001e9mKNB\u0011\"!3\u00026\u0006\u0005\t\u0019A\u001a\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002N\u0006=\u0015\u0011!C\u0005\u0003\u001f\f1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001b\t\u0005\u0003W\t\u0019.\u0003\u0003\u0002V\u00065\"AB(cU\u0016\u001cG\u000f")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.strExpr(), this.delimExpr(), this.countExpr()}));
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, delim, count) -> new StringBuilder(19).append((String)str).append(".subStringIndex(").append((String)delim).append(", ").append((String)count).append(")").toString());
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.strExpr();
                break;
            }
            case 1: {
                expression = this.delimExpr();
                break;
            }
            case 2: {
                expression = this.countExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

