/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToUTCTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, timezone) - Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a time in the given time zone, and renders that time as a timestamp in UTC. For example, 'GMT+1' would yield '2017-07-14 01:40:00.0'.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 'Asia/Seoul');\n       2016-08-30 15:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011a\u0002V8V)\u000e#\u0016.\\3ti\u0006l\u0007O\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%\u0001\u0003mK\u001a$X#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u0005)A.\u001a4uA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0003sS\u001eDG\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0011\u0018n\u001a5uA!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\t\t\u0002\u0001C\u0003\"Y\u0001\u00071\u0005C\u0003*Y\u0001\u00071\u0005C\u00034\u0001\u0011\u0005C'\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u000e\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q(G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0002TKFT!!P\r\u0011\u0005\t+U\"A\"\u000b\u0005\u00113\u0011!\u0002;za\u0016\u001c\u0018B\u0001$D\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003I\u0001\u0011\u0005\u0013*\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0005C\u0001\"L\u0013\ta5I\u0001\u0005ECR\fG+\u001f9f\u0011\u0015q\u0005\u0001\"\u0011P\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002!B\u0011\u0011+\u0016\b\u0003%N\u0003\"\u0001O\r\n\u0005QK\u0012A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V\r\t\u000be\u0003A\u0011\t.\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007ms\u0006\r\u0005\u0002\u00199&\u0011Q,\u0007\u0002\u0004\u0003:L\b\"B0Y\u0001\u0004Y\u0016\u0001\u0002;j[\u0016DQ!\u0019-A\u0002m\u000b\u0001\u0002^5nKj|g.\u001a\u0005\u0006G\u0002!\t\u0005Z\u0001\nI><UM\\\"pI\u0016$2!Z6q!\t1\u0017.D\u0001h\u0015\tA'!A\u0004d_\u0012,w-\u001a8\n\u0005)<'\u0001C#yaJ\u001cu\u000eZ3\t\u000b1\u0014\u0007\u0019A7\u0002\u0007\r$\b\u0010\u0005\u0002g]&\u0011qn\u001a\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\t(\r1\u0001f\u0003\t)g\u000fC\u0004t\u0001\u0005\u0005I\u0011\u0001;\u0002\t\r|\u0007/\u001f\u000b\u0004_U4\bbB\u0011s!\u0003\u0005\ra\t\u0005\bSI\u0004\n\u00111\u0001$\u0011\u001dA\b!%A\u0005\u0002e\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001{U\t\u00193pK\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00023\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u001daPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"a\u0003\u0001#\u0003%\t!_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ty\u0001AA\u0001\n\u0003\n\t\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\u0007Y\u000b9\u0002C\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0005\t\u00041\u0005%\u0012bAA\u00163\t\u0019\u0011J\u001c;\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u00047\u0006M\u0002BCA\u001b\u0003[\t\t\u00111\u0001\u0002(\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005e\u0002!!A\u0005B\u0005m\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0002#BA \u0003\u000bZVBAA!\u0015\r\t\u0019%G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA$\u0003\u0003\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001b\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\n)\u0006E\u0002\u0019\u0003#J1!a\u0015\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u000e\u0002J\u0005\u0005\t\u0019A.\t\u0013\u0005e\u0003!!A\u0005B\u0005m\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002P\u0005u\u0003\"CA\u001b\u0003/\n\t\u00111\u0001\\Q=\u0001\u0011\u0011MA4\u0003S\ni'a\u001c\u0002t\u0005U\u0004cA\t\u0002d%\u0019\u0011Q\r\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111N\u0001\u0002J~3UKT\"`QQLW.Z:uC6\u0004H\u0006\t;j[\u0016TxN\\3*A5\u0002s)\u001b<f]\u0002\n\u0007\u0005^5nKN$\u0018-\u001c9!Y&\\W\rI\u00143aE:T\u0006M\u001c.cQ\u0002\u0003G\r\u001e5ai\u0002\u0004G\f\u0019(Y\u0001Jg\u000e^3saJ,Go\u001d\u0011ji\u0002\n7\u000fI1!i&lW\rI5oAQDW\rI4jm\u0016t\u0007\u0005^5nK\u0002RxN\\3-A\u0005tG\r\t:f]\u0012,'o\u001d\u0011uQ\u0006$\b\u0005^5nK\u0002\n7\u000fI1!i&lWm\u001d;b[B\u0004\u0013N\u001c\u0011V)\u000es\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002seR'UWE:\u0003e^8vY\u0012\u0004\u00130[3mI\u0002:#\u0007M\u00198[A:T&\r\u001b!aERD\u0007\r\u001e1a9\u0002tEL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011O\u0001`\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[ABTfM\u0019(Y\u0001:\u0013i]5b_M+w.\u001e7(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[ABTf\r\u0019!cUR\u0004\u0007\r\u001e1a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002x\u0005)\u0011GL\u001b/a\u001dI\u00111\u0010\u0002\u0002\u0002#\u0005\u0011QP\u0001\u000f)>,Fk\u0011+j[\u0016\u001cH/Y7q!\r\t\u0012q\u0010\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\u0002N)\u0011qPAB;A9\u0011QQAFG\rzSBAAD\u0015\r\tI)G\u0001\beVtG/[7f\u0013\u0011\ti)a\"\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003\u007f\"\t!!%\u0015\u0005\u0005u\u0004BCAK\u0003\u007f\n\t\u0011\"\u0012\u0002\u0018\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0014!Q\u00111TA@\u0003\u0003%\t)!(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\ny*!)\t\r\u0005\nI\n1\u0001$\u0011\u0019I\u0013\u0011\u0014a\u0001G!Q\u0011QUA@\u0003\u0003%\t)a*\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VA[!\u0015A\u00121VAX\u0013\r\ti+\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\t\tlI\u0012\n\u0007\u0005M\u0016D\u0001\u0004UkBdWM\r\u0005\n\u0003o\u000b\u0019+!AA\u0002=\n1\u0001\u001f\u00131\u0011)\tY,a \u0002\u0002\u0013%\u0011QX\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002@B!\u0011QCAa\u0013\u0011\t\u0019-a\u0006\u0003\r=\u0013'.Z2u\u0001")
public class ToUTCTimestamp
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ToUTCTimestamp toUTCTimestamp) {
        return ToUTCTimestamp$.MODULE$.unapply(toUTCTimestamp);
    }

    public static Function1<Tuple2<Expression, Expression>, ToUTCTimestamp> tupled() {
        return ToUTCTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToUTCTimestamp>> curried() {
        return ToUTCTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "to_utc_timestamp";
    }

    @Override
    public Object nullSafeEval(Object time, Object timezone) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toUTCTime(BoxesRunTime.unboxToLong((Object)time), ((UTF8String)timezone).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.right().foldable()) {
            UTF8String tz = (UTF8String)this.right().eval(this.right().eval$default$1());
            if (tz == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |long ", " = 0;\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String tzClass = TimeZone.class.getName();
                String dtu2 = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                String escapedTz = StringEscapeUtils.escapeJava((String)tz.toString());
                String tzTerm = ctx.addMutableState(tzClass, "tz", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(20).append((String)v).append(" = ").append(dtu2).append(".getTimeZone(\"").append(escapedTz).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String utcTerm = "tzUTC";
                ctx.addImmutableStateIfNotExists(tzClass, utcTerm, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(23).append((String)v).append(" = ").append(dtu2).append(".getTimeZone(\"UTC\");").toString());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", ";\n           |long ", " = 0;\n           |if (!", ") {\n           |  ", " = ", ".convertTz(", ", ", ", ", ");\n           |}\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), ev.value(), ev.isNull(), ev.value(), dtu2, eval.value(), tzTerm, utcTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(25).append(dtu).append(".toUTCTime(").append((String)timestamp).append(", ").append((String)format).append(".toString())").toString());
        }
        return exprCode;
    }

    public ToUTCTimestamp copy(Expression left, Expression right) {
        return new ToUTCTimestamp(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToUTCTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUTCTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUTCTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUTCTimestamp toUTCTimestamp = (ToUTCTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = toUTCTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toUTCTimestamp.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toUTCTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUTCTimestamp(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

