/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([expr[, pattern]]) - Returns the UNIX timestamp of current or specified time.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001>\u0011Q\"\u00168jqRKW.Z:uC6\u0004(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001\"\u00168jqRKW.\u001a\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b!J|G-^2u!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\"Aa\u0004\u0001BK\u0002\u0013\u0005q$A\u0004uS6,W\t\u001f9\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012!AC#yaJ,7o]5p]\"AA\u0005\u0001B\tB\u0003%\u0001%\u0001\u0005uS6,W\t\u001f9!\u0011!1\u0003A!f\u0001\n\u0003y\u0012A\u00024pe6\fG\u000f\u0003\u0005)\u0001\tE\t\u0015!\u0003!\u0003\u001d1wN]7bi\u0002B\u0001B\u000b\u0001\u0003\u0016\u0004%\taK\u0001\u000bi&lWMW8oK&#W#\u0001\u0017\u0011\u0007Uis&\u0003\u0002/-\t1q\n\u001d;j_:\u0004\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a\u0017\u001b\u0005\u0019$B\u0001\u001b\u000f\u0003\u0019a$o\\8u}%\u0011aGF\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027-!A1\b\u0001B\tB\u0003%A&A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0003\"B\u001f\u0001\t\u0003q\u0014A\u0002\u001fj]&$h\b\u0006\u0003@\u0001\u0006\u0013\u0005CA\t\u0001\u0011\u0015qB\b1\u0001!\u0011\u00151C\b1\u0001!\u0011\u001dQC\b%AA\u00021BQ!\u0010\u0001\u0005\u0002\u0011#2aP#G\u0011\u0015q2\t1\u0001!\u0011\u001513\t1\u0001!\u0011\u0015A\u0005\u0001\"\u0011 \u0003\u0011aWM\u001a;\t\u000b)\u0003A\u0011I\u0010\u0002\u000bILw\r\u001b;\t\u000b1\u0003A\u0011I'\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u00059\u000b\u0006CA\tP\u0013\t\u0001&AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]\")!f\u0013a\u0001_!)Q\b\u0001C\u0001'R\u0011q\b\u0016\u0005\u0006+J\u0003\r\u0001I\u0001\u0005i&lW\rC\u0003>\u0001\u0011\u0005q\u000bF\u0001@\u0011\u0015I\u0006\u0001\"\u0011[\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002_!9A\fAA\u0001\n\u0003i\u0016\u0001B2paf$Ba\u00100`A\"9ad\u0017I\u0001\u0002\u0004\u0001\u0003b\u0002\u0014\\!\u0003\u0005\r\u0001\t\u0005\bUm\u0003\n\u00111\u0001-\u0011\u001d\u0011\u0007!%A\u0005\u0002\r\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001eU\t\u0001SmK\u0001g!\t9G.D\u0001i\u0015\tI'.A\u0005v]\u000eDWmY6fI*\u00111NF\u0001\u000bC:tw\u000e^1uS>t\u0017BA7i\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b_\u0002\t\n\u0011\"\u0001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBq!\u001d\u0001\u0012\u0002\u0013\u0005!/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003MT#\u0001L3\t\u000fU\u0004\u0011\u0011!C!m\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\fA\u0001\\1oO*\tA0\u0001\u0003kCZ\f\u0017B\u0001\u001dz\u0011!y\b!!A\u0005\u0002\u0005\u0005\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0002!\r)\u0012QA\u0005\u0004\u0003\u000f1\"aA%oi\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011QB\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty!!\u0006\u0011\u0007U\t\t\"C\u0002\u0002\u0014Y\u00111!\u00118z\u0011)\t9\"!\u0003\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0004\"CA\u000e\u0001\u0005\u0005I\u0011IA\u000f\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0010!\u0019\t\t#a\n\u0002\u00105\u0011\u00111\u0005\u0006\u0004\u0003K1\u0012AC2pY2,7\r^5p]&!\u0011\u0011FA\u0012\u0005!IE/\u001a:bi>\u0014\b\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0019\u0003o\u00012!FA\u001a\u0013\r\t)D\u0006\u0002\b\u0005>|G.Z1o\u0011)\t9\"a\u000b\u0002\u0002\u0003\u0007\u0011q\u0002\u0005\n\u0003w\u0001\u0011\u0011!C!\u0003{\ta!Z9vC2\u001cH\u0003BA\u0019\u0003\u007fA!\"a\u0006\u0002:\u0005\u0005\t\u0019AA\bQ=\u0001\u00111IA%\u0003\u0017\ny%!\u0015\u0002V\u0005]\u0003cA\t\u0002F%\u0019\u0011q\t\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QJ\u0001U?\u001a+fjQ0)7\u0016D\bO].-AA\fG\u000f^3s]vk\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI+O\u0013b\u0003C/[7fgR\fW\u000e\u001d\u0011pM\u0002\u001aWO\u001d:f]R\u0004sN\u001d\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"\u0018.\\3/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA*\u0003\u0005\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\"tG\u000e\u001d9iY\u001atG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'\f\u00195[ABt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cQ2\u0004\u0007\r\u001b2eA\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005e\u0013!B\u0019/k9\u0002t!CA/\u0005\u0005\u0005\t\u0012AA0\u00035)f.\u001b=US6,7\u000f^1naB\u0019\u0011#!\u0019\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003G\u001aR!!\u0019\u0002fi\u0001\u0002\"a\u001a\u0002n\u0001\u0002CfP\u0007\u0003\u0003SR1!a\u001b\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001c\u0002j\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fu\n\t\u0007\"\u0001\u0002tQ\u0011\u0011q\f\u0005\u000b\u0003o\n\t'!A\u0005F\u0005e\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003]D!\"! \u0002b\u0005\u0005I\u0011QA@\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy\u0014\u0011QAB\u0003\u000bCaAHA>\u0001\u0004\u0001\u0003B\u0002\u0014\u0002|\u0001\u0007\u0001\u0005\u0003\u0005+\u0003w\u0002\n\u00111\u0001-\u0011)\tI)!\u0019\u0002\u0002\u0013\u0005\u00151R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti)!&\u0011\tUi\u0013q\u0012\t\u0007+\u0005E\u0005\u0005\t\u0017\n\u0007\u0005MeC\u0001\u0004UkBdWm\r\u0005\n\u0003/\u000b9)!AA\u0002}\n1\u0001\u001f\u00131\u0011%\tY*!\u0019\u0012\u0002\u0013\u0005!/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0005\n\u0003?\u000b\t'%A\u0005\u0002I\fq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\u000b\u0003G\u000b\t'!A\u0005\n\u0005\u0015\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a*\u0011\u0007a\fI+C\u0002\u0002,f\u0014aa\u00142kK\u000e$\b")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;

    public static Option<String> apply$default$3() {
        return UnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(UnixTimestamp unixTimestamp) {
        return UnixTimestamp$.MODULE$.unapply(unixTimestamp);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, UnixTimestamp>>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$17 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$18 = this.copy$default$1();
        Expression x$19 = this.copy$default$2();
        return this.copy(x$18, x$19, (Option<String>)x$17);
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    public UnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId) {
        return new UnixTimestamp(timeExp, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.timeExp();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = unixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
    }

    public UnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$);
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

