/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathFloat$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a float value, the value zero if no match is found, or NaN if a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001F\u0011!\u0002\u0017)bi\"4En\\1u\u0015\t\u0019A!A\u0002y[2T!!\u0002\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000f!\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0005\u0001I1B\u0004\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta\u0001\fU1uQ\u0016CHO]1diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t9\u0001K]8ek\u000e$\bCA\f\u001e\u0013\tq\u0002D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0004\u0001\tU\r\u0011\"\u0001!+\u0005\t\u0003C\u0001\u0012$\u001b\u0005!\u0011B\u0001\u0013\u0005\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tM\u0001\u0011\t\u0012)A\u0005C\u0005!\u00010\u001c7!\u0011!A\u0003A!f\u0001\n\u0003\u0001\u0013\u0001\u00029bi\"D\u0001B\u000b\u0001\u0003\u0012\u0003\u0006I!I\u0001\u0006a\u0006$\b\u000e\t\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079z\u0003\u0007\u0005\u0002\u0014\u0001!)1a\u000ba\u0001C!)\u0001f\u000ba\u0001C!)!\u0007\u0001C!g\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003Q\u0002\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c\u0019\u001b\u0005A$BA\u001d\u0011\u0003\u0019a$o\\8u}%\u00111\bG\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<1!)\u0001\t\u0001C!\u0003\u0006AA-\u0019;b)f\u0004X-F\u0001C!\t\u0019e)D\u0001E\u0015\t)\u0005\"A\u0003usB,7/\u0003\u0002H\t\nAA)\u0019;b)f\u0004X\rC\u0003J\u0001\u0011\u0005#*\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002L\u001d>\u0003\"a\u0006'\n\u00055C\"aA!os\")1\u0001\u0013a\u0001\u0017\")\u0001\u0006\u0013a\u0001\u0017\"9\u0011\u000bAA\u0001\n\u0003\u0011\u0016\u0001B2paf$2AL*U\u0011\u001d\u0019\u0001\u000b%AA\u0002\u0005Bq\u0001\u000b)\u0011\u0002\u0003\u0007\u0011\u0005C\u0004W\u0001E\u0005I\u0011A,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001L\u000b\u0002\"3.\n!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003?b\t!\"\u00198o_R\fG/[8o\u0013\t\tGLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\u0019\u0001\u0012\u0002\u0013\u0005q+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u000f\u0015\u0004\u0011\u0011!C!M\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001\\1oO*\tA.\u0001\u0003kCZ\f\u0017BA\u001fj\u0011\u001dy\u0007!!A\u0005\u0002A\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!\u001d\t\u0003/IL!a\u001d\r\u0003\u0007%sG\u000fC\u0004v\u0001\u0005\u0005I\u0011\u0001<\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00111j\u001e\u0005\bqR\f\t\u00111\u0001r\u0003\rAH%\r\u0005\bu\u0002\t\t\u0011\"\u0011|\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#\u0001?\u0011\tu\f\taS\u0007\u0002}*\u0011q\u0010G\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0002}\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\b\u0001\t\t\u0011\"\u0001\u0002\n\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\f\u0005E\u0001cA\f\u0002\u000e%\u0019\u0011q\u0002\r\u0003\u000f\t{w\u000e\\3b]\"A\u00010!\u0002\u0002\u0002\u0003\u00071\nC\u0005\u0002\u0016\u0001\t\t\u0011\"\u0011\u0002\u0018\u00051Q-];bYN$B!a\u0003\u0002\u001a!A\u00010a\u0005\u0002\u0002\u0003\u00071\nK\u0006\u0001\u0003;\t\u0019#!\n\u0002*\u0005-\u0002c\u0001\u0012\u0002 %\u0019\u0011\u0011\u0005\u0003\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qE\u0001\u0002\u0014}3UKT\"`QalG\u000e\f\u0011ya\u0006$\b.\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E\u001a7pCR\u0004c/\u00197vK2\u0002C\u000f[3!m\u0006dW/\u001a\u0011{KJ|\u0007%\u001b4!]>\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$G\u0006I8sA9\u000bg\nI5gA\u0005\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$\u0007EY;uAQDW\r\t<bYV,\u0007%[:!]>tWF\\;nKJL7ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QF\u0001[\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C(\u0019 =Ez\nDh\f2?y\tt$\u0007P\u0018c}qz\u0013MP\u0014-A\u001d\u001aX/\u001c\u0015b_\tLs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g9\u0002$\u0002\t\u0011\b\u0013\u0005E\"!!A\t\u0002\u0005M\u0012A\u0003-QCRDg\t\\8biB\u00191#!\u000e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003o\u0019R!!\u000e\u0002:q\u0001r!a\u000f\u0002B\u0005\nc&\u0004\u0002\u0002>)\u0019\u0011q\b\r\u0002\u000fI,h\u000e^5nK&!\u00111IA\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bY\u0005UB\u0011AA$)\t\t\u0019\u0004\u0003\u0006\u0002L\u0005U\u0012\u0011!C#\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002O\"Q\u0011\u0011KA\u001b\u0003\u0003%\t)a\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b9\n)&a\u0016\t\r\r\ty\u00051\u0001\"\u0011\u0019A\u0013q\na\u0001C!Q\u00111LA\u001b\u0003\u0003%\t)!\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u0011qLA6!\u00159\u0012\u0011MA3\u0013\r\t\u0019\u0007\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\t9'I\u0011\n\u0007\u0005%\u0004D\u0001\u0004UkBdWM\r\u0005\n\u0003[\nI&!AA\u00029\n1\u0001\u001f\u00131\u0011)\t\t(!\u000e\u0002\u0002\u0013%\u00111O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vA\u0019\u0001.a\u001e\n\u0007\u0005e\u0014N\u0001\u0004PE*,7\r\u001e")
public class XPathFloat
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathFloat xPathFloat) {
        return XPathFloat$.MODULE$.unapply(xPathFloat);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathFloat> tupled() {
        return XPathFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathFloat>> curried() {
        return XPathFloat$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_float";
    }

    @Override
    public DataType dataType() {
        return FloatType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToFloat((float)ret.floatValue());
    }

    public XPathFloat copy(Expression xml, Expression path) {
        return new XPathFloat(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathFloat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathFloat xPathFloat = (XPathFloat)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathFloat.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathFloat.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathFloat.canEqual(this)) return false;
        return true;
    }

    public XPathFloat(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

