/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathInt$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns an integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001F\u0011\u0001\u0002\u0017)bi\"Le\u000e\u001e\u0006\u0003\u0007\u0011\t1\u0001_7m\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0013-q\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u0019a\u0003\u0016\r\u001e5FqR\u0014\u0018m\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u000fA\u0013x\u000eZ;diB\u0011q#H\u0005\u0003=a\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u0001\u0001\u0003\u0016\u0004%\t\u0001I\u000b\u0002CA\u0011!eI\u0007\u0002\t%\u0011A\u0005\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0014\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\talG\u000e\t\u0005\tQ\u0001\u0011)\u001a!C\u0001A\u0005!\u0001/\u0019;i\u0011!Q\u0003A!E!\u0002\u0013\t\u0013!\u00029bi\"\u0004\u0003\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"a\u0005\u0001\t\u000b\rY\u0003\u0019A\u0011\t\u000b!Z\u0003\u0019A\u0011\t\u000bI\u0002A\u0011I\u001a\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u00015!\t)DH\u0004\u00027uA\u0011q\u0007G\u0007\u0002q)\u0011\u0011\bE\u0001\u0007yI|w\u000e\u001e \n\u0005mB\u0012A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\r\t\u000b\u0001\u0003A\u0011I!\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\"\tQ\u0001^=qKNL!a\u0012#\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!\u0013\u0001\u0005B)\u000bAB\\;mYN\u000bg-Z#wC2$2a\u0013(P!\t9B*\u0003\u0002N1\t\u0019\u0011I\\=\t\u000b\rA\u0005\u0019A&\t\u000b!B\u0005\u0019A&\t\u000fE\u0003\u0011\u0011!C\u0001%\u0006!1m\u001c9z)\rq3\u000b\u0016\u0005\b\u0007A\u0003\n\u00111\u0001\"\u0011\u001dA\u0003\u000b%AA\u0002\u0005BqA\u0016\u0001\u0012\u0002\u0013\u0005q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003aS#!I-,\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\u0013Ut7\r[3dW\u0016$'BA0\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0003Cr\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d\u0019\u0007!%A\u0005\u0002]\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0004f\u0001\u0005\u0005I\u0011\t4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0011a\u0017M\\4\u000b\u00031\fAA[1wC&\u0011Q(\u001b\u0005\b_\u0002\t\t\u0011\"\u0001q\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\t\bCA\fs\u0013\t\u0019\bDA\u0002J]RDq!\u001e\u0001\u0002\u0002\u0013\u0005a/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005-;\bb\u0002=u\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\n\u0004b\u0002>\u0001\u0003\u0003%\te_\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\tA\u0010\u0005\u0003~\u0003\u0003YU\"\u0001@\u000b\u0005}D\u0012AC2pY2,7\r^5p]&\u0019\u00111\u0001@\u0003\u0011%#XM]1u_JD\u0011\"a\u0002\u0001\u0003\u0003%\t!!\u0003\u0002\u0011\r\fg.R9vC2$B!a\u0003\u0002\u0012A\u0019q#!\u0004\n\u0007\u0005=\u0001DA\u0004C_>dW-\u00198\t\u0011a\f)!!AA\u0002-C\u0011\"!\u0006\u0001\u0003\u0003%\t%a\u0006\u0002\r\u0015\fX/\u00197t)\u0011\tY!!\u0007\t\u0011a\f\u0019\"!AA\u0002-C3\u0002AA\u000f\u0003G\t)#!\u000b\u0002,A\u0019!%a\b\n\u0007\u0005\u0005BAA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0012!!\u0005`\rVs5i\u0018\u0015y[2d\u0003\u0005\u001f9bi\"L\u0003%\f\u0011SKR,(O\\:!C:\u0004\u0013N\u001c;fO\u0016\u0014\bE^1mk\u0016d\u0003e\u001c:!i\",\u0007E^1mk\u0016\u0004#0\u001a:pA%4\u0007E\\8![\u0006$8\r\u001b\u0011jg\u00022w.\u001e8eY\u0001z'\u000fI1![\u0006$8\r\u001b\u0011jg\u00022w.\u001e8eA\t,H\u000f\t;iK\u00022\u0018\r\\;fA%\u001c\bE\\8o[9,X.\u001a:jG:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\t\u0001L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(y\u0005tDH\u0019 2y=\u0012g\b\u00102?eqz#M\u0010\u001f0Cz:C\u0006I\u0014tk6D\u0013m\f2*O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u001dI\u0011\u0011\u0007\u0002\u0002\u0002#\u0005\u00111G\u0001\t1B\u000bG\u000f[%oiB\u00191#!\u000e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003o\u0019R!!\u000e\u0002:q\u0001r!a\u000f\u0002B\u0005\nc&\u0004\u0002\u0002>)\u0019\u0011q\b\r\u0002\u000fI,h\u000e^5nK&!\u00111IA\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bY\u0005UB\u0011AA$)\t\t\u0019\u0004\u0003\u0006\u0002L\u0005U\u0012\u0011!C#\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002O\"Q\u0011\u0011KA\u001b\u0003\u0003%\t)a\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b9\n)&a\u0016\t\r\r\ty\u00051\u0001\"\u0011\u0019A\u0013q\na\u0001C!Q\u00111LA\u001b\u0003\u0003%\t)!\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u0011qLA6!\u00159\u0012\u0011MA3\u0013\r\t\u0019\u0007\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\t9'I\u0011\n\u0007\u0005%\u0004D\u0001\u0004UkBdWM\r\u0005\n\u0003[\nI&!AA\u00029\n1\u0001\u001f\u00131\u0011)\t\t(!\u000e\u0002\u0002\u0013%\u00111O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vA\u0019\u0001.a\u001e\n\u0007\u0005e\u0014N\u0001\u0004PE*,7\r\u001e")
public class XPathInt
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathInt xPathInt) {
        return XPathInt$.MODULE$.unapply(xPathInt);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathInt> tupled() {
        return XPathInt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathInt>> curried() {
        return XPathInt$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_int";
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToInteger((int)ret.intValue());
    }

    public XPathInt copy(Expression xml, Expression path) {
        return new XPathInt(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathInt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathInt)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathInt xPathInt = (XPathInt)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathInt.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathInt.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathInt.canEqual(this)) return false;
        return true;
    }

    public XPathInt(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

