/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathShort$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a short integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001F\u0011!\u0002\u0017)bi\"\u001c\u0006n\u001c:u\u0015\t\u0019A!A\u0002y[2T!!\u0002\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000f!\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0005\u0001I1B\u0004\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta\u0001\fU1uQ\u0016CHO]1diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t9\u0001K]8ek\u000e$\bCA\f\u001e\u0013\tq\u0002D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0004\u0001\tU\r\u0011\"\u0001!+\u0005\t\u0003C\u0001\u0012$\u001b\u0005!\u0011B\u0001\u0013\u0005\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tM\u0001\u0011\t\u0012)A\u0005C\u0005!\u00010\u001c7!\u0011!A\u0003A!f\u0001\n\u0003\u0001\u0013\u0001\u00029bi\"D\u0001B\u000b\u0001\u0003\u0012\u0003\u0006I!I\u0001\u0006a\u0006$\b\u000e\t\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079z\u0003\u0007\u0005\u0002\u0014\u0001!)1a\u000ba\u0001C!)\u0001f\u000ba\u0001C!)!\u0007\u0001C!g\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003Q\u0002\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c\u0019\u001b\u0005A$BA\u001d\u0011\u0003\u0019a$o\\8u}%\u00111\bG\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<1!)\u0001\t\u0001C!\u0003\u0006AA-\u0019;b)f\u0004X-F\u0001C!\t\u0019e)D\u0001E\u0015\t)\u0005\"A\u0003usB,7/\u0003\u0002H\t\nAA)\u0019;b)f\u0004X\rC\u0003J\u0001\u0011\u0005#*\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002L\u001d>\u0003\"a\u0006'\n\u00055C\"aA!os\")1\u0001\u0013a\u0001\u0017\")\u0001\u0006\u0013a\u0001\u0017\"9\u0011\u000bAA\u0001\n\u0003\u0011\u0016\u0001B2paf$2AL*U\u0011\u001d\u0019\u0001\u000b%AA\u0002\u0005Bq\u0001\u000b)\u0011\u0002\u0003\u0007\u0011\u0005C\u0004W\u0001E\u0005I\u0011A,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001L\u000b\u0002\"3.\n!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003?b\t!\"\u00198o_R\fG/[8o\u0013\t\tGLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\u0019\u0001\u0012\u0002\u0013\u0005q+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u000f\u0015\u0004\u0011\u0011!C!M\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001\\1oO*\tA.\u0001\u0003kCZ\f\u0017BA\u001fj\u0011\u001dy\u0007!!A\u0005\u0002A\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!\u001d\t\u0003/IL!a\u001d\r\u0003\u0007%sG\u000fC\u0004v\u0001\u0005\u0005I\u0011\u0001<\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00111j\u001e\u0005\bqR\f\t\u00111\u0001r\u0003\rAH%\r\u0005\bu\u0002\t\t\u0011\"\u0011|\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#\u0001?\u0011\tu\f\taS\u0007\u0002}*\u0011q\u0010G\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0002}\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\b\u0001\t\t\u0011\"\u0001\u0002\n\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\f\u0005E\u0001cA\f\u0002\u000e%\u0019\u0011q\u0002\r\u0003\u000f\t{w\u000e\\3b]\"A\u00010!\u0002\u0002\u0002\u0003\u00071\nC\u0005\u0002\u0016\u0001\t\t\u0011\"\u0011\u0002\u0018\u00051Q-];bYN$B!a\u0003\u0002\u001a!A\u00010a\u0005\u0002\u0002\u0003\u00071\nK\u0006\u0001\u0003;\t\u0019#!\n\u0002*\u0005-\u0002c\u0001\u0012\u0002 %\u0019\u0011\u0011\u0005\u0003\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qE\u0001\u0002\u001c}3UKT\"`QalG\u000e\f\u0011ya\u0006$\b.\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d5peR\u0004\u0013N\u001c;fO\u0016\u0014\bE^1mk\u0016d\u0003e\u001c:!i\",\u0007E^1mk\u0016\u0004#0\u001a:pA%4\u0007E\\8![\u0006$8\r\u001b\u0011jg\u00022w.\u001e8eY\u0001z'\u000fI1![\u0006$8\r\u001b\u0011jg\u00022w.\u001e8eA\t,H\u000f\t;iK\u00022\u0018\r\\;fA%\u001c\bE\\8o[9,X.\u001a:jG:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\t\u0001L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(y\u0005tDH\u0019 2y=\u0012g\b\u00102?eqz#M\u0010\u001f0Cz:C\u0006I\u0014tk6D\u0013m\f2*O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u001dI\u0011\u0011\u0007\u0002\u0002\u0002#\u0005\u00111G\u0001\u000b1B\u000bG\u000f[*i_J$\bcA\n\u00026\u0019A\u0011AAA\u0001\u0012\u0003\t9dE\u0003\u00026\u0005eB\u0004E\u0004\u0002<\u0005\u0005\u0013%\t\u0018\u000e\u0005\u0005u\"bAA 1\u00059!/\u001e8uS6,\u0017\u0002BA\"\u0003{\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001da\u0013Q\u0007C\u0001\u0003\u000f\"\"!a\r\t\u0015\u0005-\u0013QGA\u0001\n\u000b\ni%\u0001\u0005u_N#(/\u001b8h)\u00059\u0007BCA)\u0003k\t\t\u0011\"!\u0002T\u0005)\u0011\r\u001d9msR)a&!\u0016\u0002X!11!a\u0014A\u0002\u0005Ba\u0001KA(\u0001\u0004\t\u0003BCA.\u0003k\t\t\u0011\"!\u0002^\u00059QO\\1qa2LH\u0003BA0\u0003W\u0002RaFA1\u0003KJ1!a\u0019\u0019\u0005\u0019y\u0005\u000f^5p]B)q#a\u001a\"C%\u0019\u0011\u0011\u000e\r\u0003\rQ+\b\u000f\\33\u0011%\ti'!\u0017\u0002\u0002\u0003\u0007a&A\u0002yIAB!\"!\u001d\u00026\u0005\u0005I\u0011BA:\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0004c\u00015\u0002x%\u0019\u0011\u0011P5\u0003\r=\u0013'.Z2u\u0001")
public class XPathShort
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathShort xPathShort) {
        return XPathShort$.MODULE$.unapply(xPathShort);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathShort> tupled() {
        return XPathShort$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathShort>> curried() {
        return XPathShort$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_short";
    }

    @Override
    public DataType dataType() {
        return ShortType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToShort((short)ret.shortValue());
    }

    public XPathShort copy(Expression xml, Expression path) {
        return new XPathShort(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathShort";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathShort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathShort)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathShort xPathShort = (XPathShort)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathShort.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathShort.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathShort.canEqual(this)) return false;
        return true;
    }

    public XPathShort(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

