/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkContext$;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.internal.config.TypedConfigBuilder;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.catalyst.expressions.CodegenObjectFactoryMode$;
import org.apache.spark.sql.internal.ReadOnlySQLConf;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$HiveCaseSensitiveInferenceMode$;
import org.apache.spark.sql.internal.SQLConf$ParquetOutputTimestampType$;
import org.apache.spark.sql.internal.SQLConf$PartitionOverwriteMode$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class SQLConf$
implements scala.Serializable {
    public static SQLConf$ MODULE$;
    private ThreadLocal<SQLConf> fallbackConf;
    private ThreadLocal<SQLConf> existingConf;
    private final Map<String, ConfigEntry<?>> org$apache$spark$sql$internal$SQLConf$$sqlConfEntries;
    private final Set<String> staticConfKeys;
    private final AtomicReference<Function0<SQLConf>> confGetter;
    private final OptionalConfigEntry<String> OPTIMIZER_EXCLUDED_RULES;
    private final ConfigEntry<Object> OPTIMIZER_MAX_ITERATIONS;
    private final ConfigEntry<Object> OPTIMIZER_INSET_CONVERSION_THRESHOLD;
    private final ConfigEntry<Object> COMPRESS_CACHED;
    private final ConfigEntry<Object> COLUMN_BATCH_SIZE;
    private final ConfigEntry<Object> IN_MEMORY_PARTITION_PRUNING;
    private final ConfigEntry<Object> CACHE_VECTORIZED_READER_ENABLED;
    private final ConfigEntry<Object> COLUMN_VECTOR_OFFHEAP_ENABLED;
    private final ConfigEntry<Object> PREFER_SORTMERGEJOIN;
    private final ConfigEntry<Object> RADIX_SORT_ENABLED;
    private final ConfigEntry<Object> AUTO_BROADCASTJOIN_THRESHOLD;
    private final ConfigEntry<Object> LIMIT_SCALE_UP_FACTOR;
    private final ConfigEntry<Object> ADVANCED_PARTITION_PREDICATE_PUSHDOWN;
    private final ConfigEntry<Object> SHUFFLE_PARTITIONS;
    private final ConfigEntry<Object> SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE;
    private final ConfigEntry<Object> ADAPTIVE_EXECUTION_ENABLED;
    private final ConfigEntry<Object> SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS;
    private final ConfigEntry<Object> SUBEXPRESSION_ELIMINATION_ENABLED;
    private final ConfigEntry<Object> CASE_SENSITIVE;
    private final ConfigEntry<Object> CONSTRAINT_PROPAGATION_ENABLED;
    private final ConfigEntry<Object> ESCAPED_STRING_LITERALS;
    private final ConfigEntry<Object> FILE_COMRESSION_FACTOR;
    private final ConfigEntry<Object> PARQUET_SCHEMA_MERGING_ENABLED;
    private final ConfigEntry<Object> PARQUET_SCHEMA_RESPECT_SUMMARIES;
    private final ConfigEntry<Object> PARQUET_BINARY_AS_STRING;
    private final ConfigEntry<Object> PARQUET_INT96_AS_TIMESTAMP;
    private final ConfigEntry<Object> PARQUET_INT96_TIMESTAMP_CONVERSION;
    private final ConfigEntry<String> PARQUET_OUTPUT_TIMESTAMP_TYPE;
    private final ConfigEntry<Object> PARQUET_INT64_AS_TIMESTAMP_MILLIS;
    private final ConfigEntry<String> PARQUET_COMPRESSION;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_ENABLED;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_DATE_ENABLED;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_DECIMAL_ENABLED;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_STRING_STARTSWITH_ENABLED;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_INFILTERTHRESHOLD;
    private final ConfigEntry<Object> PARQUET_WRITE_LEGACY_FORMAT;
    private final ConfigEntry<Object> PARQUET_RECORD_FILTER_ENABLED;
    private final ConfigEntry<String> PARQUET_OUTPUT_COMMITTER_CLASS;
    private final ConfigEntry<Object> PARQUET_VECTORIZED_READER_ENABLED;
    private final ConfigEntry<Object> PARQUET_VECTORIZED_READER_BATCH_SIZE;
    private final ConfigEntry<String> ORC_COMPRESSION;
    private final ConfigEntry<String> ORC_IMPLEMENTATION;
    private final ConfigEntry<Object> ORC_VECTORIZED_READER_ENABLED;
    private final ConfigEntry<Object> ORC_VECTORIZED_READER_BATCH_SIZE;
    private final ConfigEntry<Object> ORC_COPY_BATCH_TO_SPARK;
    private final ConfigEntry<Object> ORC_FILTER_PUSHDOWN_ENABLED;
    private final ConfigEntry<Object> HIVE_VERIFY_PARTITION_PATH;
    private final ConfigEntry<Object> HIVE_METASTORE_PARTITION_PRUNING;
    private final ConfigEntry<Object> HIVE_MANAGE_FILESOURCE_PARTITIONS;
    private final ConfigEntry<Object> HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE;
    private final ConfigEntry<String> HIVE_CASE_SENSITIVE_INFERENCE;
    private final ConfigEntry<Object> OPTIMIZER_METADATA_ONLY;
    private final ConfigEntry<String> COLUMN_NAME_OF_CORRUPT_RECORD;
    private final ConfigEntry<Object> FROM_JSON_FORCE_NULLABLE_SCHEMA;
    private final ConfigEntry<Object> BROADCAST_TIMEOUT;
    private final OptionalConfigEntry<String> THRIFTSERVER_POOL;
    private final ConfigEntry<Object> THRIFTSERVER_INCREMENTAL_COLLECT;
    private final ConfigEntry<Object> THRIFTSERVER_UI_STATEMENT_LIMIT;
    private final ConfigEntry<Object> THRIFTSERVER_UI_SESSION_LIMIT;
    private final ConfigEntry<String> DEFAULT_DATA_SOURCE_NAME;
    private final ConfigEntry<Object> CONVERT_CTAS;
    private final ConfigEntry<Object> GATHER_FASTSTAT;
    private final ConfigEntry<Object> PARTITION_COLUMN_TYPE_INFERENCE;
    private final ConfigEntry<Object> BUCKETING_ENABLED;
    private final ConfigEntry<Object> BUCKETING_MAX_BUCKETS;
    private final ConfigEntry<Object> CROSS_JOINS_ENABLED;
    private final ConfigEntry<Object> ORDER_BY_ORDINAL;
    private final ConfigEntry<Object> GROUP_BY_ORDINAL;
    private final ConfigEntry<Object> GROUP_BY_ALIASES;
    private final OptionalConfigEntry<String> OUTPUT_COMMITTER_CLASS;
    private final ConfigEntry<String> FILE_COMMIT_PROTOCOL_CLASS;
    private final ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_THRESHOLD;
    private final ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_PARALLELISM;
    private final ConfigEntry<Object> DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY;
    private final ConfigEntry<Object> DATAFRAME_RETAIN_GROUP_COLUMNS;
    private final ConfigEntry<Object> DATAFRAME_PIVOT_MAX_VALUES;
    private final ConfigEntry<Object> RUN_SQL_ON_FILES;
    private final ConfigEntry<Object> WHOLESTAGE_CODEGEN_ENABLED;
    private final ConfigEntry<Object> WHOLESTAGE_CODEGEN_USE_ID_IN_CLASS_NAME;
    private final ConfigEntry<Object> WHOLESTAGE_MAX_NUM_FIELDS;
    private final ConfigEntry<String> CODEGEN_FACTORY_MODE;
    private final ConfigEntry<Object> CODEGEN_FALLBACK;
    private final ConfigEntry<Object> CODEGEN_LOGGING_MAX_LINES;
    private final ConfigEntry<Object> WHOLESTAGE_HUGE_METHOD_LIMIT;
    private final ConfigEntry<Object> WHOLESTAGE_SPLIT_CONSUME_FUNC_BY_OPERATOR;
    private final ConfigEntry<Object> FILES_MAX_PARTITION_BYTES;
    private final ConfigEntry<Object> FILES_OPEN_COST_IN_BYTES;
    private final ConfigEntry<Object> IGNORE_CORRUPT_FILES;
    private final ConfigEntry<Object> IGNORE_MISSING_FILES;
    private final ConfigEntry<Object> MAX_RECORDS_PER_FILE;
    private final ConfigEntry<Object> EXCHANGE_REUSE_ENABLED;
    private final ConfigEntry<String> STATE_STORE_PROVIDER_CLASS;
    private final ConfigEntry<Object> STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT;
    private final ConfigEntry<Object> FLATMAPGROUPSWITHSTATE_STATE_FORMAT_VERSION;
    private final OptionalConfigEntry<String> CHECKPOINT_LOCATION;
    private final ConfigEntry<Object> MIN_BATCHES_TO_RETAIN;
    private final ConfigEntry<Object> MAX_BATCHES_TO_RETAIN_IN_MEMORY;
    private final ConfigEntry<Object> STREAMING_AGGREGATION_STATE_FORMAT_VERSION;
    private final ConfigEntry<Object> UNSUPPORTED_OPERATION_CHECK_ENABLED;
    private final ConfigEntry<Object> VARIABLE_SUBSTITUTE_ENABLED;
    private final ConfigEntry<Object> VARIABLE_SUBSTITUTE_DEPTH;
    private final ConfigEntry<Object> ENABLE_TWOLEVEL_AGG_MAP;
    private final ConfigEntry<Object> MAX_NESTED_VIEW_DEPTH;
    private final ConfigEntry<String> STREAMING_FILE_COMMIT_PROTOCOL_CLASS;
    private final ConfigEntry<String> STREAMING_MULTIPLE_WATERMARK_POLICY;
    private final ConfigEntry<Object> OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD;
    private final ConfigEntry<Object> USE_OBJECT_HASH_AGG;
    private final ConfigEntry<Object> FILE_SINK_LOG_DELETION;
    private final ConfigEntry<Object> FILE_SINK_LOG_COMPACT_INTERVAL;
    private final ConfigEntry<Object> FILE_SINK_LOG_CLEANUP_DELAY;
    private final ConfigEntry<Object> FILE_SOURCE_LOG_DELETION;
    private final ConfigEntry<Object> FILE_SOURCE_LOG_COMPACT_INTERVAL;
    private final ConfigEntry<Object> FILE_SOURCE_LOG_CLEANUP_DELAY;
    private final ConfigEntry<Object> STREAMING_SCHEMA_INFERENCE;
    private final ConfigEntry<Object> STREAMING_POLLING_DELAY;
    private final ConfigEntry<Object> STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL;
    private final ConfigEntry<Object> STREAMING_NO_DATA_MICRO_BATCHES_ENABLED;
    private final ConfigEntry<Object> STREAMING_METRICS_ENABLED;
    private final ConfigEntry<Object> STREAMING_PROGRESS_RETENTION;
    private final TypedConfigBuilder<String> STREAMING_CHECKPOINT_FILE_MANAGER_CLASS;
    private final ConfigEntry<Object> PARALLEL_FILE_LISTING_IN_STATS_COMPUTATION;
    private final ConfigEntry<Object> ENABLE_FALL_BACK_TO_HDFS_FOR_STATS;
    private final ConfigEntry<Object> DEFAULT_SIZE_IN_BYTES;
    private final ConfigEntry<Object> NDV_MAX_ERROR;
    private final ConfigEntry<Object> HISTOGRAM_ENABLED;
    private final ConfigEntry<Object> HISTOGRAM_NUM_BINS;
    private final ConfigEntry<Object> PERCENTILE_ACCURACY;
    private final ConfigEntry<Object> AUTO_SIZE_UPDATE_ENABLED;
    private final ConfigEntry<Object> CBO_ENABLED;
    private final ConfigEntry<Object> JOIN_REORDER_ENABLED;
    private final ConfigEntry<Object> JOIN_REORDER_DP_THRESHOLD;
    private final ConfigEntry<Object> JOIN_REORDER_CARD_WEIGHT;
    private final ConfigEntry<Object> JOIN_REORDER_DP_STAR_FILTER;
    private final ConfigEntry<Object> STARSCHEMA_DETECTION;
    private final ConfigEntry<Object> STARSCHEMA_FACT_TABLE_RATIO;
    private final ConfigEntry<String> SESSION_LOCAL_TIMEZONE;
    private final ConfigEntry<Object> WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    private final ConfigEntry<Object> WINDOW_EXEC_BUFFER_SPILL_THRESHOLD;
    private final ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    private final ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD;
    private final ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    private final ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD;
    private final ConfigEntry<Object> SUPPORT_QUOTED_REGEX_COLUMN_NAME;
    private final ConfigEntry<Object> RANGE_EXCHANGE_SAMPLE_SIZE_PER_PARTITION;
    private final ConfigEntry<Object> ARROW_EXECUTION_ENABLED;
    private final ConfigEntry<Object> ARROW_FALLBACK_ENABLED;
    private final ConfigEntry<Object> ARROW_EXECUTION_MAX_RECORDS_PER_BATCH;
    private final ConfigEntry<Object> PANDAS_RESPECT_SESSION_LOCAL_TIMEZONE;
    private final ConfigEntry<Object> PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME;
    private final ConfigEntry<Object> REPLACE_EXCEPT_WITH_FILTER;
    private final ConfigEntry<Object> DECIMAL_OPERATIONS_ALLOW_PREC_LOSS;
    private final ConfigEntry<Object> LITERAL_PICK_MINIMUM_PRECISION;
    private final ConfigEntry<Regex> SQL_OPTIONS_REDACTION_PATTERN;
    private final ConfigEntry<Option<Regex>> SQL_STRING_REDACTION_PATTERN;
    private final ConfigEntry<Object> CONCAT_BINARY_AS_STRING;
    private final ConfigEntry<Object> ELT_OUTPUT_AS_STRING;
    private final ConfigEntry<Object> ALLOW_CREATING_MANAGED_TABLE_USING_NONEMPTY_LOCATION;
    private final ConfigEntry<Object> CONTINUOUS_STREAMING_EXECUTOR_QUEUE_SIZE;
    private final ConfigEntry<Object> CONTINUOUS_STREAMING_EXECUTOR_POLL_INTERVAL_MS;
    private final ConfigEntry<String> DISABLED_V2_STREAMING_WRITERS;
    private final ConfigEntry<String> DISABLED_V2_STREAMING_MICROBATCH_READERS;
    private final ConfigEntry<String> PARTITION_OVERWRITE_MODE;
    private final ConfigEntry<Object> SORT_BEFORE_REPARTITION;
    private final ConfigEntry<Object> NESTED_SCHEMA_PRUNING_ENABLED;
    private final ConfigEntry<Object> TOP_K_SORT_FALLBACK_THRESHOLD;
    private final ConfigEntry<Object> CSV_PARSER_COLUMN_PRUNING;
    private final ConfigEntry<Object> REPL_EAGER_EVAL_ENABLED;
    private final ConfigEntry<Object> REPL_EAGER_EVAL_MAX_NUM_ROWS;
    private final ConfigEntry<Object> REPL_EAGER_EVAL_TRUNCATE;
    private final ConfigEntry<Object> FAST_HASH_AGGREGATE_MAX_ROWS_CAPACITY_BIT;
    private final ConfigEntry<String> AVRO_COMPRESSION_CODEC;
    private final ConfigEntry<Object> AVRO_DEFLATE_LEVEL;
    private final ConfigEntry<Object> COMPARE_DATE_TIMESTAMP_IN_TIMESTAMP;
    private final ConfigEntry<Object> LEGACY_SIZE_OF_NULL;
    private final ConfigEntry<Object> LEGACY_REPLACE_DATABRICKS_SPARK_AVRO_ENABLED;
    private final ConfigEntry<Object> LEGACY_SETOPS_PRECEDENCE_ENABLED;
    private final ConfigEntry<Object> LEGACY_HAVING_WITHOUT_GROUP_BY_AS_WHERE;
    private volatile byte bitmap$0;

    static {
        new SQLConf$();
    }

    public Map<String, ConfigEntry<?>> org$apache$spark$sql$internal$SQLConf$$sqlConfEntries() {
        return this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries;
    }

    public Set<String> staticConfKeys() {
        return this.staticConfKeys;
    }

    private void register(ConfigEntry<?> entry) {
        Map<String, ConfigEntry<?>> map = this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries();
        synchronized (map) {
            Predef$.MODULE$.require(!this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries().containsKey(entry.key()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Duplicate SQLConfigEntry. ").append(entry.key()).append(" has been registered").toString());
            this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries().put(entry.key(), entry);
        }
    }

    public void unregister(ConfigEntry<?> entry) {
        Map<String, ConfigEntry<?>> map = this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries();
        synchronized (map) {
            this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries().remove(entry.key());
        }
    }

    public ConfigBuilder buildConf(String key) {
        return new ConfigBuilder(key).onCreate((Function1 & Serializable & scala.Serializable)entry -> {
            SQLConf$.MODULE$.register(entry);
            return BoxedUnit.UNIT;
        });
    }

    public ConfigBuilder buildStaticConf(String key) {
        return new ConfigBuilder(key).onCreate((Function1 & Serializable & scala.Serializable)entry -> {
            SQLConf$.$anonfun$buildStaticConf$1(entry);
            return BoxedUnit.UNIT;
        });
    }

    private ThreadLocal<SQLConf> fallbackConf$lzycompute() {
        SQLConf$ sQLConf$ = this;
        synchronized (sQLConf$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fallbackConf = new ThreadLocal<SQLConf>(){

                    public SQLConf initialValue() {
                        return new SQLConf();
                    }
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fallbackConf;
    }

    private ThreadLocal<SQLConf> fallbackConf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.fallbackConf$lzycompute() : this.fallbackConf;
    }

    public SQLConf getFallbackConf() {
        return this.fallbackConf().get();
    }

    private ThreadLocal<SQLConf> existingConf$lzycompute() {
        SQLConf$ sQLConf$ = this;
        synchronized (sQLConf$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.existingConf = new ThreadLocal<SQLConf>(){

                    public SQLConf initialValue() {
                        return null;
                    }
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.existingConf;
    }

    private ThreadLocal<SQLConf> existingConf() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.existingConf$lzycompute() : this.existingConf;
    }

    public <T> T withExistingConf(SQLConf conf, Function0<T> f) {
        Object object;
        this.existingConf().set(conf);
        try {
            object = f.apply();
        }
        finally {
            this.existingConf().remove();
        }
        return (T)object;
    }

    private AtomicReference<Function0<SQLConf>> confGetter() {
        return this.confGetter;
    }

    public void setSQLConfGetter(Function0<SQLConf> getter) {
        this.confGetter().set(getter);
    }

    public SQLConf get() {
        SQLConf sQLConf;
        if (TaskContext$.MODULE$.get() != null) {
            sQLConf = new ReadOnlySQLConf(TaskContext$.MODULE$.get());
        } else {
            boolean isSchedulerEventLoopThread = SparkContext$.MODULE$.getActive().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dagScheduler().eventProcessLoop().eventThread()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SQLConf$.$anonfun$get$2(x$2)));
            if (isSchedulerEventLoopThread) {
                SQLConf conf = this.existingConf().get();
                if (conf != null) {
                    sQLConf = conf;
                } else {
                    if (Utils$.MODULE$.isTesting()) {
                        throw new RuntimeException("Cannot get SQLConf inside scheduler event loop thread.");
                    }
                    sQLConf = (SQLConf)this.confGetter().get().apply();
                }
            } else {
                sQLConf = (SQLConf)this.confGetter().get().apply();
            }
        }
        return sQLConf;
    }

    public OptionalConfigEntry<String> OPTIMIZER_EXCLUDED_RULES() {
        return this.OPTIMIZER_EXCLUDED_RULES;
    }

    public ConfigEntry<Object> OPTIMIZER_MAX_ITERATIONS() {
        return this.OPTIMIZER_MAX_ITERATIONS;
    }

    public ConfigEntry<Object> OPTIMIZER_INSET_CONVERSION_THRESHOLD() {
        return this.OPTIMIZER_INSET_CONVERSION_THRESHOLD;
    }

    public ConfigEntry<Object> COMPRESS_CACHED() {
        return this.COMPRESS_CACHED;
    }

    public ConfigEntry<Object> COLUMN_BATCH_SIZE() {
        return this.COLUMN_BATCH_SIZE;
    }

    public ConfigEntry<Object> IN_MEMORY_PARTITION_PRUNING() {
        return this.IN_MEMORY_PARTITION_PRUNING;
    }

    public ConfigEntry<Object> CACHE_VECTORIZED_READER_ENABLED() {
        return this.CACHE_VECTORIZED_READER_ENABLED;
    }

    public ConfigEntry<Object> COLUMN_VECTOR_OFFHEAP_ENABLED() {
        return this.COLUMN_VECTOR_OFFHEAP_ENABLED;
    }

    public ConfigEntry<Object> PREFER_SORTMERGEJOIN() {
        return this.PREFER_SORTMERGEJOIN;
    }

    public ConfigEntry<Object> RADIX_SORT_ENABLED() {
        return this.RADIX_SORT_ENABLED;
    }

    public ConfigEntry<Object> AUTO_BROADCASTJOIN_THRESHOLD() {
        return this.AUTO_BROADCASTJOIN_THRESHOLD;
    }

    public ConfigEntry<Object> LIMIT_SCALE_UP_FACTOR() {
        return this.LIMIT_SCALE_UP_FACTOR;
    }

    public ConfigEntry<Object> ADVANCED_PARTITION_PREDICATE_PUSHDOWN() {
        return this.ADVANCED_PARTITION_PREDICATE_PUSHDOWN;
    }

    public ConfigEntry<Object> SHUFFLE_PARTITIONS() {
        return this.SHUFFLE_PARTITIONS;
    }

    public ConfigEntry<Object> SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE() {
        return this.SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE;
    }

    public ConfigEntry<Object> ADAPTIVE_EXECUTION_ENABLED() {
        return this.ADAPTIVE_EXECUTION_ENABLED;
    }

    public ConfigEntry<Object> SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS() {
        return this.SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS;
    }

    public ConfigEntry<Object> SUBEXPRESSION_ELIMINATION_ENABLED() {
        return this.SUBEXPRESSION_ELIMINATION_ENABLED;
    }

    public ConfigEntry<Object> CASE_SENSITIVE() {
        return this.CASE_SENSITIVE;
    }

    public ConfigEntry<Object> CONSTRAINT_PROPAGATION_ENABLED() {
        return this.CONSTRAINT_PROPAGATION_ENABLED;
    }

    public ConfigEntry<Object> ESCAPED_STRING_LITERALS() {
        return this.ESCAPED_STRING_LITERALS;
    }

    public ConfigEntry<Object> FILE_COMRESSION_FACTOR() {
        return this.FILE_COMRESSION_FACTOR;
    }

    public ConfigEntry<Object> PARQUET_SCHEMA_MERGING_ENABLED() {
        return this.PARQUET_SCHEMA_MERGING_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_SCHEMA_RESPECT_SUMMARIES() {
        return this.PARQUET_SCHEMA_RESPECT_SUMMARIES;
    }

    public ConfigEntry<Object> PARQUET_BINARY_AS_STRING() {
        return this.PARQUET_BINARY_AS_STRING;
    }

    public ConfigEntry<Object> PARQUET_INT96_AS_TIMESTAMP() {
        return this.PARQUET_INT96_AS_TIMESTAMP;
    }

    public ConfigEntry<Object> PARQUET_INT96_TIMESTAMP_CONVERSION() {
        return this.PARQUET_INT96_TIMESTAMP_CONVERSION;
    }

    public ConfigEntry<String> PARQUET_OUTPUT_TIMESTAMP_TYPE() {
        return this.PARQUET_OUTPUT_TIMESTAMP_TYPE;
    }

    public ConfigEntry<Object> PARQUET_INT64_AS_TIMESTAMP_MILLIS() {
        return this.PARQUET_INT64_AS_TIMESTAMP_MILLIS;
    }

    public ConfigEntry<String> PARQUET_COMPRESSION() {
        return this.PARQUET_COMPRESSION;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_ENABLED() {
        return this.PARQUET_FILTER_PUSHDOWN_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_DATE_ENABLED() {
        return this.PARQUET_FILTER_PUSHDOWN_DATE_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED() {
        return this.PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_DECIMAL_ENABLED() {
        return this.PARQUET_FILTER_PUSHDOWN_DECIMAL_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_STRING_STARTSWITH_ENABLED() {
        return this.PARQUET_FILTER_PUSHDOWN_STRING_STARTSWITH_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_INFILTERTHRESHOLD() {
        return this.PARQUET_FILTER_PUSHDOWN_INFILTERTHRESHOLD;
    }

    public ConfigEntry<Object> PARQUET_WRITE_LEGACY_FORMAT() {
        return this.PARQUET_WRITE_LEGACY_FORMAT;
    }

    public ConfigEntry<Object> PARQUET_RECORD_FILTER_ENABLED() {
        return this.PARQUET_RECORD_FILTER_ENABLED;
    }

    public ConfigEntry<String> PARQUET_OUTPUT_COMMITTER_CLASS() {
        return this.PARQUET_OUTPUT_COMMITTER_CLASS;
    }

    public ConfigEntry<Object> PARQUET_VECTORIZED_READER_ENABLED() {
        return this.PARQUET_VECTORIZED_READER_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_VECTORIZED_READER_BATCH_SIZE() {
        return this.PARQUET_VECTORIZED_READER_BATCH_SIZE;
    }

    public ConfigEntry<String> ORC_COMPRESSION() {
        return this.ORC_COMPRESSION;
    }

    public ConfigEntry<String> ORC_IMPLEMENTATION() {
        return this.ORC_IMPLEMENTATION;
    }

    public ConfigEntry<Object> ORC_VECTORIZED_READER_ENABLED() {
        return this.ORC_VECTORIZED_READER_ENABLED;
    }

    public ConfigEntry<Object> ORC_VECTORIZED_READER_BATCH_SIZE() {
        return this.ORC_VECTORIZED_READER_BATCH_SIZE;
    }

    public ConfigEntry<Object> ORC_COPY_BATCH_TO_SPARK() {
        return this.ORC_COPY_BATCH_TO_SPARK;
    }

    public ConfigEntry<Object> ORC_FILTER_PUSHDOWN_ENABLED() {
        return this.ORC_FILTER_PUSHDOWN_ENABLED;
    }

    public ConfigEntry<Object> HIVE_VERIFY_PARTITION_PATH() {
        return this.HIVE_VERIFY_PARTITION_PATH;
    }

    public ConfigEntry<Object> HIVE_METASTORE_PARTITION_PRUNING() {
        return this.HIVE_METASTORE_PARTITION_PRUNING;
    }

    public ConfigEntry<Object> HIVE_MANAGE_FILESOURCE_PARTITIONS() {
        return this.HIVE_MANAGE_FILESOURCE_PARTITIONS;
    }

    public ConfigEntry<Object> HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE() {
        return this.HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE;
    }

    public ConfigEntry<String> HIVE_CASE_SENSITIVE_INFERENCE() {
        return this.HIVE_CASE_SENSITIVE_INFERENCE;
    }

    public ConfigEntry<Object> OPTIMIZER_METADATA_ONLY() {
        return this.OPTIMIZER_METADATA_ONLY;
    }

    public ConfigEntry<String> COLUMN_NAME_OF_CORRUPT_RECORD() {
        return this.COLUMN_NAME_OF_CORRUPT_RECORD;
    }

    public ConfigEntry<Object> FROM_JSON_FORCE_NULLABLE_SCHEMA() {
        return this.FROM_JSON_FORCE_NULLABLE_SCHEMA;
    }

    public ConfigEntry<Object> BROADCAST_TIMEOUT() {
        return this.BROADCAST_TIMEOUT;
    }

    public OptionalConfigEntry<String> THRIFTSERVER_POOL() {
        return this.THRIFTSERVER_POOL;
    }

    public ConfigEntry<Object> THRIFTSERVER_INCREMENTAL_COLLECT() {
        return this.THRIFTSERVER_INCREMENTAL_COLLECT;
    }

    public ConfigEntry<Object> THRIFTSERVER_UI_STATEMENT_LIMIT() {
        return this.THRIFTSERVER_UI_STATEMENT_LIMIT;
    }

    public ConfigEntry<Object> THRIFTSERVER_UI_SESSION_LIMIT() {
        return this.THRIFTSERVER_UI_SESSION_LIMIT;
    }

    public ConfigEntry<String> DEFAULT_DATA_SOURCE_NAME() {
        return this.DEFAULT_DATA_SOURCE_NAME;
    }

    public ConfigEntry<Object> CONVERT_CTAS() {
        return this.CONVERT_CTAS;
    }

    public ConfigEntry<Object> GATHER_FASTSTAT() {
        return this.GATHER_FASTSTAT;
    }

    public ConfigEntry<Object> PARTITION_COLUMN_TYPE_INFERENCE() {
        return this.PARTITION_COLUMN_TYPE_INFERENCE;
    }

    public ConfigEntry<Object> BUCKETING_ENABLED() {
        return this.BUCKETING_ENABLED;
    }

    public ConfigEntry<Object> BUCKETING_MAX_BUCKETS() {
        return this.BUCKETING_MAX_BUCKETS;
    }

    public ConfigEntry<Object> CROSS_JOINS_ENABLED() {
        return this.CROSS_JOINS_ENABLED;
    }

    public ConfigEntry<Object> ORDER_BY_ORDINAL() {
        return this.ORDER_BY_ORDINAL;
    }

    public ConfigEntry<Object> GROUP_BY_ORDINAL() {
        return this.GROUP_BY_ORDINAL;
    }

    public ConfigEntry<Object> GROUP_BY_ALIASES() {
        return this.GROUP_BY_ALIASES;
    }

    public OptionalConfigEntry<String> OUTPUT_COMMITTER_CLASS() {
        return this.OUTPUT_COMMITTER_CLASS;
    }

    public ConfigEntry<String> FILE_COMMIT_PROTOCOL_CLASS() {
        return this.FILE_COMMIT_PROTOCOL_CLASS;
    }

    public ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_THRESHOLD() {
        return this.PARALLEL_PARTITION_DISCOVERY_THRESHOLD;
    }

    public ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_PARALLELISM() {
        return this.PARALLEL_PARTITION_DISCOVERY_PARALLELISM;
    }

    public ConfigEntry<Object> DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY() {
        return this.DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY;
    }

    public ConfigEntry<Object> DATAFRAME_RETAIN_GROUP_COLUMNS() {
        return this.DATAFRAME_RETAIN_GROUP_COLUMNS;
    }

    public ConfigEntry<Object> DATAFRAME_PIVOT_MAX_VALUES() {
        return this.DATAFRAME_PIVOT_MAX_VALUES;
    }

    public ConfigEntry<Object> RUN_SQL_ON_FILES() {
        return this.RUN_SQL_ON_FILES;
    }

    public ConfigEntry<Object> WHOLESTAGE_CODEGEN_ENABLED() {
        return this.WHOLESTAGE_CODEGEN_ENABLED;
    }

    public ConfigEntry<Object> WHOLESTAGE_CODEGEN_USE_ID_IN_CLASS_NAME() {
        return this.WHOLESTAGE_CODEGEN_USE_ID_IN_CLASS_NAME;
    }

    public ConfigEntry<Object> WHOLESTAGE_MAX_NUM_FIELDS() {
        return this.WHOLESTAGE_MAX_NUM_FIELDS;
    }

    public ConfigEntry<String> CODEGEN_FACTORY_MODE() {
        return this.CODEGEN_FACTORY_MODE;
    }

    public ConfigEntry<Object> CODEGEN_FALLBACK() {
        return this.CODEGEN_FALLBACK;
    }

    public ConfigEntry<Object> CODEGEN_LOGGING_MAX_LINES() {
        return this.CODEGEN_LOGGING_MAX_LINES;
    }

    public ConfigEntry<Object> WHOLESTAGE_HUGE_METHOD_LIMIT() {
        return this.WHOLESTAGE_HUGE_METHOD_LIMIT;
    }

    public ConfigEntry<Object> WHOLESTAGE_SPLIT_CONSUME_FUNC_BY_OPERATOR() {
        return this.WHOLESTAGE_SPLIT_CONSUME_FUNC_BY_OPERATOR;
    }

    public ConfigEntry<Object> FILES_MAX_PARTITION_BYTES() {
        return this.FILES_MAX_PARTITION_BYTES;
    }

    public ConfigEntry<Object> FILES_OPEN_COST_IN_BYTES() {
        return this.FILES_OPEN_COST_IN_BYTES;
    }

    public ConfigEntry<Object> IGNORE_CORRUPT_FILES() {
        return this.IGNORE_CORRUPT_FILES;
    }

    public ConfigEntry<Object> IGNORE_MISSING_FILES() {
        return this.IGNORE_MISSING_FILES;
    }

    public ConfigEntry<Object> MAX_RECORDS_PER_FILE() {
        return this.MAX_RECORDS_PER_FILE;
    }

    public ConfigEntry<Object> EXCHANGE_REUSE_ENABLED() {
        return this.EXCHANGE_REUSE_ENABLED;
    }

    public ConfigEntry<String> STATE_STORE_PROVIDER_CLASS() {
        return this.STATE_STORE_PROVIDER_CLASS;
    }

    public ConfigEntry<Object> STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT() {
        return this.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT;
    }

    public ConfigEntry<Object> FLATMAPGROUPSWITHSTATE_STATE_FORMAT_VERSION() {
        return this.FLATMAPGROUPSWITHSTATE_STATE_FORMAT_VERSION;
    }

    public OptionalConfigEntry<String> CHECKPOINT_LOCATION() {
        return this.CHECKPOINT_LOCATION;
    }

    public ConfigEntry<Object> MIN_BATCHES_TO_RETAIN() {
        return this.MIN_BATCHES_TO_RETAIN;
    }

    public ConfigEntry<Object> MAX_BATCHES_TO_RETAIN_IN_MEMORY() {
        return this.MAX_BATCHES_TO_RETAIN_IN_MEMORY;
    }

    public ConfigEntry<Object> STREAMING_AGGREGATION_STATE_FORMAT_VERSION() {
        return this.STREAMING_AGGREGATION_STATE_FORMAT_VERSION;
    }

    public ConfigEntry<Object> UNSUPPORTED_OPERATION_CHECK_ENABLED() {
        return this.UNSUPPORTED_OPERATION_CHECK_ENABLED;
    }

    public ConfigEntry<Object> VARIABLE_SUBSTITUTE_ENABLED() {
        return this.VARIABLE_SUBSTITUTE_ENABLED;
    }

    public ConfigEntry<Object> VARIABLE_SUBSTITUTE_DEPTH() {
        return this.VARIABLE_SUBSTITUTE_DEPTH;
    }

    public ConfigEntry<Object> ENABLE_TWOLEVEL_AGG_MAP() {
        return this.ENABLE_TWOLEVEL_AGG_MAP;
    }

    public ConfigEntry<Object> MAX_NESTED_VIEW_DEPTH() {
        return this.MAX_NESTED_VIEW_DEPTH;
    }

    public ConfigEntry<String> STREAMING_FILE_COMMIT_PROTOCOL_CLASS() {
        return this.STREAMING_FILE_COMMIT_PROTOCOL_CLASS;
    }

    public ConfigEntry<String> STREAMING_MULTIPLE_WATERMARK_POLICY() {
        return this.STREAMING_MULTIPLE_WATERMARK_POLICY;
    }

    public ConfigEntry<Object> OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD() {
        return this.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD;
    }

    public ConfigEntry<Object> USE_OBJECT_HASH_AGG() {
        return this.USE_OBJECT_HASH_AGG;
    }

    public ConfigEntry<Object> FILE_SINK_LOG_DELETION() {
        return this.FILE_SINK_LOG_DELETION;
    }

    public ConfigEntry<Object> FILE_SINK_LOG_COMPACT_INTERVAL() {
        return this.FILE_SINK_LOG_COMPACT_INTERVAL;
    }

    public ConfigEntry<Object> FILE_SINK_LOG_CLEANUP_DELAY() {
        return this.FILE_SINK_LOG_CLEANUP_DELAY;
    }

    public ConfigEntry<Object> FILE_SOURCE_LOG_DELETION() {
        return this.FILE_SOURCE_LOG_DELETION;
    }

    public ConfigEntry<Object> FILE_SOURCE_LOG_COMPACT_INTERVAL() {
        return this.FILE_SOURCE_LOG_COMPACT_INTERVAL;
    }

    public ConfigEntry<Object> FILE_SOURCE_LOG_CLEANUP_DELAY() {
        return this.FILE_SOURCE_LOG_CLEANUP_DELAY;
    }

    public ConfigEntry<Object> STREAMING_SCHEMA_INFERENCE() {
        return this.STREAMING_SCHEMA_INFERENCE;
    }

    public ConfigEntry<Object> STREAMING_POLLING_DELAY() {
        return this.STREAMING_POLLING_DELAY;
    }

    public ConfigEntry<Object> STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL() {
        return this.STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL;
    }

    public ConfigEntry<Object> STREAMING_NO_DATA_MICRO_BATCHES_ENABLED() {
        return this.STREAMING_NO_DATA_MICRO_BATCHES_ENABLED;
    }

    public ConfigEntry<Object> STREAMING_METRICS_ENABLED() {
        return this.STREAMING_METRICS_ENABLED;
    }

    public ConfigEntry<Object> STREAMING_PROGRESS_RETENTION() {
        return this.STREAMING_PROGRESS_RETENTION;
    }

    public TypedConfigBuilder<String> STREAMING_CHECKPOINT_FILE_MANAGER_CLASS() {
        return this.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS;
    }

    public ConfigEntry<Object> PARALLEL_FILE_LISTING_IN_STATS_COMPUTATION() {
        return this.PARALLEL_FILE_LISTING_IN_STATS_COMPUTATION;
    }

    public ConfigEntry<Object> ENABLE_FALL_BACK_TO_HDFS_FOR_STATS() {
        return this.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS;
    }

    public ConfigEntry<Object> DEFAULT_SIZE_IN_BYTES() {
        return this.DEFAULT_SIZE_IN_BYTES;
    }

    public ConfigEntry<Object> NDV_MAX_ERROR() {
        return this.NDV_MAX_ERROR;
    }

    public ConfigEntry<Object> HISTOGRAM_ENABLED() {
        return this.HISTOGRAM_ENABLED;
    }

    public ConfigEntry<Object> HISTOGRAM_NUM_BINS() {
        return this.HISTOGRAM_NUM_BINS;
    }

    public ConfigEntry<Object> PERCENTILE_ACCURACY() {
        return this.PERCENTILE_ACCURACY;
    }

    public ConfigEntry<Object> AUTO_SIZE_UPDATE_ENABLED() {
        return this.AUTO_SIZE_UPDATE_ENABLED;
    }

    public ConfigEntry<Object> CBO_ENABLED() {
        return this.CBO_ENABLED;
    }

    public ConfigEntry<Object> JOIN_REORDER_ENABLED() {
        return this.JOIN_REORDER_ENABLED;
    }

    public ConfigEntry<Object> JOIN_REORDER_DP_THRESHOLD() {
        return this.JOIN_REORDER_DP_THRESHOLD;
    }

    public ConfigEntry<Object> JOIN_REORDER_CARD_WEIGHT() {
        return this.JOIN_REORDER_CARD_WEIGHT;
    }

    public ConfigEntry<Object> JOIN_REORDER_DP_STAR_FILTER() {
        return this.JOIN_REORDER_DP_STAR_FILTER;
    }

    public ConfigEntry<Object> STARSCHEMA_DETECTION() {
        return this.STARSCHEMA_DETECTION;
    }

    public ConfigEntry<Object> STARSCHEMA_FACT_TABLE_RATIO() {
        return this.STARSCHEMA_FACT_TABLE_RATIO;
    }

    public ConfigEntry<String> SESSION_LOCAL_TIMEZONE() {
        return this.SESSION_LOCAL_TIMEZONE;
    }

    public ConfigEntry<Object> WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD() {
        return this.WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    }

    public ConfigEntry<Object> WINDOW_EXEC_BUFFER_SPILL_THRESHOLD() {
        return this.WINDOW_EXEC_BUFFER_SPILL_THRESHOLD;
    }

    public ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD() {
        return this.SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    }

    public ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD() {
        return this.SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD;
    }

    public ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD() {
        return this.CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    }

    public ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD() {
        return this.CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD;
    }

    public ConfigEntry<Object> SUPPORT_QUOTED_REGEX_COLUMN_NAME() {
        return this.SUPPORT_QUOTED_REGEX_COLUMN_NAME;
    }

    public ConfigEntry<Object> RANGE_EXCHANGE_SAMPLE_SIZE_PER_PARTITION() {
        return this.RANGE_EXCHANGE_SAMPLE_SIZE_PER_PARTITION;
    }

    public ConfigEntry<Object> ARROW_EXECUTION_ENABLED() {
        return this.ARROW_EXECUTION_ENABLED;
    }

    public ConfigEntry<Object> ARROW_FALLBACK_ENABLED() {
        return this.ARROW_FALLBACK_ENABLED;
    }

    public ConfigEntry<Object> ARROW_EXECUTION_MAX_RECORDS_PER_BATCH() {
        return this.ARROW_EXECUTION_MAX_RECORDS_PER_BATCH;
    }

    public ConfigEntry<Object> PANDAS_RESPECT_SESSION_LOCAL_TIMEZONE() {
        return this.PANDAS_RESPECT_SESSION_LOCAL_TIMEZONE;
    }

    public ConfigEntry<Object> PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME() {
        return this.PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME;
    }

    public ConfigEntry<Object> REPLACE_EXCEPT_WITH_FILTER() {
        return this.REPLACE_EXCEPT_WITH_FILTER;
    }

    public ConfigEntry<Object> DECIMAL_OPERATIONS_ALLOW_PREC_LOSS() {
        return this.DECIMAL_OPERATIONS_ALLOW_PREC_LOSS;
    }

    public ConfigEntry<Object> LITERAL_PICK_MINIMUM_PRECISION() {
        return this.LITERAL_PICK_MINIMUM_PRECISION;
    }

    public ConfigEntry<Regex> SQL_OPTIONS_REDACTION_PATTERN() {
        return this.SQL_OPTIONS_REDACTION_PATTERN;
    }

    public ConfigEntry<Option<Regex>> SQL_STRING_REDACTION_PATTERN() {
        return this.SQL_STRING_REDACTION_PATTERN;
    }

    public ConfigEntry<Object> CONCAT_BINARY_AS_STRING() {
        return this.CONCAT_BINARY_AS_STRING;
    }

    public ConfigEntry<Object> ELT_OUTPUT_AS_STRING() {
        return this.ELT_OUTPUT_AS_STRING;
    }

    public ConfigEntry<Object> ALLOW_CREATING_MANAGED_TABLE_USING_NONEMPTY_LOCATION() {
        return this.ALLOW_CREATING_MANAGED_TABLE_USING_NONEMPTY_LOCATION;
    }

    public ConfigEntry<Object> CONTINUOUS_STREAMING_EXECUTOR_QUEUE_SIZE() {
        return this.CONTINUOUS_STREAMING_EXECUTOR_QUEUE_SIZE;
    }

    public ConfigEntry<Object> CONTINUOUS_STREAMING_EXECUTOR_POLL_INTERVAL_MS() {
        return this.CONTINUOUS_STREAMING_EXECUTOR_POLL_INTERVAL_MS;
    }

    public ConfigEntry<String> DISABLED_V2_STREAMING_WRITERS() {
        return this.DISABLED_V2_STREAMING_WRITERS;
    }

    public ConfigEntry<String> DISABLED_V2_STREAMING_MICROBATCH_READERS() {
        return this.DISABLED_V2_STREAMING_MICROBATCH_READERS;
    }

    public ConfigEntry<String> PARTITION_OVERWRITE_MODE() {
        return this.PARTITION_OVERWRITE_MODE;
    }

    public ConfigEntry<Object> SORT_BEFORE_REPARTITION() {
        return this.SORT_BEFORE_REPARTITION;
    }

    public ConfigEntry<Object> NESTED_SCHEMA_PRUNING_ENABLED() {
        return this.NESTED_SCHEMA_PRUNING_ENABLED;
    }

    public ConfigEntry<Object> TOP_K_SORT_FALLBACK_THRESHOLD() {
        return this.TOP_K_SORT_FALLBACK_THRESHOLD;
    }

    public ConfigEntry<Object> CSV_PARSER_COLUMN_PRUNING() {
        return this.CSV_PARSER_COLUMN_PRUNING;
    }

    public ConfigEntry<Object> REPL_EAGER_EVAL_ENABLED() {
        return this.REPL_EAGER_EVAL_ENABLED;
    }

    public ConfigEntry<Object> REPL_EAGER_EVAL_MAX_NUM_ROWS() {
        return this.REPL_EAGER_EVAL_MAX_NUM_ROWS;
    }

    public ConfigEntry<Object> REPL_EAGER_EVAL_TRUNCATE() {
        return this.REPL_EAGER_EVAL_TRUNCATE;
    }

    public ConfigEntry<Object> FAST_HASH_AGGREGATE_MAX_ROWS_CAPACITY_BIT() {
        return this.FAST_HASH_AGGREGATE_MAX_ROWS_CAPACITY_BIT;
    }

    public ConfigEntry<String> AVRO_COMPRESSION_CODEC() {
        return this.AVRO_COMPRESSION_CODEC;
    }

    public ConfigEntry<Object> AVRO_DEFLATE_LEVEL() {
        return this.AVRO_DEFLATE_LEVEL;
    }

    public ConfigEntry<Object> COMPARE_DATE_TIMESTAMP_IN_TIMESTAMP() {
        return this.COMPARE_DATE_TIMESTAMP_IN_TIMESTAMP;
    }

    public ConfigEntry<Object> LEGACY_SIZE_OF_NULL() {
        return this.LEGACY_SIZE_OF_NULL;
    }

    public ConfigEntry<Object> LEGACY_REPLACE_DATABRICKS_SPARK_AVRO_ENABLED() {
        return this.LEGACY_REPLACE_DATABRICKS_SPARK_AVRO_ENABLED;
    }

    public ConfigEntry<Object> LEGACY_SETOPS_PRECEDENCE_ENABLED() {
        return this.LEGACY_SETOPS_PRECEDENCE_ENABLED;
    }

    public ConfigEntry<Object> LEGACY_HAVING_WITHOUT_GROUP_BY_AS_WHERE() {
        return this.LEGACY_HAVING_WITHOUT_GROUP_BY_AS_WHERE;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$buildStaticConf$1(ConfigEntry entry) {
        MODULE$.staticConfKeys().add(entry.key());
        MODULE$.register(entry);
    }

    public static final /* synthetic */ boolean $anonfun$get$2(Thread x$2) {
        return x$2.getId() == Thread.currentThread().getId();
    }

    public static final /* synthetic */ boolean $anonfun$STREAMING_MULTIPLE_WATERMARK_POLICY$1(String str) {
        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"min", "max"}))).contains((Object)str.toLowerCase());
    }

    private SQLConf$() {
        MODULE$ = this;
        this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries = Collections.synchronizedMap(new HashMap());
        this.staticConfKeys = Collections.synchronizedSet(new HashSet());
        this.confGetter = new AtomicReference<Function0 & Serializable & scala.Serializable>((Function0 & Serializable & scala.Serializable)() -> MODULE$.fallbackConf().get());
        this.OPTIMIZER_EXCLUDED_RULES = this.buildConf("spark.sql.optimizer.excludedRules").doc("Configures a list of rules to be disabled in the optimizer, in which the rules are specified by their rule names and separated by comma. It is not guaranteed that all the rules in this configuration will eventually be excluded, as some rules are necessary for correctness. The optimizer will log the rules that have indeed been excluded.").stringConf().createOptional();
        this.OPTIMIZER_MAX_ITERATIONS = this.buildConf("spark.sql.optimizer.maxIterations").internal().doc("The max number of iterations the optimizer and analyzer runs.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.OPTIMIZER_INSET_CONVERSION_THRESHOLD = this.buildConf("spark.sql.optimizer.inSetConversionThreshold").internal().doc("The threshold of set size for InSet conversion.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.COMPRESS_CACHED = this.buildConf("spark.sql.inMemoryColumnarStorage.compressed").doc("When set to true Spark SQL will automatically select a compression codec for each column based on statistics of the data.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.COLUMN_BATCH_SIZE = this.buildConf("spark.sql.inMemoryColumnarStorage.batchSize").doc("Controls the size of batches for columnar caching.  Larger batch sizes can improve memory utilization and compression, but risk OOMs when caching data.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.IN_MEMORY_PARTITION_PRUNING = this.buildConf("spark.sql.inMemoryColumnarStorage.partitionPruning").internal().doc("When true, enable partition pruning for in-memory columnar tables.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CACHE_VECTORIZED_READER_ENABLED = this.buildConf("spark.sql.inMemoryColumnarStorage.enableVectorizedReader").doc("Enables vectorized reader for columnar caching.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.COLUMN_VECTOR_OFFHEAP_ENABLED = this.buildConf("spark.sql.columnVector.offheap.enabled").internal().doc("When true, use OffHeapColumnVector in ColumnarBatch.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PREFER_SORTMERGEJOIN = this.buildConf("spark.sql.join.preferSortMergeJoin").internal().doc("When true, prefer sort merge join over shuffle hash join.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.RADIX_SORT_ENABLED = this.buildConf("spark.sql.sort.enableRadixSort").internal().doc("When true, enable use of radix sort when possible. Radix sort is much faster but requires additional memory to be reserved up-front. The memory overhead may be significant when sorting very small rows (up to 50% more in this case).").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.AUTO_BROADCASTJOIN_THRESHOLD = this.buildConf("spark.sql.autoBroadcastJoinThreshold").doc("Configures the maximum size in bytes for a table that will be broadcast to all worker nodes when performing a join.  By setting this value to -1 broadcasting can be disabled. Note that currently statistics are only supported for Hive Metastore tables where the command <code>ANALYZE TABLE &lt;tableName&gt; COMPUTE STATISTICS noscan</code> has been run, and file-based data source tables where the statistics are computed directly on the files of data.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0xA00000L));
        this.LIMIT_SCALE_UP_FACTOR = this.buildConf("spark.sql.limit.scaleUpFactor").internal().doc("Minimal increase rate in number of partitions between attempts when executing a take on a query. Higher values lead to more partitions read. Lower values might lead to longer execution times as more jobs will be run").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4));
        this.ADVANCED_PARTITION_PREDICATE_PUSHDOWN = this.buildConf("spark.sql.hive.advancedPartitionPredicatePushdown.enabled").internal().doc("When true, advanced partition predicate pushdown into Hive metastore is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.SHUFFLE_PARTITIONS = this.buildConf("spark.sql.shuffle.partitions").doc("The default number of partitions to use when shuffling data for joins or aggregations.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
        this.SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE = this.buildConf("spark.sql.adaptive.shuffle.targetPostShuffleInputSize").doc("The target post-shuffle input size in bytes of a task.").bytesConf(ByteUnit.BYTE).createWithDefault((Object)BoxesRunTime.boxToLong((long)0x4000000L));
        this.ADAPTIVE_EXECUTION_ENABLED = this.buildConf("spark.sql.adaptive.enabled").doc("When true, enable adaptive query execution.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS = this.buildConf("spark.sql.adaptive.minNumPostShufflePartitions").internal().doc("The advisory minimal number of post-shuffle partitions provided to ExchangeCoordinator. This setting is used in our test to make sure we have enough parallelism to expose issues that will not be exposed with a single partition. When the value is a non-positive value, this setting will not be provided to ExchangeCoordinator.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)-1));
        this.SUBEXPRESSION_ELIMINATION_ENABLED = this.buildConf("spark.sql.subexpressionElimination.enabled").internal().doc("When true, common subexpressions will be eliminated.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CASE_SENSITIVE = this.buildConf("spark.sql.caseSensitive").internal().doc("Whether the query analyzer should be case sensitive or not. Default to case insensitive. It is highly discouraged to turn on case sensitive mode.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.CONSTRAINT_PROPAGATION_ENABLED = this.buildConf("spark.sql.constraintPropagation.enabled").internal().doc("When true, the query optimizer will infer and propagate data constraints in the query plan to optimize them. Constraint propagation can sometimes be computationally expensive for certain kinds of query plans (such as those with a large number of predicates and aliases) which might negatively impact overall runtime.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ESCAPED_STRING_LITERALS = this.buildConf("spark.sql.parser.escapedStringLiterals").internal().doc("When true, string literals (including regex patterns) remain escaped in our SQL parser. The default is false since Spark 2.0. Setting it to true can restore the behavior prior to Spark 2.0.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.FILE_COMRESSION_FACTOR = this.buildConf("spark.sql.sources.fileCompressionFactor").internal().doc("When estimating the output data size of a table scan, multiply the file size with this factor as the estimated data size, in case the data is compressed in the file and lead to a heavily underestimated result.").doubleConf().checkValue((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 > 0.0, "the value of fileDataSizeFactor must be larger than 0").createWithDefault((Object)BoxesRunTime.boxToDouble((double)1.0));
        this.PARQUET_SCHEMA_MERGING_ENABLED = this.buildConf("spark.sql.parquet.mergeSchema").doc("When true, the Parquet data source merges schemas collected from all data files, otherwise the schema is picked from the summary file or a random data file if no summary file is available.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_SCHEMA_RESPECT_SUMMARIES = this.buildConf("spark.sql.parquet.respectSummaryFiles").doc("When true, we make assumption that all part-files of Parquet are consistent with summary files and we will ignore them when merging schema. Otherwise, if this is false, which is the default, we will merge all part-files. This should be considered as expert-only option, and shouldn't be enabled before knowing what it means exactly.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_BINARY_AS_STRING = this.buildConf("spark.sql.parquet.binaryAsString").doc("Some other Parquet-producing systems, in particular Impala and older versions of Spark SQL, do not differentiate between binary data and strings when writing out the Parquet schema. This flag tells Spark SQL to interpret binary data as a string to provide compatibility with these systems.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_INT96_AS_TIMESTAMP = this.buildConf("spark.sql.parquet.int96AsTimestamp").doc("Some Parquet-producing systems, in particular Impala, store Timestamp into INT96. Spark would also store Timestamp as INT96 because we need to avoid precision lost of the nanoseconds field. This flag tells Spark SQL to interpret INT96 data as a timestamp to provide compatibility with these systems.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_INT96_TIMESTAMP_CONVERSION = this.buildConf("spark.sql.parquet.int96TimestampConversion").doc("This controls whether timestamp adjustments should be applied to INT96 data when converting to timestamps, for data written by Impala.  This is necessary because Impala stores INT96 data with a different timezone offset than Hive & Spark.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_OUTPUT_TIMESTAMP_TYPE = this.buildConf("spark.sql.parquet.outputTimestampType").doc("Sets which Parquet timestamp type to use when Spark writes data to Parquet files. INT96 is a non-standard but commonly used timestamp type in Parquet. TIMESTAMP_MICROS is a standard timestamp type in Parquet, which stores number of microseconds from the Unix epoch. TIMESTAMP_MILLIS is also standard, but with millisecond precision, which means Spark has to truncate the microsecond portion of its timestamp value.").stringConf().transform((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toUpperCase(Locale.ROOT)).checkValues((scala.collection.immutable.Set)SQLConf$ParquetOutputTimestampType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).createWithDefault((Object)SQLConf$ParquetOutputTimestampType$.MODULE$.INT96().toString());
        this.PARQUET_INT64_AS_TIMESTAMP_MILLIS = this.buildConf("spark.sql.parquet.int64AsTimestampMillis").doc(new StringBuilder(217).append("(Deprecated since Spark 2.3, please set ").append(this.PARQUET_OUTPUT_TIMESTAMP_TYPE().key()).append(".) ").append("When true, timestamp values will be stored as INT64 with TIMESTAMP_MILLIS as the ").append("extended type. In this mode, the microsecond portion of the timestamp value will be").append("truncated.").toString()).booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_COMPRESSION = this.buildConf("spark.sql.parquet.compression.codec").doc("Sets the compression codec used when writing Parquet files. If either `compression` or `parquet.compression` is specified in the table-specific options/properties, the precedence would be `compression`, `parquet.compression`, `spark.sql.parquet.compression.codec`. Acceptable values include: none, uncompressed, snappy, gzip, lzo, brotli, lz4, zstd.").stringConf().transform((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toLowerCase(Locale.ROOT)).checkValues((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"none", "uncompressed", "snappy", "gzip", "lzo", "lz4", "brotli", "zstd"}))).createWithDefault((Object)"snappy");
        this.PARQUET_FILTER_PUSHDOWN_ENABLED = this.buildConf("spark.sql.parquet.filterPushdown").doc("Enables Parquet filter push-down optimization when set to true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_FILTER_PUSHDOWN_DATE_ENABLED = this.buildConf("spark.sql.parquet.filterPushdown.date").doc("If true, enables Parquet filter push-down optimization for Date. This configuration only has an effect when 'spark.sql.parquet.filterPushdown' is enabled.").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED = this.buildConf("spark.sql.parquet.filterPushdown.timestamp").doc("If true, enables Parquet filter push-down optimization for Timestamp. This configuration only has an effect when 'spark.sql.parquet.filterPushdown' is enabled and Timestamp stored as TIMESTAMP_MICROS or TIMESTAMP_MILLIS type.").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_FILTER_PUSHDOWN_DECIMAL_ENABLED = this.buildConf("spark.sql.parquet.filterPushdown.decimal").doc("If true, enables Parquet filter push-down optimization for Decimal. This configuration only has an effect when 'spark.sql.parquet.filterPushdown' is enabled.").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_FILTER_PUSHDOWN_STRING_STARTSWITH_ENABLED = this.buildConf("spark.sql.parquet.filterPushdown.string.startsWith").doc("If true, enables Parquet filter push-down optimization for string startsWith function. This configuration only has an effect when 'spark.sql.parquet.filterPushdown' is enabled.").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_FILTER_PUSHDOWN_INFILTERTHRESHOLD = this.buildConf("spark.sql.parquet.pushdown.inFilterThreshold").doc("The maximum number of values to filter push-down optimization for IN predicate. Large threshold won't necessarily provide much better performance. The experiment argued that 300 is the limit threshold. By setting this value to 0 this feature can be disabled. This configuration only has an effect when 'spark.sql.parquet.filterPushdown' is enabled.").internal().intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)threshold -> threshold >= 0, "The threshold must not be negative.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.PARQUET_WRITE_LEGACY_FORMAT = this.buildConf("spark.sql.parquet.writeLegacyFormat").doc("If true, data will be written in a way of Spark 1.4 and earlier. For example, decimal values will be written in Apache Parquet's fixed-length byte array format, which other systems such as Apache Hive and Apache Impala use. If false, the newer format in Parquet will be used. For example, decimals will be written in int-based format. If Parquet output is intended for use with systems that do not support this newer format, set to true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_RECORD_FILTER_ENABLED = this.buildConf("spark.sql.parquet.recordLevelFilter.enabled").doc("If true, enables Parquet's native record-level filtering using the pushed down filters. This configuration only has an effect when 'spark.sql.parquet.filterPushdown' is enabled and the vectorized reader is not used. You can ensure the vectorized reader is not used by setting 'spark.sql.parquet.enableVectorizedReader' to false.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_OUTPUT_COMMITTER_CLASS = this.buildConf("spark.sql.parquet.output.committer.class").doc("The output committer class used by Parquet. The specified class needs to be a subclass of org.apache.hadoop.mapreduce.OutputCommitter. Typically, it's also a subclass of org.apache.parquet.hadoop.ParquetOutputCommitter. If it is not, then metadata summarieswill never be created, irrespective of the value of parquet.summary.metadata.level").internal().stringConf().createWithDefault((Object)"org.apache.parquet.hadoop.ParquetOutputCommitter");
        this.PARQUET_VECTORIZED_READER_ENABLED = this.buildConf("spark.sql.parquet.enableVectorizedReader").doc("Enables vectorized parquet decoding.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_VECTORIZED_READER_BATCH_SIZE = this.buildConf("spark.sql.parquet.columnarReaderBatchSize").doc("The number of rows to include in a parquet vectorized reader batch. The number should be carefully chosen to minimize overhead and avoid OOMs in reading data.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4096));
        this.ORC_COMPRESSION = this.buildConf("spark.sql.orc.compression.codec").doc("Sets the compression codec used when writing ORC files. If either `compression` or `orc.compress` is specified in the table-specific options/properties, the precedence would be `compression`, `orc.compress`, `spark.sql.orc.compression.codec`.Acceptable values include: none, uncompressed, snappy, zlib, lzo.").stringConf().transform((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(Locale.ROOT)).checkValues((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"none", "uncompressed", "snappy", "zlib", "lzo"}))).createWithDefault((Object)"snappy");
        this.ORC_IMPLEMENTATION = this.buildConf("spark.sql.orc.impl").doc("When native, use the native version of ORC support instead of the ORC library in Hive 1.2.1. It is 'hive' by default prior to Spark 2.4.").internal().stringConf().checkValues((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "native"}))).createWithDefault((Object)"native");
        this.ORC_VECTORIZED_READER_ENABLED = this.buildConf("spark.sql.orc.enableVectorizedReader").doc("Enables vectorized orc decoding.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ORC_VECTORIZED_READER_BATCH_SIZE = this.buildConf("spark.sql.orc.columnarReaderBatchSize").doc("The number of rows to include in a orc vectorized reader batch. The number should be carefully chosen to minimize overhead and avoid OOMs in reading data.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4096));
        this.ORC_COPY_BATCH_TO_SPARK = this.buildConf("spark.sql.orc.copyBatchToSpark").doc("Whether or not to copy the ORC columnar batch to Spark columnar batch in the vectorized ORC reader.").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ORC_FILTER_PUSHDOWN_ENABLED = this.buildConf("spark.sql.orc.filterPushdown").doc("When true, enable filter pushdown for ORC files.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.HIVE_VERIFY_PARTITION_PATH = this.buildConf("spark.sql.hive.verifyPartitionPath").doc("When true, check all the partition paths under the table's root directory when reading data stored in HDFS. This configuration will be deprecated in the future releases and replaced by spark.files.ignoreMissingFiles.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_METASTORE_PARTITION_PRUNING = this.buildConf("spark.sql.hive.metastorePartitionPruning").doc("When true, some predicates will be pushed down into the Hive metastore so that unmatching partitions can be eliminated earlier. This only affects Hive tables not converted to filesource relations (see HiveUtils.CONVERT_METASTORE_PARQUET and HiveUtils.CONVERT_METASTORE_ORC for more information).").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.HIVE_MANAGE_FILESOURCE_PARTITIONS = this.buildConf("spark.sql.hive.manageFilesourcePartitions").doc("When true, enable metastore partition management for file source tables as well. This includes both datasource and converted Hive tables. When partition management is enabled, datasource tables store partition in the Hive metastore, and use the metastore to prune partitions during query planning.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE = this.buildConf("spark.sql.hive.filesourcePartitionFileCacheSize").doc("When nonzero, enable caching of partition file metadata in memory. All tables share a cache that can use up to specified num bytes for file metadata. This conf only has an effect when hive filesource partition management is enabled.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0xFA00000L));
        this.HIVE_CASE_SENSITIVE_INFERENCE = this.buildConf("spark.sql.hive.caseSensitiveInferenceMode").doc("Sets the action to take when a case-sensitive schema cannot be read from a Hive table's properties. Although Spark SQL itself is not case-sensitive, Hive compatible file formats such as Parquet are. Spark SQL must use a case-preserving schema when querying any table backed by files containing case-sensitive field names or queries may not return accurate results. Valid options include INFER_AND_SAVE (the default mode-- infer the case-sensitive schema from the underlying data files and write it back to the table properties), INFER_ONLY (infer the schema but don't attempt to write it to the table properties) and NEVER_INFER (fallback to using the case-insensitive metastore schema instead of inferring).").stringConf().transform((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toUpperCase(Locale.ROOT)).checkValues((scala.collection.immutable.Set)SQLConf$HiveCaseSensitiveInferenceMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).createWithDefault((Object)SQLConf$HiveCaseSensitiveInferenceMode$.MODULE$.INFER_AND_SAVE().toString());
        this.OPTIMIZER_METADATA_ONLY = this.buildConf("spark.sql.optimizer.metadataOnly").doc("When true, enable the metadata-only query optimization that use the table's metadata to produce the partition columns instead of table scans. It applies when all the columns scanned are partition columns and the query has an aggregate operator that satisfies distinct semantics.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.COLUMN_NAME_OF_CORRUPT_RECORD = this.buildConf("spark.sql.columnNameOfCorruptRecord").doc("The name of internal column for storing raw/un-parsed JSON and CSV records that fail to parse.").stringConf().createWithDefault((Object)"_corrupt_record");
        this.FROM_JSON_FORCE_NULLABLE_SCHEMA = this.buildConf("spark.sql.fromJsonForceNullableSchema").internal().doc("When true, force the output schema of the from_json() function to be nullable (including all the fields). Otherwise, the schema might not be compatible withactual data, which leads to corruptions. This config will be removed in Spark 3.0.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.BROADCAST_TIMEOUT = this.buildConf("spark.sql.broadcastTimeout").doc("Timeout in seconds for the broadcast wait time in broadcast joins.").timeConf(TimeUnit.SECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)300L));
        this.THRIFTSERVER_POOL = this.buildConf("spark.sql.thriftserver.scheduler.pool").doc("Set a Fair Scheduler pool for a JDBC client session.").stringConf().createOptional();
        this.THRIFTSERVER_INCREMENTAL_COLLECT = this.buildConf("spark.sql.thriftServer.incrementalCollect").internal().doc("When true, enable incremental collection for execution in Thrift Server.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.THRIFTSERVER_UI_STATEMENT_LIMIT = this.buildConf("spark.sql.thriftserver.ui.retainedStatements").doc("The number of SQL statements kept in the JDBC/ODBC web UI history.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
        this.THRIFTSERVER_UI_SESSION_LIMIT = this.buildConf("spark.sql.thriftserver.ui.retainedSessions").doc("The number of SQL client sessions kept in the JDBC/ODBC web UI history.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
        this.DEFAULT_DATA_SOURCE_NAME = this.buildConf("spark.sql.sources.default").doc("The default data source to use in input/output.").stringConf().createWithDefault((Object)"parquet");
        this.CONVERT_CTAS = this.buildConf("spark.sql.hive.convertCTAS").internal().doc("When true, a table created by a Hive CTAS statement (no USING clause) without specifying any storage property will be converted to a data source table, using the data source set by spark.sql.sources.default.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.GATHER_FASTSTAT = this.buildConf("spark.sql.hive.gatherFastStats").internal().doc("When true, fast stats (number of files and total size of all files) will be gathered in parallel while repairing table partitions to avoid the sequential listing in Hive metastore.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARTITION_COLUMN_TYPE_INFERENCE = this.buildConf("spark.sql.sources.partitionColumnTypeInference.enabled").doc("When true, automatically infer the data types for partitioned columns.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.BUCKETING_ENABLED = this.buildConf("spark.sql.sources.bucketing.enabled").doc("When false, we will treat bucketed table as normal table").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.BUCKETING_MAX_BUCKETS = this.buildConf("spark.sql.sources.bucketing.maxBuckets").doc("The maximum number of buckets allowed. Defaults to 100000").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 > 0, "the value of spark.sql.sources.bucketing.maxBuckets must be larger than 0").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100000));
        this.CROSS_JOINS_ENABLED = this.buildConf("spark.sql.crossJoin.enabled").doc("When false, we will throw an error if a query contains a cartesian product without explicit CROSS JOIN syntax.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ORDER_BY_ORDINAL = this.buildConf("spark.sql.orderByOrdinal").doc("When true, the ordinal numbers are treated as the position in the select list. When false, the ordinal numbers in order/sort by clause are ignored.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.GROUP_BY_ORDINAL = this.buildConf("spark.sql.groupByOrdinal").doc("When true, the ordinal numbers in group by clauses are treated as the position in the select list. When false, the ordinal numbers are ignored.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.GROUP_BY_ALIASES = this.buildConf("spark.sql.groupByAliases").doc("When true, aliases in a select list can be used in group by clauses. When false, an analysis exception is thrown in the case.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.OUTPUT_COMMITTER_CLASS = this.buildConf("spark.sql.sources.outputCommitterClass").internal().stringConf().createOptional();
        this.FILE_COMMIT_PROTOCOL_CLASS = this.buildConf("spark.sql.sources.commitProtocolClass").internal().stringConf().createWithDefault((Object)"org.apache.spark.sql.execution.datasources.SQLHadoopMapReduceCommitProtocol");
        this.PARALLEL_PARTITION_DISCOVERY_THRESHOLD = this.buildConf("spark.sql.sources.parallelPartitionDiscovery.threshold").doc("The maximum number of paths allowed for listing files at driver side. If the number of detected paths exceeds this value during partition discovery, it tries to list the files with another Spark distributed job. This applies to Parquet, ORC, CSV, JSON and LibSVM data sources.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)parallel -> parallel >= 0, "The maximum number of paths allowed for listing files at driver side must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)32));
        this.PARALLEL_PARTITION_DISCOVERY_PARALLELISM = this.buildConf("spark.sql.sources.parallelPartitionDiscovery.parallelism").doc("The number of parallelism to list a collection of path recursively, Set the number to prevent file listing from generating too many tasks.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY = this.buildConf("spark.sql.selfJoinAutoResolveAmbiguity").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DATAFRAME_RETAIN_GROUP_COLUMNS = this.buildConf("spark.sql.retainGroupColumns").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DATAFRAME_PIVOT_MAX_VALUES = this.buildConf("spark.sql.pivotMaxValues").doc("When doing a pivot without specifying values for the pivot column this is the maximum number of (distinct) values that will be collected without error.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.RUN_SQL_ON_FILES = this.buildConf("spark.sql.runSQLOnFiles").internal().doc("When true, we could use `datasource`.`path` as table in SQL query.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WHOLESTAGE_CODEGEN_ENABLED = this.buildConf("spark.sql.codegen.wholeStage").internal().doc("When true, the whole stage (of multiple operators) will be compiled into single java method.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WHOLESTAGE_CODEGEN_USE_ID_IN_CLASS_NAME = this.buildConf("spark.sql.codegen.useIdInClassName").internal().doc("When true, embed the (whole-stage) codegen stage ID into the class name of the generated class as a suffix").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WHOLESTAGE_MAX_NUM_FIELDS = this.buildConf("spark.sql.codegen.maxFields").internal().doc("The maximum number of fields (including nested fields) that will be supported before deactivating whole-stage codegen.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.CODEGEN_FACTORY_MODE = this.buildConf("spark.sql.codegen.factoryMode").doc("This config determines the fallback behavior of several codegen generators during tests. `FALLBACK` means trying codegen first and then fallbacking to interpreted if any compile error happens. Disabling fallback if `CODEGEN_ONLY`. `NO_CODEGEN` skips codegen and goes interpreted path always. Note that this config works only for tests.").internal().stringConf().checkValues((scala.collection.immutable.Set)CodegenObjectFactoryMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).createWithDefault((Object)CodegenObjectFactoryMode$.MODULE$.FALLBACK().toString());
        this.CODEGEN_FALLBACK = this.buildConf("spark.sql.codegen.fallback").internal().doc("When true, (whole stage) codegen could be temporary disabled for the part of query that fail to compile generated code").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CODEGEN_LOGGING_MAX_LINES = this.buildConf("spark.sql.codegen.logging.maxLines").internal().doc("The maximum number of codegen lines to log when errors occur. Use -1 for unlimited.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)maxLines -> maxLines >= -1, "The maximum must be a positive integer, 0 to disable logging or -1 to apply no limit.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.WHOLESTAGE_HUGE_METHOD_LIMIT = this.buildConf("spark.sql.codegen.hugeMethodLimit").internal().doc(new StringBuilder(385).append("The maximum bytecode size of a single compiled Java function generated by whole-stage codegen. When the compiled function exceeds this threshold, the whole-stage codegen is deactivated for this subtree of the current query plan. The default value is 65535, which is the largest bytecode size possible for a valid Java method. When running on HotSpot, ").append(new StringBuilder(42).append("it may be preferable to set the value to ").append(8000).append(" ").toString()).append("to match HotSpot's implementation.").toString()).intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)65535));
        this.WHOLESTAGE_SPLIT_CONSUME_FUNC_BY_OPERATOR = this.buildConf("spark.sql.codegen.splitConsumeFuncByOperator").internal().doc("When true, whole stage codegen would put the logic of consuming rows of each physical operator into individual methods, instead of a single big method. This can be used to avoid oversized function that can miss the opportunity of JIT optimization.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILES_MAX_PARTITION_BYTES = this.buildConf("spark.sql.files.maxPartitionBytes").doc("The maximum number of bytes to pack into a single partition when reading files.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0x8000000L));
        this.FILES_OPEN_COST_IN_BYTES = this.buildConf("spark.sql.files.openCostInBytes").internal().doc("The estimated cost to open a file, measured by the number of bytes could be scanned in the same time. This is used when putting multiple files into a partition. It's better to over estimated, then the partitions with small files will be faster than partitions with bigger files (which is scheduled first).").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0x400000L));
        this.IGNORE_CORRUPT_FILES = this.buildConf("spark.sql.files.ignoreCorruptFiles").doc("Whether to ignore corrupt files. If true, the Spark jobs will continue to run when encountering corrupted files and the contents that have been read will still be returned.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.IGNORE_MISSING_FILES = this.buildConf("spark.sql.files.ignoreMissingFiles").doc("Whether to ignore missing files. If true, the Spark jobs will continue to run when encountering missing files and the contents that have been read will still be returned.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.MAX_RECORDS_PER_FILE = this.buildConf("spark.sql.files.maxRecordsPerFile").doc("Maximum number of records to write out to a single file. If this value is zero or negative, there is no limit.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0L));
        this.EXCHANGE_REUSE_ENABLED = this.buildConf("spark.sql.exchange.reuse").internal().doc("When true, the planner will try to find out duplicated exchanges and re-use them.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.STATE_STORE_PROVIDER_CLASS = this.buildConf("spark.sql.streaming.stateStore.providerClass").internal().doc("The class used to manage state data in stateful streaming queries. This class must be a subclass of StateStoreProvider, and must have a zero-arg constructor.").stringConf().createWithDefault((Object)"org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider");
        this.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT = this.buildConf("spark.sql.streaming.stateStore.minDeltasForSnapshot").internal().doc("Minimum number of state store delta files that needs to be generated before they consolidated into snapshots.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.FLATMAPGROUPSWITHSTATE_STATE_FORMAT_VERSION = this.buildConf("spark.sql.streaming.flatMapGroupsWithState.stateFormatVersion").internal().doc("State format version used by flatMapGroupsWithState operation in a streaming query").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)v -> ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).contains((Object)BoxesRunTime.boxToInteger((int)v)), "Valid versions are 1 and 2").createWithDefault((Object)BoxesRunTime.boxToInteger((int)2));
        this.CHECKPOINT_LOCATION = this.buildConf("spark.sql.streaming.checkpointLocation").doc("The default location for storing checkpoint data for streaming queries.").stringConf().createOptional();
        this.MIN_BATCHES_TO_RETAIN = this.buildConf("spark.sql.streaming.minBatchesToRetain").internal().doc("The minimum number of batches that must be retained and made recoverable.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.MAX_BATCHES_TO_RETAIN_IN_MEMORY = this.buildConf("spark.sql.streaming.maxBatchesToRetainInMemory").internal().doc("The maximum number of batches which will be retained in memory to avoid loading from files. The value adjusts a trade-off between memory usage vs cache miss: '2' covers both success and direct failure cases, '1' covers only success case, and '0' covers extreme case - disable cache to maximize memory size of executors.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)2));
        this.STREAMING_AGGREGATION_STATE_FORMAT_VERSION = this.buildConf("spark.sql.streaming.aggregation.stateFormatVersion").internal().doc("State format version used by streaming aggregation operations in a streaming query. State between versions are tend to be incompatible, so state format version shouldn't be modified after running.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)v -> ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).contains((Object)BoxesRunTime.boxToInteger((int)v)), "Valid versions are 1 and 2").createWithDefault((Object)BoxesRunTime.boxToInteger((int)2));
        this.UNSUPPORTED_OPERATION_CHECK_ENABLED = this.buildConf("spark.sql.streaming.unsupportedOperationCheck").internal().doc("When true, the logical plan for streaming query will be checked for unsupported operations.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.VARIABLE_SUBSTITUTE_ENABLED = this.buildConf("spark.sql.variable.substitute").doc("This enables substitution using syntax like ${var} ${system:var} and ${env:var}.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.VARIABLE_SUBSTITUTE_DEPTH = this.buildConf("spark.sql.variable.substitute.depth").internal().doc("Deprecated: The maximum replacements the substitution engine will do.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)40));
        this.ENABLE_TWOLEVEL_AGG_MAP = this.buildConf("spark.sql.codegen.aggregate.map.twolevel.enabled").internal().doc("Enable two-level aggregate hash map. When enabled, records will first be inserted/looked-up at a 1st-level, small, fast map, and then fallback to a 2nd-level, larger, slower map when 1st level is full or keys cannot be found. When disabled, records go directly to the 2nd level. Defaults to true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.MAX_NESTED_VIEW_DEPTH = this.buildConf("spark.sql.view.maxNestedViewDepth").internal().doc("The maximum depth of a view reference in a nested view. A nested view may reference other nested views, the dependencies are organized in a directed acyclic graph (DAG). However the DAG depth may become too large and cause unexpected behavior. This configuration puts a limit on this: when the depth of a view exceeds this value during analysis, we terminate the resolution to avoid potential errors.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)depth -> depth > 0, "The maximum depth of a view reference in a nested view must be positive.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.STREAMING_FILE_COMMIT_PROTOCOL_CLASS = this.buildConf("spark.sql.streaming.commitProtocolClass").internal().stringConf().createWithDefault((Object)"org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol");
        this.STREAMING_MULTIPLE_WATERMARK_POLICY = this.buildConf("spark.sql.streaming.multipleWatermarkPolicy").doc("Policy to calculate the global watermark value when there are multiple watermark operators in a streaming query. The default value is 'min' which chooses the minimum watermark reported across multiple operators. Other alternative value is'max' which chooses the maximum across multiple operators.Note: This configuration cannot be changed between query restarts from the same checkpoint location.").stringConf().checkValue((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SQLConf$.$anonfun$STREAMING_MULTIPLE_WATERMARK_POLICY$1(str)), "Invalid value for 'spark.sql.streaming.multipleWatermarkPolicy'. Valid values are 'min' and 'max'").createWithDefault((Object)"min");
        this.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD = this.buildConf("spark.sql.objectHashAggregate.sortBased.fallbackThreshold").internal().doc("In the case of ObjectHashAggregateExec, when the size of the in-memory hash map grows too large, we will fall back to sort-based aggregation. This option sets a row count threshold for the size of the hash map.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)128));
        this.USE_OBJECT_HASH_AGG = this.buildConf("spark.sql.execution.useObjectHashAggregateExec").internal().doc("Decides if we use ObjectHashAggregateExec").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILE_SINK_LOG_DELETION = this.buildConf("spark.sql.streaming.fileSink.log.deletion").internal().doc("Whether to delete the expired log files in file stream sink.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILE_SINK_LOG_COMPACT_INTERVAL = this.buildConf("spark.sql.streaming.fileSink.log.compactInterval").internal().doc("Number of log files after which all the previous files are compacted into the next log file.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.FILE_SINK_LOG_CLEANUP_DELAY = this.buildConf("spark.sql.streaming.fileSink.log.cleanupDelay").internal().doc("How long that a file is guaranteed to be visible for all readers.").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)TimeUnit.MINUTES.toMillis(10L)));
        this.FILE_SOURCE_LOG_DELETION = this.buildConf("spark.sql.streaming.fileSource.log.deletion").internal().doc("Whether to delete the expired log files in file stream source.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILE_SOURCE_LOG_COMPACT_INTERVAL = this.buildConf("spark.sql.streaming.fileSource.log.compactInterval").internal().doc("Number of log files after which all the previous files are compacted into the next log file.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.FILE_SOURCE_LOG_CLEANUP_DELAY = this.buildConf("spark.sql.streaming.fileSource.log.cleanupDelay").internal().doc("How long in milliseconds a file is guaranteed to be visible for all readers.").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)TimeUnit.MINUTES.toMillis(10L)));
        this.STREAMING_SCHEMA_INFERENCE = this.buildConf("spark.sql.streaming.schemaInference").internal().doc("Whether file-based streaming sources will infer its own schema").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STREAMING_POLLING_DELAY = this.buildConf("spark.sql.streaming.pollingDelay").internal().doc("How long to delay polling new data when no data is available").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)10L));
        this.STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL = this.buildConf("spark.sql.streaming.noDataProgressEventInterval").internal().doc("How long to wait between two progress events when there is no data").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)10000L));
        this.STREAMING_NO_DATA_MICRO_BATCHES_ENABLED = this.buildConf("spark.sql.streaming.noDataMicroBatches.enabled").doc("Whether streaming micro-batch engine will execute batches without data for eager state management for stateful streaming queries.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.STREAMING_METRICS_ENABLED = this.buildConf("spark.sql.streaming.metricsEnabled").doc("Whether Dropwizard/Codahale metrics will be reported for active streaming queries.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STREAMING_PROGRESS_RETENTION = this.buildConf("spark.sql.streaming.numRecentProgressUpdates").doc("The number of progress updates to retain for a streaming query").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS = this.buildConf("spark.sql.streaming.checkpointFileManagerClass").doc("The class used to write checkpoint files atomically. This class must be a subclass of the interface CheckpointFileManager.").internal().stringConf();
        this.PARALLEL_FILE_LISTING_IN_STATS_COMPUTATION = this.buildConf("spark.sql.statistics.parallelFileListingInStatsComputation.enabled").internal().doc("When true, SQL commands use parallel file listing, as opposed to single thread listing.This usually speeds up commands that need to list many directories.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS = this.buildConf("spark.sql.statistics.fallBackToHdfs").doc("If the table statistics are not available from table metadata enable fall back to hdfs. This is useful in determining if a table is small enough to use auto broadcast joins.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DEFAULT_SIZE_IN_BYTES = this.buildConf("spark.sql.defaultSizeInBytes").internal().doc("The default table size used in query planning. By default, it is set to Long.MaxValue which is larger than `spark.sql.autoBroadcastJoinThreshold` to be more conservative. That is to say by default the optimizer will not choose to broadcast a table unless it knows for sure its size is small enough.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        this.NDV_MAX_ERROR = this.buildConf("spark.sql.statistics.ndv.maxError").internal().doc("The maximum estimation error allowed in HyperLogLog++ algorithm when generating column level statistics.").doubleConf().createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.05));
        this.HISTOGRAM_ENABLED = this.buildConf("spark.sql.statistics.histogram.enabled").doc("Generates histograms when computing column statistics if enabled. Histograms can provide better estimation accuracy. Currently, Spark only supports equi-height histogram. Note that collecting histograms takes extra cost. For example, collecting column statistics usually takes only one table scan, but generating equi-height histogram will cause an extra table scan.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HISTOGRAM_NUM_BINS = this.buildConf("spark.sql.statistics.histogram.numBins").internal().doc("The number of bins when generating histograms.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)num -> num > 1, "The number of bins must be larger than 1.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)254));
        this.PERCENTILE_ACCURACY = this.buildConf("spark.sql.statistics.percentile.accuracy").internal().doc("Accuracy of percentile approximation when generating equi-height histograms. Larger value means better accuracy. The relative error can be deduced by 1.0 / PERCENTILE_ACCURACY.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.AUTO_SIZE_UPDATE_ENABLED = this.buildConf("spark.sql.statistics.size.autoUpdate.enabled").doc("Enables automatic update for table size once table's data is changed. Note that if the total number of files of the table is very large, this can be expensive and slow down data change commands.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.CBO_ENABLED = this.buildConf("spark.sql.cbo.enabled").doc("Enables CBO for estimation of plan statistics when set true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.JOIN_REORDER_ENABLED = this.buildConf("spark.sql.cbo.joinReorder.enabled").doc("Enables join reorder in CBO.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.JOIN_REORDER_DP_THRESHOLD = this.buildConf("spark.sql.cbo.joinReorder.dp.threshold").doc("The maximum number of joined nodes allowed in the dynamic programming algorithm.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)number -> number > 0, "The maximum number must be a positive integer.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)12));
        this.JOIN_REORDER_CARD_WEIGHT = this.buildConf("spark.sql.cbo.joinReorder.card.weight").internal().doc("The weight of cardinality (number of rows) for plan cost comparison in join reorder: rows * weight + size * (1 - weight).").doubleConf().checkValue((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)weight -> weight >= 0.0 && weight <= 1.0, "The weight value must be in [0, 1].").createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.7));
        this.JOIN_REORDER_DP_STAR_FILTER = this.buildConf("spark.sql.cbo.joinReorder.dp.star.filter").doc("Applies star-join filter heuristics to cost based join enumeration.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STARSCHEMA_DETECTION = this.buildConf("spark.sql.cbo.starSchemaDetection").doc("When true, it enables join reordering based on star schema detection. ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STARSCHEMA_FACT_TABLE_RATIO = this.buildConf("spark.sql.cbo.starJoinFTRatio").internal().doc("Specifies the upper limit of the ratio between the largest fact tables for a star join to be considered. ").doubleConf().createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.9));
        this.SESSION_LOCAL_TIMEZONE = this.buildConf("spark.sql.session.timeZone").doc("The ID of session local timezone, e.g. \"GMT\", \"America/Los_Angeles\", etc.").stringConf().createWithDefaultFunction((Function0 & Serializable & scala.Serializable)() -> TimeZone.getDefault().getID());
        this.WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD = this.buildConf("spark.sql.windowExec.buffer.in.memory.threshold").internal().doc("Threshold for number of rows guaranteed to be held in memory by the window operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4096));
        this.WINDOW_EXEC_BUFFER_SPILL_THRESHOLD = this.buildConf("spark.sql.windowExec.buffer.spill.threshold").internal().doc("Threshold for number of rows to be spilled by window operator").intConf().createWithDefault(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD().defaultValue().get());
        this.SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD = this.buildConf("spark.sql.sortMergeJoinExec.buffer.in.memory.threshold").internal().doc("Threshold for number of rows guaranteed to be held in memory by the sort merge join operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD = this.buildConf("spark.sql.sortMergeJoinExec.buffer.spill.threshold").internal().doc("Threshold for number of rows to be spilled by sort merge join operator").intConf().createWithDefault(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD().defaultValue().get());
        this.CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD = this.buildConf("spark.sql.cartesianProductExec.buffer.in.memory.threshold").internal().doc("Threshold for number of rows guaranteed to be held in memory by the cartesian product operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4096));
        this.CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD = this.buildConf("spark.sql.cartesianProductExec.buffer.spill.threshold").internal().doc("Threshold for number of rows to be spilled by cartesian product operator").intConf().createWithDefault(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD().defaultValue().get());
        this.SUPPORT_QUOTED_REGEX_COLUMN_NAME = this.buildConf("spark.sql.parser.quotedRegexColumnNames").doc("When true, quoted Identifiers (using backticks) in SELECT statement are interpreted as regular expressions.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.RANGE_EXCHANGE_SAMPLE_SIZE_PER_PARTITION = this.buildConf("spark.sql.execution.rangeExchange.sampleSizePerPartition").internal().doc("Number of points to sample per partition in order to determine the range boundaries for range partitioning, typically used in global sorting (without limit).").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.ARROW_EXECUTION_ENABLED = this.buildConf("spark.sql.execution.arrow.enabled").doc("When true, make use of Apache Arrow for columnar data transfers. Currently available for use with pyspark.sql.DataFrame.toPandas, and pyspark.sql.SparkSession.createDataFrame when its input is a Pandas DataFrame. The following data types are unsupported: BinaryType, MapType, ArrayType of TimestampType, and nested StructType.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ARROW_FALLBACK_ENABLED = this.buildConf("spark.sql.execution.arrow.fallback.enabled").doc("When true, optimizations enabled by 'spark.sql.execution.arrow.enabled' will fallback automatically to non-optimized implementations if an error occurs.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ARROW_EXECUTION_MAX_RECORDS_PER_BATCH = this.buildConf("spark.sql.execution.arrow.maxRecordsPerBatch").doc("When using Apache Arrow, limit the maximum number of records that can be written to a single ArrowRecordBatch in memory. If set to zero or negative there is no limit.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.PANDAS_RESPECT_SESSION_LOCAL_TIMEZONE = this.buildConf("spark.sql.execution.pandas.respectSessionTimeZone").internal().doc("When true, make Pandas DataFrame with timestamp type respecting session local timezone when converting to/from Pandas DataFrame. This configuration will be deprecated in the future releases.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME = this.buildConf("spark.sql.legacy.execution.pandas.groupedMap.assignColumnsByName").internal().doc("When true, columns will be looked up by name if labeled with a string and fallback to use position if not. When false, a grouped map Pandas UDF will assign columns from the returned Pandas DataFrame based on position, regardless of column label type. This configuration will be deprecated in future releases.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.REPLACE_EXCEPT_WITH_FILTER = this.buildConf("spark.sql.optimizer.replaceExceptWithFilter").internal().doc("When true, the apply function of the rule verifies whether the right node of the except operation is of type Filter or Project followed by Filter. If yes, the rule further verifies 1) Excluding the filter operations from the right (as well as the left node, if any) on the top, whether both the nodes evaluates to a same result. 2) The left and right nodes don't contain any SubqueryExpressions. 3) The output column names of the left node are distinct. If all the conditions are met, the rule will replace the except operation with a Filter by flipping the filter condition(s) of the right node.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DECIMAL_OPERATIONS_ALLOW_PREC_LOSS = this.buildConf("spark.sql.decimalOperations.allowPrecisionLoss").internal().doc("When true (default), establishing the result type of an arithmetic operation happens according to Hive behavior and SQL ANSI 2011 specification, ie. rounding the decimal part of the result if an exact representation is not possible. Otherwise, NULL is returned in those cases, as previously.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.LITERAL_PICK_MINIMUM_PRECISION = this.buildConf("spark.sql.legacy.literal.pickMinimumPrecision").internal().doc("When integral literal is used in decimal operations, pick a minimum precision required by the literal if this config is true, to make the resulting precision and/or scale smaller. This can reduce the possibility of precision lose and/or overflow.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.SQL_OPTIONS_REDACTION_PATTERN = this.buildConf("spark.sql.redaction.options.regex").doc(new StringBuilder(248).append("Regex to decide which keys in a Spark SQL command's options map contain sensitive information. The values of options whose names that match this regex will be redacted in the explain output. This redaction is applied on top of the global redaction ").append(new StringBuilder(26).append("configuration defined by ").append(package$.MODULE$.SECRET_REDACTION_PATTERN().key()).append(".").toString()).toString()).regexConf().createWithDefault((Object)new StringOps(Predef$.MODULE$.augmentString("(?i)url")).r());
        this.SQL_STRING_REDACTION_PATTERN = this.buildConf("spark.sql.redaction.string.regex").doc("Regex to decide which parts of strings produced by Spark contain sensitive information. When this regex matches a string part, that string part is replaced by a dummy value. This is currently used to redact the output of SQL explain commands. When this conf is not set, the value from `spark.redaction.string.regex` is used.").fallbackConf((ConfigEntry)package$.MODULE$.STRING_REDACTION_PATTERN());
        this.CONCAT_BINARY_AS_STRING = this.buildConf("spark.sql.function.concatBinaryAsString").doc("When this option is set to false and all inputs are binary, `functions.concat` returns an output as binary. Otherwise, it returns as a string. ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ELT_OUTPUT_AS_STRING = this.buildConf("spark.sql.function.eltOutputAsString").doc("When this option is set to false and all inputs are binary, `elt` returns an output as binary. Otherwise, it returns as a string. ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ALLOW_CREATING_MANAGED_TABLE_USING_NONEMPTY_LOCATION = this.buildConf("spark.sql.legacy.allowCreatingManagedTableUsingNonemptyLocation").internal().doc("When this option is set to true, creating managed tables with nonempty location is allowed. Otherwise, an analysis exception is thrown. ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.CONTINUOUS_STREAMING_EXECUTOR_QUEUE_SIZE = this.buildConf("spark.sql.streaming.continuous.executorQueueSize").internal().doc("The size (measured in number of rows) of the queue used in continuous execution to buffer the results of a ContinuousDataReader.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1024));
        this.CONTINUOUS_STREAMING_EXECUTOR_POLL_INTERVAL_MS = this.buildConf("spark.sql.streaming.continuous.executorPollIntervalMs").internal().doc("The interval at which continuous execution readers will poll to check whether the epoch has advanced on the driver.").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)100L));
        this.DISABLED_V2_STREAMING_WRITERS = this.buildConf("spark.sql.streaming.disabledV2Writers").internal().doc("A comma-separated list of fully qualified data source register class names for which StreamWriteSupport is disabled. Writes to these sources will fall back to the V1 Sinks.").stringConf().createWithDefault((Object)"");
        this.DISABLED_V2_STREAMING_MICROBATCH_READERS = this.buildConf("spark.sql.streaming.disabledV2MicroBatchReaders").internal().doc("A comma-separated list of fully qualified data source register class names for which MicroBatchReadSupport is disabled. Reads from these sources will fall back to the V1 Sources.").stringConf().createWithDefault((Object)"");
        this.PARTITION_OVERWRITE_MODE = this.buildConf("spark.sql.sources.partitionOverwriteMode").doc("When INSERT OVERWRITE a partitioned data source table, we currently support 2 modes: static and dynamic. In static mode, Spark deletes all the partitions that match the partition specification(e.g. PARTITION(a=1,b)) in the INSERT statement, before overwriting. In dynamic mode, Spark doesn't delete partitions ahead, and only overwrite those partitions that have data written into it at runtime. By default we use static mode to keep the same behavior of Spark prior to 2.3. Note that this config doesn't affect Hive serde tables, as they are always overwritten with dynamic mode. This can also be set as an output option for a data source using key partitionOverwriteMode (which takes precedence over this setting), e.g. dataframe.write.option(\"partitionOverwriteMode\", \"dynamic\").save(path).").stringConf().transform((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toUpperCase(Locale.ROOT)).checkValues((scala.collection.immutable.Set)SQLConf$PartitionOverwriteMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).createWithDefault((Object)SQLConf$PartitionOverwriteMode$.MODULE$.STATIC().toString());
        this.SORT_BEFORE_REPARTITION = this.buildConf("spark.sql.execution.sortBeforeRepartition").internal().doc("When perform a repartition following a shuffle, the output row ordering would be nondeterministic. If some downstream stages fail and some tasks of the repartition stage retry, these tasks may generate different data, and that can lead to correctness issues. Turn on this config to insert a local sort before actually doing repartition to generate consistent repartition results. The performance of repartition() may go down since we insert extra local sort before it.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.NESTED_SCHEMA_PRUNING_ENABLED = this.buildConf("spark.sql.optimizer.nestedSchemaPruning.enabled").internal().doc("Prune nested fields from a logical relation's output which are unnecessary in satisfying a query. This optimization allows columnar file format readers to avoid reading unnecessary nested column data. Currently Parquet is the only data source that implements this optimization.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.TOP_K_SORT_FALLBACK_THRESHOLD = this.buildConf("spark.sql.execution.topKSortFallbackThreshold").internal().doc("In SQL queries with a SORT followed by a LIMIT like 'SELECT x FROM t ORDER BY y LIMIT m', if m is under this threshold, do a top-K sort in memory, otherwise do a global sort which spills to disk if necessary.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.CSV_PARSER_COLUMN_PRUNING = this.buildConf("spark.sql.csv.parser.columnPruning.enabled").internal().doc("If it is set to true, column names of the requested schema are passed to CSV parser. Other column values can be ignored during parsing even if they are malformed.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.REPL_EAGER_EVAL_ENABLED = this.buildConf("spark.sql.repl.eagerEval.enabled").doc("Enables eager evaluation or not. When true, the top K rows of Dataset will be displayed if and only if the REPL supports the eager evaluation. Currently, the eager evaluation is only supported in PySpark. For the notebooks like Jupyter, the HTML table (generated by _repr_html_) will be returned. For plain Python REPL, the returned outputs are formatted like dataframe.show().").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.REPL_EAGER_EVAL_MAX_NUM_ROWS = this.buildConf("spark.sql.repl.eagerEval.maxNumRows").doc("The max number of rows that are returned by eager evaluation. This only takes effect when spark.sql.repl.eagerEval.enabled is set to true. The valid range of this config is from 0 to (Int.MaxValue - 1), so the invalid config like negative and greater than (Int.MaxValue - 1) will be normalized to 0 and (Int.MaxValue - 1).").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)20));
        this.REPL_EAGER_EVAL_TRUNCATE = this.buildConf("spark.sql.repl.eagerEval.truncate").doc("The max number of characters for each cell that is returned by eager evaluation. This only takes effect when spark.sql.repl.eagerEval.enabled is set to true.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)20));
        this.FAST_HASH_AGGREGATE_MAX_ROWS_CAPACITY_BIT = this.buildConf("spark.sql.codegen.aggregate.fastHashMap.capacityBit").internal().doc("Capacity for the max number of rows to be held in memory by the fast hash aggregate product operator. The bit is not for actual value, but the actual numBuckets is determined by loadFactor (e.g: default bit value 16 , the actual numBuckets is ((1 << 16) / 0.5).").intConf().checkValue((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)bit -> bit >= 10 && bit <= 30, "The bit value must be in [10, 30].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)16));
        this.AVRO_COMPRESSION_CODEC = this.buildConf("spark.sql.avro.compression.codec").doc("Compression codec used in writing of AVRO files. Supported codecs: uncompressed, deflate, snappy, bzip2 and xz. Default codec is snappy.").stringConf().checkValues((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uncompressed", "deflate", "snappy", "bzip2", "xz"}))).createWithDefault((Object)"snappy");
        this.AVRO_DEFLATE_LEVEL = this.buildConf("spark.sql.avro.deflate.level").doc("Compression level for the deflate codec used in writing of AVRO files. Valid value must be in the range of from 1 to 9 inclusive or -1. The default value is -1 which corresponds to 6 level in the current implementation.").intConf().checkValues((scala.collection.immutable.Set)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).toSet().$plus((Object)BoxesRunTime.boxToInteger((int)-1))).createWithDefault((Object)BoxesRunTime.boxToInteger((int)-1));
        this.COMPARE_DATE_TIMESTAMP_IN_TIMESTAMP = this.buildConf("spark.sql.legacy.compareDateTimestampInTimestamp").internal().doc("When true (default), compare Date with Timestamp after converting both sides to Timestamp. This behavior is compatible with Hive 2.2 or later. See HIVE-15236. When false, restore the behavior prior to Spark 2.4. Compare Date with Timestamp after converting both sides to string. This config will be removed in Spark 3.0.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.LEGACY_SIZE_OF_NULL = this.buildConf("spark.sql.legacy.sizeOfNull").doc("If it is set to true, size of null returns -1. This behavior was inherited from Hive. The size function returns null for null input if the flag is disabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.LEGACY_REPLACE_DATABRICKS_SPARK_AVRO_ENABLED = this.buildConf("spark.sql.legacy.replaceDatabricksSparkAvro.enabled").doc("If it is set to true, the data source provider com.databricks.spark.avro is mapped to the built-in but external Avro data source module for backward compatibility.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.LEGACY_SETOPS_PRECEDENCE_ENABLED = this.buildConf("spark.sql.legacy.setopsPrecedence.enabled").internal().doc("When set to true and the order of evaluation is not specified by parentheses, the set operations are performed from left to right as they appear in the query. When set to false and order of evaluation is not specified by parentheses, INTERSECT operations are performed before any UNION, EXCEPT and MINUS operations.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.LEGACY_HAVING_WITHOUT_GROUP_BY_AS_WHERE = this.buildConf("spark.sql.legacy.parser.havingWithoutGroupByAsWhere").internal().doc("If it is set to true, the parser will treat HAVING without GROUP BY as a normal WHERE, which does not follow SQL standard.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }
}

