/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp[, idx]) - Extracts a group that matches `regexp`.", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ")
@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0014(\u0001RB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0013Y\u0006\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0003f\u0011%Y\u0007\u00011A\u0001B\u0003&A\fC\u0005q\u0001\u0001\u0007\t\u0019!C\u0005c\"IA\u0010\u0001a\u0001\u0002\u0004%I! \u0005\n\u007f\u0002\u0001\r\u0011!Q!\nIDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003?\u0002A\u0011KA1\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\n\"I\u0011q\u0014\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003C\u0003\u0011\u0013!C\u0001\u0003\u0013C\u0011\"a)\u0001\u0003\u0003%\t%!*\t\u0013\u0005E\u0006!!A\u0005\u0002\u0005M\u0006\"CA^\u0001\u0005\u0005I\u0011AA_\u0011%\t\t\rAA\u0001\n\u0003\n\u0019\rC\u0005\u0002R\u0002\t\t\u0011\"\u0001\u0002T\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0013q\\\u0004\n\u0003o<\u0013\u0011!E\u0001\u0003s4\u0001BJ\u0014\u0002\u0002#\u0005\u00111 \u0005\u0007\u001f\u0002\"\tA!\u0003\t\u0013\t-\u0001%!A\u0005F\t5\u0001\"\u0003B\bA\u0005\u0005I\u0011\u0011B\t\u0011%\u0011I\u0002IA\u0001\n\u0003\u0013Y\u0002C\u0005\u0003.\u0001\n\t\u0011\"\u0003\u00030\ti!+Z4FqB,\u0005\u0010\u001e:bGRT!\u0001K\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003U-\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Y5\n1a]9m\u0015\tqs&A\u0003ta\u0006\u00148N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0006\u0001UJDH\u0011\t\u0003m]j\u0011aJ\u0005\u0003q\u001d\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t1$(\u0003\u0002<O\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0004Qe>$Wo\u0019;\u0011\u0005u\u001a\u0015B\u0001#?\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\u0019XO\u00196fGR,\u0012a\u0012\t\u0003m!K!!S\u0014\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0005tk\nTWm\u0019;!\u0003\u0019\u0011XmZ3ya\u00069!/Z4fqB\u0004\u0013aA5eq\u0006!\u0011\u000e\u001a=!\u0003\u0019a\u0014N\\5u}Q!\u0011KU*U!\t1\u0004\u0001C\u0003F\u000f\u0001\u0007q\tC\u0003L\u000f\u0001\u0007q\tC\u0003N\u000f\u0001\u0007q\tF\u0002R-bCQa\u0016\u0005A\u0002\u001d\u000b\u0011a\u001d\u0005\u00063\"\u0001\raR\u0001\u0002e\u0006IA.Y:u%\u0016<W\r_\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0006if\u0004Xm\u001d\u0006\u0003C6\na!\u001e8tC\u001a,\u0017BA2_\u0005))FK\u0012\u001dTiJLgnZ\u0001\u000eY\u0006\u001cHOU3hKb|F%Z9\u0015\u0005\u0019L\u0007CA\u001fh\u0013\tAgH\u0001\u0003V]&$\bb\u00026\u000b\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014A\u00037bgR\u0014VmZ3yA!\u00121\"\u001c\t\u0003{9L!a\u001c \u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00029biR,'O\\\u000b\u0002eB\u00111O_\u0007\u0002i*\u0011QO^\u0001\u0006e\u0016<W\r\u001f\u0006\u0003ob\fA!\u001e;jY*\t\u00110\u0001\u0003kCZ\f\u0017BA>u\u0005\u001d\u0001\u0016\r\u001e;fe:\f1\u0002]1ui\u0016\u0014hn\u0018\u0013fcR\u0011aM \u0005\bU6\t\t\u00111\u0001s\u0003!\u0001\u0018\r\u001e;fe:\u0004\u0003F\u0001\bn\u00031qW\u000f\u001c7TC\u001a,WI^1m)!\t9!!\u0004\u0002\u0010\u0005M\u0001cA\u001f\u0002\n%\u0019\u00111\u0002 \u0003\u0007\u0005s\u0017\u0010\u0003\u0004X\u001f\u0001\u0007\u0011q\u0001\u0005\b\u0003#y\u0001\u0019AA\u0004\u0003\u0005\u0001\bBB-\u0010\u0001\u0004\t9!\u0001\u0005eCR\fG+\u001f9f+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005}QBAA\u000f\u0015\ty6&\u0003\u0003\u0002\"\u0005u!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002(A1\u0011\u0011FA\u001d\u0003\u007fqA!a\u000b\u000269!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022M\na\u0001\u0010:p_Rt\u0014\"A \n\u0007\u0005]b(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\u0004'\u0016\f(bAA\u001c}A!\u00111DA!\u0013\u0011\t\u0019%!\b\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001C2iS2$'/\u001a8\u0016\u0005\u0005%\u0003#BA\u0015\u0003s9\u0015A\u00039sKR$\u0018PT1nKV\u0011\u0011q\n\t\u0005\u0003#\nIF\u0004\u0003\u0002T\u0005U\u0003cAA\u0017}%\u0019\u0011q\u000b \u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\r\t9FP\u0001\nI><UM\\\"pI\u0016$b!a\u0019\u0002p\u0005e\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%t%A\u0004d_\u0012,w-\u001a8\n\t\u00055\u0014q\r\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\u000f\u000bA\u0002\u0005M\u0014aA2uqB!\u0011QMA;\u0013\u0011\t9(a\u001a\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\u0010\u000bA\u0002\u0005\r\u0014AA3w\u0003\u0011\u0019w\u000e]=\u0015\u000fE\u000b\t)a!\u0002\u0006\"9Q)\u0006I\u0001\u0002\u00049\u0005bB&\u0016!\u0003\u0005\ra\u0012\u0005\b\u001bV\u0001\n\u00111\u0001H\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a#+\u0007\u001d\u000bii\u000b\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015!C;oG\",7m[3e\u0015\r\tIJP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAO\u0003'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0003B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[C\u0018\u0001\u00027b]\u001eLA!a\u0017\u0002,\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0017\t\u0004{\u0005]\u0016bAA]}\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qAA`\u0011!Q7$!AA\u0002\u0005U\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\u0007CBAd\u0003\u001b\f9!\u0004\u0002\u0002J*\u0019\u00111\u001a \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0006%'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!6\u0002\\B\u0019Q(a6\n\u0007\u0005egHA\u0004C_>dW-\u00198\t\u0011)l\u0012\u0011!a\u0001\u0003\u000f\ta!Z9vC2\u001cH\u0003BAk\u0003CD\u0001B\u001b\u0010\u0002\u0002\u0003\u0007\u0011q\u0001\u0015\f\u0001\u0005\u0015\u00181^Aw\u0003c\f\u0019\u0010E\u00027\u0003OL1!!;(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a<\u0002\t~3UKT\"`QM$(\u000f\f\u0011sK\u001e,\u0007\u0010].-A%$\u00070X\u0015![\u0001*\u0005\u0010\u001e:bGR\u001c\b%\u0019\u0011he>,\b\u000f\t;iCR\u0004S.\u0019;dQ\u0016\u001c\b\u0005\u0019:fO\u0016D\b\u000f\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!>\u0002%*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u00191[I\u0002\u0004g\n\u0017!O!bF\fZ\u0016*[!bF\fZ\u0016*O1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cA\u0002$\u0002\t\u0011\u0002\u001bI+w-\u0012=q\u000bb$(/Y2u!\t1\u0004e\u0005\u0003!\u0003{\u0014\u0005\u0003CA\u0000\u0005\u000b9uiR)\u000e\u0005\t\u0005!b\u0001B\u0002}\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u0004\u0005\u0003\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\tI0\u0001\u0005u_N#(/\u001b8h)\t\t9+A\u0003baBd\u0017\u0010F\u0004R\u0005'\u0011)Ba\u0006\t\u000b\u0015\u001b\u0003\u0019A$\t\u000b-\u001b\u0003\u0019A$\t\u000b5\u001b\u0003\u0019A$\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0004B\u0015!\u0015i$q\u0004B\u0012\u0013\r\u0011\tC\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ru\u0012)cR$H\u0013\r\u00119C\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t-B%!AA\u0002E\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tE\u0002\u0003BAU\u0005gIAA!\u000e\u0002,\n1qJ\u00196fGR\u0004")
public class RegExpExtract
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract regExpExtract) {
        return RegExpExtract$.MODULE$.unapply(regExpExtract);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtract> tupled() {
        return RegExpExtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtract>>> curried() {
        return RegExpExtract$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression idx() {
        return this.idx;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        MatchResult mr;
        String group;
        Matcher m;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        return (m = this.pattern().matcher(s.toString())).find() ? ((group = (mr = m.toMatchResult()).group(BoxesRunTime.unboxToInt((Object)r))) == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group)) : UTF8String.EMPTY_UTF8;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.idx();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(476).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      java.util.regex.Matcher ").append(matcher).append(" =\n        ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n      if (").append(matcher).append(".find()) {\n        java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n        if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n          ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        } else {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append("));\n        }\n        ").append(setEvNotNull).append("\n      } else {\n        ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        ").append(setEvNotNull).append("\n      }").toString());
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
        ExpectsInputTypes.$init$(this);
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

