/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015Y\u0006\u0001\"\u0015]\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0015A\b\u0001\"\u0011z\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001dI\u0011\u0011\u0011\u000f\u0002\u0002#\u0005\u00111\u0011\u0004\t7q\t\t\u0011#\u0001\u0002\u0006\"1!)\u0006C\u0001\u0003'C\u0011\"!&\u0016\u0003\u0003%)%a&\t\u0013\u0005eU#!A\u0005\u0002\u0006m\u0005\"CAQ+\u0005\u0005I\u0011QAR\u0011%\t),FA\u0001\n\u0013\t9LA\u0005GS:$\u0017J\\*fi*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001U9\nt\u0007\u0005\u0002,Y5\tA$\u0003\u0002.9\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003W=J!\u0001\r\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00023q%\u0011\u0011h\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001=!\tYS(\u0003\u0002?9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019A)\u0012$\u0011\u0005-\u0002\u0001\"\u0002\u001e\u0006\u0001\u0004a\u0004\"\u0002!\u0006\u0001\u0004a\u0014AC5oaV$H+\u001f9fgV\t\u0011\nE\u0002K%Vs!a\u0013)\u000f\u00051{U\"A'\u000b\u00059C\u0013A\u0002\u001fs_>$h(C\u00015\u0013\t\t6'A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&aA*fc*\u0011\u0011k\r\t\u0003-fk\u0011a\u0016\u0006\u00031\u0002\nQ\u0001^=qKNL!AW,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA/aEB\u0011!GX\u0005\u0003?N\u00121!\u00118z\u0011\u0015\tw\u00011\u0001^\u0003\u00119xN\u001d3\t\u000b\r<\u0001\u0019A/\u0002\u0007M,G/A\u0005e_\u001e+gnQ8eKR\u0019a\r\\9\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0012aB2pI\u0016<WM\\\u0005\u0003W\"\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006[\"\u0001\rA\\\u0001\u0004GRD\bCA4p\u0013\t\u0001\bN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bID\u0001\u0019\u00014\u0002\u0005\u00154\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0004\"A\u0016<\n\u0005]<&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001{!\tYxP\u0004\u0002}{B\u0011AjM\u0005\u0003}N\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@4\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0011\u000bI!a\u0003\t\u000fiZ\u0001\u0013!a\u0001y!9\u0001i\u0003I\u0001\u0002\u0004a\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#Q3\u0001PA\nW\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0010g\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\u0005Y\u0006twM\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\t\t!a\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0002c\u0001\u001a\u0002@%\u0019\u0011\u0011I\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007u\u000b9\u0005C\u0005\u0002JA\t\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0014\u0011\u000b\u0005E\u0013qK/\u000e\u0005\u0005M#bAA+g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00131\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002`\u0005\u0015\u0004c\u0001\u001a\u0002b%\u0019\u00111M\u001a\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\n\n\u0002\u0002\u0003\u0007Q,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\nY\u0007\u0003\u0005\u0002JM\t\t\u00111\u0001^Q-\u0001\u0011qNA;\u0003o\nY(! \u0011\u0007-\n\t(C\u0002\u0002tq\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002z\u0005\t\u0019M\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!gR\u0014x,\u0019:sCfL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001b8eKb\u0004\u0003&M\u0017cCN,G-\u000b\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI:ue&tw\r\t\u0015agR\u0014\b-\u000b\u0011j]\u0002\"\b.\u001a\u0011d_6l\u0017-\f3fY&l\u0017\u000e^3eA1L7\u000f\u001e\u0011)AN$(oX1se\u0006L\b-\u000b\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011SKR,(O\\:!a1\u0002\u0013N\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e\u0004s/Y:!]>$\bEZ8v]\u0012\u0004sN\u001d\u0011jM\u0002\"\b.\u001a\u0011hSZ,g\u000eI:ue&tw\r\t\u0015agR\u0014\b-\u000b\u0011d_:$\u0018-\u001b8tA\u0005\u00043m\\7nC:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qP\u0001I\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013MY\u0014-O\u0005\u00147\r\f2-C\nd3\r\f3fM\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\n\u0011BR5oI&s7+\u001a;\u0011\u0005-*2\u0003B\u000b\u0002\b^\u0002r!!#\u0002\u0010rbD)\u0004\u0002\u0002\f*\u0019\u0011QR\u001a\u0002\u000fI,h\u000e^5nK&!\u0011\u0011SAF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u0007\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003W\tQ!\u00199qYf$R\u0001RAO\u0003?CQA\u000f\rA\u0002qBQ\u0001\u0011\rA\u0002q\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002&\u0006E\u0006#\u0002\u001a\u0002(\u0006-\u0016bAAUg\t1q\n\u001d;j_:\u0004RAMAWyqJ1!a,4\u0005\u0019!V\u000f\u001d7fe!A\u00111W\r\u0002\u0002\u0003\u0007A)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0018\t\u0005\u0003[\tY,\u0003\u0003\u0002>\u0006=\"AB(cU\u0016\u001cG\u000f")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet findInSet) {
        return FindInSet$.MODULE$.unapply(findInSet);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)set).findInSet((UTF8String)word));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(word, set) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)set).append(".findInSet(").append((String)word).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

