/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005I\u0001\tE\t\u0015!\u0003F\u0011!I\u0005A!f\u0001\n\u0003q\u0004\u0002\u0003&\u0001\u0005#\u0005\u000b\u0011B \t\u000b-\u0003A\u0011\u0001'\t\u000b-\u0003A\u0011A)\t\u000b-\u0003A\u0011\u0001+\t\u000bY\u0003A\u0011I,\t\u000b\u0011\u0002A\u0011I4\t\u000bA\u0004A\u0011I4\t\u000fE\u0004\u0011\u0011!C\u0001e\"9a\u000fAI\u0001\n\u00039\b\"CA\u0003\u0001E\u0005I\u0011AA\u0004\u0011!\tY\u0001AI\u0001\n\u00039\b\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0011%\ty\u0002AA\u0001\n\u0003\t\t\u0003C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003B\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\b\u0013\u0005-t$!A\t\u0002\u00055d\u0001\u0003\u0010 \u0003\u0003E\t!a\u001c\t\r-CB\u0011AA?\u0011%\ty\bGA\u0001\n\u000b\n\t\tC\u0005\u0002\u0004b\t\t\u0011\"!\u0002\u0006\"I\u0011Q\u0012\r\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003;C\u0012\u0011!C\u0005\u0003?\u00131\u0002U1sg\u0016$v\u000eR1uK*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[E\"$\b\u0005\u0002/_5\tq$\u0003\u00021?\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003}\u0002\"A\f!\n\u0005\u0005{\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012!\u0012\t\u0004k\u0019{\u0014BA$7\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002/\u0001!)Qh\u0002a\u0001\u007f!)1i\u0002a\u0001\u000b\")\u0011j\u0002a\u0001\u007fQ\u0019QJU*\t\u000buB\u0001\u0019A \t\u000b\rC\u0001\u0019A \u0015\u00055+\u0006\"B\u001f\n\u0001\u0004y\u0014!\u00044mCR\f%oZ;nK:$8/F\u0001Y!\rI\u0016\r\u001a\b\u00035~s!a\u00170\u000e\u0003qS!!X\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u000117\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0011%#XM]1u_JT!\u0001\u0019\u001c\u0011\u0005U*\u0017B\u000147\u0005\r\te._\u000b\u0002QB\u0011\u0011.\u001c\b\u0003U.\u0004\"a\u0017\u001c\n\u000514\u0014A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\u001c\u001c\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0003d_BLH\u0003B'tiVDq!P\u0007\u0011\u0002\u0003\u0007q\bC\u0004D\u001bA\u0005\t\u0019A#\t\u000f%k\u0001\u0013!a\u0001\u007f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001=+\u0005}J8&\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0005v]\u000eDWmY6fI*\u0011qPN\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0002y\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0002\u0016\u0003\u000bf\fabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\u00079\f)\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002$A\u0019Q'!\n\n\u0007\u0005\u001dbGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002e\u0003[A\u0011\"a\f\u0014\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0004E\u0003\u00028\u0005uB-\u0004\u0002\u0002:)\u0019\u00111\b\u001c\u0002\u0015\r|G\u000e\\3di&|g.C\u0002c\u0003s\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\nI\u0005E\u00026\u0003\u000bJ1!a\u00127\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\f\u0016\u0003\u0003\u0005\r\u0001Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0013q\n\u0005\t\u0003_1\u0012\u0011!a\u0001I\"z\u0001!a\u0015\u0002Z\u0005m\u0013qLA1\u0003K\n9\u0007E\u0002/\u0003+J1!a\u0016 \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0018\u0002\u0003sS\u0001\u0005\t\u0011!?\u001a+fjQ0)I\u0006$XmX:uenc\u0003EZ7u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u0002G-\u0019;f?N$(\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004s/\u001b;iAQDW\r\t1g[R\u0004\u0007%\u001a=qe\u0016\u001c8/[8oAQ|'\u0002\t\u0011!A\u0001\u0002\u0013\r\t3bi\u0016t\u0003EU3ukJt7\u000f\t8vY2\u0004s/\u001b;iA%tg/\u00197jI\u0002Jg\u000e];u]\u0001\u0012\u0015\u0010\t3fM\u0006,H\u000e\u001e\u0017!SR\u0004cm\u001c7m_^\u001c\beY1ti&tw\r\t:vY\u0016\u001c\b\u0005^8!C\u0002\"\u0017\r^3!S\u001aT\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111M\u0001\u0002.)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aAJT\u0006M\u001c.gAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002j\u0005)\u0011GL\u001b/a\u0005Y\u0001+\u0019:tKR{G)\u0019;f!\tq\u0003d\u0005\u0003\u0019\u0003cR\u0004\u0003CA:\u0003szTiP'\u000e\u0005\u0005U$bAA<m\u00059!/\u001e8uS6,\u0017\u0002BA>\u0003k\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\ti'\u0001\u0005u_N#(/\u001b8h)\t\t\t\"A\u0003baBd\u0017\u0010F\u0004N\u0003\u000f\u000bI)a#\t\u000buZ\u0002\u0019A \t\u000b\r[\u0002\u0019A#\t\u000b%[\u0002\u0019A \u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011SAM!\u0011)d)a%\u0011\rU\n)jP#@\u0013\r\t9J\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005mE$!AA\u00025\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0006\u0003BA\n\u0003GKA!!*\u0002\u0016\t1qJ\u00196fGR\u0004")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new Cast(new UnixTimestamp(left, format, UnixTimestamp$.MODULE$.apply$default$3()), TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

