/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.8446490682263027\n      > SELECT _FUNC_(null);\n       0.8446490682263027\n  ", note="The function is non-deterministic in general case.")
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!)Q\b\u0001C\u0001}!)Q\b\u0001C\u0001\u0003\")!\t\u0001C!\u0007\")\u0011\n\u0001C)\u0015\")A\u000b\u0001C!+\")1\r\u0001C!\u0003\"9A\rAA\u0001\n\u0003)\u0007bB4\u0001#\u0003%\t\u0001\u001b\u0005\bg\u0002\t\t\u0011\"\u0011u\u0011\u001di\b!!A\u0005\u0002yD\u0011\"!\u0002\u0001\u0003\u0003%\t!a\u0002\t\u0013\u0005M\u0001!!A\u0005B\u0005U\u0001\"CA\u0012\u0001\u0005\u0005I\u0011AA\u0013\u0011%\ty\u0003AA\u0001\n\u0003\n\tdB\u0004\u0002PeA\t!!\u0015\u0007\raI\u0002\u0012AA*\u0011\u0019i$\u0003\"\u0001\u0002\\!9\u0011Q\f\n\u0005\u0002\u0005}\u0003\"CA/%\u0005\u0005I\u0011QA2\u0011%\t9GEA\u0001\n\u0003\u000bI\u0007C\u0005\u0002vI\t\t\u0011\"\u0003\u0002x\t!!+\u00198e\u0015\tQ2$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011#\u0002\u0001(W9\"\u0004C\u0001\u0015*\u001b\u0005I\u0012B\u0001\u0016\u001a\u0005\r\u0011Fi\u0012\t\u0003Q1J!!L\r\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0004Qe>$Wo\u0019;\u0011\u0005=*\u0014B\u0001\u001c1\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\u0004C\u0001\u0015;\u0013\tY\u0014D\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002@\u0001B\u0011\u0001\u0006\u0001\u0005\u0006o\r\u0001\r!\u000f\u000b\u0002\u007f\u0005Yq/\u001b;i\u001d\u0016<8+Z3e)\tyD\tC\u0003F\u000b\u0001\u0007a)\u0001\u0003tK\u0016$\u0007CA\u0018H\u0013\tA\u0005G\u0001\u0003M_:<\u0017\u0001D3wC2Le\u000e^3s]\u0006dGCA&O!\tyC*\u0003\u0002Na\t1Ai\\;cY\u0016DQa\u0014\u0004A\u0002A\u000bQ!\u001b8qkR\u0004\"!\u0015*\u000e\u0003mI!aU\u000e\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2A\u0016/b!\t9&,D\u0001Y\u0015\tI\u0016$A\u0004d_\u0012,w-\u001a8\n\u0005mC&\u0001C#yaJ\u001cu\u000eZ3\t\u000bu;\u0001\u0019\u00010\u0002\u0007\r$\b\u0010\u0005\u0002X?&\u0011\u0001\r\u0017\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0011w\u00011\u0001W\u0003\t)g/A\u0005ge\u0016\u001c\bnQ8qs\u0006!1m\u001c9z)\tyd\rC\u00048\u0013A\u0005\t\u0019A\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0011N\u000b\u0002:U.\n1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003aB\n!\"\u00198o_R\fG/[8o\u0013\t\u0011XNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001\u00027b]\u001eT\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}o\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a \t\u0004_\u0005\u0005\u0011bAA\u0002a\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011BA\b!\ry\u00131B\u0005\u0004\u0003\u001b\u0001$aA!os\"A\u0011\u0011C\u0007\u0002\u0002\u0003\u0007q0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0001b!!\u0007\u0002 \u0005%QBAA\u000e\u0015\r\ti\u0002M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0011\u00037\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qEA\u0017!\ry\u0013\u0011F\u0005\u0004\u0003W\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003#y\u0011\u0011!a\u0001\u0003\u0013\ta!Z9vC2\u001cH\u0003BA\u0014\u0003gA\u0011\"!\u0005\u0011\u0003\u0003\u0005\r!!\u0003)\u001f\u0001\t9$!\u0010\u0002@\u0005\r\u0013QIA%\u0003\u0017\u00022\u0001KA\u001d\u0013\r\tY$\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t%AA\u0006?\u001a+fjQ0)7N,W\rZ/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011sC:$w.\u001c\u0011wC2,X\rI<ji\"\u0004\u0013N\u001c3fa\u0016tG-\u001a8uA\u0005tG\rI5eK:$\u0018nY1mYf\u0004C-[:ue&\u0014W\u000f^3eA!Jg&\u001b\u0018e]%\u0002SO\\5g_JlG.\u001f\u0011eSN$(/\u001b2vi\u0016$\u0007E^1mk\u0016\u001c\b%\u001b8!7Bb\u0003%M\u0015/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA$\u0003\u0005}#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAr\u0013H\u000e\u001a:oQ\u0012\u0014(N\u00195gQ*Dg\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u00189iQ2D'\u000f\u00197qI\u0012dg\r\u00193o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.\u001e7mSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003G\f\u001d5iY\"\u0014\b\r\u001c9eI24\u0007\r\u001a8\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!!\u0014\u0002eQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!S:\u0004s-\u001a8fe\u0006d\u0007eY1tK:\nAAU1oIB\u0011\u0001FE\n\u0005%\u0005UC\u0007E\u00020\u0003/J1!!\u00171\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011K\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u007f\u0005\u0005\u0004\"B#\u0015\u0001\u00041EcA \u0002f!)q'\u0006a\u0001s\u00059QO\\1qa2LH\u0003BA6\u0003c\u0002BaLA7s%\u0019\u0011q\u000e\u0019\u0003\r=\u0003H/[8o\u0011!\t\u0019HFA\u0001\u0002\u0004y\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\bE\u0002w\u0003wJ1!! x\u0005\u0019y%M[3di\u0002")
public class Rand
extends RDG
implements ExpressionWithRandomSeed,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$));
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Rand freshCopy() {
        return new Rand(this.child());
    }

    public Rand copy(Expression child) {
        return new Rand(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child) {
        this.child = child;
    }

    public Rand() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$));
    }
}

