/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sentences$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str[, lang, country]) - Splits `str` into an array of array of words.", examples="\n    Examples:\n      > SELECT _FUNC_('Hi there! Good morning.');\n       [[\"Hi\",\"there\"],[\"Good\",\"morning\"]]\n  ")
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0013'\u0001NB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005i!AQ\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005O\u0001\tE\t\u0015!\u00035\u0011!y\u0005A!f\u0001\n\u0003Y\u0005\u0002\u0003)\u0001\u0005#\u0005\u000b\u0011\u0002\u001b\t\u000bE\u0003A\u0011\u0001*\t\u000bE\u0003A\u0011A,\t\u000bE\u0003A\u0011A-\t\u000bq\u0003A\u0011I/\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000bi\u0004A\u0011I>\t\u000bu\u0004A\u0011\t@\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003'B\u0011\"!\u001b\u0001#\u0003%\t!a\u0015\t\u0013\u0005-\u0004!%A\u0005\u0002\u0005M\u0003\"CA7\u0001\u0005\u0005I\u0011IA8\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0001\u0002\b\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003;\u0003\u0011\u0011!C\u0001\u0003?C\u0011\"a)\u0001\u0003\u0003%\t%!*\b\u0013\u0005uf%!A\t\u0002\u0005}f\u0001C\u0013'\u0003\u0003E\t!!1\t\rE[B\u0011AAh\u0011%\t\tnGA\u0001\n\u000b\n\u0019\u000eC\u0005\u0002Vn\t\t\u0011\"!\u0002X\"I\u0011q\\\u000e\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003C\\\u0012\u0013!C\u0001\u0003'B\u0011\"a9\u001c\u0003\u0003%\t)!:\t\u0013\u0005]8$%A\u0005\u0002\u0005M\u0003\"CA}7E\u0005I\u0011AA*\u0011%\tYpGA\u0001\n\u0013\tiPA\u0005TK:$XM\\2fg*\u0011q\u0005K\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002*U\u0005A1-\u0019;bYf\u001cHO\u0003\u0002,Y\u0005\u00191/\u001d7\u000b\u00055r\u0013!B:qCJ\\'BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001iaZ\u0014i\u0012\t\u0003kYj\u0011AJ\u0005\u0003o\u0019\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t)\u0014(\u0003\u0002;M\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002=\u007f5\tQH\u0003\u0002?M\u000591m\u001c3fO\u0016t\u0017B\u0001!>\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005\"K!!S\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007M$(/F\u00015\u0003\u0011\u0019HO\u001d\u0011\u0002\u00111\fgnZ;bO\u0016\f\u0011\u0002\\1oOV\fw-\u001a\u0011\u0002\u000f\r|WO\u001c;ss\u0006A1m\\;oiJL\b%\u0001\u0004=S:LGO\u0010\u000b\u0005'R+f\u000b\u0005\u00026\u0001!)!j\u0002a\u0001i!9Qj\u0002I\u0001\u0002\u0004!\u0004bB(\b!\u0003\u0005\r\u0001\u000e\u000b\u0003'bCQA\u0013\u0005A\u0002Q\"2a\u0015.\\\u0011\u0015Q\u0015\u00021\u00015\u0011\u0015i\u0015\u00021\u00015\u0003!qW\u000f\u001c7bE2,W#\u00010\u0011\u0005\t{\u0016B\u00011D\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011aMK\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0016\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A6\u0011\u00071$xO\u0004\u0002ne:\u0011a.]\u0007\u0002_*\u0011\u0001OM\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!a]\"\u0002\u000fA\f7m[1hK&\u0011QO\u001e\u0002\u0004'\u0016\f(BA:D!\t!\u00070\u0003\u0002zK\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tG\"LG\u000e\u001a:f]V\tA\u0010E\u0002miR\nA!\u001a<bYR\u0019q0!\u0002\u0011\u0007\t\u000b\t!C\u0002\u0002\u0004\r\u00131!\u00118z\u0011%\t9A\u0004I\u0001\u0002\u0004\tI!A\u0003j]B,H\u000f\u0005\u0003\u0002\f\u00055Q\"\u0001\u0015\n\u0007\u0005=\u0001FA\u0006J]R,'O\\1m%><\u0018\u0001D4fiN+g\u000e^3oG\u0016\u001cHCBA\u000b\u0003C\t)\u0004\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002K\u0001\u0005kRLG.\u0003\u0003\u0002 \u0005e!\u0001E$f]\u0016\u0014\u0018nY!se\u0006LH)\u0019;b\u0011\u001d\t\u0019c\u0004a\u0001\u0003K\t\u0011b]3oi\u0016t7-Z:\u0011\t\u0005\u001d\u0012q\u0006\b\u0005\u0003S\tY\u0003\u0005\u0002o\u0007&\u0019\u0011QF\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\rM#(/\u001b8h\u0015\r\tic\u0011\u0005\b\u0003oy\u0001\u0019AA\u001d\u0003\u0019awnY1mKB!\u00111HA\"\u001b\t\tiD\u0003\u0003\u0002\u001c\u0005}\"BAA!\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0013Q\b\u0002\u0007\u0019>\u001c\u0017\r\\3\u0002\t\r|\u0007/\u001f\u000b\b'\u0006-\u0013QJA(\u0011\u001dQ\u0005\u0003%AA\u0002QBq!\u0014\t\u0011\u0002\u0003\u0007A\u0007C\u0004P!A\u0005\t\u0019\u0001\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000b\u0016\u0004i\u0005]3FAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r4)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001a\u0002^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002rA!\u00111OA=\u001b\t\t)H\u0003\u0003\u0002x\u0005}\u0012\u0001\u00027b]\u001eLA!!\r\u0002v\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0010\t\u0004\u0005\u0006\u0005\u0015bAAB\u0007\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q0!#\t\u0013\u0005-e#!AA\u0002\u0005}\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0012B)\u00111SAM\u007f6\u0011\u0011Q\u0013\u0006\u0004\u0003/\u001b\u0015AC2pY2,7\r^5p]&!\u00111TAK\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007y\u000b\t\u000b\u0003\u0005\u0002\fb\t\t\u00111\u0001\u0000\u0003\u0019)\u0017/^1mgR\u0019a,a*\t\u0011\u0005-\u0015$!AA\u0002}D3\u0002AAV\u0003c\u000b\u0019,a.\u0002:B\u0019Q'!,\n\u0007\u0005=fEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0016\u0001T0G+:\u001bu\fK:uenc\u0003\u0005\\1oO2\u00023m\\;oiJLX,\u000b\u0011.AM\u0003H.\u001b;tA\u0001\u001cHO\u001d1!S:$x\u000eI1oA\u0005\u0014(/Y=!_\u001a\u0004\u0013M\u001d:bs\u0002zg\rI<pe\u0012\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY,\u00018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0015\u000e\t;iKJ,\u0017\u0005I$p_\u0012\u0004Sn\u001c:oS:<gfJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[&\u0005S5#Y\t\"\b.\u001a:fEuc3LI$p_\u0012\u0014CFI7pe:Lgn\u001a\u0012^;*\u0001\u0003%A\u0005TK:$XM\\2fgB\u0011QgG\n\u00057\u0005\rw\t\u0005\u0005\u0002F\u0006-G\u0007\u000e\u001bT\u001b\t\t9MC\u0002\u0002J\u000e\u000bqA];oi&lW-\u0003\u0003\u0002N\u0006\u001d'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011qX\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011O\u0001\u0006CB\u0004H.\u001f\u000b\b'\u0006e\u00171\\Ao\u0011\u0015Qe\u00041\u00015\u0011\u001die\u0004%AA\u0002QBqa\u0014\u0010\u0011\u0002\u0003\u0007A'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\f\u0019\u0010E\u0003C\u0003S\fi/C\u0002\u0002l\u000e\u0013aa\u00149uS>t\u0007C\u0002\"\u0002pR\"D'C\u0002\u0002r\u000e\u0013a\u0001V;qY\u0016\u001c\u0004\u0002CA{C\u0005\u0005\t\u0019A*\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0004B!a\u001d\u0003\u0002%!!1AA;\u0005\u0019y%M[3di\u0002")
public class Sentences
extends Expression
implements ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private final Expression str;
    private final Expression language;
    private final Expression country;

    public static Expression $lessinit$greater$default$3() {
        return Sentences$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return Sentences$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Sentences sentences) {
        return Sentences$.MODULE$.unapply(sentences);
    }

    public static Expression apply$default$3() {
        return Sentences$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return Sentences$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Sentences> tupled() {
        return Sentences$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Sentences>>> curried() {
        return Sentences$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression language() {
        return this.language;
    }

    public Expression country() {
        return this.country;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(new ArrayType(StringType$.MODULE$, false), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.language();
        Expression expression3 = this.country();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object string = this.str().eval(input);
        if (string == null) {
            genericArrayData = null;
        } else {
            UTF8String languageStr = (UTF8String)this.language().eval(input);
            UTF8String countryStr = (UTF8String)this.country().eval(input);
            Locale locale = languageStr != null && countryStr != null ? new Locale(languageStr.toString(), countryStr.toString()) : Locale.US;
            genericArrayData = this.getSentences(((UTF8String)string).toString(), locale);
        }
        return genericArrayData;
    }

    private GenericArrayData getSentences(String sentences, Locale locale) {
        BreakIterator bi = BreakIterator.getSentenceInstance(locale);
        bi.setText(sentences);
        int idx = 0;
        ArrayBuffer result = new ArrayBuffer();
        while (bi.next() != -1) {
            String sentence = sentences.substring(idx, bi.current());
            idx = bi.current();
            BreakIterator wi = BreakIterator.getWordInstance(locale);
            int widx = 0;
            wi.setText(sentence);
            ArrayBuffer words = new ArrayBuffer();
            while (wi.next() != -1) {
                String word = sentence.substring(widx, wi.current());
                widx = wi.current();
                Object object = Character.isLetterOrDigit(word.charAt(0)) ? words.$plus$eq((Object)UTF8String.fromString((String)word)) : BoxedUnit.UNIT;
            }
            result.$plus$eq((Object)new GenericArrayData((Seq<Object>)words));
        }
        return new GenericArrayData((Seq<Object>)result);
    }

    public Sentences copy(Expression str, Expression language, Expression country) {
        return new Sentences(str, language, country);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.language();
    }

    public Expression copy$default$3() {
        return this.country();
    }

    @Override
    public String productPrefix() {
        return "Sentences";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.language();
                break;
            }
            case 2: {
                expression = this.country();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sentences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sentences)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sentences sentences = (Sentences)x$1;
        Expression expression = this.str();
        Expression expression2 = sentences.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.language();
        Expression expression4 = sentences.language();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.country();
        Expression expression6 = sentences.country();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!sentences.canEqual(this)) return false;
        return true;
    }

    public Sentences(Expression str, Expression language, Expression country) {
        this.str = str;
        this.language = language;
        this.country = country;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public Sentences(Expression str) {
        this(str, Literal$.MODULE$.apply(""), Literal$.MODULE$.apply(""));
    }

    public Sentences(Expression str, Expression language) {
        this(str, language, Literal$.MODULE$.apply(""));
    }
}

