/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len, pad) - Returns `str`, right-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       hi???\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011!1\u0005A!f\u0001\n\u0003y\u0004\u0002C$\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b!\u0003A\u0011A%\t\u000b9\u0003A\u0011I(\t\u000bq\u0003A\u0011I/\t\u000b\u0011\u0004A\u0011I3\t\u000b\u001d\u0004A\u0011\t5\t\u000b=\u0004A\u0011\u000b9\t\u000by\u0004A\u0011I@\t\u0013\u0005E\u0001!!A\u0005\u0002\u0005M\u0001\"CA\u000e\u0001E\u0005I\u0011AA\u000f\u0011%\t\u0019\u0004AI\u0001\n\u0003\ti\u0002C\u0005\u00026\u0001\t\n\u0011\"\u0001\u0002\u001e!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0013\u0011\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0003\"CA6\u0001\u0005\u0005I\u0011AA7\u0011%\t9\bAA\u0001\n\u0003\nIhB\u0005\u0002\u0012\u0002\n\t\u0011#\u0001\u0002\u0014\u001aAq\u0004IA\u0001\u0012\u0003\t)\n\u0003\u0004I3\u0011\u0005\u00111\u0015\u0005\n\u0003KK\u0012\u0011!C#\u0003OC\u0011\"!+\u001a\u0003\u0003%\t)a+\t\u0013\u0005M\u0016$!A\u0005\u0002\u0006U\u0006\"CAd3\u0005\u0005I\u0011BAe\u0005)\u0019FO]5oOJ\u0003\u0016\r\u001a\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M)\u0001A\f\u001a6wA\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e\u001f\n\u0005u:$\u0001D*fe&\fG.\u001b>bE2,\u0017aA:ueV\t\u0001\t\u0005\u00020\u0003&\u0011!\t\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:ue\u0002\n1\u0001\\3o\u0003\u0011aWM\u001c\u0011\u0002\u0007A\fG-\u0001\u0003qC\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005CA\u0018\u0001\u0011\u0015qt\u00011\u0001A\u0011\u0015!u\u00011\u0001A\u0011\u00151u\u00011\u0001A\u0003!\u0019\u0007.\u001b7ee\u0016tW#\u0001)\u0011\u0007EK\u0006I\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011Q\u000bL\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!\u0001W\u001c\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\u0004'\u0016\f(B\u0001-8\u0003!!\u0017\r^1UsB,W#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005$\u0013!\u0002;za\u0016\u001c\u0018BA2a\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\ta\rE\u0002R3z\u000bAB\\;mYN\u000bg-Z#wC2$B!\u001b7n]B\u0011aG[\u0005\u0003W^\u00121!\u00118z\u0011\u0015q4\u00021\u0001j\u0011\u0015!5\u00021\u0001j\u0011\u001515\u00021\u0001j\u0003%!wnR3o\u0007>$W\rF\u0002ror\u0004\"A];\u000e\u0003MT!\u0001\u001e\u0011\u0002\u000f\r|G-Z4f]&\u0011ao\u001d\u0002\t\u000bb\u0004(oQ8eK\")\u0001\u0010\u0004a\u0001s\u0006\u00191\r\u001e=\u0011\u0005IT\u0018BA>t\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ! \u0007A\u0002E\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0002A!\u00111AA\u0006\u001d\u0011\t)!a\u0002\u0011\u0005M;\u0014bAA\u0005o\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u00038\u0003\u0011\u0019w\u000e]=\u0015\u000f)\u000b)\"a\u0006\u0002\u001a!9aH\u0004I\u0001\u0002\u0004\u0001\u0005b\u0002#\u000f!\u0003\u0005\r\u0001\u0011\u0005\b\r:\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\b+\u0007\u0001\u000b\tc\u000b\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C;oG\",7m[3e\u0015\r\ticN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0019\u0003O\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003mC:<'BAA#\u0003\u0011Q\u0017M^1\n\t\u00055\u0011qH\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001b\u00022ANA(\u0013\r\t\tf\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004S\u0006]\u0003\"CA-)\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\f\t\u0006\u0003C\n9'[\u0007\u0003\u0003GR1!!\u001a8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\n\u0019G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA8\u0003k\u00022ANA9\u0013\r\t\u0019h\u000e\u0002\b\u0005>|G.Z1o\u0011!\tIFFA\u0001\u0002\u0004I\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002p\u0005m\u0004\u0002CA-/\u0005\u0005\t\u0019A5)\u0017\u0001\ty(!\"\u0002\b\u0006-\u0015Q\u0012\t\u0004_\u0005\u0005\u0015bAABA\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAE\u0003\u0005%$\u0002\t\u0011!A}3UKT\"`QM$(\u000f\f\u0011mK:d\u0003\u0005]1eS\u0001j\u0003EU3ukJt7\u000f\t1tiJ\u0004G\u0006\t:jO\"$X\u0006]1eI\u0016$\u0007e^5uQ\u0002\u0002\u0007/\u00193aAQ|\u0007%\u0019\u0011mK:<G\u000f\u001b\u0011pM\u0002\u0002G.\u001a8a])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y:ue\u0002\u0004\u0013n\u001d\u0011m_:<WM\u001d\u0011uQ\u0006t\u0007\u0005\u00197f]\u0002d\u0003\u0005\u001e5fAI,G/\u001e:oAY\fG.^3!SN\u00043\u000f[8si\u0016tW\r\u001a\u0011u_\u0002\u0002G.\u001a8aA\rD\u0017M]1di\u0016\u00148O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0010\u0006\u0019(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iS\u001eb\u0003%\u000e\u0017!O}zt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q&|th\u0010\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00112Y\u0001:shP\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001B'\u0002\t\u0011\u0002\u0015M#(/\u001b8h%B\u000bG\r\u0005\u000203M!\u0011$a&<!!\tI*a(A\u0001\u0002SUBAAN\u0015\r\tijN\u0001\beVtG/[7f\u0013\u0011\t\t+a'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002\u0014\u0006AAo\\*ue&tw\r\u0006\u0002\u0002<\u0005)\u0011\r\u001d9msR9!*!,\u00020\u0006E\u0006\"\u0002 \u001d\u0001\u0004\u0001\u0005\"\u0002#\u001d\u0001\u0004\u0001\u0005\"\u0002$\u001d\u0001\u0004\u0001\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u000b\u0019\rE\u00037\u0003s\u000bi,C\u0002\u0002<^\u0012aa\u00149uS>t\u0007C\u0002\u001c\u0002@\u0002\u0003\u0005)C\u0002\u0002B^\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAc;\u0005\u0005\t\u0019\u0001&\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAf!\u0011\ti$!4\n\t\u0005=\u0017q\b\u0002\u0007\u001f\nTWm\u0019;")
public class StringRPad
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringRPad stringRPad) {
        return StringRPad$.MODULE$.unapply(stringRPad);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringRPad> tupled() {
        return StringRPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringRPad>>> curried() {
        return StringRPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).rpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".rpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "rpad";
    }

    public StringRPad copy(Expression str, Expression len, Expression pad) {
        return new StringRPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringRPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRPad stringRPad = (StringRPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringRPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringRPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringRPad.canEqual(this)) return false;
        return true;
    }

    public StringRPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }
}

