/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('SL', 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004B\u0002\u001f\u0002\t\u0003\t)\u000b\u0003\u0005=\u0003\u0005\u0005I\u0011QAU\u0011%\ty+AI\u0001\n\u0003\tY\u0004C\u0005\u00022\u0006\t\t\u0011\"!\u00024\"I\u0011\u0011Y\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\f\u0011\u0011!C\u0005\u0003\u000b4Aa\f\u0011A\u007f!A\u0011J\u0003BK\u0002\u0013\u0005!\n\u0003\u0005L\u0015\tE\t\u0015!\u0003A\u0011!a%B!f\u0001\n\u0003i\u0005\u0002C)\u000b\u0005#\u0005\u000b\u0011\u0002(\t\u000biRA\u0011\u0001*\t\u000biRA\u0011A+\t\u000biRA\u0011\u0001-\t\u000biSA\u0011I.\t\u000b\u001dTA\u0011\t5\t\u000bITA\u0011I:\t\u000buTA\u0011\t@\t\u0013\u0005e!\"!A\u0005\u0002\u0005m\u0001\"CA\u0011\u0015E\u0005I\u0011AA\u0012\u0011%\tIDCI\u0001\n\u0003\tY\u0004C\u0005\u0002@)\t\t\u0011\"\u0011\u0002B!I\u0011\u0011\u000b\u0006\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037R\u0011\u0011!C\u0001\u0003;B\u0011\"a\u0019\u000b\u0003\u0003%\t%!\u001a\t\u0013\u0005M$\"!A\u0005\u0002\u0005U\u0004\"CA@\u0015\u0005\u0005I\u0011IAA\u0003)\u0019FO]5oOR\u0013\u0018.\u001c\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001A\u0011a&A\u0007\u0002A\tQ1\u000b\u001e:j]\u001e$&/[7\u0014\u0007\u0005\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003eaJ!!O\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005i\u0013!B1qa2LH#\u0002 \u0002 \u0006\r\u0006C\u0001\u0018\u000b'\u0015Q\u0001i\u0011$8!\tq\u0013)\u0003\u0002CA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\"\u0015BA#!\u0005U\u0019FO]5oOJ\"&/[7FqB\u0014Xm]:j_:\u0004\"AM$\n\u0005!\u001b$a\u0002)s_\u0012,8\r^\u0001\u0007gJ\u001c7\u000b\u001e:\u0016\u0003\u0001\u000bqa\u001d:d'R\u0014\b%A\u0004ue&l7\u000b\u001e:\u0016\u00039\u00032AM(A\u0013\t\u00016G\u0001\u0004PaRLwN\\\u0001\tiJLWn\u0015;sAQ\u0019ah\u0015+\t\u000b%{\u0001\u0019\u0001!\t\u000f1{\u0001\u0013!a\u0001\u001dR\u0019aHV,\t\u000b1\u0003\u0002\u0019\u0001!\t\u000b%\u0003\u0002\u0019\u0001!\u0015\u0005yJ\u0006\"B%\u0012\u0001\u0004\u0001\u0015A\u00039sKR$\u0018PT1nKV\tA\f\u0005\u0002^I:\u0011aL\u0019\t\u0003?Nj\u0011\u0001\u0019\u0006\u0003C2\na\u0001\u0010:p_Rt\u0014BA24\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u001c\u0014\u0001C2iS2$'/\u001a8\u0016\u0003%\u00042A[8A\u001d\tYWN\u0004\u0002`Y&\tA'\u0003\u0002og\u00059\u0001/Y2lC\u001e,\u0017B\u00019r\u0005\r\u0019V-\u001d\u0006\u0003]N\nA!\u001a<bYR\u0011Ao\u001e\t\u0003eUL!A^\u001a\u0003\u0007\u0005s\u0017\u0010C\u0004y)A\u0005\t\u0019A=\u0002\u000b%t\u0007/\u001e;\u0011\u0005i\\X\"\u0001\u0012\n\u0005q\u0014#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u000b}\fY!!\u0006\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002!\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0003\u0002\u0004\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u000eU\u0001\r!a\u0004\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0002\u0005E\u0011\u0002BA\n\u0003\u0007\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0018U\u0001\ra`\u0001\u0003KZ\fAaY8qsR)a(!\b\u0002 !9\u0011J\u0006I\u0001\u0002\u0004\u0001\u0005b\u0002'\u0017!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)CK\u0002A\u0003OY#!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\u0019\u0014AC1o]>$\u0018\r^5p]&!\u0011qGA\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiDK\u0002O\u0003O\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001\\1oO*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-C\u0002f\u0003\u000f\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0016\u0011\u0007I\n9&C\u0002\u0002ZM\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001^A0\u0011%\t\tgGA\u0001\u0002\u0004\t)&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0002R!!\u001b\u0002pQl!!a\u001b\u000b\u0007\u000554'\u0001\u0006d_2dWm\u0019;j_:LA!!\u001d\u0002l\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9(! \u0011\u0007I\nI(C\u0002\u0002|M\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002bu\t\t\u00111\u0001u\u0003\u0019)\u0017/^1mgR!\u0011qOAB\u0011!\t\tGHA\u0001\u0002\u0004!\bf\u0004\u0006\u0002\b\u00065\u0015qRAJ\u0003+\u000bI*a'\u0011\u00079\nI)C\u0002\u0002\f\u0002\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0012\u0006\u0011\tO\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!Y\u0016\fG-\u001b8hA\u0005tG\r\t;sC&d\u0017N\\4!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015C\u001fRC\u0005\u0005\u001e:j[N#(\u000f\t$S\u001f6\u00033\u000f\u001e:*A5\u0002#+Z7pm\u0016\u0004C\u000f[3!Y\u0016\fG-\u001b8hA\u0005tG\r\t;sC&d\u0017N\\4!AR\u0014\u0018.\\*ue\u0002\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004'B\u0003\u0011!A\u0001zf)\u0016(D?\"bU)\u0011#J\u001d\u001e\u0003CO]5n'R\u0014\bE\u0012*P\u001b\u0002\u001aHO]\u0015![\u0001\u0012V-\\8wK\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!AR\u0014\u0018.\\*ue\u0002\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004'B\u0003\u0011!A\u0001zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005\u0005\u001e:j[N#(\u000f\t$S\u001f6\u00033\u000f\u001e:*A5\u0002#+Z7pm\u0016\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u0002GO]5n'R\u0014\b\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003/\u000b1q\u001f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!iJLWn\u0015;sA5\u0002C\u000f[3!iJLW\u000eI:ue&tw\rI2iCJ\f7\r^3sg\u0002\"x\u000e\t;sS6d\u0003\u0005\u001e5fA\u0011,g-Y;mi\u00022\u0018\r\\;fA%\u001c\b%\u0019\u0011tS:<G.\u001a\u0011ta\u0006\u001cWM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011C\u001fRCE\u0006\t$S\u001f6\u0003S\u0006\t;iKN,\u0007%\u0019:fA-,\u0017p^8sIN\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!iJLW.\\5oO\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007EY8uQ\u0002*g\u000eZ:!_\u001aT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005\t\u0011!A\u0001R\u0003\u0005T#B\t&su\t\f\u0011G%>k\u0005%\f\u0011uQ\u0016\u001cX\rI1sK\u0002ZW-_<pe\u0012\u001c\b\u0005^8!gB,7-\u001b4zAQ\u0014\u0018.\\7j]\u001e\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t;iK\u0002bWM\u001a;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002SM\u001c3!_\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQ\u0013\u0016)\u0013'J\u001d\u001ec\u0003E\u0012*P\u001b\u0002j\u0003\u0005\u001e5fg\u0016\u0004\u0013M]3!W\u0016Lxo\u001c:eg\u0002\"x\u000eI:qK\u000eLg-\u001f\u0011ue&lW.\u001b8hAM$(/\u001b8hA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004C\u000f[3!e&<\u0007\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u001e\u0006\u0011YK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001aFj\n\u0017!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AA\f'o[*R\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012u\n\u0016%!OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005]1sWN\u000b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b'F\u0003\u0012Kej\u0012\u0011('2;\u0003E\u0012*P\u001b\u0002:3k\u00159be.\u001c\u0016\u000bT*(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:l'Fc5K\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015U%\u0006KE*\u0013(HA\u001d\u001aFj\n\u0011G%>k\u0005eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*Ta\u0006\u00148nU)\u000bA\u0001Ba!!)\u0004\u0001\u0004\u0001\u0015aA:ue\")Aj\u0001a\u0001\u0001R\u0019a(a*\t\r\u0005\u0005F\u00011\u0001A)\u0015q\u00141VAW\u0011\u0015IU\u00011\u0001A\u0011\u001daU\u0001%AA\u00029\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t),!0\u0011\tIz\u0015q\u0017\t\u0006e\u0005e\u0006IT\u0005\u0004\u0003w\u001b$A\u0002+va2,'\u0007\u0003\u0005\u0002@\u001e\t\t\u00111\u0001?\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000f\u0004B!!\u0012\u0002J&!\u00111ZA$\u0005\u0019y%M[3di\u0002")
public class StringTrim
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringBuilder(84).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trim(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

