/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t\r\u0002\u0011\t\u0012)A\u0005u!)q\t\u0001C\u0001\u0011\"A1\n\u0001EC\u0002\u0013\u0005A\n\u0003\u0005V\u0001!\u0015\r\u0011\"\u0001M\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015Y\u0007\u0001\"\u0011X\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\ti\u0001\u0001C!\u0003\u001fA\u0011\"!\t\u0001\u0003\u0003%\t!a\t\t\u0013\u0005\u001d\u0002!%A\u0005\u0002\u0005%\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003cB\u0011\"!\u001e\u0001\u0003\u0003%\t%a\u001e\b\u0013\u0005=U$!A\t\u0002\u0005Ee\u0001\u0003\u000f\u001e\u0003\u0003E\t!a%\t\r\u001d3B\u0011AAQ\u0011%\t\u0019KFA\u0001\n\u000b\n)\u000bC\u0005\u0002(Z\t\t\u0011\"!\u0002*\"I\u0011Q\u0016\f\u0002\u0002\u0013\u0005\u0015q\u0016\u0005\n\u0003w3\u0012\u0011!C\u0005\u0003{\u0013\u0011b\u0011:fCR,W*\u00199\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00160kA\u0011A&L\u0007\u0002;%\u0011a&\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002)s_\u0012,8\r\u001e\t\u0003aYJ!aN\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u000f\t\u0004w\r[cB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\ty\u0014&\u0001\u0004=e>|GOP\u0005\u0002e%\u0011!)M\u0001\ba\u0006\u001c7.Y4f\u0013\t!UIA\u0002TKFT!AQ\u0019\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002J\u0015B\u0011A\u0006\u0001\u0005\u0006q\r\u0001\rAO\u0001\u0005W\u0016L8/F\u0001N!\rq5kK\u0007\u0002\u001f*\u0011\u0001+U\u0001\nS6lW\u000f^1cY\u0016T!AU\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U\u001f\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\rY\fG.^3t\u0003!1w\u000e\u001c3bE2,W#\u0001-\u0011\u0005AJ\u0016B\u0001.2\u0005\u001d\u0011un\u001c7fC:\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A~\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003E~\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\tI\u0006$\u0018\rV=qKV\tQ\r\u0005\u0002gS6\tqM\u0003\u0002iC\u0005)A/\u001f9fg&\u0011!n\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0003fm\u0006dGC\u00018r!\t\u0001t.\u0003\u0002qc\t\u0019\u0011I\\=\t\u000fIT\u0001\u0013!a\u0001g\u0006)\u0011N\u001c9viB\u0011A/^\u0007\u0002?%\u0011ao\b\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR!\u0011p`A\u0005!\tQX0D\u0001|\u0015\taX$A\u0004d_\u0012,w-\u001a8\n\u0005y\\(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u00051\u00021\u0001\u0002\u0004\u0005\u00191\r\u001e=\u0011\u0007i\f)!C\u0002\u0002\bm\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\f-\u0001\r!_\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005ma\u0002BA\u000b\u0003/\u0001\"!P\u0019\n\u0007\u0005e\u0011'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033\t\u0014\u0001B2paf$2!SA\u0013\u0011\u001dAT\u0002%AA\u0002i\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002,)\u001a!(!\f,\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000f2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\t\u0019DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001\\1oO*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\r\u0001\u0014qK\u0005\u0004\u00033\n$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00018\u0002`!I\u0011\u0011M\t\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0004#BA5\u0003WrW\"A)\n\u0007\u00055\u0014K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001-\u0002t!A\u0011\u0011M\n\u0002\u0002\u0003\u0007a.\u0001\u0004fcV\fGn\u001d\u000b\u00041\u0006e\u0004\u0002CA1)\u0005\u0005\t\u0019\u00018)\u0017\u0001\ti(a!\u0002\u0006\u0006%\u00151\u0012\t\u0004Y\u0005}\u0014bAAA;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAD\u0003]{f)\u0016(D?\"ZW-\u001f\u0019-AY\fG.^31Y\u0001ZW-_\u0019-AY\fG.^32Y\u0001rcFL\u0015![\u0001\u001a%/Z1uKN\u0004\u0013\rI7ba\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u00043.Z=0m\u0006dW/\u001a\u0011qC&\u00148OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QR\u0001V\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nd\u0006\r\u0017!OI:C\u0006I\u001a/a1\u0002s\u0005N\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0018G\f\u0019;EI\u0012Cf\r\u00181u\t\"$% \u0006!A\u0005I1I]3bi\u0016l\u0015\r\u001d\t\u0003YY\u0019BAFAKkA1\u0011qSAOu%k!!!'\u000b\u0007\u0005m\u0015'A\u0004sk:$\u0018.\\3\n\t\u0005}\u0015\u0011\u0014\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAI\u0003!!xn\u0015;sS:<GCAA\"\u0003\u0015\t\u0007\u000f\u001d7z)\rI\u00151\u0016\u0005\u0006qe\u0001\rAO\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t,a.\u0011\tA\n\u0019LO\u0005\u0004\u0003k\u000b$AB(qi&|g\u000e\u0003\u0005\u0002:j\t\t\u00111\u0001J\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002@B!\u0011QIAa\u0013\u0011\t\u0019-a\u0012\u0003\r=\u0013'.Z2u\u0001")
public class CreateMap
extends Expression
implements scala.Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private final Seq<Expression> children;
    private volatile byte bitmap$0;

    public static Option<Seq<Expression>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<CreateMap, A> function1) {
        return CreateMap$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, CreateMap> compose(Function1<A, Seq<Expression>> function1) {
        return CreateMap$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 % 2 == 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 % 2 != 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.foldable()));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), this.values().exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.nullable())));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object[] keyArray = (Object[])((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.eval(input), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        if (Predef$.MODULE$.genericArrayOps((Object)keyArray).contains(null)) {
            throw new RuntimeException("Cannot use null as map key!");
        }
        Object[] valueArray = (Object[])((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.eval(input), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        return new ArrayBasedMapData(new GenericArrayData(keyArray), new GenericArrayData(valueArray));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String mapClass = ArrayBasedMapData.class.getName();
        DataType dataType = this.dataType();
        if (!(dataType instanceof MapType)) {
            throw new MatchError((Object)dataType);
        }
        MapType mapType = (MapType)dataType;
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        IndexedSeq evalKeys = (IndexedSeq)this.keys().map((Function1 & Serializable & scala.Serializable)e -> e.genCode(ctx), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq evalValues = (IndexedSeq)this.values().map((Function1 & Serializable & scala.Serializable)e -> e.genCode(ctx), IndexedSeq$.MODULE$.canBuildFrom());
        Tuple4<String, String, String, String> tuple4 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<ExprCode>)evalKeys, true);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        String preprocessKeyData = (String)tuple4._1();
        String assignKeys = (String)tuple4._2();
        String postprocessKeyData = (String)tuple4._3();
        String keyArrayData = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)preprocessKeyData, (Object)assignKeys, (Object)postprocessKeyData, (Object)keyArrayData);
        Tuple4 tuple43 = tuple42;
        String preprocessKeyData2 = (String)tuple43._1();
        String assignKeys2 = (String)tuple43._2();
        String postprocessKeyData2 = (String)tuple43._3();
        String keyArrayData2 = (String)tuple43._4();
        Tuple4<String, String, String, String> tuple44 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<ExprCode>)evalValues, false);
        if (tuple44 == null) {
            throw new MatchError(tuple44);
        }
        String preprocessValueData = (String)tuple44._1();
        String assignValues = (String)tuple44._2();
        String postprocessValueData = (String)tuple44._3();
        String valueArrayData = (String)tuple44._4();
        Tuple4 tuple45 = new Tuple4((Object)preprocessValueData, (Object)assignValues, (Object)postprocessValueData, (Object)valueArrayData);
        Tuple4 tuple46 = tuple45;
        String preprocessValueData2 = (String)tuple46._1();
        String assignValues2 = (String)tuple46._2();
        String postprocessValueData2 = (String)tuple46._3();
        String valueArrayData2 = (String)tuple46._4();
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       final boolean ", " = false;\n       ", "\n       ", "\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = new ", "(", ", ", ");\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), preprocessKeyData2, assignKeys2, postprocessKeyData2, preprocessValueData2, assignValues2, postprocessValueData2, ev.value(), mapClass, keyArrayData2, valueArrayData2}));
        return ev.copy(code, ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    public CreateMap copy(Seq<Expression> children2) {
        return new CreateMap(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2) {
        this.children = children2;
    }
}

