/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.1164209726833079\n      > SELECT _FUNC_(null);\n       1.1164209726833079\n  ", note="The function is non-deterministic in general case.", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!)Q\b\u0001C\u0001}!)Q\b\u0001C\u0001\u0003\")!\t\u0001C!\u0007\")\u0011\n\u0001C)\u0015\")A\u000b\u0001C!+\")1\r\u0001C!\u0003\"9A\rAA\u0001\n\u0003)\u0007bB4\u0001#\u0003%\t\u0001\u001b\u0005\bg\u0002\t\t\u0011\"\u0011u\u0011\u001di\b!!A\u0005\u0002yD\u0011\"!\u0002\u0001\u0003\u0003%\t!a\u0002\t\u0013\u0005M\u0001!!A\u0005B\u0005U\u0001\"CA\u0012\u0001\u0005\u0005I\u0011AA\u0013\u0011%\ty\u0003AA\u0001\n\u0003\n\tdB\u0004\u0002VeA\t!a\u0016\u0007\raI\u0002\u0012AA-\u0011\u0019i$\u0003\"\u0001\u0002b!9\u00111\r\n\u0005\u0002\u0005\u0015\u0004\"CA2%\u0005\u0005I\u0011QA5\u0011%\tiGEA\u0001\n\u0003\u000by\u0007C\u0005\u0002|I\t\t\u0011\"\u0003\u0002~\t)!+\u00198e]*\u0011!dG\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001d;\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001O-rC\u0007\u0005\u0002)S5\t\u0011$\u0003\u0002+3\t\u0019!\u000bR$\u0011\u0005!b\u0013BA\u0017\u001a\u0005a)\u0005\u0010\u001d:fgNLwN\\,ji\"\u0014\u0016M\u001c3p[N+W\r\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b!J|G-^2u!\tyS'\u0003\u00027a\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t\u0011\b\u0005\u0002)u%\u00111(\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f\u0001\u0003\"\u0001\u000b\u0001\t\u000b]\u001a\u0001\u0019A\u001d\u0015\u0003}\n1b^5uQ:+woU3fIR\u0011q\b\u0012\u0005\u0006\u000b\u0016\u0001\rAR\u0001\u0005g\u0016,G\r\u0005\u00020\u000f&\u0011\u0001\n\r\u0002\u0005\u0019>tw-\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000e\u0006\u0002L\u001dB\u0011q\u0006T\u0005\u0003\u001bB\u0012a\u0001R8vE2,\u0007\"B(\u0007\u0001\u0004\u0001\u0016!B5oaV$\bCA)S\u001b\u0005Y\u0012BA*\u001c\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u0001,]CB\u0011qKW\u0007\u00021*\u0011\u0011,G\u0001\bG>$WmZ3o\u0013\tY\u0006L\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015iv\u00011\u0001_\u0003\r\u0019G\u000f\u001f\t\u0003/~K!\u0001\u0019-\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")!m\u0002a\u0001-\u0006\u0011QM^\u0001\nMJ,7\u000f[\"paf\fAaY8qsR\u0011qH\u001a\u0005\bo%\u0001\n\u00111\u0001:\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001b\u0016\u0003s)\\\u0013a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005A\u0004\u0014AC1o]>$\u0018\r^5p]&\u0011!/\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001v!\t180D\u0001x\u0015\tA\u00180\u0001\u0003mC:<'\"\u0001>\u0002\t)\fg/Y\u0005\u0003y^\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A@\u0011\u0007=\n\t!C\u0002\u0002\u0004A\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0003\u0002\u0010A\u0019q&a\u0003\n\u0007\u00055\u0001GA\u0002B]fD\u0001\"!\u0005\u000e\u0003\u0003\u0005\ra`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0001CBA\r\u0003?\tI!\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005m!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\n\u0002.A\u0019q&!\u000b\n\u0007\u0005-\u0002GA\u0004C_>dW-\u00198\t\u0013\u0005Eq\"!AA\u0002\u0005%\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002(\u0005M\u0002\"CA\t!\u0005\u0005\t\u0019AA\u0005QM\u0001\u0011qGA\u001f\u0003\u007f\t\u0019%!\u0012\u0002J\u0005-\u0013qJA)!\rA\u0013\u0011H\u0005\u0004\u0003wI\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0003\n\u00111E0G+:\u001bu\fK.tK\u0016$W,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]1oI>l\u0007E^1mk\u0016\u0004s/\u001b;iA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011b]\u0012\u0004\u0013\u000eZ3oi&\u001c\u0017\r\u001c7zA\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AY\fG.^3tA\u0011\u0014\u0018m\u001e8!MJ|W\u000e\t;iK\u0002\u001aH/\u00198eCJ$\u0007E\\8s[\u0006d\u0007\u0005Z5tiJL'-\u001e;j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0013!!\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\f\u0019/gI*D'\r\u001b8sa\u001a\u0004\u0007\u000f\u00193qaR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0013'\r\u001c5eAJtG\r\u001c9gM\u0002t'\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9\n\u0014G\u000e\u001b3ae:$G\u000e\u001d4gA:\u0014H\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u00055\u0013A\r+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007%\u001b8!O\u0016tWM]1mA\r\f7/\u001a\u0018\u0002\u000bMLgnY3\"\u0005\u0005M\u0013!B\u0019/k9\u0002\u0014!\u0002*b]\u0012t\u0007C\u0001\u0015\u0013'\u0011\u0011\u00121\f\u001b\u0011\u0007=\ni&C\u0002\u0002`A\u0012a!\u00118z%\u00164GCAA,\u0003\u0015\t\u0007\u000f\u001d7z)\ry\u0014q\r\u0005\u0006\u000bR\u0001\rA\u0012\u000b\u0004\u007f\u0005-\u0004\"B\u001c\u0016\u0001\u0004I\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003c\n9\b\u0005\u00030\u0003gJ\u0014bAA;a\t1q\n\u001d;j_:D\u0001\"!\u001f\u0017\u0003\u0003\u0005\raP\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a \u0011\u0007Y\f\t)C\u0002\u0002\u0004^\u0014aa\u00142kK\u000e$\b")
public class Randn
extends RDG
implements ExpressionWithRandomSeed,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Randn randn) {
        return Randn$.MODULE$.unapply(randn);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$));
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Randn freshCopy() {
        return new Randn(this.child());
    }

    public Randn copy(Expression child) {
        return new Randn(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child) {
        this.child = child;
    }

    public Randn() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$));
    }
}

