/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep) - Replaces all substrings of `str` that match `regexp` with `rep`.", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001\u0002\u0017.\u0001jB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011!\u0019\u0006A!f\u0001\n\u0003a\u0005\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B'\t\u000bU\u0003A\u0011\u0001,\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0013a\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%a\u0007\u00011A\u0001B\u0003&Q\fC\u0005r\u0001\u0001\u0007\t\u0019!C\u0005e\"IQ\u0010\u0001a\u0001\u0002\u0004%IA \u0005\u000b\u0003\u0003\u0001\u0001\u0019!A!B\u0013\u0019\bbCA\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fA1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u0011Q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0005\u0011)\tI\u0003\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003\u0003\u0006\u00022\u0001\u0001\r\u0011!Q!\nuC!\"!\u000e\u0001\u0011\u000b\u0007I\u0011BA\u001c\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011Q\u0012\u0001\u0005B\u0005\u001d\u0001bBAH\u0001\u0011E\u0013\u0011\u0013\u0005\n\u0003[\u0003\u0011\u0011!C\u0001\u0003_C\u0011\"a.\u0001#\u0003%\t!!/\t\u0013\u0005=\u0007!%A\u0005\u0002\u0005e\u0006\"CAi\u0001E\u0005I\u0011AA]\u0011%\t\u0019\u000eAA\u0001\n\u0003\n)\u000eC\u0005\u0002\\\u0002\t\t\u0011\"\u0001\u0002^\"I\u0011Q\u001d\u0001\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003W\u0004\u0011\u0011!C!\u0003[D\u0011\"a?\u0001\u0003\u0003%\t!!@\t\u0013\t\u001d\u0001!!A\u0005B\t%q!\u0003B\u0014[\u0005\u0005\t\u0012\u0001B\u0015\r!aS&!A\t\u0002\t-\u0002BB+'\t\u0003\u0011I\u0004C\u0005\u0003<\u0019\n\t\u0011\"\u0012\u0003>!I!q\b\u0014\u0002\u0002\u0013\u0005%\u0011\t\u0005\n\u0005\u00132\u0013\u0011!CA\u0005\u0017B\u0011B!\u0018'\u0003\u0003%IAa\u0018\u0003\u001bI+w-\u0012=q%\u0016\u0004H.Y2f\u0015\tqs&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u00192\u0003!\u0019\u0017\r^1msN$(B\u0001\u001a4\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003iU\nQa\u001d9be.T!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO\u000e\u00011#\u0002\u0001<\u007f\tC\u0005C\u0001\u001f>\u001b\u0005i\u0013B\u0001 .\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003y\u0001K!!Q\u0017\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0013&\u0011!\n\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bgV\u0014'.Z2u+\u0005i\u0005C\u0001\u001fO\u0013\tyUF\u0001\u0006FqB\u0014Xm]:j_:\f\u0001b];cU\u0016\u001cG\u000fI\u0001\u0007e\u0016<W\r\u001f9\u0002\u000fI,w-\u001a=qA\u0005\u0019!/\u001a9\u0002\tI,\u0007\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]C\u0016L\u0017\t\u0003y\u0001AQaS\u0004A\u00025CQ!U\u0004A\u00025CQaU\u0004A\u00025\u000b\u0011\u0002\\1tiJ+w-\u001a=\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\u000bQL\b/Z:\u000b\u0005\t\u001c\u0014AB;og\u00064W-\u0003\u0002e?\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u001b1\f7\u000f\u001e*fO\u0016Dx\fJ3r)\t9'\u000e\u0005\u0002DQ&\u0011\u0011\u000e\u0012\u0002\u0005+:LG\u000fC\u0004l\u0013\u0005\u0005\t\u0019A/\u0002\u0007a$\u0013'\u0001\u0006mCN$(+Z4fq\u0002B#A\u00038\u0011\u0005\r{\u0017B\u00019E\u0005%!(/\u00198tS\u0016tG/A\u0004qCR$XM\u001d8\u0016\u0003M\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u000bI,w-\u001a=\u000b\u0005aL\u0018\u0001B;uS2T\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}k\n9\u0001+\u0019;uKJt\u0017a\u00039biR,'O\\0%KF$\"aZ@\t\u000f-d\u0011\u0011!a\u0001g\u0006A\u0001/\u0019;uKJt\u0007\u0005\u000b\u0002\u000e]\u0006yA.Y:u%\u0016\u0004H.Y2f[\u0016tG/\u0006\u0002\u0002\nA!\u00111BA\r\u001d\u0011\ti!!\u0006\u0011\u0007\u0005=A)\u0004\u0002\u0002\u0012)\u0019\u00111C\u001d\u0002\rq\u0012xn\u001c;?\u0013\r\t9\u0002R\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0011Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]A)A\nmCN$(+\u001a9mC\u000e,W.\u001a8u?\u0012*\u0017\u000fF\u0002h\u0003GA\u0001b[\b\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0011Y\u0006\u001cHOU3qY\u0006\u001cW-\\3oi\u0002B#\u0001\u00058\u0002+1\f7\u000f\u001e*fa2\f7-Z7f]RLe.\u0016+Gq\u0005IB.Y:u%\u0016\u0004H.Y2f[\u0016tG/\u00138V)\u001aCt\fJ3r)\r9\u0017q\u0006\u0005\bWJ\t\t\u00111\u0001^\u0003Ya\u0017m\u001d;SKBd\u0017mY3nK:$\u0018J\\+U\rb\u0002\u0003FA\no\u0003\u0019\u0011Xm];miV\u0011\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011qH=\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\niD\u0001\u0007TiJLgn\u001a\"vM\u001a,'\u000f\u000b\u0002\u0015]\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u00111JA)\u0003+\nI\u0006E\u0002D\u0003\u001bJ1!a\u0014E\u0005\r\te.\u001f\u0005\b\u0003'*\u0002\u0019AA&\u0003\u0005\u0019\bbBA,+\u0001\u0007\u00111J\u0001\u0002a\"9\u00111L\u000bA\u0002\u0005-\u0013!\u0001:\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0019\u0011\t\u0005\r\u0014qM\u0007\u0003\u0003KR!\u0001Y\u0019\n\t\u0005%\u0014Q\r\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005=\u0004CBA9\u0003w\n\tI\u0004\u0003\u0002t\u0005]d\u0002BA\b\u0003kJ\u0011!R\u0005\u0004\u0003s\"\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyHA\u0002TKFT1!!\u001fE!\u0011\t\u0019'a!\n\t\u0005\u0015\u0015Q\r\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003\u0017\u0003R!!\u001d\u0002|5\u000b!\u0002\u001d:fiRLh*Y7f\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0014\u0006}\u0015\u0011\u0016\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u0017\u0002\u000f\r|G-Z4f]&!\u0011QTAL\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAQ5\u0001\u0007\u00111U\u0001\u0004GRD\b\u0003BAK\u0003KKA!a*\u0002\u0018\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBAV5\u0001\u0007\u00111S\u0001\u0003KZ\fAaY8qsR9q+!-\u00024\u0006U\u0006bB&\u001c!\u0003\u0005\r!\u0014\u0005\b#n\u0001\n\u00111\u0001N\u0011\u001d\u00196\u0004%AA\u00025\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002<*\u001aQ*!0,\u0005\u0005}\u0006\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!3E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\f\u0019MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u000e\u0005\u0003\u0002<\u0005e\u0017\u0002BA\u000e\u0003{\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a8\u0011\u0007\r\u000b\t/C\u0002\u0002d\u0012\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0013\u0002j\"A1.IA\u0001\u0002\u0004\ty.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000f\u0005\u0004\u0002r\u0006]\u00181J\u0007\u0003\u0003gT1!!>E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\f\u0019P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0000\u0005\u000b\u00012a\u0011B\u0001\u0013\r\u0011\u0019\u0001\u0012\u0002\b\u0005>|G.Z1o\u0011!Y7%!AA\u0002\u0005-\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0000\n-\u0001\u0002C6%\u0003\u0003\u0005\r!a\u0013)\u001f\u0001\u0011yA!\u0006\u0003\u0018\tm!Q\u0004B\u0011\u0005G\u00012\u0001\u0010B\t\u0013\r\u0011\u0019\"\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011I\"A.`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u0004H\u0006\t:fa&\u0002S\u0006\t*fa2\f7-Z:!C2d\u0007e];cgR\u0014\u0018N\\4tA=4\u0007\u0005Y:ue\u0002\u0004C\u000f[1uA5\fGo\u00195!AJ,w-\u001a=qA\u0002:\u0018\u000e\u001e5!AJ,\u0007\u000f\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\b\u0002'*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u00191[I\u0002\u0004g\n\u0017!O!bF\fZ\u0016*O1\u0002sE\\;nO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\\;n[9,XN\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011)#A\u00032]Ur\u0003'A\u0007SK\u001e,\u0005\u0010\u001d*fa2\f7-\u001a\t\u0003y\u0019\u001aBA\nB\u0017\u0011BA!q\u0006B\u001b\u001b6ku+\u0004\u0002\u00032)\u0019!1\u0007#\u0002\u000fI,h\u000e^5nK&!!q\u0007B\u0019\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005S\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003/\fQ!\u00199qYf$ra\u0016B\"\u0005\u000b\u00129\u0005C\u0003LS\u0001\u0007Q\nC\u0003RS\u0001\u0007Q\nC\u0003TS\u0001\u0007Q*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5#\u0011\f\t\u0006\u0007\n=#1K\u0005\u0004\u0005#\"%AB(qi&|g\u000e\u0005\u0004D\u0005+jU*T\u0005\u0004\u0005/\"%A\u0002+va2,7\u0007\u0003\u0005\u0003\\)\n\t\u00111\u0001X\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003bA!\u00111\bB2\u0013\u0011\u0011)'!\u0010\u0003\r=\u0013'.Z2u\u0001")
public class RegExpReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpReplace> tupled() {
        return RegExpReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpReplace>>> curried() {
        return RegExpReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        return !this.bitmap$trans$0 ? this.result$lzycompute() : this.result;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        Matcher m = this.pattern().matcher(s.toString());
        this.result().delete(0, this.result().length());
        while (m.find()) {
            m.appendReplacement(this.result(), this.lastReplacement());
        }
        m.appendTail(this.result());
        return UTF8String.fromString((String)this.result().toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.rep();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, rep) -> new StringBuilder(465).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n      java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n\n      while (").append(matcher).append(".find()) {\n        ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n      }\n      ").append(matcher).append(".appendTail(").append(termResult).append(");\n      ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n      ").append(termResult).append(" = null;\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep) {
        return new RegExpReplace(subject, regexp, rep);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.rep();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        ExpectsInputTypes.$init$(this);
    }
}

