/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    The function returns -1 if its input is null and spark.sql.legacy.sizeOfNull is set to true.\n    If spark.sql.legacy.sizeOfNull is set to false, the function returns null for null input.\n    By default, the spark.sql.legacy.sizeOfNull parameter is set to true.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n      > SELECT _FUNC_(NULL);\n       -1\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0012)A\u0005w!)q\b\u0001C\u0001\u0001\"91\t\u0001b\u0001\n\u0003!\u0005B\u0002%\u0001A\u0003%Q\tC\u0003J\u0001\u0011\u0005#\nC\u0003R\u0001\u0011\u0005#\u000bC\u0003c\u0001\u0011\u0005C\tC\u0003d\u0001\u0011\u0005C\rC\u0003o\u0001\u0011\u0005s\u000eC\u0004~\u0001\u0005\u0005I\u0011\u0001@\t\u0013\u0005\u0005\u0001!%A\u0005\u0002\u0005\r\u0001\"CA\r\u0001\u0005\u0005I\u0011IA\u000e\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\b\u0013\u0005=4$!A\t\u0002\u0005Ed\u0001\u0003\u000e\u001c\u0003\u0003E\t!a\u001d\t\r}\"B\u0011AAA\u0011%\t\u0019\tFA\u0001\n\u000b\n)\tC\u0005\u0002\bR\t\t\u0011\"!\u0002\n\"I\u0011Q\u0012\u000b\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u00037#\u0012\u0011!C\u0005\u0003;\u0013AaU5{K*\u0011A$H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001f?\u0005A1-\u0019;bYf\u001cHO\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001S5\u0002d\u0007\u0005\u0002+W5\t1$\u0003\u0002-7\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002+]%\u0011qf\u0007\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002)s_\u0012,8\r\u001e\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003m\u0002\"A\u000b\u001f\n\u0005uZ\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA!C!\tQ\u0003\u0001C\u0003:\u0007\u0001\u00071(\u0001\tmK\u001e\f7-_*ju\u0016|eMT;mYV\tQ\t\u0005\u00022\r&\u0011qI\r\u0002\b\u0005>|G.Z1o\u0003EaWmZ1dsNK'0Z(g\u001dVdG\u000eI\u0001\tI\u0006$\u0018\rV=qKV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O?\u0005)A/\u001f9fg&\u0011\u0001+\u0014\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003M\u00032\u0001\u0016/`\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002YO\u00051AH]8pizJ\u0011aM\u0005\u00037J\nq\u0001]1dW\u0006<W-\u0003\u0002^=\n\u00191+Z9\u000b\u0005m\u0013\u0004C\u0001'a\u0013\t\tWJ\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0003fm\u0006dGCA3i!\t\td-\u0003\u0002he\t\u0019\u0011I\\=\t\u000f%L\u0001\u0013!a\u0001U\u0006)\u0011N\u001c9viB\u00111\u000e\\\u0007\u0002;%\u0011Q.\b\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u0019\u0001O^>\u0011\u0005E$X\"\u0001:\u000b\u0005M\\\u0012aB2pI\u0016<WM\\\u0005\u0003kJ\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006o*\u0001\r\u0001_\u0001\u0004GRD\bCA9z\u0013\tQ(O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bqT\u0001\u0019\u00019\u0002\u0005\u00154\u0018\u0001B2paf$\"!Q@\t\u000feZ\u0001\u0013!a\u0001w\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0003U\rY\u0014qA\u0016\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0003\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00055!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005!A.\u00198h\u0015\t\t9#\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003C\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0019!\r\t\u00141G\u0005\u0004\u0003k\u0011$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002<!I\u0011QH\b\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0003#BA#\u0003\u0017*WBAA$\u0015\r\tIEM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q)a\u0015\t\u0011\u0005u\u0012#!AA\u0002\u0015\fa!Z9vC2\u001cHcA#\u0002Z!A\u0011Q\b\n\u0002\u0002\u0003\u0007Q\rK\u0006\u0001\u0003;\n\u0019'!\u001a\u0002j\u0005-\u0004c\u0001\u0016\u0002`%\u0019\u0011\u0011M\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qM\u0001\u0003\u000e*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:ju\u0016\u0004sN\u001a\u0011b]\u0002\n'O]1zA=\u0014\b%\u0019\u0011nCBt#\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA5\n\u0004%\u001b4!SR\u001c\b%\u001b8qkR\u0004\u0013n\u001d\u0011ok2d\u0007%\u00198eAM\u0004\u0018M]6/gFdg\u0006\\3hC\u000eLhf]5{K>3g*\u001e7mA%\u001c\be]3uAQ|\u0007\u0005\u001e:vK:R\u0001\u0005\t\u0011!\u0013\u001a\u00043\u000f]1sW:\u001a\u0018\u000f\u001c\u0018mK\u001e\f7-\u001f\u0018tSj,wJ\u001a(vY2\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011gC2\u001cX\r\f\u0011uQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011ok2d\u0007EZ8sA9,H\u000e\u001c\u0011j]B,HO\f\u0006!A\u0001\u0002#)\u001f\u0011eK\u001a\fW\u000f\u001c;-AQDW\rI:qCJ\\gf]9m]1,w-Y2z]ML'0Z(g\u001dVdG\u000e\t9be\u0006lW\r^3sA%\u001c\be]3uAQ|\u0007\u0005\u001e:vK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QN\u0001\u0002R)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":#m\n\u0017!O\u0011<C\u0006I\u0014dO1\u0002s%Y\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002CG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u0012\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!e)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002S&\r\u0006!A\u0005!1+\u001b>f!\tQCc\u0005\u0003\u0015\u0003k2\u0004CBA<\u0003{Z\u0014)\u0004\u0002\u0002z)\u0019\u00111\u0010\u001a\u0002\u000fI,h\u000e^5nK&!\u0011qPA=\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003c\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003;\tQ!\u00199qYf$2!QAF\u0011\u0015It\u00031\u0001<\u0003\u001d)h.\u00199qYf$B!!%\u0002\u0018B!\u0011'a%<\u0013\r\t)J\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005e\u0005$!AA\u0002\u0005\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0005\u0003BA\u0010\u0003CKA!a)\u0002\"\t1qJ\u00196fGR\u0004")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Expression> unapply(Size size) {
        return Size$.MODULE$.unapply(size);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Size, A> function1) {
        return Size$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Size> compose(Function1<A, Expression> function1) {
        return Size$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$}))}));
    }

    @Override
    public boolean nullable() {
        return this.legacySizeOfNull() ? false : super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Integer n;
        Object value = this.child().eval(input);
        if (value == null) {
            n = this.legacySizeOfNull() ? BoxesRunTime.boxToInteger((int)-1) : null;
        } else {
            Integer n2;
            DataType dataType = this.child().dataType();
            if (dataType instanceof ArrayType) {
                n2 = BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
            } else if (dataType instanceof MapType) {
                n2 = BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(51).append("The size function doesn't support the operand type ").append(dataType.getClass().getCanonicalName()).toString());
            }
            n = n2;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append("(").append((String)c).append(").numElements()").toString());
        }
        return exprCode;
    }

    public Size copy(Expression child) {
        return new Size(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        this.legacySizeOfNull = SQLConf$.MODULE$.get().legacySizeOfNull();
    }
}

