/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array((map('a', 1))));\n       [{\"a\":1}]\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\tA\u0002\u0011\t\u0012)A\u0005%\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B5\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011\t;\t\u000b5\u0004A\u0011\u0001=\t\u000b5\u0004A\u0011A>\t\u000b5\u0004A\u0011A?\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\u001e\u0001A)\u0019!C\u0001\u0003?A!\"a\f\u0001\u0011\u000b\u0007I\u0011AA\u0019\u0011)\t\t\u0005\u0001EC\u0002\u0013\u0005\u00111\t\u0005\b\u0003C\u0002A\u0011IA\u0019\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003O\u0003\u0011\u0013!C\u0001\u0003SC\u0011\"a0\u0001#\u0003%\t!!1\t\u0013\u0005\u0015\u0007!%A\u0005\u0002\u0005\u001d\u0007\"CAf\u0001\u0005\u0005I\u0011IAg\u0011%\tI\u000eAA\u0001\n\u0003\tY\u000eC\u0005\u0002d\u0002\t\t\u0011\"\u0001\u0002f\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003w\u0004\u0011\u0011!C\u0001\u0003{D\u0011B!\u0001\u0001\u0003\u0003%\tEa\u0001\b\u0013\t\u0005\u0012&!A\t\u0002\t\rb\u0001\u0003\u0015*\u0003\u0003E\tA!\n\t\r5\u0004C\u0011\u0001B\u001a\u0011%\u0011)\u0004IA\u0001\n\u000b\u00129\u0004C\u0005\u0003:\u0001\n\t\u0011\"!\u0003<!I!1\t\u0011\u0012\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0005\u000b\u0002\u0013\u0011!CA\u0005\u000fB\u0011B!\u0016!#\u0003%\t!a2\t\u0013\t]\u0003%!A\u0005\n\te#!D*ueV\u001cGo\u001d+p\u0015N|gN\u0003\u0002+W\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taS&\u0001\u0005dCR\fG._:u\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'\u001d\u0001qg\u000f E\u000f6\u0003\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u000f\u001f\n\u0005uJ#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\ty$)D\u0001A\u0015\t\t\u0015&A\u0004d_\u0012,w-\u001a8\n\u0005\r\u0003%aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005a*\u0015B\u0001$*\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\b!J|G-^2u!\tAe*\u0003\u0002P\u0013\na1+\u001a:jC2L'0\u00192mK\u00069q\u000e\u001d;j_:\u001cX#\u0001*\u0011\tMSV,\u0018\b\u0003)b\u0003\"!V%\u000e\u0003YS!aV\u001b\u0002\rq\u0012xn\u001c;?\u0013\tI\u0016*\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u00131!T1q\u0015\tI\u0016\n\u0005\u0002T=&\u0011q\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\nQa\u00195jY\u0012,\u0012a\u0019\t\u0003q\u0011L!!Z\u0015\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#W#A5\u0011\u0007!SW,\u0003\u0002l\u0013\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"Ba\u001c9reB\u0011\u0001\b\u0001\u0005\u0006!\u001e\u0001\rA\u0015\u0005\u0006C\u001e\u0001\ra\u0019\u0005\bO\u001e\u0001\n\u00111\u0001j\u0003!qW\u000f\u001c7bE2,W#A;\u0011\u0005!3\u0018BA<J\u0005\u001d\u0011un\u001c7fC:$2a\\={\u0011\u0015\u0001\u0016\u00021\u0001S\u0011\u0015\t\u0017\u00021\u0001d)\tyG\u0010C\u0003b\u0015\u0001\u00071\rF\u0002p}~DQ!Y\u0006A\u0002\rDQ\u0001U\u0006A\u0002\r\faa\u001e:ji\u0016\u0014XCAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t!![8\u000b\u0005\u0005=\u0011\u0001\u00026bm\u0006LA!a\u0005\u0002\n\ty1\t[1s\u0003J\u0014\u0018-_,sSR,'\u000fK\u0002\r\u0003/\u00012\u0001SA\r\u0013\r\tY\"\u0013\u0002\niJ\fgn]5f]R\f1aZ3o+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9cK\u0001\u0005UN|g.\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0005&bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8sQ\ri\u0011qC\u0001\fS:\u0004X\u000f^*dQ\u0016l\u0017-\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:5\nQ\u0001^=qKNLA!!\u0010\u00028\tAA)\u0019;b)f\u0004X\rK\u0002\u000f\u0003/\t\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005\u0015\u0003c\u0002%\u0002H\u0005-\u0013\u0011K\u0005\u0004\u0003\u0013J%!\u0003$v]\u000e$\u0018n\u001c82!\rA\u0015QJ\u0005\u0004\u0003\u001fJ%aA!osB!\u00111KA.\u001b\t\t)F\u0003\u0003\u0002:\u0005]#bAA-_\u00051QO\\:bM\u0016LA!!\u0018\u0002V\tQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007=\t9\"\u0001\u0005eCR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t9\u0007\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\tigK\u0001\tC:\fG._:jg&!\u0011\u0011OA6\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001D<ji\"$\u0016.\\3[_:,GcA\u001e\u0002x!)qM\u0005a\u0001;\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u00111JA?\u0011\u001d\tyh\u0005a\u0001\u0003\u0017\nQA^1mk\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t)\t\u0005\u0004\u0002\b\u0006E\u0015q\u0013\b\u0005\u0003\u0013\u000biID\u0002V\u0003\u0017K\u0011AS\u0005\u0004\u0003\u001fK\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003'\u000b)JA\u0002TKFT1!a$J!\u0011\t)$!'\n\t\u0005m\u0015q\u0007\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fAaY8qsR9q.!)\u0002$\u0006\u0015\u0006b\u0002)\u0016!\u0003\u0005\rA\u0015\u0005\bCV\u0001\n\u00111\u0001d\u0011\u001d9W\u0003%AA\u0002%\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002,*\u001a!+!,,\u0005\u0005=\u0006\u0003BAY\u0003wk!!a-\u000b\t\u0005U\u0016qW\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!/J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\u000b\u0019LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002D*\u001a1-!,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001a\u0016\u0004S\u00065\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002PB!\u0011\u0011[Al\u001b\t\t\u0019N\u0003\u0003\u0002V\u00065\u0011\u0001\u00027b]\u001eL1aXAj\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u000eE\u0002I\u0003?L1!!9J\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY%a:\t\u0013\u0005%8$!AA\u0002\u0005u\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002pB1\u0011\u0011_A|\u0003\u0017j!!a=\u000b\u0007\u0005U\u0018*\u0001\u0006d_2dWm\u0019;j_:LA!!?\u0002t\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r)\u0018q \u0005\n\u0003Sl\u0012\u0011!a\u0001\u0003\u0017\na!Z9vC2\u001cHcA;\u0003\u0006!I\u0011\u0011\u001e\u0010\u0002\u0002\u0003\u0007\u00111\n\u0015\u0010\u0001\t%!q\u0002B\t\u0005+\u00119Ba\u0007\u0003\u001eA\u0019\u0001Ha\u0003\n\u0007\t5\u0011FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tM\u0011!S0G+:\u001bu\fK3yaJ\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011K'>s\u0005e\u001d;sS:<\u0007e^5uQ\u0002\n\u0007eZ5wK:\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0006AQ\r_1na2,7/\t\u0002\u0003\u001a\u0005!9M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014bO1\u0002\u0013\u0007\f\u0011(E\u001eb\u0003EM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;c1\u0012#M\t\u001e3{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.Y7fI~\u001bHO];di\":C/[7fO1\u0002Co\\0uS6,7\u000f^1na\":#\u0007M\u00196[ABTF\r\u001c(Y\u0001:\u00130_=z[5kU\u0006\u001a3(S%b\u0003%\\1qQ\u001d\"\u0018.\\3ti\u0006l\u0007OR8s[\u0006$x\u0005\f\u0011(I\u0012|S*T\u0018zsfLx%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014C/[7fEi\u0012#GN\u00181q=\u0012\u0004'M\u001b#{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"r\u0017-\\3e?N$(/^2uQ\u001d\nw\u0005\f\u00112Y\u0001:#m\n\u0017!e%J\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\w\n\n'EO\u0019-E\t\u0014#HM?^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0017\r\u001d\u0015(C\u001eb\u0003E\\1nK\u0012|6\u000f\u001e:vGRDsEY\u0014-AEJ\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'EO>#E\nR\u0014'`?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000f\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\n\u0014\u0006\f8b[\u0016$wl\u001d;sk\u000e$\bf\n2(Y\u0001\u0012\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u00143,M/#um\u0014#M\t\u001e3{vT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQ\u001d\nw\u0005\f\u00112S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEi\nTP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\u000b\u0015nCBDs%Y\u0014-AEJ\u0013&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u0019\u0012;cul&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t}\u0011!\u0002\u001a/e9\u0002\u0014!D*ueV\u001cGo\u001d+p\u0015N|g\u000e\u0005\u00029AM!\u0001Ea\nN!!\u0011ICa\fSG&|WB\u0001B\u0016\u0015\r\u0011i#S\u0001\beVtG/[7f\u0013\u0011\u0011\tDa\u000b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003$\u0005AAo\\*ue&tw\r\u0006\u0002\u0002P\u0006)\u0011\r\u001d9msR9qN!\u0010\u0003@\t\u0005\u0003\"\u0002)$\u0001\u0004\u0011\u0006\"B1$\u0001\u0004\u0019\u0007bB4$!\u0003\u0005\r![\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B%\u0005#\u0002B\u0001\u00136\u0003LA1\u0001J!\u0014SG&L1Aa\u0014J\u0005\u0019!V\u000f\u001d7fg!A!1K\u0013\u0002\u0002\u0003\u0007q.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0017\u0011\t\u0005E'QL\u0005\u0005\u0005?\n\u0019N\u0001\u0004PE*,7\r\u001e")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson structsToJson) {
        return StructsToJson$.MODULE$.unapply(structsToJson);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType) {
            TypeCheckResult typeCheckResult2;
            StructType structType = (StructType)dataType;
            try {
                JacksonUtils$.MODULE$.verifySchema(structType);
                typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult2 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult2;
        } else if (dataType instanceof MapType) {
            TypeCheckResult typeCheckResult3;
            MapType mapType = (MapType)dataType;
            try {
                StructField structField = new StructField("a", mapType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType st = StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField));
                JacksonUtils$.MODULE$.verifySchema(st);
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult3;
        } else if (dataType instanceof ArrayType) {
            TypeCheckResult typeCheckResult4;
            ArrayType arrayType = (ArrayType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), arrayType);
                typeCheckResult4 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult4 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult4;
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("Input type ").append(this.child().dataType().catalogString()).append(" must be a struct, array of structs or ").append("a map or array of map.").toString());
        }
        return typeCheckResult;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

