/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. Returns NULL if the index exceeds the length\n      of the array.\n\n    _FUNC_(map, key) - Returns value for given key, or NULL if the key is not contained in the map\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0011#\u0001>B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011!Q\u0005\u0001#b\u0001\n\u0013Y\u0005\u0002\u0003,\u0001\u0011\u000b\u0007I\u0011B,\t\u0011q\u0003\u0001R1A\u0005\nuC\u0001B\u001c\u0001\t\u0006\u0004%\te\u0013\u0005\u0006a\u0002!\t%\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\u0007\u0003\u0003\u0001A\u0011I,\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!Q\u0011q\u0002\u0001\t\u0006\u0004%I!!\u0005\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002\"CA'\u0001\u0005\u0005I\u0011AA(\u0011%\t)\u0006AI\u0001\n\u0003\t9\u0006C\u0005\u0002n\u0001\t\n\u0011\"\u0001\u0002X!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003\u0003\u0003\u0011\u0011!C\u0001\u0003\u0007C\u0011\"a#\u0001\u0003\u0003%\t!!$\t\u0013\u0005M\u0005!!A\u0005B\u0005U\u0005\"CAR\u0001\u0005\u0005I\u0011AAS\u0011%\tI\u000bAA\u0001\n\u0003\nYkB\u0005\u0002J\n\n\t\u0011#\u0001\u0002L\u001aA\u0011EIA\u0001\u0012\u0003\ti\r\u0003\u0004F7\u0011\u0005\u00111\u001c\u0005\n\u0003;\\\u0012\u0011!C#\u0003?D\u0011\"!9\u001c\u0003\u0003%\t)a9\t\u0013\u0005%8$!A\u0005\u0002\u0006-\b\"CA\u007f7\u0005\u0005I\u0011BA\u0000\u0005%)E.Z7f]R\fEO\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0007\u000e\u001e\u0011\u0005E\u0012T\"\u0001\u0012\n\u0005M\u0012#aD$fi6\u000b\u0007OV1mk\u0016,F/\u001b7\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011QgO\u0005\u0003yY\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\tq\b\u0005\u00022\u0001&\u0011\u0011I\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f\"K\u0005CA\u0019\u0001\u0011\u0015iT\u00011\u0001@\u0011\u0015\u0019U\u00011\u0001@\u0003)i\u0017\r]&fsRK\b/Z\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011qJJ\u0001\u0006if\u0004Xm]\u0005\u0003#:\u0013\u0001\u0002R1uCRK\b/\u001a\u0015\u0003\rM\u0003\"!\u000e+\n\u0005U3$!\u0003;sC:\u001c\u0018.\u001a8u\u0003E\t'O]1z\u0007>tG/Y5og:+H\u000e\\\u000b\u00021B\u0011Q'W\u0005\u00035Z\u0012qAQ8pY\u0016\fg\u000e\u000b\u0002\b'\u0006AqN\u001d3fe&tw-F\u0001_!\ryvM\u001b\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!a\u0019\u0018\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u000147\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0011=\u0013H-\u001a:j]\u001eT!A\u001a\u001c\u0011\u0005UZ\u0017B\u000177\u0005\r\te.\u001f\u0015\u0003\u0011M\u000b\u0001\u0002Z1uCRK\b/\u001a\u0015\u0003\u0013M\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\bcA0tk&\u0011A/\u001b\u0002\u0004'\u0016\f\bCA'w\u0013\t9hJ\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~I\u0005A\u0011M\\1msNL7/\u0003\u0002\u0000y\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0005ok2d\u0017M\u00197f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0015Q\u0017qAA\u0006\u0011\u0019\tI!\u0004a\u0001U\u0006)a/\u00197vK\"1\u0011QB\u0007A\u0002)\fqa\u001c:eS:\fG.A\u0006e_\u0016cW-\\3oi\u0006#XCAA\n!\u0019)\u0014Q\u00036kU&\u0019\u0011q\u0003\u001c\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004F\u0001\bT\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002 \u0005-\u0012Q\u0007\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0012\u0002\u000f\r|G-Z4f]&!\u0011\u0011FA\u0012\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0017\u001f\u0001\u0007\u0011qF\u0001\u0004GRD\b\u0003BA\u0011\u0003cIA!a\r\u0002$\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u001c\u001f\u0001\u0007\u0011qD\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\ti\u0004\u0005\u0003\u0002@\u0005\u001dc\u0002BA!\u0003\u0007\u0002\"!\u0019\u001c\n\u0007\u0005\u0015c'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\nYE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b2\u0014\u0001B2paf$RaRA)\u0003'Bq!P\t\u0011\u0002\u0003\u0007q\bC\u0004D#A\u0005\t\u0019A \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\f\u0016\u0004\u007f\u0005m3FAA/!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dd'\u0001\u0006b]:|G/\u0019;j_:LA!a\u001b\u0002b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005!A.\u00198h\u0015\t\ti(\u0001\u0003kCZ\f\u0017\u0002BA%\u0003o\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\"\u0011\u0007U\n9)C\u0002\u0002\nZ\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A[AH\u0011%\t\tJFA\u0001\u0002\u0004\t))A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0003R!!'\u0002 *l!!a'\u000b\u0007\u0005ue'\u0001\u0006d_2dWm\u0019;j_:LA!!)\u0002\u001c\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA\u0016q\u0015\u0005\t\u0003#C\u0012\u0011!a\u0001U\u00061Q-];bYN$2\u0001WAW\u0011!\t\t*GA\u0001\u0002\u0004Q\u0007f\u0004\u0001\u00022\u0006]\u0016\u0011XA_\u0003\u007f\u000b\u0019-!2\u0011\u0007E\n\u0019,C\u0002\u00026\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002<\u0006\u0011\tH\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1zY\u0001Jg\u000eZ3yS\u0001j\u0003EU3ukJt7\u000fI3mK6,g\u000e\u001e\u0011pM\u0002\n'O]1zA\u0005$\beZ5wK:\u0004\u0003&M\u0017cCN,G-\u000b\u0011j]\u0012,\u0007P\f\u0011JM\u0002Jg\u000eZ3yAq\u0002\u0003\u0007\f\u0006!A\u0001\u0002\u0003\u0005I1dG\u0016\u001c8/Z:!K2,W.\u001a8ug\u00022'o\\7!i\",\u0007\u0005\\1ti\u0002\"x\u000e\t;iK\u00022\u0017N]:u]\u0001\u0012V\r^;s]N\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA%tG-\u001a=!Kb\u001cW-\u001a3tAQDW\r\t7f]\u001e$\bN\u0003\u0011!A\u0001\u0002\u0003e\u001c4!i\",\u0007%\u0019:sCft#B\u0003\u0011!A\u0001zf)\u0016(D?\"j\u0017\r\u001d\u0017!W\u0016L\u0018\u0006I\u0017!%\u0016$XO\u001d8tAY\fG.^3!M>\u0014\beZ5wK:\u00043.Z=-A=\u0014\bET+M\u0019\u0002Jg\r\t;iK\u0002ZW-\u001f\u0011jg\u0002rw\u000e\u001e\u0011d_:$\u0018-\u001b8fI\u0002Jg\u000e\t;iK\u0002j\u0017\r\u001d\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002B\u0006a(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023'\u000b\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[\u0006\u0004\b&\r\u0017!O\u0005<C\u0006\t\u001a-A\u001d\u0012w%\u000b\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\u0019\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qY\u0001\u0006e9\"d\u0006M\u0001\n\u000b2,W.\u001a8u\u0003R\u0004\"!M\u000e\u0014\tm\tyM\u000f\t\b\u0003#\f9nP H\u001b\t\t\u0019NC\u0002\u0002VZ\nqA];oi&lW-\u0003\u0003\u0002Z\u0006M'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111Z\u0001\ti>\u001cFO]5oOR\u0011\u00111O\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u000f\u0006\u0015\u0018q\u001d\u0005\u0006{y\u0001\ra\u0010\u0005\u0006\u0007z\u0001\raP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti/!?\u0011\u000bU\ny/a=\n\u0007\u0005EhG\u0001\u0004PaRLwN\u001c\t\u0006k\u0005UxhP\u0005\u0004\u0003o4$A\u0002+va2,'\u0007\u0003\u0005\u0002|~\t\t\u00111\u0001H\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0002A!\u0011Q\u000fB\u0002\u0013\u0011\u0011)!a\u001e\u0003\r=\u0013'.Z2u\u0001")
public class ElementAt
extends GetMapValueUtil
implements scala.Serializable {
    private transient DataType mapKeyType;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static Function1<Tuple2<Expression, Expression>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ElementAt>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(89).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The first argument to function ").append(this.prettyName()).append(" should ").append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").append(this.left().dataType().catalogString()).append(" type.").toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            object = null;
                        } else {
                            if (index == 0) {
                                throw new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(489).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(ev.isNull()).append(" = true;\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw new ArrayIndexOutOfBoundsException(\"SQL array indices start at 1\");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    public ElementAt copy(Expression left, Expression right) {
        return new ElementAt(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

