/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, bitLength) - Returns a checksum of SHA-2 family as a hex string of `expr`.\n      SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 256);\n       529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015\u0011\u0007\u0001\"\u0015d\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u001dQ\b!!A\u0005\u0002mDqA \u0001\u0012\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0000\u0011%\t9\u0002AA\u0001\n\u0003\nI\u0002C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003{\u0001\u0011\u0011!C!\u0003\u007fA\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\t\u0013\u0005M\u0003!!A\u0005B\u0005Us!CA79\u0005\u0005\t\u0012AA8\r!YB$!A\t\u0002\u0005E\u0004B\u0002\"\u0016\t\u0003\ty\bC\u0005\u0002\u0002V\t\t\u0011\"\u0012\u0002\u0004\"I\u0011QQ\u000b\u0002\u0002\u0013\u0005\u0015q\u0011\u0005\n\u0003\u001b+\u0012\u0011!CA\u0003\u001fC\u0011\"!)\u0016\u0003\u0003%I!a)\u0003\tMC\u0017M\r\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M)\u0001A\u000b\u00185oA\u00111\u0006L\u0007\u00029%\u0011Q\u0006\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"aK\u001b\n\u0005Yb\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005=B\u0014BA\u001d1\u0005\u001d\u0001&o\u001c3vGR\fA\u0001\\3giV\tA\b\u0005\u0002,{%\u0011a\b\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005CA\u0016\u0001\u0011\u0015QT\u00011\u0001=\u0011\u0015\u0001U\u00011\u0001=\u0003!!\u0017\r^1UsB,W#A%\u0011\u0005)kU\"A&\u000b\u00051\u0003\u0013!\u0002;za\u0016\u001c\u0018B\u0001(L\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0003E\u0003\"a\f*\n\u0005M\u0003$a\u0002\"p_2,\u0017M\\\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001,\u0011\u0007]{\u0016J\u0004\u0002Y;:\u0011\u0011\fX\u0007\u00025*\u00111\fK\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!A\u0018\u0019\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u0004'\u0016\f(B\u000101\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r!w-\u001b\t\u0003_\u0015L!A\u001a\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003i\u0013\u0001\u0007A-\u0001\u0004j]B,H/\r\u0005\u0006U&\u0001\r\u0001Z\u0001\u0007S:\u0004X\u000f\u001e\u001a\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA7tqB\u0011a.]\u0007\u0002_*\u0011\u0001\u000fH\u0001\bG>$WmZ3o\u0013\t\u0011xN\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015!(\u00021\u0001v\u0003\r\u0019G\u000f\u001f\t\u0003]ZL!a^8\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")\u0011P\u0003a\u0001[\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0002EyvDqAO\u0006\u0011\u0002\u0003\u0007A\bC\u0004A\u0017A\u0005\t\u0019\u0001\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0001\u0016\u0004y\u0005\r1FAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0001'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0005\u0002\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A.\u00198h\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u0003?\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0018!\ry\u0013\u0011G\u0005\u0004\u0003g\u0001$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00013\u0002:!I\u00111\b\t\u0002\u0002\u0003\u0007\u0011qF\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0003#BA\"\u0003\u0013\"WBAA#\u0015\r\t9\u0005M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA&\u0003\u000b\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0011+!\u0015\t\u0011\u0005m\"#!AA\u0002\u0011\fa!Z9vC2\u001cHcA)\u0002X!A\u00111H\n\u0002\u0002\u0003\u0007A\rK\u0006\u0001\u00037\n\t'a\u0019\u0002h\u0005%\u0004cA\u0016\u0002^%\u0019\u0011q\f\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QM\u0001\u0002\u0004*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014H\u0006\t2ji2+gn\u001a;iS\u0001j\u0003EU3ukJt7\u000fI1!G\",7m[:v[\u0002zg\rI*I\u00036\u0012\u0004EZ1nS2L\b%Y:!C\u0002BW\r\u001f\u0011tiJLgn\u001a\u0011pM\u0002\u0002W\r\u001f9sA:R\u0001\u0005\t\u0011!A\u0001\u001a\u0006*Q\u00173eQb\u0003e\u0015%B[I*d\u0007\f\u0011T\u0011\u0006k3\u0007\u000f\u001b-A\u0005tG\rI*I\u00036*\u0014G\r\u0011be\u0016\u00043/\u001e9q_J$X\r\u001a\u0018!\u0005&$\b\u0005\\3oORD\u0007e\u001c4!a\u0001J7\u000fI3rk&4\u0018\r\\3oi\u0002\"x\u000e\t\u001a6m9R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111N\u0001\u007f\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003EM\u001b7SmR\u0001\u0005\t\u0011!A\u0001\u0002SGM\u001dcGN\u0012\u0007gN\u00193o\u0015\u001c'mN36g\u0005$Dm\u001942se\nD-O\u00196e\r\u0014D'N\u001a8If\n\u0014(M\u001c9aI\u0012$MM25eY*tGZ\u001c:CJ2$M\u0003\u0011!\u0003\u0011\u0019\u0006.\u0019\u001a\u0011\u0005-*2\u0003B\u000b\u0002t9\u0002r!!\u001e\u0002|qbD)\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u0019\u0002\u000fI,h\u000e^5nK&!\u0011QPA<\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003_\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\tQ!\u00199qYf$R\u0001RAE\u0003\u0017CQA\u000f\rA\u0002qBQ\u0001\u0011\rA\u0002q\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0012\u0006u\u0005#B\u0018\u0002\u0014\u0006]\u0015bAAKa\t1q\n\u001d;j_:\u0004RaLAMyqJ1!a'1\u0005\u0019!V\u000f\u001d7fe!A\u0011qT\r\u0002\u0002\u0003\u0007A)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0015\t\u0005\u0003;\t9+\u0003\u0003\u0002*\u0006}!AB(cU\u0016\u001cG\u000f")
public class Sha2
extends BinaryExpression
implements scala.Serializable,
ImplicitCastInputTypes {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 sha2) {
        return Sha2$.MODULE$.unapply(sha2);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            case 224: {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-224");
                    md.update(input);
                    uTF8String = UTF8String.fromBytes((byte[])md.digest());
                }
                catch (NoSuchAlgorithmException noa) {
                    uTF8String = null;
                }
                break;
            }
            case 0: 
            case 256: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
                break;
            }
            case 384: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
                break;
            }
            case 512: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
                break;
            }
            default: {
                uTF8String = null;
                break;
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = "org.apache.commons.codec.digest.DigestUtils";
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(645).append("\n        if (").append((String)eval2).append(" == 224) {\n          try {\n            java.security.MessageDigest md = java.security.MessageDigest.getInstance(\"SHA-224\");\n            md.update(").append((String)eval1).append(");\n            ").append(ev.value()).append(" = UTF8String.fromBytes(md.digest());\n          } catch (java.security.NoSuchAlgorithmException e) {\n            ").append(ev.isNull()).append(" = true;\n          }\n        } else if (").append((String)eval2).append(" == 256 || ").append((String)eval2).append(" == 0) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha256Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 384) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha384Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 512) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha512Hex(").append((String)eval1).append("));\n        } else {\n          ").append(ev.isNull()).append(" = true;\n        }\n      ").toString());
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

