/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.Cost;
import org.apache.spark.sql.catalyst.optimizer.JoinGraphInfo;
import org.apache.spark.sql.catalyst.optimizer.JoinReorderDP;
import org.apache.spark.sql.catalyst.optimizer.JoinReorderDPFilters$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

public final class JoinReorderDP$
implements PredicateHelper,
Logging {
    public static JoinReorderDP$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JoinReorderDP$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$(this, condition);
    }

    @Override
    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$(this, condition);
    }

    @Override
    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$(this, condition, aliases);
    }

    @Override
    public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return PredicateHelper.canEvaluate$(this, expr, plan2);
    }

    @Override
    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$(this, expr);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalPlan search(SQLConf conf, Seq<LogicalPlan> items, Set<Expression> conditions, Seq<Attribute> output) {
        long startTime = System.nanoTime();
        Seq itemIndex = (Seq)items.zipWithIndex(Seq$.MODULE$.canBuildFrom());
        Buffer foundPlans = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{((TraversableOnce)itemIndex.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LogicalPlan item = (LogicalPlan)tuple2._1();
            int id = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), (Object)new JoinReorderDP.JoinPlan((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), item, (Set<Expression>)Predef$.MODULE$.Set().empty(), new Cost(BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0))));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())}));
        Option<JoinGraphInfo> filters = JoinReorderDPFilters$.MODULE$.buildJoinGraphInfo(conf, items, conditions, (Seq<Tuple2<LogicalPlan, Object>>)itemIndex);
        AttributeSet topOutputSet = AttributeSet$.MODULE$.apply((Iterable<Expression>)output);
        while (foundPlans.size() < items.length()) {
            foundPlans.$plus$eq(this.searchLevel((Seq<Map<Set<Object>, JoinReorderDP.JoinPlan>>)foundPlans, conf, conditions, topOutputSet, filters));
        }
        long durationInMs = (System.nanoTime() - startTime) / 1000000L;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Join reordering finished. Duration: ").append(durationInMs).append(" ms, number of items: ").append(items.length()).append(", number of plans in memo: ").append(((TraversableOnce)foundPlans.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)).toString());
        Predef$.MODULE$.assert(foundPlans.size() == items.length() && ((TraversableOnce)foundPlans.last()).size() == 1);
        LogicalPlan logicalPlan = ((JoinReorderDP.JoinPlan)((Tuple2)((IterableLike)foundPlans.last()).head())._2()).plan();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan j = project.child();
            if (j instanceof Join) {
                Seq<NamedExpression> seq = projectList;
                Seq<Attribute> seq2 = output;
                if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                    AttributeSet attributeSet = topOutputSet;
                    AttributeSet attributeSet2 = project.outputSet();
                    Predef$.MODULE$.assert(!(attributeSet != null ? !((Object)attributeSet).equals(attributeSet2) : attributeSet2 != null));
                    return project.copy(output, project.copy$default$2());
                }
            }
        }
        if (this.sameOutput(logicalPlan, output)) return logicalPlan;
        return new Project(output, logicalPlan);
    }

    private boolean sameOutput(LogicalPlan plan2, Seq<Attribute> expectedOutput) {
        Seq<Attribute> thisOutput = plan2.output();
        return thisOutput.length() == expectedOutput.length() && ((IterableLike)thisOutput.zip(expectedOutput, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.$anonfun$sameOutput$1(x0$1)));
    }

    private Map<Set<Object>, JoinReorderDP.JoinPlan> searchLevel(Seq<Map<Set<Object>, JoinReorderDP.JoinPlan>> existingLevels, SQLConf conf, Set<Expression> conditions, AttributeSet topOutput, Option<JoinGraphInfo> filters) {
        scala.collection.mutable.Map nextLevel = Map$.MODULE$.empty();
        IntRef k = IntRef.create((int)0);
        int lev = existingLevels.length() - 1;
        while (k.elem <= lev - k.elem) {
            Seq oneSideCandidates = ((MapLike)existingLevels.apply(k.elem)).values().toSeq();
            oneSideCandidates.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                JoinReorderDP.JoinPlan oneSidePlan = (JoinReorderDP.JoinPlan)oneSideCandidates.apply(i);
                Seq otherSideCandidates = k$1.elem == lev - k$1.elem ? (Seq)oneSideCandidates.drop(i) : ((MapLike)existingLevels.apply(lev - k$1.elem)).values().toSeq();
                otherSideCandidates.foreach((Function1 & Serializable & scala.Serializable)otherSidePlan -> {
                    JoinReorderDP$.$anonfun$searchLevel$2(oneSidePlan, conf, conditions, topOutput, filters, nextLevel, otherSidePlan);
                    return BoxedUnit.UNIT;
                });
            });
            ++k.elem;
        }
        return nextLevel.toMap(Predef$.MODULE$.$conforms());
    }

    private Option<JoinReorderDP.JoinPlan> buildJoin(JoinReorderDP.JoinPlan oneJoinPlan, JoinReorderDP.JoinPlan otherJoinPlan, SQLConf conf, Set<Expression> conditions, AttributeSet topOutput, Option<JoinGraphInfo> filters) {
        Tuple2 tuple2;
        boolean isValidJoinCombination;
        if (((TraversableOnce)oneJoinPlan.itemIds().intersect(otherJoinPlan.itemIds())).nonEmpty()) {
            return None$.MODULE$;
        }
        if (filters.isDefined() && !(isValidJoinCombination = JoinReorderDPFilters$.MODULE$.starJoinFilter(oneJoinPlan.itemIds(), otherJoinPlan.itemIds(), (JoinGraphInfo)filters.get()))) {
            return None$.MODULE$;
        }
        LogicalPlan onePlan = oneJoinPlan.plan();
        LogicalPlan otherPlan = otherJoinPlan.plan();
        Set joinConds = (Set)((TraversableLike)((TraversableLike)conditions.filterNot((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.MODULE$.canEvaluate(l, onePlan)))).filterNot((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.MODULE$.canEvaluate(r, otherPlan)))).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.$anonfun$buildJoin$3(onePlan, otherPlan, e)));
        if (joinConds.isEmpty()) {
            return None$.MODULE$;
        }
        Tuple2 tuple22 = tuple2 = oneJoinPlan.itemIds().size() >= otherJoinPlan.itemIds().size() ? new Tuple2((Object)onePlan, (Object)otherPlan) : new Tuple2((Object)otherPlan, (Object)onePlan);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan left = (LogicalPlan)tuple2._1();
        LogicalPlan right = (LogicalPlan)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)left, (Object)right);
        Tuple2 tuple24 = tuple23;
        LogicalPlan left2 = (LogicalPlan)tuple24._1();
        LogicalPlan right2 = (LogicalPlan)tuple24._2();
        Join newJoin = new Join(left2, right2, Inner$.MODULE$, (Option<Expression>)joinConds.reduceOption((Function2)And$.MODULE$));
        Set collectedJoinConds = (Set)joinConds.$plus$plus(oneJoinPlan.joinConds()).$plus$plus(otherJoinPlan.joinConds());
        Set remainingConds = (Set)conditions.$minus$minus((GenTraversableOnce)collectedJoinConds);
        AttributeSet neededAttr = AttributeSet$.MODULE$.apply((Iterable<Expression>)((Iterable)remainingConds.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.references(), Set$.MODULE$.canBuildFrom()))).$plus$plus(topOutput);
        Seq neededFromNewJoin = (Seq)newJoin.output().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)neededAttr.contains(elem)));
        LogicalPlan newPlan = newJoin.outputSet().$minus$minus((Traversable<NamedExpression>)neededFromNewJoin).nonEmpty() ? new Project((Seq<NamedExpression>)neededFromNewJoin, newJoin) : newJoin;
        Set itemIds = (Set)oneJoinPlan.itemIds().union(otherJoinPlan.itemIds());
        Cost newPlanCost = oneJoinPlan.planCost().$plus(oneJoinPlan.rootCost(conf)).$plus(otherJoinPlan.planCost()).$plus(otherJoinPlan.rootCost(conf));
        return new Some((Object)new JoinReorderDP.JoinPlan((Set<Object>)itemIds, newPlan, (Set<Expression>)collectedJoinConds, newPlanCost));
    }

    public static final /* synthetic */ boolean $anonfun$sameOutput$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Attribute a1 = (Attribute)tuple2._1();
        Attribute a2 = (Attribute)tuple2._2();
        boolean bl = a1.semanticEquals(a2);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$searchLevel$2(JoinReorderDP.JoinPlan oneSidePlan$1, SQLConf conf$1, Set conditions$1, AttributeSet topOutput$1, Option filters$1, scala.collection.mutable.Map nextLevel$1, JoinReorderDP.JoinPlan otherSidePlan) {
        Option<JoinReorderDP.JoinPlan> option = MODULE$.buildJoin(oneSidePlan$1, otherSidePlan, conf$1, (Set<Expression>)conditions$1, topOutput$1, (Option<JoinGraphInfo>)filters$1);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            JoinReorderDP.JoinPlan newJoinPlan = (JoinReorderDP.JoinPlan)some.value();
            Option existingPlan = nextLevel$1.get(newJoinPlan.itemIds());
            if (existingPlan.isEmpty() || newJoinPlan.betterThan((JoinReorderDP.JoinPlan)existingPlan.get(), conf$1)) {
                nextLevel$1.update(newJoinPlan.itemIds(), (Object)newJoinPlan);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildJoin$3(LogicalPlan onePlan$1, LogicalPlan otherPlan$1, Expression e) {
        return e.references().subsetOf(onePlan$1.outputSet().$plus$plus(otherPlan$1.outputSet()));
    }

    private JoinReorderDP$() {
        MODULE$ = this;
        PredicateHelper.$init$(this);
        Logging.$init$((Logging)this);
    }
}

