/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class StringUtils$ {
    public static StringUtils$ MODULE$;
    private final Set<UTF8String> trueStrings;
    private final Set<UTF8String> falseStrings;

    static {
        new StringUtils$();
    }

    public String escapeLikeRegex(String pattern) {
        Iterator in = new StringOps(Predef$.MODULE$.augmentString(pattern)).toIterator();
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        while (in.hasNext()) {
            char c = BoxesRunTime.unboxToChar((Object)in.next());
            block0 : switch (c) {
                case '\\': {
                    scala.collection.mutable.StringBuilder stringBuilder;
                    if (in.hasNext()) {
                        char c2;
                        char c3 = c2 = BoxesRunTime.unboxToChar((Object)in.next());
                        switch (c3) {
                            case '%': 
                            case '\\': 
                            case '_': {
                                stringBuilder = out.$plus$plus$eq(Pattern.quote(Character.toString(c2)));
                                break block0;
                            }
                        }
                        throw StringUtils$.fail$1(new StringBuilder(49).append("the escape character is not allowed to precede '").append(c2).append("'").toString(), pattern);
                    }
                    throw StringUtils$.fail$1("it is not allowed to end with the escape character", pattern);
                }
                case '_': {
                    scala.collection.mutable.StringBuilder stringBuilder = out.$plus$plus$eq(".");
                    break;
                }
                case '%': {
                    scala.collection.mutable.StringBuilder stringBuilder = out.$plus$plus$eq(".*");
                    break;
                }
                default: {
                    scala.collection.mutable.StringBuilder stringBuilder = out.$plus$plus$eq(Pattern.quote(Character.toString(c)));
                    break;
                }
            }
        }
        return new StringBuilder(4).append("(?s)").append(out.result()).toString();
    }

    public boolean isTrueString(UTF8String s) {
        return this.trueStrings.contains((Object)s.toLowerCase());
    }

    public boolean isFalseString(UTF8String s) {
        return this.falseStrings.contains((Object)s.toLowerCase());
    }

    public Seq<String> filterPattern(Seq<String> names, String pattern) {
        SortedSet funcNames = SortedSet$.MODULE$.empty((Ordering)Ordering.String$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pattern.trim().split("\\|"))).foreach((Function1 & Serializable & scala.Serializable)subPattern -> {
            BoxedUnit boxedUnit;
            try {
                Regex regex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append("(?i)").append(subPattern.replaceAll("\\*", ".*")).toString())).r();
                boxedUnit = funcNames.$plus$plus$eq((TraversableOnce)names.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)StringUtils$.$anonfun$filterPattern$2(regex, name))));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return funcNames.toSeq();
    }

    private static final Nothing$ fail$1(String message, String pattern$1) {
        throw new AnalysisException(new StringBuilder(27).append("the pattern '").append(pattern$1).append("' is invalid, ").append(message).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$filterPattern$2(Regex regex$1, String name) {
        return regex$1.pattern().matcher(name).matches();
    }

    private StringUtils$() {
        MODULE$ = this;
        this.trueStrings = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "true", "y", "yes", "1"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1), Set$.MODULE$.canBuildFrom());
        this.falseStrings = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f", "false", "n", "no", "0"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1), Set$.MODULE$.canBuildFrom());
    }
}

