/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\ruf\u0001B$I\u0001UC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005M\")Q\u000e\u0001C\u0001]\u001a!!\u000f\u0001\u0003t\u0011!!HA!a\u0001\n\u0003)\b\u0002C=\u0005\u0005\u0003\u0007I\u0011\u0001>\t\u0013\u0005\u0005AA!A!B\u00131\bBB7\u0005\t\u0003\t\u0019\u0001C\u0005\u0002\f\u0011\u0011\r\u0011\"\u0001\u0002\u000e!A\u00111\u0007\u0003!\u0002\u0013\tyA\u0002\u0004\u00026\u0001!\u0011q\u0007\u0005\u000b\u0003sY!\u00111A\u0005\u0002\u0005m\u0002BCA\"\u0017\t\u0005\r\u0011\"\u0001\u0002F!Q\u0011\u0011J\u0006\u0003\u0002\u0003\u0006K!!\u0010\t\r5\\A\u0011AA&\u0011%\t\tf\u0003b\u0001\n\u0003\t\u0019\u0006\u0003\u0005\u0002n-\u0001\u000b\u0011BA+\u0011%\tyg\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002|-\u0001\u000b\u0011BA:\u0011!I\u0005A1A\u0005\n\u0005u\u0004\u0002CAA\u0001\u0001\u0006I!a \t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAO\u0001\u0011%\u0011q\u0014\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t)\r\u0001C!\u0003\u000fDq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\"9\u00111\u001e\u0001\u0005B\u00055\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0003c\u0004A\u0011IA|\u0011\u001d\ti\u0010\u0001C!\u0003\u007fDqAa\u0001\u0001\t\u0003\u0012)\u0001C\u0004\u0003\u000e\u0001!\tEa\u0004\t\u000f\tm\u0001\u0001\"\u0011\u0003\u001e!9!\u0011\u0006\u0001\u0005B\t-\u0002b\u0002B\u0018\u0001\u0011\u0005#\u0011\u0007\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0011\u001d\u0011y\u0006\u0001C!\u0005CBqAa\u001a\u0001\t\u0003\u0012I\u0007C\u0004\u0003r\u0001!\tEa\u001d\t\u000f\te\u0004\u0001\"\u0011\u0003|!9!\u0011\u0010\u0001\u0005B\t}\u0004b\u0002BC\u0001\u0011\u0005#q\u0011\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011y\u000b\u0001C!\u0005cCqA!3\u0001\t\u0003\u0012Y\rC\u0004\u0003Z\u0002!\tEa7\t\u000f\t5\b\u0001\"\u0011\u0003p\"9!1 \u0001\u0005B\tu\bbBB\u0003\u0001\u0011\u00053q\u0001\u0005\b\u0007\u001f\u0001A\u0011IB\t\u0011\u001d\u0019Y\u0002\u0001C!\u0007;A\u0011b!\u000b\u0001#\u0003%\taa\u000b\t\u000f\r\u0005\u0003\u0001\"\u0011\u0004D!I11\n\u0001\u0012\u0002\u0013\u000511\u0006\u0005\b\u0007\u001b\u0002A\u0011IB(\u0011\u001d\u0019Y\u0007\u0001C!\u0007[Bqa!\u001e\u0001\t\u0003\u001a9\bC\u0004\u0004\u0000\u0001!\te!!\t\u000f\r\u001d\u0005\u0001\"\u0011\u0004\n\"91\u0011\u0013\u0001\u0005B\rM\u0005bBBM\u0001\u0011\u000531\u0014\u0005\b\u0007C\u0003A\u0011IBR\u000f%\u0019I\u000bSA\u0001\u0012\u0003\u0019YK\u0002\u0005H\u0011\u0006\u0005\t\u0012ABW\u0011\u0019i7\t\"\u0001\u00040\"I1\u0011W\"\u0012\u0002\u0013\u000511\u0017\u0005\n\u0007o\u001b\u0015\u0013!C\u0001\u0007s\u0013q\"\u00138NK6|'/_\"bi\u0006dwn\u001a\u0006\u0003\u0013*\u000bqaY1uC2|wM\u0003\u0002L\u0019\u0006A1-\u0019;bYf\u001cHO\u0003\u0002N\u001d\u0006\u00191/\u001d7\u000b\u0005=\u0003\u0016!B:qCJ\\'BA)S\u0003\u0019\t\u0007/Y2iK*\t1+A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-r\u0003\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013a!\u00118z%\u00164\u0007CA/_\u001b\u0005A\u0015BA0I\u0005=)\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0017\u0001B2p]\u001a\u0004\"AY2\u000e\u00039K!\u0001\u001a(\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001\u00045bI>|\u0007oQ8oM&<\u0007CA4l\u001b\u0005A'B\u00011j\u0015\tQ\u0007+\u0001\u0004iC\u0012|w\u000e]\u0005\u0003Y\"\u0014QbQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0002paF\u0004\"!\u0018\u0001\t\u000f\u0001\u001c\u0001\u0013!a\u0001C\"9Qm\u0001I\u0001\u0002\u00041'!\u0003+bE2,G)Z:d'\t!a+A\u0003uC\ndW-F\u0001w!\tiv/\u0003\u0002y\u0011\na1)\u0019;bY><G+\u00192mK\u0006IA/\u00192mK~#S-\u001d\u000b\u0003wz\u0004\"a\u0016?\n\u0005uD&\u0001B+oSRDqa \u0004\u0002\u0002\u0003\u0007a/A\u0002yIE\na\u0001^1cY\u0016\u0004C\u0003BA\u0003\u0003\u0013\u00012!a\u0002\u0005\u001b\u0005\u0001\u0001\"\u0002;\t\u0001\u00041\u0018A\u00039beRLG/[8ogV\u0011\u0011q\u0002\t\t\u0003#\tY\"a\b\u0002.5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005e\u0001,\u0001\u0006d_2dWm\u0019;j_:LA!!\b\u0002\u0014\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0011\u0003Oq1!XA\u0012\u0013\r\t)\u0003S\u0001\r\u0007\u0006$\u0018\r\\8h)f\u0004Xm]\u0005\u0005\u0003S\tYC\u0001\nUC\ndW\rU1si&$\u0018n\u001c8Ta\u0016\u001c'bAA\u0013\u0011B\u0019Q,a\f\n\u0007\u0005E\u0002JA\u000bDCR\fGn\\4UC\ndW\rU1si&$\u0018n\u001c8\u0002\u0017A\f'\u000f^5uS>t7\u000f\t\u0002\r\t\u0006$\u0018MY1tK\u0012+7oY\n\u0003\u0017Y\u000b!\u0001\u001a2\u0016\u0005\u0005u\u0002cA/\u0002@%\u0019\u0011\u0011\t%\u0003\u001f\r\u000bG/\u00197pO\u0012\u000bG/\u00192bg\u0016\fa\u0001\u001a2`I\u0015\fHcA>\u0002H!Aq0DA\u0001\u0002\u0004\ti$A\u0002eE\u0002\"B!!\u0014\u0002PA\u0019\u0011qA\u0006\t\u000f\u0005er\u00021\u0001\u0002>\u00051A/\u00192mKN,\"!!\u0016\u0011\u0011\u0005E\u00111DA,\u0003\u000b\u0001B!!\u0017\u0002h9!\u00111LA2!\r\ti\u0006W\u0007\u0003\u0003?R1!!\u0019U\u0003\u0019a$o\\8u}%\u0019\u0011Q\r-\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)\u0007W\u0001\bi\u0006\u0014G.Z:!\u0003%1WO\\2uS>t7/\u0006\u0002\u0002tAA\u0011\u0011CA\u000e\u0003/\n)\bE\u0002^\u0003oJ1!!\u001fI\u0005=\u0019\u0015\r^1m_\u001e4UO\\2uS>t\u0017A\u00034v]\u000e$\u0018n\u001c8tAU\u0011\u0011q\u0010\t\t\u0003#\tY\"a\u0016\u0002N\u0005A1-\u0019;bY><\u0007%A\bqCJ$\u0018\u000e^5p]\u0016C\u0018n\u001d;t)!\t9)!$\u0002\u0010\u0006E\u0005cA,\u0002\n&\u0019\u00111\u0012-\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\b\fA\u0002\u0005]\u0003B\u0002;\u0017\u0001\u0004\t9\u0006C\u0004\u0002\u0014Z\u0001\r!a\b\u0002\tM\u0004XmY\u0001\u0016e\u0016\fX/\u001b:f)\u0006\u0014G.\u001a(pi\u0016C\u0018n\u001d;t)\u0015Y\u0018\u0011TAN\u0011\u001d\tId\u0006a\u0001\u0003/Ba\u0001^\fA\u0002\u0005]\u0013A\u0006:fcVL'/\u001a)beRLG/[8og\u0016C\u0018n\u001d;\u0015\u000fm\f\t+a)\u0002&\"9\u0011\u0011\b\rA\u0002\u0005]\u0003B\u0002;\u0019\u0001\u0004\t9\u0006C\u0004\u0002(b\u0001\r!!+\u0002\u000bM\u0004XmY:\u0011\r\u0005-\u0016QWA\u0010\u001d\u0011\ti+!-\u000f\t\u0005u\u0013qV\u0005\u00023&\u0019\u00111\u0017-\u0002\u000fA\f7m[1hK&!\u0011qWA]\u0005\r\u0019V-\u001d\u0006\u0004\u0003gC\u0016!\u0007:fcVL'/\u001a)beRLG/[8og:{G/\u0012=jgR$ra_A`\u0003\u0003\f\u0019\rC\u0004\u0002:e\u0001\r!a\u0016\t\rQL\u0002\u0019AA,\u0011\u001d\t9+\u0007a\u0001\u0003S\u000bab\u0019:fCR,G)\u0019;bE\u0006\u001cX\rF\u0003|\u0003\u0013\fi\rC\u0004\u0002Lj\u0001\r!!\u0010\u0002\u0019\u0011\u0014G)\u001a4j]&$\u0018n\u001c8\t\u000f\u0005='\u00041\u0001\u0002\b\u0006q\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001c\u0018\u0001\u00043s_B$\u0015\r^1cCN,GcB>\u0002V\u0006]\u00171\u001c\u0005\b\u0003sY\u0002\u0019AA,\u0011\u001d\tIn\u0007a\u0001\u0003\u000f\u000b\u0011#[4o_J,\u0017J\u001a(pi\u0016C\u0018n\u001d;t\u0011\u001d\tin\u0007a\u0001\u0003\u000f\u000bqaY1tG\u0006$W-A\u0007bYR,'\u000fR1uC\n\f7/\u001a\u000b\u0004w\u0006\r\bbBAf9\u0001\u0007\u0011QH\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002>\u0005%\bbBA\u001d;\u0001\u0007\u0011qK\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\t9)a<\t\u000f\u0005eb\u00041\u0001\u0002X\u0005iA.[:u\t\u0006$\u0018MY1tKN$\"!!>\u0011\r\u0005-\u0016QWA,)\u0011\t)0!?\t\u000f\u0005m\b\u00051\u0001\u0002X\u00059\u0001/\u0019;uKJt\u0017AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$2a\u001fB\u0001\u0011\u001d\tI$\ta\u0001\u0003/\n1b\u0019:fCR,G+\u00192mKR)1Pa\u0002\u0003\f!1!\u0011\u0002\u0012A\u0002Y\fq\u0002^1cY\u0016$UMZ5oSRLwN\u001c\u0005\b\u0003\u001f\u0014\u0003\u0019AAD\u0003%!'o\u001c9UC\ndW\rF\u0005|\u0005#\u0011\u0019B!\u0006\u0003\u0018!9\u0011\u0011H\u0012A\u0002\u0005]\u0003B\u0002;$\u0001\u0004\t9\u0006C\u0004\u0002Z\u000e\u0002\r!a\"\t\u000f\te1\u00051\u0001\u0002\b\u0006)\u0001/\u001e:hK\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u001dY(q\u0004B\u0011\u0005KAq!!\u000f%\u0001\u0004\t9\u0006C\u0004\u0003$\u0011\u0002\r!a\u0016\u0002\u000f=dGMT1nK\"9!q\u0005\u0013A\u0002\u0005]\u0013a\u00028fo:\u000bW.Z\u0001\u000bC2$XM\u001d+bE2,GcA>\u0003.!1!\u0011B\u0013A\u0002Y\fA#\u00197uKJ$\u0016M\u00197f\t\u0006$\u0018mU2iK6\fGcB>\u00034\tU\"q\u0007\u0005\b\u0003s1\u0003\u0019AA,\u0011\u0019!h\u00051\u0001\u0002X!9!\u0011\b\u0014A\u0002\tm\u0012!\u00048fo\u0012\u000bG/Y*dQ\u0016l\u0017\r\u0005\u0003\u0003>\t\rSB\u0001B \u0015\r\u0011\t\u0005T\u0001\u0006if\u0004Xm]\u0005\u0005\u0005\u000b\u0012yD\u0001\u0006TiJ,8\r\u001e+za\u0016\fq\"\u00197uKJ$\u0016M\u00197f'R\fGo\u001d\u000b\bw\n-#Q\nB(\u0011\u001d\tId\na\u0001\u0003/Ba\u0001^\u0014A\u0002\u0005]\u0003b\u0002B)O\u0001\u0007!1K\u0001\u0006gR\fGo\u001d\t\u0006/\nU#\u0011L\u0005\u0004\u0005/B&AB(qi&|g\u000eE\u0002^\u00057J1A!\u0018I\u0005E\u0019\u0015\r^1m_\u001e\u001cF/\u0019;jgRL7m]\u0001\tO\u0016$H+\u00192mKR)aOa\u0019\u0003f!9\u0011\u0011\b\u0015A\u0002\u0005]\u0003B\u0002;)\u0001\u0004\t9&A\bhKR$\u0016M\u00197fg\nKh*Y7f)\u0019\u0011YG!\u001c\u0003pA)\u00111VA[m\"9\u0011\u0011H\u0015A\u0002\u0005]\u0003bBA)S\u0001\u0007\u0011Q_\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0004\u0002\b\nU$q\u000f\u0005\b\u0003sQ\u0003\u0019AA,\u0011\u0019!(\u00061\u0001\u0002X\u0005QA.[:u)\u0006\u0014G.Z:\u0015\t\u0005U(Q\u0010\u0005\b\u0003sY\u0003\u0019AA,)\u0019\t)P!!\u0003\u0004\"9\u0011\u0011\b\u0017A\u0002\u0005]\u0003bBA~Y\u0001\u0007\u0011qK\u0001\nY>\fG\rV1cY\u0016$2b\u001fBE\u0005\u0017\u0013iI!%\u0003\u0016\"9\u0011\u0011H\u0017A\u0002\u0005]\u0003B\u0002;.\u0001\u0004\t9\u0006C\u0004\u0003\u00106\u0002\r!a\u0016\u0002\u00111|\u0017\r\u001a)bi\"DqAa%.\u0001\u0004\t9)A\u0006jg>3XM]<sSR,\u0007b\u0002BL[\u0001\u0007\u0011qQ\u0001\u000bSN\u001c&o\u0019'pG\u0006d\u0017!\u00047pC\u0012\u0004\u0016M\u001d;ji&|g\u000eF\b|\u0005;\u0013yJ!)\u0003$\n\u001d&\u0011\u0016BW\u0011\u001d\tID\fa\u0001\u0003/Ba\u0001\u001e\u0018A\u0002\u0005]\u0003b\u0002BH]\u0001\u0007\u0011q\u000b\u0005\b\u0005Ks\u0003\u0019AA\u0010\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0003\u0014:\u0002\r!a\"\t\u000f\t-f\u00061\u0001\u0002\b\u0006\t\u0012N\u001c5fe&$H+\u00192mKN\u0003XmY:\t\u000f\t]e\u00061\u0001\u0002\b\u0006)Bn\\1e\tft\u0017-\\5d!\u0006\u0014H/\u001b;j_:\u001cH#D>\u00034\nU&q\u0017B]\u0005w\u0013y\fC\u0004\u0002:=\u0002\r!a\u0016\t\rQ|\u0003\u0019AA,\u0011\u001d\u0011yi\fa\u0001\u0003/BqA!*0\u0001\u0004\ty\u0002C\u0004\u0003>>\u0002\r!a\"\u0002\u000fI,\u0007\u000f\\1dK\"9!\u0011Y\u0018A\u0002\t\r\u0017!\u00028v[\u0012\u0003\u0006cA,\u0003F&\u0019!q\u0019-\u0003\u0007%sG/\u0001\tde\u0016\fG/\u001a)beRLG/[8ogRI1P!4\u0003P\nE'q\u001b\u0005\b\u0003s\u0001\u0004\u0019AA,\u0011\u0019!\b\u00071\u0001\u0002X!9!1\u001b\u0019A\u0002\tU\u0017!\u00029beR\u001c\bCBAV\u0003k\u000bi\u0003C\u0004\u0002PB\u0002\r!a\"\u0002\u001d\u0011\u0014x\u000e\u001d)beRLG/[8ogRi1P!8\u0003`\n\u0005(Q\u001dBt\u0005SDq!!\u000f2\u0001\u0004\t9\u0006\u0003\u0004uc\u0001\u0007\u0011q\u000b\u0005\b\u0005G\f\u0004\u0019AAU\u0003%\u0001\u0018M\u001d;Ta\u0016\u001c7\u000fC\u0004\u0002ZF\u0002\r!a\"\t\u000f\te\u0011\u00071\u0001\u0002\b\"9!1^\u0019A\u0002\u0005\u001d\u0015A\u0003:fi\u0006Lg\u000eR1uC\u0006\u0001\"/\u001a8b[\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\nw\nE(1\u001fB{\u0005oDq!!\u000f3\u0001\u0004\t9\u0006\u0003\u0004ue\u0001\u0007\u0011q\u000b\u0005\b\u0003O\u0013\u0004\u0019AAU\u0011\u001d\u0011IP\ra\u0001\u0003S\u000b\u0001B\\3x'B,7m]\u0001\u0010C2$XM\u001d)beRLG/[8ogR91Pa@\u0004\u0002\r\r\u0001bBA\u001dg\u0001\u0007\u0011q\u000b\u0005\u0007iN\u0002\r!a\u0016\t\u000f\tM7\u00071\u0001\u0003V\u0006aq-\u001a;QCJ$\u0018\u000e^5p]RA\u0011QFB\u0005\u0007\u0017\u0019i\u0001C\u0004\u0002:Q\u0002\r!a\u0016\t\rQ$\u0004\u0019AA,\u0011\u001d\t\u0019\n\u000ea\u0001\u0003?\t!cZ3u!\u0006\u0014H/\u001b;j_:|\u0005\u000f^5p]RA11CB\u000b\u0007/\u0019I\u0002E\u0003X\u0005+\ni\u0003C\u0004\u0002:U\u0002\r!a\u0016\t\rQ,\u0004\u0019AA,\u0011\u001d\t\u0019*\u000ea\u0001\u0003?\t!\u0003\\5tiB\u000b'\u000f^5uS>tg*Y7fgRA\u0011Q_B\u0010\u0007C\u0019\u0019\u0003C\u0004\u0002:Y\u0002\r!a\u0016\t\rQ4\u0004\u0019AA,\u0011%\u0019)C\u000eI\u0001\u0002\u0004\u00199#A\u0006qCJ$\u0018.\u00197Ta\u0016\u001c\u0007#B,\u0003V\u0005}\u0011\u0001\b7jgR\u0004\u0016M\u001d;ji&|gNT1nKN$C-\u001a4bk2$HeM\u000b\u0003\u0007[QCaa\n\u00040-\u00121\u0011\u0007\t\u0005\u0007g\u0019i$\u0004\u0002\u00046)!1qGB\u001d\u0003%)hn\u00195fG.,GMC\u0002\u0004<a\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019yd!\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bmSN$\b+\u0019:uSRLwN\\:\u0015\u0011\tU7QIB$\u0007\u0013Bq!!\u000f9\u0001\u0004\t9\u0006\u0003\u0004uq\u0001\u0007\u0011q\u000b\u0005\n\u0007KA\u0004\u0013!a\u0001\u0007O\t\u0001\u0004\\5tiB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003Ya\u0017n\u001d;QCJ$\u0018\u000e^5p]N\u0014\u0015PR5mi\u0016\u0014HC\u0003Bk\u0007#\u001a\u0019f!\u0016\u0004h!9\u0011\u0011\b\u001eA\u0002\u0005]\u0003B\u0002;;\u0001\u0004\t9\u0006C\u0004\u0004Xi\u0002\ra!\u0017\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0004\u0002,\u0006U61\f\t\u0005\u0007;\u001a\u0019'\u0004\u0002\u0004`)\u00191\u0011\r&\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0007K\u001ayF\u0001\u0006FqB\u0014Xm]:j_:Dqa!\u001b;\u0001\u0004\t9&A\teK\u001a\fW\u000f\u001c;US6,'l\u001c8f\u0013\u0012\fab\u0019:fCR,g)\u001e8di&|g\u000eF\u0003|\u0007_\u001a\t\bC\u0004\u0002:m\u0002\r!a\u0016\t\u000f\rM4\b1\u0001\u0002v\u0005!a-\u001e8d\u00031!'o\u001c9Gk:\u001cG/[8o)\u0015Y8\u0011PB>\u0011\u001d\tI\u0004\u0010a\u0001\u0003/Bqa! =\u0001\u0004\t9&\u0001\u0005gk:\u001cg*Y7f\u00035\tG\u000e^3s\rVt7\r^5p]R)1pa!\u0004\u0006\"9\u0011\u0011H\u001fA\u0002\u0005]\u0003bBB:{\u0001\u0007\u0011QO\u0001\u000fe\u0016t\u0017-\\3Gk:\u001cG/[8o)\u001dY81RBG\u0007\u001fCq!!\u000f?\u0001\u0004\t9\u0006C\u0004\u0003$y\u0002\r!a\u0016\t\u000f\t\u001db\b1\u0001\u0002X\u0005Yq-\u001a;Gk:\u001cG/[8o)\u0019\t)h!&\u0004\u0018\"9\u0011\u0011H A\u0002\u0005]\u0003bBB?\u007f\u0001\u0007\u0011qK\u0001\u000fMVt7\r^5p]\u0016C\u0018n\u001d;t)\u0019\t9i!(\u0004 \"9\u0011\u0011\b!A\u0002\u0005]\u0003bBB?\u0001\u0002\u0007\u0011qK\u0001\u000eY&\u001cHOR;oGRLwN\\:\u0015\r\u0005U8QUBT\u0011\u001d\tI$\u0011a\u0001\u0003/Bq!a?B\u0001\u0004\t9&A\bJ]6+Wn\u001c:z\u0007\u0006$\u0018\r\\8h!\ti6i\u0005\u0002D-R\u001111V\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rU&fA1\u00040\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"aa/+\u0007\u0019\u001cy\u0003")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                boxedUnit = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)db)) {
                if (!cascade) {
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(49).append("Database ").append(db).append(" is not empty. One or more tables exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(54).append("Database '").append(db).append("' is not empty. One or more functions exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                boxedUnit = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(defaultTableLocation, table);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$12 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$1)));
                TableIdentifier x$2 = tableWithLocation.copy$default$1();
                CatalogTableType x$3 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$4 = tableWithLocation.copy$default$3();
                StructType x$5 = tableWithLocation.copy$default$4();
                Option<String> x$6 = tableWithLocation.copy$default$5();
                Seq<String> x$7 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$8 = tableWithLocation.copy$default$7();
                String x$9 = tableWithLocation.copy$default$8();
                long x$10 = tableWithLocation.copy$default$9();
                long x$11 = tableWithLocation.copy$default$10();
                String x$122 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$13 = tableWithLocation.copy$default$13();
                Option<String> x$14 = tableWithLocation.copy$default$14();
                Option<String> x$15 = tableWithLocation.copy$default$15();
                Seq<String> x$16 = tableWithLocation.copy$default$16();
                boolean x$17 = tableWithLocation.copy$default$17();
                boolean x$18 = tableWithLocation.copy$default$18();
                Map<String, String> x$19 = tableWithLocation.copy$default$19();
                Option<String> x$20 = tableWithLocation.copy$default$20();
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, (Map<String, String>)x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                Object object;
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.location(), Seq$.MODULE$.canBuildFrom());
                    locationAllParts.foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(dir, table));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$1 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$2 = qual$1.copy$default$2();
            CatalogStorageFormat x$3 = qual$1.copy$default$3();
            StructType x$4 = qual$1.copy$default$4();
            Option<String> x$5 = qual$1.copy$default$5();
            Seq<String> x$6 = qual$1.copy$default$6();
            Option<BucketSpec> x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            long x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            Map<String, String> x$12 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$13 = qual$1.copy$default$13();
            Option<String> x$14 = qual$1.copy$default$14();
            Option<String> x$15 = qual$1.copy$default$15();
            Seq<String> x$16 = qual$1.copy$default$16();
            boolean x$17 = qual$1.copy$default$17();
            boolean x$18 = qual$1.copy$default$18();
            Map<String, String> x$19 = qual$1.copy$default$19();
            Option<String> x$20 = qual$1.copy$default$20();
            oldDesc.table_$eq(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldDir, newDir, oldName, newName);
                CatalogTable qual$2 = oldDesc.table();
                Some x$21 = new Some((Object)newDir.toUri());
                Option<String> x$22 = qual$2.withNewStorage$default$2();
                Option<String> x$23 = qual$2.withNewStorage$default$3();
                boolean x$24 = qual$2.withNewStorage$default$4();
                Option<String> x$25 = qual$2.withNewStorage$default$5();
                Map<String, String> x$26 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$21, x$22, x$23, x$24, x$25, x$26));
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$1 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        String x$12 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Seq<String> x$16 = tableDefinition.copy$default$16();
        boolean x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        Map<String, String> x$19 = tableDefinition.copy$default$19();
        Option<String> x$20 = tableDefinition.copy$default$20();
        CatalogTable newTableDefinition = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$1 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$1 = stats;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        StructType x$5 = origTable.copy$default$4();
        Option<String> x$6 = origTable.copy$default$5();
        Seq<String> x$7 = origTable.copy$default$6();
        Option<BucketSpec> x$8 = origTable.copy$default$7();
        String x$9 = origTable.copy$default$8();
        long x$10 = origTable.copy$default$9();
        long x$11 = origTable.copy$default$10();
        String x$12 = origTable.copy$default$11();
        Map<String, String> x$13 = origTable.copy$default$12();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public Seq<CatalogTable> getTablesByName(String db, Seq<String> tables) {
        this.requireDbExists(db);
        HashMap<String, TableDesc> hashMap = ((DatabaseDesc)this.catalog().apply((Object)db)).tables();
        return (Seq)((TraversableLike)tables.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.table(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadTable is not implemented");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadPartition is not implemented.");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw new UnsupportedOperationException("loadDynamicPartitions is not implemented.");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$4 -> new Path(x$4)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw new SparkException(new StringBuilder(32).append("Unable to create partition path ").append(partitionPath).toString(), (Throwable)e);
            }
            CatalogStorageFormat x$1 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$2 = p.copy$default$1();
            Map<String, String> x$3 = p.copy$default$3();
            long x$42 = p.copy$default$4();
            long x$5 = p.copy$default$5();
            Option<CatalogStatistics> x$6 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$2, x$1, x$3, x$42, x$5, x$6));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> partSpecs, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = !this.existingParts$2.contains(A1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x1) {
                Map<String, String> map = x1;
                boolean bl = !this.existingParts$2.contains(map);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Object object;
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
                }
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                object = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable & scala.Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CatalogTablePartition catalogTablePartition;
            Map newSpec;
            Map oldSpec;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                oldSpec = (Map)tuple2._1();
                newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.rename(oldPartPath, newPartPath);
                    }
                    catch (IOException e) {
                        throw new SparkException(new StringBuilder(32).append("Unable to rename partition path ").append(oldPartPath).toString(), (Throwable)e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CatalogTablePartition newPartition = catalogTablePartition;
            existingParts.remove((Object)oldSpec);
            Option option = existingParts.put((Object)newSpec, (Object)newPartition);
            return option;
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> parts) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)p -> p.spec(), Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> spec) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> spec) {
        return !this.partitionExists(db, table, spec) ? None$.MODULE$ : Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        return (Seq)((SeqLike)this.listPartitions(db, table, partialSpec).map((Function1 & Serializable & scala.Serializable)partition -> ((TraversableOnce)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName((String)name)).append("=").append(ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/"), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq seq;
        this.requireTableExists(db, table);
        Option<Map<String, String>> option = partialSpec;
        if (None$.MODULE$.equals(option)) {
            seq = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            seq = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new scala.Serializable(null, partial){
                public static final long serialVersionUID = 0L;
                private final Map partial$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            object = partition;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x1) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x1;
                    boolean bl = tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                    return bl;
                }
                {
                    this.partial$1 = partial$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$1 = this.getFunction(db, oldName);
            FunctionIdentifier x$1 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$2 = qual$1.copy$default$2();
            Seq<FunctionResource> x$3 = qual$1.copy$default$3();
            CatalogFunction newFunc = qual$1.copy(x$1, x$2, x$3);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionAlreadyExistsException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(61).append("Unable to create database ").append(dbDefinition$1.name()).append(" as failed ").append("to create its directory ").append(dbDefinition$1.locationUri()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(59).append("Unable to drop database ").append(dbDefinition$2.name()).append(" as failed ").append("to delete its directory ").append(dbDefinition$2.locationUri()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree3$1(Path defaultTableLocation$1, String table$3) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(58).append("Unable to create table ").append(table$3).append(" as failed ").append("to create its directory ").append(defaultTableLocation$1).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$1) {
        Object object = x$1._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree4$1(Path dir$1, String table$4) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(56).append("Unable to drop table ").append(table$4).append(" as failed ").append("to delete its directory ").append(dir$1).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree5$1(Path oldDir$1, Path newDir$1, String oldName$1, String newName$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(62).append("Unable to rename table ").append(oldName$1).append(" to ").append(newName$1).append(" as failed ").append("to rename its directory ").append(oldDir$1).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    public class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    public class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

