/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u0015+\u0001]B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000b\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003O\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Z\u000b\u0011i\u0006\u0001\u00020\t\u000f=\u0004!\u0019!C\u0005a\"1A\u0010\u0001Q\u0001\nEDq! \u0001C\u0002\u0013%a\u0010\u0003\u0004\u0000\u0001\u0001\u0006I!\u0012\u0005\n\u0003\u0003\u0001!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?A\u0001\"!\f\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"a\u0010\u0001A\u0003%\u00111\u0007\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0013\u0001A\u0003%\u0011Q\t\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA2\u0011%\tY\u0007\u0001b\u0001\n\u0013\ti\u0007\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA8\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003C\u0011\"a'\u0001#\u0003%\t!!(\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"I\u0011q\u0019\u0001C\u0002\u0013%\u0011\u0011\u001a\u0005\t\u0003+\u0004\u0001\u0015!\u0003\u0002L\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007\"CAp\u0001\t\u0007I\u0011BAq\u0011!\t\t\u0010\u0001Q\u0001\n\u0005\r\bbBAz\u0001\u0011%\u0011Q_\u0004\t\u0003wT\u0003\u0012\u0001\u0018\u0002~\u001a9\u0011F\u000bE\u0001]\u0005}\bBB*$\t\u0003\u0011\t\u0001C\u0004\u0003\u0004\r\"\tA!\u0002\t\u000f\tM2\u0005\"\u0001\u00036!9!1J\u0012\u0005\n\t5\u0003b\u0002BCG\u0011\u0005!q\u0011\u0002\u0010+:Lgo\\2jif\u0004\u0016M]:fe*\u00111\u0006L\u0001\u0004GN4(BA\u0017/\u0003!\u0019\u0017\r^1msN$(BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO\u000e\u00011c\u0001\u00019}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0019\u0002\u0011%tG/\u001a:oC2L!a\u0011!\u0003\u000f1{wmZ5oO\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005\u0019KU\"A$\u000b\u0005!s\u0013!\u0002;za\u0016\u001c\u0018B\u0001&H\u0005)\u0019FO];diRK\b/Z\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0003\u001dy\u0007\u000f^5p]N,\u0012A\u0014\t\u0003\u001fBk\u0011AK\u0005\u0003#*\u0012!bQ*W\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003V-^C\u0006CA(\u0001\u0011\u0015!U\u00011\u0001F\u0011\u0015YU\u00011\u0001F\u0011\u0015aU\u00011\u0001O)\r)&\f\u0018\u0005\u00067\u001a\u0001\r!R\u0001\u0007g\u000eDW-\\1\t\u000b13\u0001\u0019\u0001(\u0003\u001dY\u000bG.^3D_:4XM\u001d;feB!\u0011hX1m\u0013\t\u0001'HA\u0005Gk:\u001cG/[8ocA\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001\u001a\u001e\u000e\u0003\u0015T!A\u001a\u001c\u0002\rq\u0012xn\u001c;?\u0013\tA'(\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015;!\tIT.\u0003\u0002ou\t\u0019\u0011I\\=\u0002\u001bQ|7.\u001a8J]\u0012,\u00070\u0011:s+\u0005\t\bcA\u001dsi&\u00111O\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fA\u0001\\1oO*\t\u00110\u0001\u0003kCZ\f\u0017BA>w\u0005\u001dIe\u000e^3hKJ\fa\u0002^8lK:Le\u000eZ3y\u0003J\u0014\b%\u0001\u0007qCJ\u001cX\rZ*dQ\u0016l\u0017-F\u0001F\u00035\u0001\u0018M]:fIN\u001b\u0007.Z7bA\u0005IAo\\6f]&TXM]\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0004W\u0005-!\u0002BA\u0007\u0003\u001f\tq\u0001]1sg\u0016\u00148O\u0003\u0003\u0002\u0012\u0005M\u0011!C;oSZ|7-\u001b;z\u0015\t\t)\"A\u0002d_6LA!!\u0007\u0002\n\tI1i\u001d<QCJ\u001cXM]\u0001\u000bi>\\WM\\5{KJ\u0004\u0013a\u0001:poV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0017\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003W\t)C\u0001\nHK:,'/[2J]R,'O\\1m%><\u0018\u0001\u0002:po\u0002\n!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\u0011\u00111\u0007\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0017\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003{\t9D\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u00043bi\u00164uN]7biR,'/\u0006\u0002\u0002FA!\u0011QGA$\u0013\u0011\tI%a\u000e\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u00039!\u0017\r^3G_Jl\u0017\r\u001e;fe\u0002\nqbZ3u\u0007V\u0014(/\u001a8u\u0013:\u0004X\u000f^\u000b\u0003\u0003#\u0002B!a\u0015\u0002\\5\u0011\u0011Q\u000b\u0006\u0004\u0011\u0006]#bAA-a\u00051QO\\:bM\u0016LA!!\u0018\u0002V\tQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u001fY\fG.^3D_:4XM\u001d;feN,\"!a\u0019\u0011\te\u0012\u0018Q\r\t\u0004\u0003O:Q\"\u0001\u0001\u0002!Y\fG.^3D_:4XM\u001d;feN\u0004\u0013!\u00043fG&l\u0017\r\u001c)beN,'/\u0006\u0002\u0002pA)\u0011hX1\u0002rA!\u00111OA=\u001b\t\t)HC\u0002\u0002xa\fA!\\1uQ&!\u00111PA;\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\\\u0001\u000fI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:!\u00035i\u0017m[3D_:4XM\u001d;feRA\u0011QMAB\u0003\u000f\u000b\t\n\u0003\u0004\u0002\u0006f\u0001\r!Y\u0001\u0005]\u0006lW\rC\u0004\u0002\nf\u0001\r!a#\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042ARAG\u0013\r\tyi\u0012\u0002\t\t\u0006$\u0018\rV=qK\"I\u00111S\r\u0011\u0002\u0003\u0007\u0011QS\u0001\t]VdG.\u00192mKB\u0019\u0011(a&\n\u0007\u0005e%HA\u0004C_>dW-\u00198\u0002/5\f7.Z\"p]Z,'\u000f^3sI\u0011,g-Y;mi\u0012\u001aTCAAPU\u0011\t)*!),\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!,;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000b9KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQB\\;mYN\u000bg-\u001a#biVlGCCA\\\u0003{\u000b\t-a1\u0002FR\u0019A.!/\t\u000f\u0005m6\u00041\u0001\u0002f\u0005I1m\u001c8wKJ$XM\u001d\u0005\u0007\u0003\u007f[\u0002\u0019A1\u0002\u000b\u0011\fG/^7\t\r\u0005\u00155\u00041\u0001b\u0011\u001d\t\u0019j\u0007a\u0001\u0003+CQ\u0001T\u000eA\u00029\u000bq\u0001Z8QCJ\u001cX-\u0006\u0002\u0002LB)\u0011hX1\u0002NB!\u0011qZAi\u001b\u0005a\u0013bAAjY\tY\u0011J\u001c;fe:\fGNU8x\u0003!!w\u000eU1sg\u0016\u0004\u0013!\u00029beN,G\u0003BAg\u00037Da!!8\u001f\u0001\u0004\t\u0017!B5oaV$\u0018\u0001C4fiR{7.\u001a8\u0016\u0005\u0005\r\b\u0003C\u001d\u0002f\u0006%\u00181^1\n\u0007\u0005\u001d(HA\u0005Gk:\u001cG/[8oeA\u0019\u0011H]1\u0011\u0007e\ni/C\u0002\u0002pj\u00121!\u00138u\u0003%9W\r\u001e+pW\u0016t\u0007%A\u0004d_:4XM\u001d;\u0015\t\u00055\u0017q\u001f\u0005\b\u0003s\f\u0003\u0019AAu\u0003\u0019!xn[3og\u0006yQK\\5w_\u000eLG/\u001f)beN,'\u000f\u0005\u0002PGM\u00111\u0005\u000f\u000b\u0003\u0003{\fa\u0002^8lK:L'0Z*ue\u0016\fW\u000e\u0006\u0006\u0003\b\te!\u0011\u0006B\u0017\u0005_\u0001bA!\u0003\u0003\u0014\u0005%h\u0002\u0002B\u0006\u0005\u001fq1\u0001\u001aB\u0007\u0013\u0005Y\u0014b\u0001B\tu\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u000b\u0005/\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0005#Q\u0004b\u0002B\u000eK\u0001\u0007!QD\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\r\u0011\u0019\u0003_\u0001\u0003S>LAAa\n\u0003\"\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0011Y#\na\u0001\u0003+\u000b\u0001c\u001d5pk2$GI]8q\u0011\u0016\fG-\u001a:\t\u000f\u0005\u0005Q\u00051\u0001\u0002\u0006!1!\u0011G\u0013A\u0002\u0005\f\u0001\"\u001a8d_\u0012LgnZ\u0001\fa\u0006\u00148/Z*ue\u0016\fW\u000e\u0006\u0006\u00038\te\"1\bB \u0005\u0013\u0002bA!\u0003\u0003\u0014\u00055\u0007b\u0002B\u000eM\u0001\u0007!Q\u0004\u0005\u0007\u0005{1\u0003\u0019A+\u0002\rA\f'o]3s\u0011\u001d\u0011\tE\na\u0001\u0005\u0007\nQ\u0002[3bI\u0016\u00148\t[3dW\u0016\u0014\bcA(\u0003F%\u0019!q\t\u0016\u0003!\r\u001bf\u000bS3bI\u0016\u00148\t[3dW\u0016\u0014\b\"B.'\u0001\u0004)\u0015!D2p]Z,'\u000f^*ue\u0016\fW.\u0006\u0003\u0003P\t}CC\u0003B)\u0005_\u0012\tHa\u001d\u0003\u0004R!!1\u000bB6%\u0015\u0011)\u0006\u000fB-\r\u0019\u00119f\n\u0001\u0003T\taAH]3gS:,W.\u001a8u}A1!\u0011\u0002B\n\u00057\u0002BA!\u0018\u0003`1\u0001Aa\u0002B1O\t\u0007!1\r\u0002\u0002)F\u0019!Q\r7\u0011\u0007e\u00129'C\u0002\u0003ji\u0012qAT8uQ&tw\rC\u0004\u0002t\u001e\u0002\rA!\u001c\u0011\rez\u0016\u0011\u001eB.\u0011\u001d\u0011Yb\na\u0001\u0005;Aq!!\u0001(\u0001\u0004\t)\u0001C\u0004\u0003v\u001d\u0002\rAa\u001e\u0002\u0019!\fg\u000e\u001a7f\u0011\u0016\fG-\u001a:\u0011\u000be\u0012IH! \n\u0007\tm$HA\u0005Gk:\u001cG/[8oaA\u0019\u0011Ha \n\u0007\t\u0005%H\u0001\u0003V]&$\bB\u0002B\u0019O\u0001\u0007\u0011-A\u0007qCJ\u001cX-\u0013;fe\u0006$xN\u001d\u000b\u000b\u0005o\u0011IIa$\u0003\u0012\nM\u0005b\u0002BFQ\u0001\u0007!QR\u0001\u0006Y&tWm\u001d\t\u0006\u0005\u0013\u0011\u0019\"\u0019\u0005\u0007\u0005{A\u0003\u0019A+\t\u000f\t\u0005\u0003\u00061\u0001\u0003D!)1\f\u000ba\u0001\u000b\u0002")
public class UnivocityParser
implements Logging {
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final CSVOptions options;
    private final Integer[] tokenIndexArr;
    private final StructType parsedSchema;
    private final CsvParser tokenizer;
    private final GenericInternalRow row;
    private final TimestampFormatter timestampFormatter;
    private final DateFormatter dateFormatter;
    private final Function1<String, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<String, InternalRow> doParse;
    private final Function2<String[], Object, String> getToken;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Iterator<InternalRow> parseIterator(Iterator<String> iterator, UnivocityParser univocityParser, CSVHeaderChecker cSVHeaderChecker, StructType structType) {
        return UnivocityParser$.MODULE$.parseIterator(iterator, univocityParser, cSVHeaderChecker, structType);
    }

    public static Iterator<InternalRow> parseStream(InputStream inputStream, UnivocityParser univocityParser, CSVHeaderChecker cSVHeaderChecker, StructType structType) {
        return UnivocityParser$.MODULE$.parseStream(inputStream, univocityParser, cSVHeaderChecker, structType);
    }

    public static Iterator<String[]> tokenizeStream(InputStream inputStream, boolean bl, CsvParser csvParser, String string) {
        return UnivocityParser$.MODULE$.tokenizeStream(inputStream, bl, csvParser, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVOptions options() {
        return this.options;
    }

    private Integer[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private StructType parsedSchema() {
        return this.parsedSchema;
    }

    public CsvParser tokenizer() {
        return this.tokenizer;
    }

    private GenericInternalRow row() {
        return this.row;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private UTF8String getCurrentInput() {
        return UTF8String.fromString((String)new StringOps(Predef$.MODULE$.augmentString(this.tokenizer().getContext().currentParsedContent())).stripLineEnd());
    }

    private Function1<String, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public Function1<String, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        Function1<String, Object> function1;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)UnivocityParser.$anonfun$makeConverter$2(x$1)));
        } else if (dataType2 instanceof ShortType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)UnivocityParser.$anonfun$makeConverter$4(x$2)));
        } else if (dataType2 instanceof IntegerType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)UnivocityParser.$anonfun$makeConverter$6(x$3)));
        } else if (dataType2 instanceof LongType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$8(x$4)));
        } else if (dataType2 instanceof FloatType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
                Float f;
                String string = x0$1;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    f = BoxesRunTime.boxToFloat((float)Float.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        f = BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        f = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY) : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(string)).toFloat());
                    }
                }
                return f;
            });
        } else if (dataType2 instanceof DoubleType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
                Double d;
                String string = x0$2;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    d = BoxesRunTime.boxToDouble((double)Double.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        d = BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        d = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY) : BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                    }
                }
                return d;
            });
        } else if (dataType2 instanceof BooleanType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UnivocityParser.$anonfun$makeConverter$14(x$5)));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> Decimal$.MODULE$.apply((BigDecimal)this.decimalParser().apply(datum), decimalType.precision(), decimalType.scale()));
        } else if (dataType2 instanceof TimestampType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$18(this, s)));
        } else if (dataType2 instanceof DateType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)UnivocityParser.$anonfun$makeConverter$20(this, s)));
        } else if (dataType2 instanceof StringType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1));
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            function1 = this.makeConverter(name, userDefinedType.sqlType(), nullable);
        } else {
            throw new RuntimeException(new StringBuilder(18).append("Unsupported type: ").append(dataType.typeName()).toString());
        }
        return function1;
    }

    public boolean makeConverter$default$3() {
        return true;
    }

    private Object nullSafeDatum(String datum, String name, boolean nullable, CSVOptions options, Function1<String, Object> converter) {
        Object object;
        String string = datum;
        String string2 = options.nullValue();
        if (!(string == null ? string2 != null : !string.equals(string2)) || datum == null) {
            if (!nullable) {
                throw new RuntimeException(new StringBuilder(44).append("null value found but field ").append(name).append(" is not nullable.").toString());
            }
            object = null;
        } else {
            object = converter.apply((Object)datum);
        }
        return object;
    }

    private Function1<String, InternalRow> doParse() {
        return this.doParse;
    }

    public InternalRow parse(String input) {
        return (InternalRow)this.doParse().apply((Object)input);
    }

    private Function2<String[], Object, String> getToken() {
        return this.getToken;
    }

    public InternalRow org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(String[] tokens) {
        if (tokens == null) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, new RuntimeException("Malformed CSV record"));
        }
        if (tokens.length != this.parsedSchema().length()) {
            String[] checkedTokens = this.parsedSchema().length() > tokens.length ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[this.parsedSchema().length() - tokens.length])), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).take(this.parsedSchema().length());
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> this.getPartialResult$1(checkedTokens), new RuntimeException("Malformed CSV record"));
        }
        None$ badRecordException = None$.MODULE$;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                this.row().update(i, this.valueConverters()[i].apply(this.getToken().apply((Object)tokens, (Object)BoxesRunTime.boxToInteger((int)i))));
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    badRecordException = badRecordException.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)e));
                    this.row().setNullAt(i);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        if (!badRecordException.isEmpty()) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> new Some((Object)this.row()), (Throwable)badRecordException.get());
        }
        return this.row();
    }

    public static final /* synthetic */ byte $anonfun$makeConverter$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toByte();
    }

    public static final /* synthetic */ short $anonfun$makeConverter$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toShort();
    }

    public static final /* synthetic */ int $anonfun$makeConverter$6(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$8(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$makeConverter$14(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$18(UnivocityParser $this, String s) {
        return $this.timestampFormatter().parse(s);
    }

    public static final /* synthetic */ int $anonfun$makeConverter$20(UnivocityParser $this, String s) {
        return $this.dateFormatter().parse(s);
    }

    public static final /* synthetic */ String $anonfun$getToken$1(String[] tokens, int index) {
        return tokens[index];
    }

    public static final /* synthetic */ String $anonfun$getToken$2(UnivocityParser $this, String[] tokens, int index) {
        return tokens[Predef$.MODULE$.Integer2int($this.tokenIndexArr()[index])];
    }

    private final Option getPartialResult$1(String[] checkedTokens$1) {
        Some some;
        try {
            some = new Some((Object)this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(checkedTokens$1));
        }
        catch (BadRecordException badRecordException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf(dataSchema.toSet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("requiredSchema (").append($this.requiredSchema.catalogString()).append(") should be the subset of ").append("dataSchema (").append($this.dataSchema.catalogString()).append(").").toString());
        this.tokenIndexArr = (Integer[])((TraversableOnce)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> $this.dataSchema.indexOf(f), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
        this.parsedSchema = options.columnPruning() ? requiredSchema : dataSchema;
        CsvParserSettings parserSetting = options.asParserSettings();
        Object object = this.parsedSchema().length() < dataSchema.length() ? parserSetting.selectIndexes(this.tokenIndexArr()) : BoxedUnit.UNIT;
        this.tokenizer = new CsvParser(parserSetting);
        this.row = new GenericInternalRow(requiredSchema.length());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormat(), options.zoneId(), options.locale());
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormat(), options.zoneId(), options.locale());
        this.valueConverters = (Function1[])((TraversableOnce)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.doParse = options.columnPruning() && requiredSchema.isEmpty() ? (Function1 & Serializable & scala.Serializable)x$6 -> InternalRow$.MODULE$.empty() : (Function1 & Serializable & scala.Serializable)input -> this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(this.tokenizer().parseLine(input));
        this.getToken = options.columnPruning() ? (Function2 & Serializable & scala.Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$1(tokens, BoxesRunTime.unboxToInt((Object)index)) : (Function2 & Serializable & scala.Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$2(this, tokens, BoxesRunTime.unboxToInt((Object)index));
    }

    public UnivocityParser(StructType schema, CSVOptions options) {
        this(schema, schema, options);
    }
}

