/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitwiseCount$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the number of bits that are set in the argument expr as an unsigned 64-bit integer, or NULL if the argument is NULL.", examples="\n    Examples:\n      > SELECT _FUNC_(0);\n       0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005u!)a\b\u0001C\u0001\u007f!)!\t\u0001C!\u0007\")a\u000b\u0001C!/\")1\f\u0001C!9\")Q\r\u0001C!M\")A\u000f\u0001C)k\")q\u0004\u0001C!w\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033:\u0011\"!\u001d\u001b\u0003\u0003E\t!a\u001d\u0007\u0011eQ\u0012\u0011!E\u0001\u0003kBaAP\n\u0005\u0002\u0005\r\u0005\u0002C.\u0014\u0003\u0003%)%!\"\t\u0013\u0005\u001d5#!A\u0005\u0002\u0006%\u0005\"CAG'\u0005\u0005I\u0011QAH\u0011%\tYjEA\u0001\n\u0013\tiJ\u0001\u0007CSR<\u0018n]3D_VtGO\u0003\u0002\u001c9\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tib$\u0001\u0005dCR\fG._:u\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0006L\u00186!\tI#&D\u0001\u001b\u0013\tY#DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tIS&\u0003\u0002/5\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001GN\u0005\u0003oE\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012A\u000f\t\u0003SmJ!\u0001\u0010\u000e\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0001\u000b\u0005CA\u0015\u0001\u0011\u0015A4\u00011\u0001;\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002\tB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%'\u0003\u0019a$o\\8u}%\t!'\u0003\u0002Mc\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003\u0019F\u0002\"!\u0015+\u000e\u0003IS!a\u0015\u0010\u0002\u000bQL\b/Z:\n\u0005U\u0013&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u0001-\u0011\u0005EK\u0016B\u0001.S\u0005!!\u0015\r^1UsB,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003u\u0003\"A\u00182\u000f\u0005}\u0003\u0007CA$2\u0013\t\t\u0017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA12\u0003%!wnR3o\u0007>$W\rF\u0002h[J\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u000e\u0002\u000f\r|G-Z4f]&\u0011A.\u001b\u0002\t\u000bb\u0004(oQ8eK\")an\u0002a\u0001_\u0006\u00191\r\u001e=\u0011\u0005!\u0004\u0018BA9j\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa]\u0004A\u0002\u001d\f!!\u001a<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005YL\bC\u0001\u0019x\u0013\tA\u0018GA\u0002B]fDQA\u001f\u0005A\u0002Y\fQ!\u001b8qkR,\u0012!X\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002A}\"9\u0001H\u0003I\u0001\u0002\u0004Q\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007Q3AOA\u0003W\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\tc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00027b]\u001eT!!!\n\u0002\t)\fg/Y\u0005\u0004G\u0006}\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0017!\r\u0001\u0014qF\u0005\u0004\u0003c\t$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001<\u00028!I\u0011\u0011\b\b\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000f2XBAA\"\u0015\r\t)%M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qJA+!\r\u0001\u0014\u0011K\u0005\u0004\u0003'\n$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003s\u0001\u0012\u0011!a\u0001m\u00061Q-];bYN$B!a\u0014\u0002\\!A\u0011\u0011H\t\u0002\u0002\u0003\u0007a\u000fK\u0006\u0001\u0003?\n)'a\u001a\u0002l\u00055\u0004cA\u0015\u0002b%\u0019\u00111\r\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011N\u0001\u0002\u0018}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004#-\u001b;tAQD\u0017\r\u001e\u0011be\u0016\u00043/\u001a;!S:\u0004C\u000f[3!CJ<W/\\3oi\u0002*\u0007\u0010\u001d:!CN\u0004\u0013M\u001c\u0011v]NLwM\\3eAY\"TFY5uA%tG/Z4fe2\u0002sN\u001d\u0011O+2c\u0005%\u001b4!i\",\u0007%\u0019:hk6,g\u000e\u001e\u0011jg\u0002rU\u000b\u0014'/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA8\u0003QR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAR\u0001\u0005I\u0001\r\u0005&$x/[:f\u0007>,h\u000e\u001e\t\u0003SM\u0019BaEA<kA1\u0011\u0011PA@u\u0001k!!a\u001f\u000b\u0007\u0005u\u0014'A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00151\u0010\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAA:)\t\tY\"A\u0003baBd\u0017\u0010F\u0002A\u0003\u0017CQ\u0001\u000f\fA\u0002i\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0012\u0006]\u0005\u0003\u0002\u0019\u0002\u0014jJ1!!&2\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011T\f\u0002\u0002\u0003\u0007\u0001)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0014\t\u0005\u0003;\t\t+\u0003\u0003\u0002$\u0006}!AB(cU\u0016\u001cG\u000f")
public class BitwiseCount
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitwiseCount bitwiseCount) {
        return BitwiseCount$.MODULE$.unapply(bitwiseCount);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitwiseCount, A> function1) {
        return BitwiseCount$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitwiseCount> compose(Function1<A, Expression> function1) {
        return BitwiseCount$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, BooleanType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String toString() {
        return new StringBuilder(11).append("bit_count(").append(this.child()).append(")").toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        ExprCode exprCode = BooleanType$.MODULE$.equals(dataType) ? this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(14).append("if (").append((String)c).append(") 1 else 0").toString()) : this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(25).append("java.lang.Long.bitCount(").append((String)c).append(")").toString());
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.unboxToBoolean((Object)input) ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToByte((Object)input)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToShort((Object)input)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToInt((Object)input)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToLong((Object)input)));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public String sql() {
        return new StringBuilder(11).append("bit_count(").append(this.child().sql()).append(")").toString();
    }

    public BitwiseCount copy(Expression child) {
        return new BitwiseCount(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitwiseCount";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseCount bitwiseCount = (BitwiseCount)x$1;
        Expression expression = this.child();
        Expression expression2 = bitwiseCount.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitwiseCount.canEqual(this)) return false;
        return true;
    }

    public BitwiseCount(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

