/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u000f\u001f\u0001.B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005w!)\u0001\n\u0001C\u0001\u0013\"AA\n\u0001EC\u0002\u0013\u0005Q\n\u0003\u0005W\u0001!\u0015\r\u0011\"\u0001N\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015a\u0006\u0001\"\u0011^\u0011!!\u0007\u0001#b\u0001\n\u0003*\u0007\"\u00027\u0001\t\u0003B\u0006\u0002C7\u0001\u0011\u000b\u0007I\u0011\u00028\t\u000bU\u0004A\u0011\t<\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003[\u0002\u0011\u0011!C\u0001\u0003_B\u0011\"!\u001e\u0001\u0003\u0003%\t%a\u001e\t\u0013\u0005\u0005\u0005!!A\u0005\u0002\u0005\r\u0005\"CAD\u0001\u0005\u0005I\u0011IAE\u000f%\t\tKHA\u0001\u0012\u0003\t\u0019K\u0002\u0005\u001e=\u0005\u0005\t\u0012AAS\u0011\u0019Au\u0003\"\u0001\u00024\"I\u0011QW\f\u0002\u0002\u0013\u0015\u0013q\u0017\u0005\n\u0003s;\u0012\u0011!CA\u0003wC\u0011\"a0\u0018\u0003\u0003%\t)!1\t\u0013\u00055w#!A\u0005\n\u0005='!C\"sK\u0006$X-T1q\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011\u0003\u0002\u0001-aY\u0002\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$GA\u0004Qe>$Wo\u0019;\u0011\u0005E:\u0014B\u0001\u001d3\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!\u0019\u0007.\u001b7ee\u0016tW#A\u001e\u0011\u0007q\"EF\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IK\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!a\u0011\u001a\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u0004'\u0016\f(BA\"3\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0015.\u0003\"!\f\u0001\t\u000be\u001a\u0001\u0019A\u001e\u0002\t-,\u0017p]\u000b\u0002\u001dB\u0019q\n\u0016\u0017\u000e\u0003AS!!\u0015*\u0002\u0013%lW.\u001e;bE2,'BA*3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003+B\u0013!\"\u00138eKb,GmU3r\u0003\u00191\u0018\r\\;fg\u0006Aam\u001c7eC\ndW-F\u0001Z!\t\t$,\u0003\u0002\\e\t9!i\\8mK\u0006t\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u0004\u0013\u0001C1oC2L8/[:\n\u0005\r\u0004'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\n\nQ\u0001^=qKNL!a\u001b5\u0003\u000f5\u000b\u0007\u000fV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0006nCB\u0014U/\u001b7eKJ,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0002\nA!\u001e;jY&\u0011A/\u001d\u0002\u0015\u0003J\u0014\u0018-\u001f\"bg\u0016$W*\u00199Ck&dG-\u001a:\u0002\t\u00154\u0018\r\u001c\u000b\u0003oj\u0004\"!\r=\n\u0005e\u0014$aA!os\"91p\u0003I\u0001\u0002\u0004a\u0018!B5oaV$\bCA?\u007f\u001b\u0005\u0001\u0013BA@!\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0003\u0003#\tY\u0002\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYAH\u0001\bG>$WmZ3o\u0013\u0011\ty!!\u0003\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0005\r\u0001\u0004\t)\"A\u0002dib\u0004B!a\u0002\u0002\u0018%!\u0011\u0011DA\u0005\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\b\r\u0001\u0004\t)!\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003[qA!a\n\u0002*A\u0011aHM\u0005\u0004\u0003W\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,I\nAaY8qsR\u0019!*a\u000e\t\u000fer\u0001\u0013!a\u0001w\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001fU\rY\u0014qH\u0016\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0005v]\u000eDWmY6fI*\u0019\u00111\n\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0005\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0016\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!A.\u00198h\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u00033\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001a\u0011\u0007E\nI'C\u0002\u0002lI\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a^A9\u0011%\t\u0019HEA\u0001\u0002\u0004\t9'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0002R!a\u001f\u0002~]l\u0011AU\u0005\u0004\u0003\u007f\u0012&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!WAC\u0011!\t\u0019\bFA\u0001\u0002\u00049\u0018AB3rk\u0006d7\u000fF\u0002Z\u0003\u0017C\u0001\"a\u001d\u0016\u0003\u0003\u0005\ra\u001e\u0015\f\u0001\u0005=\u0015QSAL\u00037\u000bi\nE\u0002.\u0003#K1!a%\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!'\u0002/~3UKT\"`Q-,\u0017\u0010\r\u0017!m\u0006dW/\u001a\u0019-A-,\u00170\r\u0017!m\u0006dW/Z\u0019-A9rc&\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002ZW-_\u0018wC2,X\r\t9bSJ\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty*A+\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QEr\u0003\u0007\f\u0011(e\u001db\u0003e\r\u00181Y\u0001:CgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\fd\u0006\r\u001e#e\tb3G\f\u0019;EQ\u0012SP\u0003\u0011!\u0003%\u0019%/Z1uK6\u000b\u0007\u000f\u0005\u0002./M!q#a*7!\u0019\tI+a,<\u00156\u0011\u00111\u0016\u0006\u0004\u0003[\u0013\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003c\u000bYKA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!a)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007)\u000bi\fC\u0003:5\u0001\u00071(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0017\u0011\u001a\t\u0005c\u0005\u00157(C\u0002\u0002HJ\u0012aa\u00149uS>t\u0007\u0002CAf7\u0005\u0005\t\u0019\u0001&\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAi!\u0011\t9&a5\n\t\u0005U\u0017\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class CreateMap
extends Expression
implements scala.Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private MapType dataType;
    private ArrayBasedMapBuilder mapBuilder;
    private final Seq<Expression> children;
    private volatile byte bitmap$0;

    public static Option<Seq<Expression>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<CreateMap, A> function1) {
        return CreateMap$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, CreateMap> compose(Function1<A, Seq<Expression>> function1) {
        return CreateMap$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 % 2 == 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 % 2 != 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.foldable()));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : TypeUtils$.MODULE$.checkForMapKeyType(this.dataType().keyType())));
    }

    private MapType dataType$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataType = new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), this.values().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.nullable())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataType;
    }

    @Override
    public MapType dataType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object eval(InternalRow input) {
        for (int i = 0; i < this.keys().length(); ++i) {
            this.mapBuilder().put(((Expression)this.keys().apply(i)).eval(input), ((Expression)this.values().apply(i)).eval(input));
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        MapType mapType = this.dataType();
        if (mapType == null) {
            throw new MatchError((Object)mapType);
        }
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        Tuple3<String, String, String> tuple3 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<Expression>)this.keys(), "createMap");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String allocationKeyData = (String)tuple3._1();
        String assignKeys = (String)tuple3._2();
        String keyArrayData = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)allocationKeyData, (Object)assignKeys, (Object)keyArrayData);
        Tuple3 tuple33 = tuple32;
        String allocationKeyData2 = (String)tuple33._1();
        String assignKeys2 = (String)tuple33._2();
        String keyArrayData2 = (String)tuple33._3();
        Tuple3<String, String, String> tuple34 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<Expression>)this.values(), "createMap");
        if (tuple34 == null) {
            throw new MatchError(tuple34);
        }
        String allocationValueData = (String)tuple34._1();
        String assignValues = (String)tuple34._2();
        String valueArrayData = (String)tuple34._3();
        Tuple3 tuple35 = new Tuple3((Object)allocationValueData, (Object)assignValues, (Object)valueArrayData);
        Tuple3 tuple36 = tuple35;
        String allocationValueData2 = (String)tuple36._1();
        String assignValues2 = (String)tuple36._2();
        String valueArrayData2 = (String)tuple36._3();
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = ", ".from(", ", ", ");\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allocationKeyData2, assignKeys2, allocationValueData2, assignValues2, ev.value(), builderTerm, keyArrayData2, valueArrayData2}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    public CreateMap copy(Seq<Expression> children2) {
        return new CreateMap(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2) {
        this.children = children2;
    }
}

