/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.CsvToStructs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(csvStr, schema[, options]) - Returns a struct value with the given `csvStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('1, 0.8', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('26/08/2015', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00.0}\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0017/\u0001nB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tI\u0002\u0011\t\u0012)A\u0005=\"AQ\r\u0001BK\u0002\u0013\u0005a\r\u0003\u0005v\u0001\tE\t\u0015!\u0003h\u0011!1\bA!f\u0001\n\u00039\b\u0002C>\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u0011q\u0004!Q3A\u0005\u0002uD\u0011\"a\u0001\u0001\u0005#\u0005\u000b\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u00111\u0003\u0001\u0005B\u0005U\u0001\u0002CA\u000f\u0001\t\u0007I\u0011A/\t\u000f\u0005}\u0001\u0001)A\u0005=\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0003\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u000b\u0001A\u0011AA\u0018\u0011)\t9\u0004\u0001EC\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003C\u0002!\u0019!C\u0001\u0003GBq!!\u001a\u0001A\u0003%!\u000f\u0003\u0006\u0002h\u0001A)\u0019!C\u0001\u0003SBq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAT\u0001\u0011\u0005\u00131\r\u0005\n\u0003S\u0003\u0011\u0011!C\u0001\u0003WC\u0011\"!.\u0001#\u0003%\t!a.\t\u0013\u00055\u0007!%A\u0005\u0002\u0005=\u0007\"CAj\u0001E\u0005I\u0011AAk\u0011%\tI\u000eAI\u0001\n\u0003\tY\u000eC\u0005\u0002`\u0002\t\t\u0011\"\u0011\u0002b\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003w\u0004\u0011\u0011!C\u0001\u0003{D\u0011Ba\u0001\u0001\u0003\u0003%\tE!\u0002\t\u0013\tE\u0001!!A\u0005\u0002\tM\u0001\"\u0003B\f\u0001\u0005\u0005I\u0011\tB\r\u000f%\u00119DLA\u0001\u0012\u0003\u0011ID\u0002\u0005.]\u0005\u0005\t\u0012\u0001B\u001e\u0011\u001d\t)!\nC\u0001\u0005\u0013B\u0011Ba\u0013&\u0003\u0003%)E!\u0014\t\u0013\t=S%!A\u0005\u0002\nE\u0003\"\u0003B.KE\u0005I\u0011AAn\u0011%\u0011i&JA\u0001\n\u0003\u0013y\u0006C\u0005\u0003n\u0015\n\n\u0011\"\u0001\u0002\\\"I!qN\u0013\u0002\u0002\u0013%!\u0011\u000f\u0002\r\u0007N4Hk\\*ueV\u001cGo\u001d\u0006\u0003_A\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011GM\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0007N\u0001\u0004gFd'BA\u001b7\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\u0004\u0001MA\u0001\u0001\u0010!D\u00132\u001b\u0016\f\u0005\u0002>}5\ta&\u0003\u0002@]\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002>\u0003&\u0011!I\f\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0018\u0002\u000f\r|G-Z4f]&\u0011\u0001*\u0012\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011QHS\u0005\u0003\u0017:\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\ti\u0005K\u0004\u0002>\u001d&\u0011qJL\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&K\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005=s\u0003C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&a\u0002)s_\u0012,8\r\u001e\t\u0003)jK!aW+\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rM\u001c\u0007.Z7b+\u0005q\u0006CA0c\u001b\u0005\u0001'BA13\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\u0006TiJ,8\r\u001e+za\u0016\fqa]2iK6\f\u0007%A\u0004paRLwN\\:\u0016\u0003\u001d\u0004B\u0001[8se:\u0011\u0011.\u001c\t\u0003UVk\u0011a\u001b\u0006\u0003Yj\na\u0001\u0010:p_Rt\u0014B\u00018V\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0004\u001b\u0006\u0004(B\u00018V!\tA7/\u0003\u0002uc\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0006G\"LG\u000eZ\u000b\u0002qB\u0011Q(_\u0005\u0003u:\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005QA/[7f5>tW-\u00133\u0016\u0003y\u00042\u0001V@s\u0013\r\t\t!\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005%\u00111BA\u0007\u0003\u001f\t\t\u0002\u0005\u0002>\u0001!)A,\u0003a\u0001=\")Q-\u0003a\u0001O\")a/\u0003a\u0001q\"9A0\u0003I\u0001\u0002\u0004q\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005]\u0001c\u0001+\u0002\u001a%\u0019\u00111D+\u0003\u000f\t{w\u000e\\3b]\u0006qa.\u001e7mC\ndWmU2iK6\f\u0017a\u00048vY2\f'\r\\3TG\",W.\u0019\u0011\u0015\u0011\u0005%\u00111EA\u0013\u0003OAQA^\u0007A\u0002aDQ\u0001X\u0007A\u0002aDQ!Z\u0007A\u0002\u001d$b!!\u0003\u0002,\u00055\u0002\"\u0002<\u000f\u0001\u0004A\b\"\u0002/\u000f\u0001\u0004AH\u0003CA\u0005\u0003c\t\u0019$!\u000e\t\u000bY|\u0001\u0019\u0001=\t\u000bq{\u0001\u0019\u0001=\t\u000b\u0015|\u0001\u0019\u0001=\u0002\u0013\r|gN^3si\u0016\u0014XCAA\u001e!\u001d!\u0016QHA!\u0003#J1!a\u0010V\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0002D\u0005-\u0013\u0011\u000b\b\u0005\u0003\u000b\nIED\u0002k\u0003\u000fJ\u0011AV\u0005\u0003\u001fVKA!!\u0014\u0002P\tA\u0011\n^3sCR|'O\u0003\u0002P+B!\u00111KA+\u001b\u0005\u0001\u0014bAA,a\tY\u0011J\u001c;fe:\fGNU8xQ\r\u0001\u00121\f\t\u0004)\u0006u\u0013bAA0+\nIAO]1og&,g\u000e^\u0001\u0014]\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ\u000b\u0002e\u0006!b.Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sI\u0002\na\u0001]1sg\u0016\u0014XCAA6!\u0015\ti'a\u001ds\u001b\t\tyGC\u0002\u0002rA\nA!\u001e;jY&!\u0011QOA8\u0005E1\u0015-\u001b7ve\u0016\u001c\u0016MZ3QCJ\u001cXM\u001d\u0015\u0004'\u0005m\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005u\u0004cA0\u0002\u0000%\u0019\u0011\u0011\u00111\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAb^5uQRKW.\u001a.p]\u0016$2\u0001QAD\u0011\u0015aX\u00031\u0001s\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\ti)a%\u0011\u0007Q\u000by)C\u0002\u0002\u0012V\u00131!\u00118z\u0011\u001d\t)J\u0006a\u0001\u0003\u001b\u000bQ!\u001b8qkR\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tY\n\u0005\u0004\u0002D\u0005u\u0015\u0011U\u0005\u0005\u0003?\u000byEA\u0002TKF\u00042aXAR\u0013\r\t)\u000b\u0019\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005%\u0011QVAX\u0003c\u000b\u0019\fC\u0004]3A\u0005\t\u0019\u00010\t\u000f\u0015L\u0002\u0013!a\u0001O\"9a/\u0007I\u0001\u0002\u0004A\bb\u0002?\u001a!\u0003\u0005\rA`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tILK\u0002_\u0003w[#!!0\u0011\t\u0005}\u0016\u0011Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f,\u0016AC1o]>$\u0018\r^5p]&!\u00111ZAa\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tNK\u0002h\u0003w\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002X*\u001a\u00010a/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u001c\u0016\u0004}\u0006m\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002dB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018\u0001\u00027b]\u001eT!!!<\u0002\t)\fg/Y\u0005\u0004i\u0006\u001d\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA{!\r!\u0016q_\u0005\u0004\u0003s,&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAG\u0003\u007fD\u0011B!\u0001!\u0003\u0003\u0005\r!!>\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0001\u0005\u0004\u0003\n\t=\u0011QR\u0007\u0003\u0005\u0017Q1A!\u0004V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\u0012Y!\u0001\u0005dC:,\u0015/^1m)\u0011\t9B!\u0006\t\u0013\t\u0005!%!AA\u0002\u00055\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0018\tm\u0001\"\u0003B\u0001G\u0005\u0005\t\u0019AAGQ=\u0001!q\u0004B\u0013\u0005O\u0011YC!\f\u00032\tM\u0002cA\u001f\u0003\"%\u0019!1\u0005\u0018\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011F\u0001a?\u001a+fjQ0)GN48\u000b\u001e:-AM\u001c\u0007.Z7b72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d;sk\u000e$\bE^1mk\u0016\u0004s/\u001b;iAQDW\rI4jm\u0016t\u0007\u0005Y2tmN#(\u000f\u0019\u0011b]\u0012\u0004\u0003m]2iK6\f\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qF\u0001\u0002@*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u0017!a9Bt\u0005\f\u0011(C\u0002Je\n\u0016\u0017!E\u0002\"u*\u0016\"M\u000b\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0012cEi\u0002d\u0006O?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012dg\f\u00199_I\u0002\u0014'N\u0014-A\u001d\"\u0018.\\3!)&lWm\u001d;b[B<C\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$\u0007M\u00196[ABTF\r\u001c!aAR\u0004\u0007\r\u001e1a9\u0002TP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011)$A\u00034]Ar\u0003'\u0001\u0007DgZ$vn\u0015;sk\u000e$8\u000f\u0005\u0002>KM!QE!\u0010Z!)\u0011yD!\u0012_Obt\u0018\u0011B\u0007\u0003\u0005\u0003R1Aa\u0011V\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0012\u0003B\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\te\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0018!B1qa2LHCCA\u0005\u0005'\u0012)Fa\u0016\u0003Z!)A\f\u000ba\u0001=\")Q\r\u000ba\u0001O\")a\u000f\u000ba\u0001q\"9A\u0010\u000bI\u0001\u0002\u0004q\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\rB5!\u0011!vPa\u0019\u0011\u000fQ\u0013)GX4y}&\u0019!qM+\u0003\rQ+\b\u000f\\35\u0011%\u0011YGKA\u0001\u0002\u0004\tI!A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u001d\u0011\t\u0005\u0015(QO\u0005\u0005\u0005o\n9O\u0001\u0004PE*,7\r\u001e")
public class CsvToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, InternalRow> converter;
    private transient FailureSafeParser<String> parser;
    private final StructType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final StructType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private transient TimeZone timeZone;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<StructType, Map<String, String>, Expression, Option<String>>> unapply(CsvToStructs csvToStructs) {
        return CsvToStructs$.MODULE$.unapply(csvToStructs);
    }

    public static Option<String> apply$default$4() {
        return CsvToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<StructType, Map<String, String>, Expression, Option<String>>, CsvToStructs> tupled() {
        return CsvToStructs$.MODULE$.tupled();
    }

    public static Function1<StructType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, CsvToStructs>>>> curried() {
        return CsvToStructs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    private ZoneId zoneId$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return this.child().nullable();
    }

    public StructType nullableSchema() {
        return this.nullableSchema;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.converter = (Function1 & Serializable & scala.Serializable)rows -> {
                    void var1_1;
                    if (!rows.hasNext()) {
                        throw new IllegalArgumentException("Expected one row from CSV parser.");
                    }
                    InternalRow result = (InternalRow)rows.next();
                    Predef$.MODULE$.assert(!rows.hasNext());
                    return var1_1;
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, InternalRow> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<String> parser$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ParseMode mode;
                CSVOptions parsedOptions = new CSVOptions(this.options(), true, (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw new AnalysisException(new StringBuilder(65).append("from_csv() doesn't support the ").append(mode.name()).append(" mode. ").append("Acceptable modes are ").append(PermissiveMode$.MODULE$.name()).append(" and ").append(FailFastMode$.MODULE$.name()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
                ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                StructType actualSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)this.nullableSchema().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CsvToStructs.$anonfun$parser$1(parsedOptions, x$1)))));
                UnivocityParser rawParser = new UnivocityParser(actualSchema, actualSchema, parsedOptions);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{rawParser.parse((String)input)})), mode, this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object input) {
        String csv = ((UTF8String)input).toString();
        return this.converter().apply(this.parser().parse(csv));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String prettyName() {
        return "from_csv";
    }

    public CsvToStructs copy(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new CsvToStructs(schema, options, child, timeZoneId);
    }

    public StructType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "CsvToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvToStructs csvToStructs = (CsvToStructs)x$1;
        StructType structType = this.schema();
        StructType structType2 = csvToStructs.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!((Object)structType).equals(structType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = csvToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = csvToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = csvToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!csvToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(CSVOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public CsvToStructs(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public CsvToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public CsvToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public CsvToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

