/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0012%\u0001FB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u0003q\u0005\u0002C/\u0001\u0005#\u0005\u000b\u0011B(\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000b\u001d\u0004A\u0011\t5\t\u000b=\u0004A\u0011\t9\t\u000bu\u0004A\u0011\t@\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u001c\u0001!\t&!\b\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u00111\n\u0001\u0005B\u00055\u0003\"CA(\u0001\u0005\u0005I\u0011AA)\u0011%\tI\u0006AI\u0001\n\u0003\tY\u0006C\u0005\u0002r\u0001\t\n\u0011\"\u0001\u0002\\!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003wB\u0011\"a#\u0001\u0003\u0003%\t!!$\t\u0013\u0005U\u0005!!A\u0005\u0002\u0005]\u0005\"CAO\u0001\u0005\u0005I\u0011IAP\u0011%\ti\u000bAA\u0001\n\u0003\ty\u000bC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\u001eI\u0011\u0011\u001c\u0013\u0002\u0002#\u0005\u00111\u001c\u0004\tG\u0011\n\t\u0011#\u0001\u0002^\"1al\u0007C\u0001\u0003WD\u0011\"!<\u001c\u0003\u0003%)%a<\t\u0013\u0005E8$!A\u0005\u0002\u0006M\b\"CA~7E\u0005I\u0011AA;\u0011%\tipGA\u0001\n\u0003\u000by\u0010C\u0005\u0003\u000em\t\n\u0011\"\u0001\u0002v!I!qB\u000e\u0002\u0002\u0013%!\u0011\u0003\u0002\u0010\t\u0006$XMR8s[\u0006$8\t\\1tg*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001eYJDH\u0011\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M:\u0014B\u0001\u001d%\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u00024u%\u00111\b\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t9\u0001K]8ek\u000e$\bCA\u001fD\u0013\t!eH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A$\u0011\u0005MB\u0015BA%%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001P!\ri\u0004KU\u0005\u0003#z\u0012aa\u00149uS>t\u0007CA*[\u001d\t!\u0006\f\u0005\u0002V}5\taK\u0003\u0002Xa\u00051AH]8pizJ!!\u0017 \u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033z\n1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"B\u0001Y1cGB\u00111\u0007\u0001\u0005\u0006\u000b\u001e\u0001\ra\u0012\u0005\u0006\u0017\u001e\u0001\ra\u0012\u0005\b\u001b\u001e\u0001\n\u00111\u0001P)\r\u0001WM\u001a\u0005\u0006\u000b\"\u0001\ra\u0012\u0005\u0006\u0017\"\u0001\raR\u0001\tI\u0006$\u0018\rV=qKV\t\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002mQ\u0005)A/\u001f9fg&\u0011an\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003E\u00042A]<{\u001d\t\u0019XO\u0004\u0002Vi&\tq(\u0003\u0002w}\u00059\u0001/Y2lC\u001e,\u0017B\u0001=z\u0005\r\u0019V-\u001d\u0006\u0003mz\u0002\"A[>\n\u0005q\\'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t1t\u0010C\u0003N\u0017\u0001\u0007!+A\u0005g_Jl\u0017\r\u001e;feV\u0011\u0011Q\u0001\t\u0005{A\u000b9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAJ\u0001\u0005kRLG.\u0003\u0003\u0002\u0012\u0005-!A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJD3\u0001DA\u000b!\ri\u0014qC\u0005\u0004\u00033q$!\u0003;sC:\u001c\u0018.\u001a8u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\ty\"!\n\u0002*A\u0019Q(!\t\n\u0007\u0005\rbHA\u0002B]fDq!a\n\u000e\u0001\u0004\ty\"A\u0005uS6,7\u000f^1na\"9\u00111F\u0007A\u0002\u0005}\u0011A\u00024pe6\fG/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011GA\u001f\u0003\u000f\u0002B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o!\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003w\t)D\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\n1a\u0019;y!\u0011\t\u0019$a\u0011\n\t\u0005\u0015\u0013Q\u0007\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIE\u0004a\u0001\u0003c\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001S\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0001\f\u0019&!\u0016\u0002X!9Q\t\u0005I\u0001\u0002\u00049\u0005bB&\u0011!\u0003\u0005\ra\u0012\u0005\b\u001bB\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0018+\u0007\u001d\u000byf\u000b\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C;oG\",7m[3e\u0015\r\tYGP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA8\u0003K\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002x)\u001aq*a\u0018\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\u000bAA[1wC&\u00191,!!\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0005cA\u001f\u0002\u0012&\u0019\u00111\u0013 \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0011\u0011\u0014\u0005\n\u000373\u0012\u0011!a\u0001\u0003\u001f\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAQ!\u0019\t\u0019+!+\u0002 5\u0011\u0011Q\u0015\u0006\u0004\u0003Os\u0014AC2pY2,7\r^5p]&!\u00111VAS\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0016q\u0017\t\u0004{\u0005M\u0016bAA[}\t9!i\\8mK\u0006t\u0007\"CAN1\u0005\u0005\t\u0019AA\u0010\u0003\u0019)\u0017/^1mgR!\u0011\u0011WA_\u0011%\tY*GA\u0001\u0002\u0004\ty\u0002K\b\u0001\u0003\u0003\f9-!3\u0002N\u0006=\u00171[Ak!\r\u0019\u00141Y\u0005\u0004\u0003\u000b$#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0017\fAo\u0018$V\u001d\u000e{\u0006\u0006^5nKN$\u0018-\u001c9-A\u0019lG/\u000b\u0011.A\r{gN^3siN\u0004\u0003\r^5nKN$\u0018-\u001c9aAQ|\u0007%\u0019\u0011wC2,X\rI8gAM$(/\u001b8hA%t\u0007\u0005\u001e5fA\u0019|'/\\1uAM\u0004XmY5gS\u0016$\u0007EY=!i\",\u0007\u0005Z1uK\u00022wN]7bi\u0002\u0002g-\u001c;a]\u0005AQ\r_1na2,7/\t\u0002\u0002R\u00069%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002X\u0006)\u0011GL\u001b/a\u0005yA)\u0019;f\r>\u0014X.\u0019;DY\u0006\u001c8\u000f\u0005\u000247M!1$a8C!!\t\t/a:H\u000f>\u0003WBAAr\u0015\r\t)OP\u0001\beVtG/[7f\u0013\u0011\tI/a9\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002\\\u0006AAo\\*ue&tw\r\u0006\u0002\u0002~\u0005)\u0011\r\u001d9msR9\u0001-!>\u0002x\u0006e\b\"B#\u001f\u0001\u00049\u0005\"B&\u001f\u0001\u00049\u0005bB'\u001f!\u0003\u0005\raT\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\u0001\u0005\u0013\u0001B!\u0010)\u0003\u0004A1QH!\u0002H\u000f>K1Aa\u0002?\u0005\u0019!V\u000f\u001d7fg!A!1\u0002\u0011\u0002\u0002\u0003\u0007\u0001-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0005\u0011\t\u0005}$QC\u0005\u0005\u0005/\t\tI\u0001\u0004PE*,7\r\u001e")
public class DateFormatClass
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private transient Option<TimestampFormatter> formatter;
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    private Option<TimestampFormatter> formatter$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.right().foldable() ? Option$.MODULE$.apply(this.right().eval(this.right().eval$default$1())).map((Function1 & Serializable & scala.Serializable)format -> TimestampFormatter$.MODULE$.apply(format.toString(), this.zoneId())) : None$.MODULE$;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    private Option<TimestampFormatter> formatter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter tf = this.formatter().isEmpty() ? TimestampFormatter$.MODULE$.apply(format.toString(), this.zoneId()) : (TimestampFormatter)this.formatter().get();
        return UTF8String.fromString((String)tf.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatter().map((Function1 & Serializable & scala.Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, x$1) -> new StringBuilder(32).append("UTF8String.fromString(").append(timestampFormatter).append(".format(").append((String)timestamp).append("))").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(73).append("UTF8String.fromString(").append(tf).append("$.MODULE$.apply(").append((String)format).append(".toString(), ").append(zid).append(")\n          .format(").append((String)timestamp).append("))").toString());
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.left();
                break;
            }
            case 1: {
                option = this.right();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

