/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalPart$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted.\n               Supported string values of `field` for dates and timestamps are:\n                [\"MILLENNIUM\", (\"MILLENNIA\", \"MIL\", \"MILS\"),\n                 \"CENTURY\", (\"CENTURIES\", \"C\", \"CENT\"),\n                 \"DECADE\", (\"DECADES\", \"DEC\", \"DECS\"),\n                 \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\"),\n                 \"ISOYEAR\",\n                 \"QUARTER\", (\"QTR\"),\n                 \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\"),\n                 \"WEEK\", (\"W\", \"WEEKS\"),\n                 \"DAY\", (\"D\", \"DAYS\"),\n                 \"DAYOFWEEK\",\n                 \"DOW\",\n                 \"ISODOW\",\n                 \"DOY\",\n                 \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\"),\n                 \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\"),\n                 \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\"),\n                 \"MILLISECONDS\", (\"MSEC\", \"MSECS\", \"MILLISECON\", \"MSECONDS\", \"MS\"),\n                 \"MICROSECONDS\", (\"USEC\", \"USECS\", \"USECONDS\", \"MICROSECON\", \"US\"),\n                 \"EPOCH\"]\n                Supported string values of `field` for intervals are:\n                 [\"MILLENNIUM\", (\"MILLENNIA\", \"MIL\", \"MILS\"),\n                   \"CENTURY\", (\"CENTURIES\", \"C\", \"CENT\"),\n                   \"DECADE\", (\"DECADES\", \"DEC\", \"DECS\"),\n                   \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\"),\n                   \"QUARTER\", (\"QTR\"),\n                   \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\"),\n                   \"DAY\", (\"D\", \"DAYS\"),\n                   \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\"),\n                   \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\"),\n                   \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\"),\n                   \"MILLISECONDS\", (\"MSEC\", \"MSECS\", \"MILLISECON\", \"MSECONDS\", \"MS\"),\n                   \"MICROSECONDS\", (\"USEC\", \"USECS\", \"USECONDS\", \"MICROSECON\", \"US\"),\n                   \"EPOCH\"]\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 1 year 10 months 5 days);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005=v!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002,\u0002\u0003\u0003%\ti\u0016\u0005\n\u0003#\u000b\u0011\u0011!CA\u0003'C\u0011\"!*\u0002\u0003\u0003%I!a*\u0007\t5r\u0002)\u0017\u0005\tG\u001e\u0011)\u001a!C\u0001I\"AQm\u0002B\tB\u0003%A\b\u0003\u0005N\u000f\tU\r\u0011\"\u0001e\u0011!1wA!E!\u0002\u0013a\u0004\u0002C4\b\u0005+\u0007I\u0011\u00013\t\u0011!<!\u0011#Q\u0001\nqBQ\u0001O\u0004\u0005\u0002%DQ\u0001O\u0004\u0005\u00025DQ\u0001]\u0004\u0005BEDQaI\u0004\u0005ByDQa`\u0004\u0005ByD\u0011\"!\u0001\b\u0003\u0003%\t!a\u0001\t\u0013\u0005-q!%A\u0005\u0002\u00055\u0001\"CA\u0012\u000fE\u0005I\u0011AA\u0007\u0011%\t)cBI\u0001\n\u0003\ti\u0001C\u0005\u0002(\u001d\t\t\u0011\"\u0011\u0002*!I\u0011\u0011H\u0004\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007:\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0013\b\u0003\u0003%\t%!\u0014\t\u0013\u0005es!!A\u0005\u0002\u0005m\u0003\"CA3\u000f\u0005\u0005I\u0011IA4\u0003!!\u0015\r^3QCJ$(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051\nQ\"\u0001\u0010\u0003\u0011\u0011\u000bG/\u001a)beR\u001c2!A\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011\u0001GN\u0005\u0003oE\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u0016\u0002#A\f'o]3FqR\u0014\u0018m\u0019;GS\u0016dG\r\u0006\u0003=\u007f1s\u0005C\u0001\u0017>\u0013\tqdD\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001Q\u0002A\u0002\u0005\u000bA\"\u001a=ue\u0006\u001cGOR5fY\u0012\u0004\"AQ%\u000f\u0005\r;\u0005C\u0001#2\u001b\u0005)%B\u0001$+\u0003\u0019a$o\\8u}%\u0011\u0001*M\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002Ic!)Qj\u0001a\u0001y\u000511o\\;sG\u0016DaaT\u0002\u0005\u0002\u0004\u0001\u0016aD3se>\u0014\b*\u00198eY\u00164UO\\2\u0011\u0007A\n6+\u0003\u0002Sc\tAAHY=oC6,g\b\u0005\u00021)&\u0011Q+\r\u0002\b\u001d>$\b.\u001b8h\u0003\u0015\t\u0007\u000f\u001d7z)\u001dA\u00161RAG\u0003\u001f\u0003\"\u0001L\u0004\u0014\u000b\u001dQV\fY\u001b\u0011\u00051Z\u0016B\u0001/\u001f\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u0017_\u0013\tyfD\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007C\u0001\u0019b\u0013\t\u0011\u0017GA\u0004Qe>$Wo\u0019;\u0002\u000b\u0019LW\r\u001c3\u0016\u0003q\naAZ5fY\u0012\u0004\u0013aB:pkJ\u001cW\rI\u0001\u0006G\"LG\u000eZ\u0001\u0007G\"LG\u000e\u001a\u0011\u0015\taS7\u000e\u001c\u0005\u0006G:\u0001\r\u0001\u0010\u0005\u0006\u001b:\u0001\r\u0001\u0010\u0005\u0006O:\u0001\r\u0001\u0010\u000b\u00041:|\u0007\"B2\u0010\u0001\u0004a\u0004\"B'\u0010\u0001\u0004a\u0014!\u00044mCR\f%oZ;nK:$8/F\u0001s!\r\u0019\bp\u001f\b\u0003iZt!\u0001R;\n\u0003IJ!a^\u0019\u0002\u000fA\f7m[1hK&\u0011\u0011P\u001f\u0002\t\u0013R,'/\u0019;pe*\u0011q/\r\t\u0003aqL!!`\u0019\u0003\u0007\u0005s\u00170F\u0001B\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\u0005G>\u0004\u0018\u0010F\u0004Y\u0003\u000b\t9!!\u0003\t\u000f\r\u001c\u0002\u0013!a\u0001y!9Qj\u0005I\u0001\u0002\u0004a\u0004bB4\u0014!\u0003\u0005\r\u0001P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyAK\u0002=\u0003#Y#!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\t\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011EA\f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tA\u0001\\1oO*\u0011\u0011QG\u0001\u0005U\u00064\u0018-C\u0002K\u0003_\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0010\u0011\u0007A\ny$C\u0002\u0002BE\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a_A$\u0011%\tI%GA\u0001\u0002\u0004\ti$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001f\u0002R!!\u0015\u0002Xml!!a\u0015\u000b\u0007\u0005U\u0013'\u0001\u0006d_2dWm\u0019;j_:L1!_A*\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA/\u0003G\u00022\u0001MA0\u0013\r\t\t'\r\u0002\b\u0005>|G.Z1o\u0011!\tIeGA\u0001\u0002\u0004Y\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002^\u0005%\u0004\u0002CA%9\u0005\u0005\t\u0019A>)'\u001d\ti'a\u001d\u0002v\u0005e\u00141PA@\u0003\u0003\u000b))a\"\u0011\u00071\ny'C\u0002\u0002ry\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002x\u0005\tvLR+O\u0007~Cc-[3mI2\u00023o\\;sG\u0016L\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!g>,(oY3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002~\u0005yyG\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M&,G\u000e\u001a\u0011.AM,G.Z2ug\u0002:\b.[2iAA\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011t_V\u00148-\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002*\u0007\u0010\u001e:bGR,GM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'V\u0004\bo\u001c:uK\u0012\u00043\u000f\u001e:j]\u001e\u0004c/\u00197vKN\u0004sN\u001a\u0011aM&,G\u000e\u001a1!M>\u0014\b\u0005Z1uKN\u0004\u0013M\u001c3!i&lWm\u001d;b[B\u001c\b%\u0019:fu)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u0017\u0012N\u00132cUI\u0014(J+6\u0013C\u0006\t\u0015#\u001b&cE*\u0012(O\u0013\u0006\u0013C\u0006\t\u0012N\u00132\u0013C\u0006\t\u0012N\u00132\u001b&%\u000b\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#eQ#O)V\u0013\u0016L\t\u0017!Q\t\u001aUI\u0014+V%&+5K\t\u0017!E\r\u0013C\u0006\t\u0012D\u000b:#&%\u000b\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#\u0005R#D\u0003\u0012+%\u0005\f\u0011)E\u0011+5)\u0011#F'\nb\u0003E\t#F\u0007\nb\u0003E\t#F\u0007N\u0013\u0013\u0006\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012\u0013,R!SE1\u0002\u0003FI-#Y\u0001\u0012\u0013,R!S'\nb\u0003EI-SE1\u0002#%\u0017*TE%b#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E%\u001bv*W#B%\nb#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!EE+\u0016I\u0015+F%\nb\u0003\u0005\u000b\u0012R)J\u0013\u0013\u0006\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012Sj\u0014(U\u0011\nb\u0003\u0005\u000b\u0012N\u001f:\u0013C\u0006\t\u0012N\u001f:\u001b&\u0005\f\u0011#\u001b>sE\u000bS*#S1R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#/\u0016+5J\t\u0017!Q\t:&\u0005\f\u0011#/\u0016+5j\u0015\u0012*Y)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012E\u0003f\u0013C\u0006\t\u0015#\t\nb\u0003E\t#B3N\u0013\u0013\u0006\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012C)Q-P\r^+Ui\u0013\u0012-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\t#P/\nb#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E%\u001bv\nR(XE1R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#\t>K&\u0005\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012\u0003jT+SE1\u0002\u0003F\t%#Y\u0001\u0012\u0003jT+S'\nb\u0003E\t%SE1\u0002#\u0005\u0013*TE%b#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E5Ke*\u0016+FE1\u0002\u0003FI'#Y\u0001\u0012S*\u0013(#Y\u0001\u0012S*\u0013(TE1\u0002#%T%O+R+5KI\u0015-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EI*F\u0007>sEI\t\u0017!Q\t\u001a&\u0005\f\u0011#'\u0016\u001b%\u0005\f\u0011#'\u0016\u001buJ\u0014#TE1\u0002#eU#D'\nJCF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\tj\u0015\n\u0014'J'\u0016\u001buJ\u0014#TE1\u0002\u0003FI'T\u000b\u000e\u0013C\u0006\t\u0012N'\u0016\u001b5K\t\u0017!E5KE\nT%T\u000b\u000e{eJ\t\u0017!E5\u001bViQ(O\tN\u0013C\u0006\t\u0012N'\nJCF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\tj\u0015j\u0011*P'\u0016\u001buJ\u0014#TE1\u0002\u0003FI+T\u000b\u000e\u0013C\u0006\t\u0012V'\u0016\u001b5K\t\u0017!EU\u001bViQ(O\tN\u0013C\u0006\t\u0012N\u0013\u000e\u0013vjU#D\u001f:\u0013C\u0006\t\u0012V'\nJCF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t*\u0005kT\"IEuS\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I*vaB|'\u000f^3eAM$(/\u001b8hAY\fG.^3tA=4\u0007\u0005\u00194jK2$\u0007\r\t4pe\u0002Jg\u000e^3sm\u0006d7\u000fI1sKjR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011\\E5KE\nT#O\u001d&+VJ\t\u0017!Q\tj\u0015\n\u0014'F\u001d:K\u0015I\t\u0017!E5KEJ\t\u0017!E5KEj\u0015\u0012*Y)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E\r+e\nV+S3\nb\u0003\u0005\u000b\u0012D\u000b:#VKU%F'\nb\u0003EI\"#Y\u0001\u00123)\u0012(UE%b#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012C)R\"B\t\u0016\u0013C\u0006\t\u0015#\t\u0016\u001b\u0015\tR#TE1\u0002#\u0005R#DE1\u0002#\u0005R#D'\nJCF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#%W#B%\nb\u0003\u0005\u000b\u0012ZE1\u0002#%W#B%N\u0013C\u0006\t\u0012Z%\nb\u0003EI-S'\nJCF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#%U+B%R+%K\t\u0017!Q\t\nFK\u0015\u0012*Y)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E5{e\n\u0016%#Y\u0001B#%T(OE1\u0002#%T(O'\nb\u0003EI'P\u001dRC5KI\u0015-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#\t\u0006K&\u0005\f\u0011)E\u0011\u0013C\u0006\t\u0012E\u0003f\u001b&%\u000b\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012I\u001fV\u0013&\u0005\f\u0011)E!\u0013C\u0006\t\u0012I\u001fV\u00136K\t\u0017!E!\u0013&\u0005\f\u0011#\u0011J\u001b&%\u000b\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012N\u0013:+F+\u0012\u0012-A!\u0012SJ\t\u0017!E5KeJ\t\u0017!E5Kej\u0015\u0012-A\tj\u0015JT+U\u000bN\u0013\u0013\u0006\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EI*F\u0007>sEI\t\u0017!Q\t\u001a&\u0005\f\u0011#'\u0016\u001b%\u0005\f\u0011#'\u0016\u001buJ\u0014#TE1\u0002#eU#D'\nJCF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#%T%M\u0019&\u001bViQ(O\tN\u0013C\u0006\t\u0015#\u001bN+5I\t\u0017!E5\u001bViQ*#Y\u0001\u0012S*\u0013'M\u0013N+5i\u0014(#Y\u0001\u0012SjU#D\u001f:#5K\t\u0017!E5\u001b&%\u000b\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012N\u0013\u000e\u0013vjU#D\u001f:#5K\t\u0017!Q\t*6+R\"#Y\u0001\u0012SkU#D'\nb\u0003EI+T\u000b\u000e{e\nR*#Y\u0001\u0012S*S\"S\u001fN+5i\u0014(#Y\u0001\u0012Sk\u0015\u0012*Y)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E\u0015\u0003vj\u0011%#;*\u0001\u0003\u0005\t\u0011!A)\u00023o\\;sG\u0016\u0004S\u0006I1!I\u0006$Xm\f;j[\u0016\u001cH/Y7qA=\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0011d_2,XN\u001c\u0011ge>l\u0007e\u001e5fe\u0016\u0004\u0003MZ5fY\u0012\u0004\u0007e\u001d5pk2$\u0007EY3!Kb$(/Y2uK\u0012T\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111Q\u0001\u0005\u0002)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%W#B%\u001eb\u0003\u0005V%N\u000bN#\u0016)\u0014)!OI\u0002\u0014'O\u00171q5\n$\u0007\t\u00192uA\u0002$\b\r\u0019/cI\u001aD'\u000e\u001c(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u0019:\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":s/Z3lO1\u0002C/[7fgR\fW\u000e]\u00143aEJT\u0006\r\u001d.cI\u0002\u0003'\r\u001e1ai\u0002\u0004GL\u00193gQ*dgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014e_f<C\u0006\t#B)\u0016;#\u0007M\u0019:[ABT&\r\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\r\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001aViQ(O\tN;C\u0006\t;j[\u0016\u001cH/Y7qOI\u0002\u0014'O\u00172a5\u0002\u0014\u0007\t\u00191uA\u0002$\bM\u0019/aA\u0002\u0004\u0007M\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\f\u00191aA\u0002\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(I\u0006L8o\n\u0017!S:$XM\u001d<bY\u0002\n\u0004%_3be\u0002\n\u0004\u0007I7p]RD7\u000fI\u001b!I\u0006L8/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse]3d_:$7o\n\u0017!S:$XM\u001d<bY\u0002*\u0004\u0005[8veN\u00043\u0007\r\u0011tK\u000e|g\u000eZ:!c\u0001j\u0017\u000e\u001c7jg\u0016\u001cwN\u001c3tAE\u0002S.[2s_N,7m\u001c8eg&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0019/aA\n\u0004\u0007M\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!#\u0002\u000bMr\u0003G\f\u0019\t\u000b\r$\u0001\u0019\u0001\u001f\t\u000b5#\u0001\u0019\u0001\u001f\t\u000b\u001d$\u0001\u0019\u0001\u001f\u0002\u000fUt\u0017\r\u001d9msR!\u0011QSAQ!\u0015\u0001\u0014qSAN\u0013\r\tI*\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rA\ni\n\u0010\u001f=\u0013\r\ty*\r\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005\rV!!AA\u0002a\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005%\u0006\u0003BA\u0017\u0003WKA!!,\u00020\t1qJ\u00196fGR\u0004")
public class DatePart
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(DatePart datePart) {
        return DatePart$.MODULE$.unapply(datePart);
    }

    public static Expression parseExtractField(String string, Expression expression, Function0<Nothing$> function0) {
        return DatePart$.MODULE$.parseExtractField(string, expression, function0);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        DatePart datePart = this;
        synchronized (datePart) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.field().sql()).append(", ").append(this.source().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "date_part";
    }

    public DatePart copy(Expression field, Expression source, Expression child) {
        return new DatePart(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "DatePart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatePart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DatePart)) return false;
        boolean bl = true;
        if (!bl) return false;
        DatePart datePart = (DatePart)x$1;
        Expression expression = this.field();
        Expression expression2 = datePart.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = datePart.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = datePart.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!datePart.canEqual(this)) return false;
        return true;
    }

    public DatePart(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public DatePart(Expression field, Expression source) {
        Expression expression;
        if (!field.foldable()) {
            throw new AnalysisException("The field parameter needs to be a foldable string value.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Object fieldEval = field.eval(field.eval$default$1());
        if (fieldEval == null) {
            expression = new Literal(null, DoubleType$.MODULE$);
        } else {
            String fieldStr = ((UTF8String)fieldEval).toString();
            String errMsg = new StringBuilder(62).append("Literals of type '").append(fieldStr).append("' are currently not supported ").append("for the ").append(source.dataType().catalogString()).append(" type.").toString();
            DataType dataType = source.dataType();
            CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
            expression = !(dataType != null ? !dataType.equals(calendarIntervalType$) : calendarIntervalType$ != null) ? ExtractIntervalPart$.MODULE$.parseExtractField(fieldStr, source, (Function0<Nothing$>)new Serializable(errMsg){
                public static final long serialVersionUID = 0L;
                private final String errMsg$1;

                public final Nothing$ apply() {
                    throw new AnalysisException(this.errMsg$1, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                {
                    this.errMsg$1 = errMsg$1;
                }
            }) : DatePart$.MODULE$.parseExtractField(fieldStr, source, (Function0<Nothing$>)new Serializable(errMsg){
                public static final long serialVersionUID = 0L;
                private final String errMsg$1;

                public final Nothing$ apply() {
                    throw new AnalysisException(this.errMsg$1, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                {
                    this.errMsg$1 = errMsg$1;
                }
            });
        }
        this(field, source, expression);
    }
}

