/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatString$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(strfmt, obj, ...) - Returns a formatted string from printf-style format strings.", examples="\n    Examples:\n      > SELECT _FUNC_(\"Hello World %d %s\", 100, \"days\");\n       Hello World 100 days\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!)Q\b\u0001C\u0001}!)\u0011\t\u0001C!\u0005\")a\t\u0001C!\u0005\")q\t\u0001C!\u0011\")q\n\u0001C!!\")\u0001\r\u0001C!C\")1\u000e\u0001C!Y\")!\u0010\u0001C!w\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00131\u0002\u0005\n\u00037\u0001\u0011\u0011!C\u0001\u0003;A\u0011\"!\n\u0001\u0003\u0003%\t!a\n\t\u0013\u00055\u0002!!A\u0005B\u0005=\u0002\"CA\u001f\u0001\u0005\u0005I\u0011AA \u0011%\t\u0019\u0005AA\u0001\n\u0003\n)eB\u0005\u0002de\t\t\u0011#\u0001\u0002f\u0019A\u0001$GA\u0001\u0012\u0003\t9\u0007\u0003\u0004>%\u0011\u0005\u0011Q\u000f\u0005\n\u0003o\u0012\u0012\u0011!C#\u0003sB\u0011\"a\u001f\u0013\u0003\u0003%\t)! \t\u0013\u0005\u0005%#!A\u0005\u0002\u0006\r\u0005\"CAI%\u0005\u0005I\u0011BAJ\u000511uN]7biN#(/\u001b8h\u0015\tQ2$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011#\u0002\u0001(W9\"\u0004C\u0001\u0015*\u001b\u0005I\u0012B\u0001\u0016\u001a\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003Q1J!!L\r\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00020k%\u0011a\u0007\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\tG\"LG\u000e\u001a:f]V\t\u0011\bE\u00020u\u001dJ!a\u000f\u0019\u0003\u0015q\u0012X\r]3bi\u0016$g(A\u0005dQ&dGM]3oA\u00051A(\u001b8jiz\"\"a\u0010!\u0011\u0005!\u0002\u0001\"B\u001c\u0004\u0001\u0004I\u0014\u0001\u00034pY\u0012\f'\r\\3\u0016\u0003\r\u0003\"a\f#\n\u0005\u0015\u0003$a\u0002\"p_2,\u0017M\\\u0001\t]VdG.\u00192mK\u0006AA-\u0019;b)f\u0004X-F\u0001J!\tQU*D\u0001L\u0015\taU$A\u0003usB,7/\u0003\u0002O\u0017\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0015\t\u0004%jkfBA*Y\u001d\t!v+D\u0001V\u0015\t1V%\u0001\u0004=e>|GOP\u0005\u0002c%\u0011\u0011\fM\u0001\ba\u0006\u001c7.Y4f\u0013\tYFLA\u0002TKFT!!\u0017\u0019\u0011\u0005)s\u0016BA0L\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0003fm\u0006dGC\u00012f!\ty3-\u0003\u0002ea\t\u0019\u0011I\\=\t\u000f\u0019D\u0001\u0013!a\u0001O\u0006)\u0011N\u001c9viB\u0011\u0001.[\u0007\u00027%\u0011!n\u0007\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u0019Qn\u001d=\u0011\u00059\fX\"A8\u000b\u0005AL\u0012aB2pI\u0016<WM\\\u0005\u0003e>\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006i&\u0001\r!^\u0001\u0004GRD\bC\u00018w\u0013\t9xN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000beL\u0001\u0019A7\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\tA\u0010E\u0002~\u0003\u0007q!A`@\u0011\u0005Q\u0003\u0014bAA\u0001a\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u00011\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0011\u0001\u00026bm\u0006LA!!\u0002\u0002\u0012\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0004\t\u0004_\u0005\u0005\u0012bAA\u0012a\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!-!\u000b\t\u0013\u0005-R\"!AA\u0002\u0005}\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00022A)\u00111GA\u001dE6\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0001\u0014AC2pY2,7\r^5p]&!\u00111HA\u001b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\r\u000b\t\u0005\u0003\u0005\u0002,=\t\t\u00111\u0001c\u0003\u0019)\u0017/^1mgR\u00191)a\u0012\t\u0011\u0005-\u0002#!AA\u0002\tDs\u0002AA&\u0003#\n\u0019&a\u0016\u0002Z\u0005u\u0013q\f\t\u0004Q\u00055\u0013bAA(3\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA+\u0003]{f)\u0016(D?\"\u001aHO\u001d4ni2\u0002sN\u00196-A9rc&\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007EZ8s[\u0006$H/\u001a3!gR\u0014\u0018N\\4!MJ|W\u000e\t9sS:$h-L:us2,\u0007EZ8s[\u0006$\be\u001d;sS:<7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111L\u0001g\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0003*\u001a7m_\u0002:vN\u001d7eA\u0015\"\u0007%J:#Y\u0001\n\u0004\u0007\r\u0017!E\u0011\f\u0017p\u001d\u0012*w)\u0001\u0003\u0005\t\u0011!A\u0001BU\r\u001c7pA]{'\u000f\u001c3!cA\u0002\u0004\u0005Z1zg*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002b\u0005)\u0011GL\u001b/a\u0005aai\u001c:nCR\u001cFO]5oOB\u0011\u0001FE\n\u0005%\u0005%D\u0007\u0005\u0004\u0002l\u0005E\u0014hP\u0007\u0003\u0003[R1!a\u001c1\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001d\u0002n\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005\u0015\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0011!B1qa2LHcA \u0002\u0000!)q'\u0006a\u0001s\u0005QQO\\1qa2L8+Z9\u0015\t\u0005\u0015\u0015Q\u0012\t\u0006_\u0005\u001d\u00151R\u0005\u0004\u0003\u0013\u0003$AB(qi&|g\u000eE\u0002S5\u001eB\u0001\"a$\u0017\u0003\u0003\u0005\raP\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!&\u0011\t\u0005=\u0011qS\u0005\u0005\u00033\u000b\tB\u0001\u0004PE*,7\r\u001e")
public class FormatString
extends Expression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Seq<Expression> children;

    public static Option<Seq<Expression>> unapplySeq(FormatString formatString) {
        return FormatString$.MODULE$.unapplySeq(formatString);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<FormatString, A> function1) {
        return FormatString$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, FormatString> compose(Function1<A, Seq<Expression>> function1) {
        return FormatString$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$69 -> BoxesRunTime.boxToBoolean((boolean)x$69.foldable()));
    }

    @Override
    public boolean nullable() {
        return ((Expression)this.children().apply(0)).nullable();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return ((List)List$.MODULE$.fill(this.children().size() - 1, (Function0 & Serializable & scala.Serializable)() -> AnyDataType$.MODULE$)).$colon$colon((Object)stringType$);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object pattern = ((Expression)this.children().apply(0)).eval(input);
        if (pattern == null) {
            uTF8String = null;
        } else {
            StringBuffer sb = new StringBuffer();
            Formatter formatter = new Formatter(sb, Locale.US);
            Seq arglist = (Seq)((TraversableLike)this.children().tail()).map((Function1 & Serializable & scala.Serializable)x$71 -> x$71.eval(input), Seq$.MODULE$.canBuildFrom());
            formatter.format(((UTF8String)pattern).toString(), (Object[])arglist.toArray(ClassTag$.MODULE$.AnyRef()));
            uTF8String = UTF8String.fromString((String)sb.toString());
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode pattern = ((Expression)this.children().head()).genCode(ctx);
        Seq argListGen = (Seq)((TraversableLike)this.children().tail()).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.dataType(), (Object)x.genCode(ctx)), Seq$.MODULE$.canBuildFrom());
        String argList = ctx.freshName("argLists");
        int numArgLists = argListGen.length();
        Seq argListCode = (Seq)((TraversableLike)argListGen.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 v = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = CodeGenerator$.MODULE$.boxedType((DataType)v._1());
            String string2 = CodeGenerator$.MODULE$.javaType((DataType)v._1());
            String value = (string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(21).append("(").append(((ExprCode)v._2()).isNull()).append(") ? (").append(CodeGenerator$.MODULE$.boxedType((DataType)v._1())).append(") null : ").append("new ").append(CodeGenerator$.MODULE$.boxedType((DataType)v._1())).append("(").append(((ExprCode)v._2()).value()).append(")").toString() : new StringBuilder(12).append("(").append(((ExprCode)v._2()).isNull()).append(") ? null : ").append(((ExprCode)v._2()).value()).toString();
            String string3 = new StringBuilder(34).append("\n         ").append(((ExprCode)v._2()).code()).append("\n         ").append(argList).append("[").append(index).append("] = ").append(value).append(";\n       ").toString();
            return string3;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = new Tuple2((Object)"Object[]", (Object)argList);
        String argListCodes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)argListCode, "valueFormatString", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple2), ctx.splitExpressionsWithCurrentInputs$default$4(), ctx.splitExpressionsWithCurrentInputs$default$5(), ctx.splitExpressionsWithCurrentInputs$default$6());
        String form = ctx.freshName("formatter");
        String formatter = Formatter.class.getName();
        String sb = ctx.freshName("sb");
        String stringBuffer = StringBuffer.class.getName();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      boolean ", " = ", ";\n      ", " ", " = ", ";\n      if (!", ") {\n        ", " ", " = new ", "();\n        ", " ", " = new ", "(", ", ", ".US);\n        Object[] ", " = new Object[", "];\n        ", "\n        ", ".format(", ".toString(), ", ");\n        ", " = UTF8String.fromString(", ".toString());\n      }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern.code(), ev.isNull(), pattern.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), stringBuffer, sb, stringBuffer, formatter, form, formatter, sb, Locale.class.getName(), argList, BoxesRunTime.boxToInteger((int)numArgLists), argListCodes, form, pattern.value(), argList, ev.value(), sb})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "format_string";
    }

    @Override
    public String productPrefix() {
        return "FormatString";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatString)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatString formatString = (FormatString)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = formatString.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!formatString.canEqual(this)) return false;
        return true;
    }

    public FormatString(Seq<Expression> children2) {
        this.children = children2;
        ExpectsInputTypes.$init$(this);
        Predef$.MODULE$.require(children2.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "format_string() should take at least 1 argument");
    }
}

