/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.InterpretedHashFunction;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HiveHashFunction$
extends InterpretedHashFunction {
    public static HiveHashFunction$ MODULE$;
    private final int HIVE_DECIMAL_MAX_PRECISION;
    private final int HIVE_DECIMAL_MAX_SCALE;

    static {
        new HiveHashFunction$();
    }

    @Override
    public long hashInt(int i, long seed) {
        return HiveHasher.hashInt((int)i);
    }

    @Override
    public long hashLong(long l, long seed) {
        return HiveHasher.hashLong((long)l);
    }

    @Override
    public long hashUnsafeBytes(Object base, long offset, int len, long seed) {
        return HiveHasher.hashUnsafeBytes((Object)base, (long)offset, (int)len);
    }

    private int HIVE_DECIMAL_MAX_PRECISION() {
        return this.HIVE_DECIMAL_MAX_PRECISION;
    }

    private int HIVE_DECIMAL_MAX_SCALE() {
        return this.HIVE_DECIMAL_MAX_SCALE;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal normalizeDecimal(BigDecimal input) {
        void var2_2;
        block2: {
            if (input == null) {
                return null;
            }
            BigDecimal result = HiveHashFunction$.trimDecimal$1(input);
            int intDigits = result.precision() - result.scale();
            if (intDigits > this.HIVE_DECIMAL_MAX_PRECISION()) {
                return null;
            }
            int maxScale = Math.min(this.HIVE_DECIMAL_MAX_SCALE(), Math.min(this.HIVE_DECIMAL_MAX_PRECISION() - intDigits, result.scale()));
            if (result.scale() <= maxScale) break block2;
            result = result.setScale(maxScale, RoundingMode.HALF_UP);
            result = HiveHashFunction$.trimDecimal$1(result);
        }
        return var2_2;
    }

    public long hashTimestamp(long timestamp) {
        long timestampInSeconds = TimeUnit.MICROSECONDS.toSeconds(timestamp);
        long nanoSecondsPortion = timestamp % DateTimeUtils$.MODULE$.MICROS_PER_SECOND() * DateTimeUtils$.MODULE$.NANOS_PER_MICROS();
        long result = timestampInSeconds;
        result <<= 30;
        return (int)((result |= nanoSecondsPortion) >>> 32 ^ result);
    }

    public long hashCalendarInterval(CalendarInterval calendarInterval) {
        long totalSeconds = calendarInterval.microseconds / (long)((int)1000000L);
        int result = 629 + (int)(totalSeconds ^ totalSeconds >> 32);
        int nanoSeconds = (int)(calendarInterval.microseconds - totalSeconds * (long)((int)1000000L)) * 1000;
        return result * 37 + nanoSeconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long hash(Object value, DataType dataType, long seed) {
        Object object = value;
        if (object == null) {
            return 0L;
        }
        if (object instanceof ArrayData) {
            DataType dataType2;
            ArrayData arrayData = (ArrayData)object;
            DataType dataType3 = dataType;
            if (dataType3 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = ((ArrayType)userDefinedType.sqlType()).elementType();
            } else {
                DataType et;
                if (!(dataType3 instanceof ArrayType)) throw new MatchError((Object)dataType3);
                ArrayType arrayType = (ArrayType)dataType3;
                dataType2 = et = arrayType.elementType();
            }
            DataType elementType = dataType2;
            int result = 0;
            int i = 0;
            int length = arrayData.numElements();
            while (i < length) {
                result = 31 * result + (int)this.hash(arrayData.get(i, elementType), elementType, 0L);
                ++i;
            }
            return result;
        }
        if (object instanceof MapData) {
            Tuple2 tuple2;
            MapData mapData = (MapData)object;
            DataType dataType4 = dataType;
            if (dataType4 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType4;
                MapType mapType = (MapType)userDefinedType.sqlType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.keyType()), (Object)mapType.valueType());
            } else {
                if (!(dataType4 instanceof MapType)) throw new MatchError((Object)dataType4);
                MapType mapType = (MapType)dataType4;
                DataType _kt = mapType.keyType();
                DataType _vt = mapType.valueType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)_kt), (Object)_vt);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            DataType kt = (DataType)tuple22._1();
            DataType vt = (DataType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)kt, (Object)vt);
            Tuple2 tuple24 = tuple23;
            DataType kt2 = (DataType)tuple24._1();
            DataType vt2 = (DataType)tuple24._2();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            int result = 0;
            int i = 0;
            int length = mapData.numElements();
            while (i < length) {
                result += (int)this.hash(keys.get(i, kt2), kt2, 0L) ^ (int)this.hash(values.get(i, vt2), vt2, 0L);
                ++i;
            }
            return result;
        }
        if (object instanceof InternalRow) {
            DataType[] dataTypeArray;
            InternalRow internalRow = (InternalRow)object;
            DataType dataType5 = dataType;
            if (dataType5 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType5;
                dataTypeArray = (DataType[])((TraversableOnce)((StructType)userDefinedType.sqlType()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
            } else {
                if (!(dataType5 instanceof StructType)) throw new MatchError((Object)dataType5);
                StructType structType = (StructType)dataType5;
                StructField[] fields = structType.fields();
                dataTypeArray = (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
            }
            DataType[] types = dataTypeArray;
            int result = 0;
            int i = 0;
            int length = internalRow.numFields();
            while (i < length) {
                result = 31 * result + (int)this.hash(internalRow.get(i, types[i]), types[i], 0L);
                ++i;
            }
            return result;
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return this.normalizeDecimal(decimal.toJavaBigDecimal()).hashCode();
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            if (dataType instanceof TimestampType) {
                return this.hashTimestamp(l);
            }
        }
        if (!(object instanceof CalendarInterval)) return super.hash(value, dataType, 0L);
        CalendarInterval calendarInterval = (CalendarInterval)object;
        return this.hashCalendarInterval(calendarInterval);
    }

    /*
     * WARNING - void declaration
     */
    private static final BigDecimal trimDecimal$1(BigDecimal input) {
        void var1_1;
        block1: {
            BigDecimal result;
            block0: {
                result = input;
                if (result.compareTo(BigDecimal.ZERO) != 0) break block0;
                result = BigDecimal.ZERO;
                break block1;
            }
            if ((result = result.stripTrailingZeros()).scale() >= 0) break block1;
            result = result.setScale(0);
        }
        return var1_1;
    }

    private HiveHashFunction$() {
        MODULE$ = this;
        this.HIVE_DECIMAL_MAX_PRECISION = 38;
        this.HIVE_DECIMAL_MAX_SCALE = 38;
    }
}

