/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$DecimalAsIfIntegral$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long if spark.sql.legacy.integralDivide.returnBigint is true, otherwise the data type of the operands is returned.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015!\u0007\u0001\"\u0011Y\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015I\u0007\u0001\"\u0011Y\u0011!Q\u0007\u0001#b\u0001\n\u0013Y\u0007\"\u0002:\u0001\t\u0003\u001a\bb\u0002<\u0001\u0003\u0003%\ta\u001e\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011!\ti\u0001AI\u0001\n\u0003Y\b\"CA\b\u0001\u0005\u0005I\u0011IA\t\u0011%\t\t\u0003AA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u00111\u0007\u0001\u0002\u0002\u0013\u0005\u0013Q\u0007\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\b\u0013\u0005=t$!A\t\u0002\u0005Ed\u0001\u0003\u0010 \u0003\u0003E\t!a\u001d\t\r\u0015CB\u0011AAA\u0011%\t\u0019\tGA\u0001\n\u000b\n)\tC\u0005\u0002\bb\t\t\u0011\"!\u0002\n\"I\u0011q\u0012\r\u0002\u0002\u0013\u0005\u0015\u0011\u0013\u0005\n\u0003GC\u0012\u0011!C\u0005\u0003K\u0013a\"\u00138uK\u001e\u0014\u0018\r\u001c#jm&$WM\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0015\u0001Q&\r\u001b;!\tqs&D\u0001 \u0013\t\u0001tD\u0001\tCS:\f'/_!sSRDW.\u001a;jGB\u0011aFM\u0005\u0003g}\u0011!\u0002R5w\u001b>$G*[6f!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u001d\u0001&o\u001c3vGR\u0004\"!N\u001e\n\u0005q2$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012a\u0010\t\u0003]\u0001K!!Q\u0010\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dC\u0015\n\u0005\u0002/\u0001!)Q(\u0002a\u0001\u007f!)1)\u0002a\u0001\u007f\u0005I\u0011N\u001c9viRK\b/Z\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011qjI\u0001\u0006if\u0004Xm]\u0005\u0003#:\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0016\t\u0003\u001bVK!A\u0016(\u0003\u0011\u0011\u000bG/\u0019+za\u0016\faa]=nE>dW#A-\u0011\u0005i\u000bgBA.`!\taf'D\u0001^\u0015\tq6&\u0001\u0004=e>|GOP\u0005\u0003AZ\na\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001MN\u0001\u000eI\u0016\u001c\u0017.\\1m\u001b\u0016$\bn\u001c3\u00021\u0011,7-[7bYR{G)\u0019;b)f\u0004XmQ8eK\u001e+g\u000e\u0006\u0002ZO\")\u0001N\u0003a\u00013\u0006iA-Z2j[\u0006d'+Z:vYR\f1b]9m\u001fB,'/\u0019;pe\u0006\u0019A-\u001b<\u0016\u00031\u0004R!N7p_>L!A\u001c\u001c\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA\u001bq\u0013\t\thGA\u0002B]f\fQ\"\u001a<bY>\u0003XM]1uS>tGcA8uk\")Q(\u0004a\u0001_\")1)\u0004a\u0001_\u0006!1m\u001c9z)\r9\u00050\u001f\u0005\b{9\u0001\n\u00111\u0001@\u0011\u001d\u0019e\u0002%AA\u0002}\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001}U\tyTpK\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f1\u0014AC1o]>$\u0018\r^5p]&!\u00111BA\u0001\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006L1AYA\f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0003E\u00026\u0003OI1!!\u000b7\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ry\u0017q\u0006\u0005\n\u0003c\u0019\u0012\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001c!\u0015\tI$a\u0010p\u001b\t\tYDC\u0002\u0002>Y\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\ni\u0005E\u00026\u0003\u0013J1!a\u00137\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\r\u0016\u0003\u0003\u0005\ra\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u00131\u000b\u0005\t\u0003c1\u0012\u0011!a\u0001_\"z\u0001!a\u0016\u0002^\u0005}\u00131MA3\u0003S\nY\u0007E\u0002/\u00033J1!a\u0017 \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0019\u0002\u0003G,\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\"\u0015N^5eK\u0002\u0002W\r\u001f9sc\u0001\u0004#-\u001f\u0011aKb\u0004(O\r1/A%#\bE]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011b]\u0002z\u0007/\u001a:b]\u0012\u0004\u0013n\u001d\u0011O+2c\u0005e\u001c:!A\u0016D\bO\u001d\u001aaA%\u001c\b\u0005\r\u0018!)\",\u0007E]3tk2$\b%[:!G\u0006\u001cH/\u001a3!i>\u0004Cn\u001c8hA%4\u0007e\u001d9be.t3/\u001d7/Y\u0016<\u0017mY=/S:$Xm\u001a:bY\u0012Kg/\u001b3f]I,G/\u001e:o\u0005&<\u0017N\u001c;!SN\u0004CO];fY\u0001zG\u000f[3so&\u001cX\r\t;iK\u0002\"\u0017\r^1!if\u0004X\rI8gAQDW\rI8qKJ\fg\u000eZ:!SN\u0004#/\u001a;ve:,GML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qM\u00016\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001a\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002n\u0005)1G\f\u0019/a\u0005q\u0011J\u001c;fOJ\fG\u000eR5wS\u0012,\u0007C\u0001\u0018\u0019'\u0011A\u0012Q\u000f\u001e\u0011\u000f\u0005]\u0014QP @\u000f6\u0011\u0011\u0011\u0010\u0006\u0004\u0003w2\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u007f\nIHA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0005\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u001d\u000bY)!$\t\u000buZ\u0002\u0019A \t\u000b\r[\u0002\u0019A \u0002\u000fUt\u0017\r\u001d9msR!\u00111SAP!\u0015)\u0014QSAM\u0013\r\t9J\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\nYjP \n\u0007\u0005ueG\u0001\u0004UkBdWM\r\u0005\t\u0003Cc\u0012\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0003B!!\u0006\u0002*&!\u00111VA\f\u0005\u0019y%M[3di\u0002")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike,
scala.Serializable {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(IntegralDivide integralDivide) {
        return IntegralDivide$.MODULE$.unapply(integralDivide);
    }

    public static Function1<Tuple2<Expression, Expression>, IntegralDivide> tupled() {
        return IntegralDivide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, IntegralDivide>> curried() {
        return IntegralDivide$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, DecimalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().integralDivideReturnLong() ? LongType$.MODULE$ : this.left().dataType();
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return SQLConf$.MODULE$.get().integralDivideReturnLong() ? new StringBuilder(9).append(decimalResult).append(".toLong()").toString() : decimalResult;
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if (!this.bitmap$0) {
                Function2 & Serializable & scala.Serializable intersect;
                Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimal$DecimalAsIfIntegral$ = integralType.integral();
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    decimal$DecimalAsIfIntegral$ = decimalType.asIntegral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal$DecimalAsIfIntegral$ integral = decimal$DecimalAsIfIntegral$;
                Function2 & Serializable & scala.Serializable divide = (Function2 & Serializable & scala.Serializable)(x, y) -> integral.quot(x, y);
                if (SQLConf$.MODULE$.get().integralDivideReturnLong()) {
                    Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$2 = integral;
                    Function1 & Serializable & scala.Serializable toLong = (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)decimal$DecimalAsIfIntegral$2.toLong(x));
                    intersect = (Function2 & Serializable & scala.Serializable)(x, y) -> {
                        Object res = divide.apply(x, y);
                        return res == null ? null : toLong.apply(res);
                    };
                } else {
                    intersect = divide;
                }
                this.div = intersect;
                this.bitmap$0 = true;
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        return !this.bitmap$0 ? this.div$lzycompute() : this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    public IntegralDivide copy(Expression left, Expression right) {
        return new IntegralDivide(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        DivModLike.$init$(this);
    }
}

