/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00.0}\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u00193\u0001~B\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\tC\u0002\u0011\t\u0012)A\u00057\"A!\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005s\u0001\tE\t\u0015!\u0003e\u0011!\u0019\bA!f\u0001\n\u0003!\b\u0002\u0003=\u0001\u0005#\u0005\u000b\u0011B;\t\u0011e\u0004!Q3A\u0005\u0002iD\u0001B \u0001\u0003\u0012\u0003\u0006Ia\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0005\t\u0011\u0005e\u0001A1A\u0005\u0002iCq!a\u0007\u0001A\u0003%1\fC\u0004\u0002\u001e\u0001!\t%a\u0004\t\r}\u0004A\u0011AA\u0010\u0011\u0019y\b\u0001\"\u0001\u0002(!1q\u0010\u0001C\u0001\u0003[Aq!!\u000e\u0001\t\u0003\n9\u0004\u0003\u0006\u0002F\u0001A)\u0019!C\u0001\u0003\u000fB\u0011\"a\"\u0001\u0005\u0004%\t!!#\t\u000f\u0005-\u0005\u0001)A\u0005_\"Q\u0011Q\u0012\u0001\t\u0006\u0004%\t!a$\t\r\u00055\u0006\u0001\"\u0011[\u0011\u001d\ty\u000b\u0001C!\u0003cCq!!.\u0001\t\u0003\n9\fC\u0004\u0002D\u0002!\t%!2\t\r]\u0002A\u0011IAE\u0011\u001d\t\u0019\u000e\u0001C!\u0003\u0013C\u0011\"!6\u0001\u0003\u0003%\t!a6\t\u0013\u0005\u0005\b!%A\u0005\u0002\u0005\r\b\"CA}\u0001E\u0005I\u0011AA~\u0011%\ty\u0010AI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\u0006\u0001\t\n\u0011\"\u0001\u0003\b!I!1\u0002\u0001\u0002\u0002\u0013\u0005#Q\u0002\u0005\n\u0005'\u0001\u0011\u0011!C\u0001\u0005+A\u0011B!\b\u0001\u0003\u0003%\tAa\b\t\u0013\t\u0015\u0002!!A\u0005B\t\u001d\u0002\"\u0003B\u001a\u0001\u0005\u0005I\u0011\u0001B\u001b\u0011%\u0011I\u0004AA\u0001\n\u0003\u0012YdB\u0005\u0003ZI\n\t\u0011#\u0001\u0003\\\u0019A\u0011GMA\u0001\u0012\u0003\u0011i\u0006\u0003\u0004\u0000S\u0011\u0005!1\u000e\u0005\n\u0005[J\u0013\u0011!C#\u0005_B\u0011B!\u001d*\u0003\u0003%\tIa\u001d\t\u0013\tu\u0014&%A\u0005\u0002\t\u001d\u0001\"\u0003B@S\u0005\u0005I\u0011\u0011BA\u0011%\u0011y)KI\u0001\n\u0003\u00119\u0001C\u0005\u0003\u0012&\n\t\u0011\"\u0003\u0003\u0014\ni!j]8o)>\u001cFO];diNT!a\r\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003kY\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003oa\n1a]9m\u0015\tI$(A\u0003ta\u0006\u00148N\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<7\u0001A\n\b\u0001\u0001#u)\u0014)W!\t\t%)D\u00013\u0013\t\u0019%GA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tU)\u0003\u0002Ge\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015J\nqaY8eK\u001e,g.\u0003\u0002M\u0013\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002B\u001d&\u0011qJ\r\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&a\u0002)s_\u0012,8\r\u001e\t\u0003#^K!\u0001\u0017*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rM\u001c\u0007.Z7b+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u000107\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001WL\u0001\u0005ECR\fG+\u001f9f\u0003\u001d\u00198\r[3nC\u0002\nqa\u001c9uS>t7/F\u0001e!\u0011)Gn\\8\u000f\u0005\u0019T\u0007CA4S\u001b\u0005A'BA5?\u0003\u0019a$o\\8u}%\u00111NU\u0001\u0007!J,G-\u001a4\n\u00055t'aA'ba*\u00111N\u0015\t\u0003KBL!!\u001d8\u0003\rM#(/\u001b8h\u0003!y\u0007\u000f^5p]N\u0004\u0013!B2iS2$W#A;\u0011\u0005\u00053\u0018BA<3\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001|!\r\tFp\\\u0005\u0003{J\u0013aa\u00149uS>t\u0017a\u0003;j[\u0016TvN\\3JI\u0002\na\u0001P5oSRtDCCA\u0002\u0003\u000b\t9!!\u0003\u0002\fA\u0011\u0011\t\u0001\u0005\u00063&\u0001\ra\u0017\u0005\u0006E&\u0001\r\u0001\u001a\u0005\u0006g&\u0001\r!\u001e\u0005\bs&\u0001\n\u00111\u0001|\u0003M1wN]2f\u001dVdG.\u00192mKN\u001b\u0007.Z7b+\t\t\t\u0002E\u0002R\u0003'I1!!\u0006S\u0005\u001d\u0011un\u001c7fC:\fACZ8sG\u0016tU\u000f\u001c7bE2,7k\u00195f[\u0006\u0004\u0013A\u00048vY2\f'\r\\3TG\",W.Y\u0001\u0010]VdG.\u00192mKN\u001b\u0007.Z7bA\u0005Aa.\u001e7mC\ndW\r\u0006\u0005\u0002\u0004\u0005\u0005\u00121EA\u0013\u0011\u0015\u0019x\u00021\u0001v\u0011\u0015Iv\u00021\u0001v\u0011\u0015\u0011w\u00021\u0001e)\u0019\t\u0019!!\u000b\u0002,!)1\u000f\u0005a\u0001k\")\u0011\f\u0005a\u0001kRA\u00111AA\u0018\u0003c\t\u0019\u0004C\u0003t#\u0001\u0007Q\u000fC\u0003Z#\u0001\u0007Q\u000fC\u0003c#\u0001\u0007Q/A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@Q\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u0007\niDA\bUsB,7\t[3dWJ+7/\u001e7u\u0003%\u0019wN\u001c<feR,'/\u0006\u0002\u0002JA9\u0011+a\u0013\u0002P\u0005%\u0014bAA'%\nIa)\u001e8di&|g.\r\t\u0007\u0003#\nY&!\u0019\u000f\t\u0005M\u0013q\u000b\b\u0004O\u0006U\u0013\"A*\n\u0007\u0005e#+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0013q\f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011\u0011\f*\u0011\t\u0005\r\u0014QM\u0007\u0002i%\u0019\u0011q\r\u001b\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\n\u0006\u0003W2\u0016q\u000e\u0004\u0007\u0003[\u0002\u0001!!\u001b\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005E\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005!A.\u00198h\u0015\t\tI(\u0001\u0003kCZ\f\u0017\u0002BA?\u0003g\u0012aa\u00142kK\u000e$\bfA\n\u0002\u0002B\u0019\u0011+a!\n\u0007\u0005\u0015%KA\u0005ue\u0006t7/[3oi\u0006\u0019b.Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sIV\tq.\u0001\u000boC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H\rI\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0005\u0005E\u0005CBAJ\u00033\u000bi*\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\u000b)JA\tGC&dWO]3TC\u001a,\u0007+\u0019:tKJ\u0004B!a(\u0002(6\u0011\u0011\u0011\u0015\u0006\u0004=\u0006\r&bAASq\u00051QO\\:bM\u0016LA!!+\u0002\"\nQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007Y\t\t)\u0001\u0005eCR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r!\u00151\u0017\u0005\u0006sb\u0001\ra\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003s\u000by\fE\u0002R\u0003wK1!!0S\u0005\r\te.\u001f\u0005\b\u0003\u0003L\u0002\u0019AA]\u0003\u0011Q7o\u001c8\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002HB1\u0011\u0011KAe\u0003\u001bLA!a3\u0002`\t\u00191+Z9\u0011\u0007q\u000by-C\u0002\u0002Rv\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0003d_BLHCCA\u0002\u00033\fY.!8\u0002`\"9\u0011,\bI\u0001\u0002\u0004Y\u0006b\u00022\u001e!\u0003\u0005\r\u0001\u001a\u0005\bgv\u0001\n\u00111\u0001v\u0011\u001dIX\u0004%AA\u0002m\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002f*\u001a1,a:,\u0005\u0005%\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a=S\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\fiOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002~*\u001aA-a:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0001\u0016\u0004k\u0006\u001d\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0013Q3a_At\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u0002\t\u0005\u0003c\u0012\t\"C\u0002r\u0003g\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0006\u0011\u0007E\u0013I\"C\u0002\u0003\u001cI\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!/\u0003\"!I!1\u0005\u0013\u0002\u0002\u0003\u0007!qC\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t%\u0002C\u0002B\u0016\u0005c\tI,\u0004\u0002\u0003.)\u0019!q\u0006*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\t5\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E!q\u0007\u0005\n\u0005G1\u0013\u0011!a\u0001\u0003s\u000ba!Z9vC2\u001cH\u0003BA\t\u0005{A\u0011Ba\t(\u0003\u0003\u0005\r!!/)\u001f\u0001\u0011\tEa\u0012\u0003J\t5#q\nB*\u0005+\u00022!\u0011B\"\u0013\r\u0011)E\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011Y%\u00012`\rVs5i\u0018\u0015kg>t7\u000b\u001e:-AM\u001c\u0007.Z7b72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d;sk\u000e$\bE^1mk\u0016\u0004s/\u001b;iAQDW\rI4jm\u0016t\u0007\u0005\u00196t_:\u001cFO\u001d1!C:$\u0007\u0005Y:dQ\u0016l\u0017\r\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0015\u0002\u0003ST\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#C\nR\u0014\u0007\f\u0011#E\nR\u0004G\f\u001d~O1\u0002s%\u0019\u0011J\u001dRc\u0003E\u0019\u0011E\u001fV\u0013E*R\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;c1\u0012#M\t\u001e1]aj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|EQLW.\u001a\u0012;EI2t\u0006\r\u001d0eA\nTGI?(Y\u0001:C/[7fAQKW.Z:uC6\u0004x\u0005\f\u0011nCBDs\u0005^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0014-A\u001d\"GmL'N_eL\u00180_\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;j[\u0016\u0014#H\r\u00192k5\u0002\u0004(\f\u001a7AA\u0002$\b\r\u0019;aAr\u0003' \u0006!A\u0005)1/\u001b8dK\u0006\u0012!qK\u0001\u0006e9\u0012d\u0006M\u0001\u000e\u0015N|g\u000eV8TiJ,8\r^:\u0011\u0005\u0005K3\u0003B\u0015\u0003`Y\u0003\"B!\u0019\u0003hm#Wo_A\u0002\u001b\t\u0011\u0019GC\u0002\u0003fI\u000bqA];oi&lW-\u0003\u0003\u0003j\t\r$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u0011!1L\u0001\ti>\u001cFO]5oOR\u0011!qB\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003\u0007\u0011)Ha\u001e\u0003z\tm\u0004\"B--\u0001\u0004Y\u0006\"\u00022-\u0001\u0004!\u0007\"B:-\u0001\u0004)\bbB=-!\u0003\u0005\ra_\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002BB\u0005\u0017\u0003B!\u0015?\u0003\u0006B9\u0011Ka\"\\IV\\\u0018b\u0001BE%\n1A+\u001e9mKRB\u0011B!$/\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002p\u0001")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean forceNullableSchema;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private transient TimeZone timeZone;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean forceNullableSchema() {
        return this.forceNullableSchema;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes.checkInputDataTypes$(this) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? (InternalRow)rows.next() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getArray(0) : null;
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getMap(0) : null;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw new IllegalArgumentException(new StringBuilder(66).append("from_json() doesn't support the ").append(mode.name()).append(" mode. ").append("Acceptable modes are ").append(PermissiveMode$.MODULE$.name()).append(" and ").append(FailFastMode$.MODULE$.name()).append(".").toString());
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)structType.filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$11))))));
                } else {
                    StructField structField = new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField)), (Object)dataType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                StructType parserSchema = (StructType)tuple22._1();
                DataType actualSchema = (DataType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                Tuple2 tuple24 = tuple23;
                StructType parserSchema2 = (StructType)tuple24._1();
                DataType actualSchema2 = (DataType)tuple24._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false);
                Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$11) {
        String string = x$11.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.forceNullableSchema = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA()));
        this.nullableSchema = this.forceNullableSchema() ? schema.asNullable() : schema;
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

