/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.MapEntries$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(map) - Returns an unordered array of all entries in the given map.", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'));\n       [{\"key\":1,\"value\":\"a\"},{\"key\":2,\"value\":\"b\"}]\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!)!\t\u0001C\u0001\u0007\")a\t\u0001C!\u000f\"A!\f\u0001EC\u0002\u0013%1\fC\u0003d\u0001\u0011\u0005C\rC\u0003i\u0001\u0011E\u0013\u000eC\u0003p\u0001\u0011E\u0003\u000fC\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"a\u0018\u0001#\u0003%\t!!\u0019\t\u0013\u0005]\u0004!!A\u0005B\u0005e\u0004\"CAE\u0001\u0005\u0005I\u0011AAF\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003c\u0003\u0011\u0011!C!\u0003g;\u0011\"!5\u001f\u0003\u0003E\t!a5\u0007\u0011uq\u0012\u0011!E\u0001\u0003+DaAQ\f\u0005\u0002\u0005\r\b\"CAs/\u0005\u0005IQIAt\u0011%\tIoFA\u0001\n\u0003\u000bY\u000fC\u0005\u0002p^\t\t\u0011\"!\u0002r\"I\u0011Q`\f\u0002\u0002\u0013%\u0011q \u0002\u000b\u001b\u0006\u0004XI\u001c;sS\u0016\u001c(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0003gM\u001d\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00055\n\u0014B\u0001\u001a\u001f\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\t!$(\u0003\u0002<k\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\ta\b\u0005\u0002.\u007f%\u0011\u0001I\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\t\u0016\u0003\"!\f\u0001\t\u000bq\u001a\u0001\u0019\u0001 \u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001I!\rI\u0015\u000b\u0016\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!\u0014\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014B\u0001)6\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0007M+\u0017O\u0003\u0002QkA\u0011Q\u000bW\u0007\u0002-*\u0011qKI\u0001\u0006if\u0004Xm]\u0005\u00033Z\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u001b\rD\u0017\u000e\u001c3ECR\fG+\u001f9f+\u0005a\u0006CA+^\u0013\tqfKA\u0004NCB$\u0016\u0010]3)\u0005\u0015\u0001\u0007C\u0001\u001bb\u0013\t\u0011WGA\u0005ue\u0006t7/[3oi\u0006AA-\u0019;b)f\u0004X-F\u0001f!\t)f-\u0003\u0002h-\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002k[B\u0011Ag[\u0005\u0003YV\u00121!\u00118z\u0011\u0015qw\u00011\u0001k\u0003\u0015Ig\u000e];u\u0003%!wnR3o\u0007>$W\rF\u0002ror\u0004\"A];\u000e\u0003MT!\u0001\u001e\u0010\u0002\u000f\r|G-Z4f]&\u0011ao\u001d\u0002\t\u000bb\u0004(oQ8eK\")\u0001\u0010\u0003a\u0001s\u0006\u00191\r\u001e=\u0011\u0005IT\u0018BA>t\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ! \u0005A\u0002E\f!!\u001a<\u0002\r\u001d,GoS3z)\u0019\t\t!!\u0005\u0002\u0016A!\u00111AA\u0006\u001d\u0011\t)!a\u0002\u0011\u0005-+\u0014bAA\u0005k\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u00036\u0011\u001d\t\u0019\"\u0003a\u0001\u0003\u0003\tqA^1s\u001d\u0006lW\rC\u0004\u0002\u0018%\u0001\r!!\u0001\u0002\u000b%tG-\u001a=\u0002\u0011\u001d,GOV1mk\u0016$b!!\u0001\u0002\u001e\u0005}\u0001bBA\n\u0015\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003/Q\u0001\u0019AA\u0001\u0003m9WM\\\"pI\u00164uN\u001d)sS6LG/\u001b<f\u000b2,W.\u001a8ugR\u0001\u0012\u0011AA\u0013\u0003O\tY#a\f\u00024\u0005]\u00121\b\u0005\u0006q.\u0001\r!\u001f\u0005\b\u0003SY\u0001\u0019AA\u0001\u0003%\t'O]1z\t\u0006$\u0018\rC\u0004\u0002.-\u0001\r!!\u0001\u0002\t-,\u0017p\u001d\u0005\b\u0003cY\u0001\u0019AA\u0001\u0003\u00191\u0018\r\\;fg\"9\u0011QG\u0006A\u0002\u0005\u0005\u0011a\u0004:fgVdG/\u0011:sCf$\u0015\r^1\t\u000f\u0005e2\u00021\u0001\u0002\u0002\u0005Ya.^7FY\u0016lWM\u001c;t\u0011\u001d\tid\u0003a\u0001\u0003\u007f\t!b\u001d;sk\u000e$8+\u001b>f!\r!\u0014\u0011I\u0005\u0004\u0003\u0007*$aA%oi\u0006)r-\u001a8D_\u0012,gi\u001c:B]f,E.Z7f]R\u001cHCDA\u0001\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131\u000b\u0005\u0006q2\u0001\r!\u001f\u0005\b\u0003Sa\u0001\u0019AA\u0001\u0011\u001d\ti\u0003\u0004a\u0001\u0003\u0003Aq!!\r\r\u0001\u0004\t\t\u0001C\u0004\u000261\u0001\r!!\u0001\t\u000f\u0005eB\u00021\u0001\u0002\u0002\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005\u0005\u0011\u0001B2paf$2\u0001RA/\u0011\u001dad\u0002%AA\u0002y\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002d)\u001aa(!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001d6\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000bA\u0001\\1oO*\u0011\u0011QQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005}\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA \u00039\u0001(o\u001c3vGR,E.Z7f]R$2A[AI\u0011%\t\u0019JEA\u0001\u0002\u0004\ty$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0003R!a'\u0002\"*l!!!(\u000b\u0007\u0005}U'\u0001\u0006d_2dWm\u0019;j_:LA!a)\u0002\u001e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI+a,\u0011\u0007Q\nY+C\u0002\u0002.V\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0014R\t\t\u00111\u0001k\u0003\u0019)\u0017/^1mgR!\u0011\u0011VA[\u0011!\t\u0019*FA\u0001\u0002\u0004Q\u0007f\u0004\u0001\u0002:\u0006}\u0016\u0011YAc\u0003\u000f\fY-!4\u0011\u00075\nY,C\u0002\u0002>z\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002D\u0006IuLR+O\u0007~CS.\u00199*A5\u0002#+\u001a;ve:\u001c\b%\u00198!k:|'\u000fZ3sK\u0012\u0004\u0013M\u001d:bs\u0002zg\rI1mY\u0002*g\u000e\u001e:jKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004s-\u001b<f]\u0002j\u0017\r\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!3\u0002e*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)c1\u0002s%Y\u0014-AIb\u0003e\n2(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#W\u0016L(EO\u0019-EY\fG.^3#u\t\n'% \u0017|E-,\u0017P\t\u001e3Y\t2\u0018\r\\;fEi\u0012#MI?^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAh\u0003\u0015\u0019d\u0006\r\u00181\u0003)i\u0015\r]#oiJLWm\u001d\t\u0003[]\u0019BaFAlsA1\u0011\u0011\\Ap}\u0011k!!a7\u000b\u0007\u0005uW'A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00181\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAj\u0003!!xn\u0015;sS:<GCAA>\u0003\u0015\t\u0007\u000f\u001d7z)\r!\u0015Q\u001e\u0005\u0006yi\u0001\rAP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u00190!?\u0011\tQ\n)PP\u0005\u0004\u0003o,$AB(qi&|g\u000e\u0003\u0005\u0002|n\t\t\u00111\u0001E\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0002A!\u0011Q\u0010B\u0002\u0013\u0011\u0011)!a \u0003\r=\u0013'.Z2u\u0001")
public class MapEntries
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private transient MapType childDataType;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(MapEntries mapEntries) {
        return MapEntries$.MODULE$.unapply(mapEntries);
    }

    public static <A> Function1<Expression, A> andThen(Function1<MapEntries, A> function1) {
        return MapEntries$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, MapEntries> compose(Function1<A, Expression> function1) {
        return MapEntries$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MapType$[]{MapType$.MODULE$}));
    }

    private MapType childDataType$lzycompute() {
        MapEntries mapEntries = this;
        synchronized (mapEntries) {
            if (!this.bitmap$trans$0) {
                this.childDataType = (MapType)this.child().dataType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.childDataType;
    }

    private MapType childDataType() {
        return !this.bitmap$trans$0 ? this.childDataType$lzycompute() : this.childDataType;
    }

    @Override
    public DataType dataType() {
        StructField structField = new StructField("key", this.childDataType().keyType(), false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("value", this.childDataType().valueType(), this.childDataType().valueContainsNull(), StructField$.MODULE$.apply$default$4());
        return new ArrayType(StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), false);
    }

    @Override
    public Object nullSafeEval(Object input) {
        MapData childMap = (MapData)input;
        ArrayData keys = childMap.keyArray();
        ArrayData values = childMap.valueArray();
        int length = childMap.numElements();
        Object[] resultData = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object key = keys.get(i, this.childDataType().keyType());
            Object value = values.get(i, this.childDataType().valueType());
            GenericInternalRow row = new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value}), ClassTag$.MODULE$.Any()));
            resultData[i] = row;
        }
        return new GenericArrayData((Object)resultData);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String string;
            Tuple2.mcZI.sp sp2;
            String arrayData = ctx.freshName("arrayData");
            String numElements = ctx.freshName("numElements");
            String keys = ctx.freshName("keys");
            String values = ctx.freshName("values");
            boolean isKeyPrimitive = CodeGenerator$.MODULE$.isPrimitiveType(this.childDataType().keyType());
            boolean isValuePrimitive = CodeGenerator$.MODULE$.isPrimitiveType(this.childDataType().valueType());
            int wordSize = 8;
            int structSize = UnsafeRow.calculateBitSetWidthInBytes(2) + wordSize * 2;
            Tuple2.mcZI.sp sp3 = sp2 = isKeyPrimitive && isValuePrimitive ? new Tuple2.mcZI.sp(true, structSize + wordSize) : new Tuple2.mcZI.sp(false, -1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            boolean isPrimitive = sp2._1$mcZ$sp();
            int elementSize = sp2._2$mcI$sp();
            Tuple2.mcZI.sp sp4 = new Tuple2.mcZI.sp(isPrimitive, elementSize);
            Tuple2.mcZI.sp sp5 = sp4;
            boolean isPrimitive2 = sp5._1$mcZ$sp();
            int elementSize2 = sp5._2$mcI$sp();
            String allocation = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n           |ArrayData ").append(arrayData).append(" = ArrayData.allocateArrayData(\n           |  ").append(elementSize2).append(", ").append(numElements).append(", \" ").append(this.prettyName()).append(" failed.\");\n         ").toString())).stripMargin();
            if (isPrimitive2) {
                String genCodeForPrimitive = this.genCodeForPrimitiveElements(ctx, arrayData, keys, values, ExprValue$.MODULE$.exprValueToString(ev.value()), numElements, structSize);
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           |if (").append(arrayData).append(" instanceof UnsafeArrayData) {\n           |  ").append(genCodeForPrimitive).append("\n           |} else {\n           |  ").append(this.genCodeForAnyElements(ctx, arrayData, keys, values, ExprValue$.MODULE$.exprValueToString(ev.value()), numElements)).append("\n           |}\n         ").toString())).stripMargin();
            } else {
                string = String.valueOf(this.genCodeForAnyElements(ctx, arrayData, keys, values, ExprValue$.MODULE$.exprValueToString(ev.value()), numElements));
            }
            String code = string;
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n         |final int ").append(numElements).append(" = ").append((String)c).append(".numElements();\n         |final ArrayData ").append(keys).append(" = ").append((String)c).append(".keyArray();\n         |final ArrayData ").append(values).append(" = ").append((String)c).append(".valueArray();\n         |").append(allocation).append("\n         |").append(code).append("\n       ").toString())).stripMargin();
        });
    }

    private String getKey(String varName, String index) {
        return CodeGenerator$.MODULE$.getValue(varName, this.childDataType().keyType(), index);
    }

    private String getValue(String varName, String index) {
        return CodeGenerator$.MODULE$.getValue(varName, this.childDataType().valueType(), index);
    }

    private String genCodeForPrimitiveElements(CodegenContext ctx, String arrayData, String keys, String values, String resultArrayData, String numElements, int structSize) {
        String unsafeArrayData = ctx.freshName("unsafeArrayData");
        String baseObject = ctx.freshName("baseObject");
        String unsafeRow = ctx.freshName("unsafeRow");
        String structsOffset = ctx.freshName("structsOffset");
        String offset = ctx.freshName("offset");
        String z = ctx.freshName("z");
        String calculateHeader = "UnsafeArrayData.calculateHeaderPortionInBytes";
        String baseOffset = "Platform.BYTE_ARRAY_OFFSET";
        int wordSize = 8;
        String structSizeAsLong = new StringBuilder(1).append(structSize).append("L").toString();
        String setKey = CodeGenerator$.MODULE$.setColumn(unsafeRow, this.childDataType().keyType(), 0, this.getKey(keys, z));
        String valueAssignmentChecked = CodeGenerator$.MODULE$.createArrayAssignment(unsafeRow, this.childDataType().valueType(), values, "1", z, this.childDataType().valueContainsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n       |UnsafeArrayData ").append(unsafeArrayData).append(" = (UnsafeArrayData)").append(arrayData).append(";\n       |Object ").append(baseObject).append(" = ").append(unsafeArrayData).append(".getBaseObject();\n       |final int ").append(structsOffset).append(" = ").append(calculateHeader).append("(").append(numElements).append(") + ").append(numElements).append(" * ").append(wordSize).append(";\n       |UnsafeRow ").append(unsafeRow).append(" = new UnsafeRow(2);\n       |for (int ").append(z).append(" = 0; ").append(z).append(" < ").append(numElements).append("; ").append(z).append("++) {\n       |  long ").append(offset).append(" = ").append(structsOffset).append(" + ").append(z).append(" * ").append(structSizeAsLong).append(";\n       |  ").append(unsafeArrayData).append(".setLong(").append(z).append(", (").append(offset).append(" << 32) + ").append(structSizeAsLong).append(");\n       |  ").append(unsafeRow).append(".pointTo(").append(baseObject).append(", ").append(baseOffset).append(" + ").append(offset).append(", ").append(structSize).append(");\n       |  ").append(setKey).append(";\n       |  ").append(valueAssignmentChecked).append("\n       |}\n       |").append(resultArrayData).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    private String genCodeForAnyElements(CodegenContext ctx, String arrayData, String keys, String values, String resultArrayData, String numElements) {
        String z = ctx.freshName("z");
        boolean isValuePrimitive = CodeGenerator$.MODULE$.isPrimitiveType(this.childDataType().valueType());
        String getValueWithCheck = this.childDataType().valueContainsNull() && isValuePrimitive ? new StringBuilder(29).append(values).append(".isNullAt(").append(z).append(") ? null : (Object)").append(this.getValue(values, z)).toString() : this.getValue(values, z);
        String rowClass = GenericInternalRow.class.getName();
        String genericArrayDataClass = GenericArrayData.class.getName();
        String genericArrayData = ctx.freshName("genericArrayData");
        String rowObject = new StringBuilder(22).append("new ").append(rowClass).append("(new Object[]{").append(this.getKey(keys, z)).append(", ").append(getValueWithCheck).append("})").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n       |").append(genericArrayDataClass).append(" ").append(genericArrayData).append(" = (").append(genericArrayDataClass).append(")").append(arrayData).append(";\n       |for (int ").append(z).append(" = 0; ").append(z).append(" < ").append(numElements).append("; ").append(z).append("++) {\n       |  ").append(genericArrayData).append(".update(").append(z).append(", ").append(rowObject).append(");\n       |}\n       |").append(resultArrayData).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "map_entries";
    }

    public MapEntries copy(Expression child) {
        return new MapEntries(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "MapEntries";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapEntries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapEntries)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapEntries mapEntries = (MapEntries)x$1;
        Expression expression = this.child();
        Expression expression2 = mapEntries.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!mapEntries.canEqual(this)) return false;
        return true;
    }

    public MapEntries(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

