/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp[, fmt]) - Parses the `timestamp` expression with the `fmt` expression to\n      a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\tE\t\u0015!\u0003G\u0011!Q\u0005A!f\u0001\n\u0003y\u0004\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000b1\u0003A\u0011A+\t\u000b]\u0003A\u0011\t-\t\u000b\u0015\u0002A\u0011\t5\t\u000bE\u0004A\u0011\t5\t\u000bI\u0004A\u0011I:\t\u000fi\u0004\u0011\u0011!C\u0001w\"Aq\u0010AI\u0001\n\u0003\t\t\u0001C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a!I\u0011Q\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003?\u0001\u0011\u0011!C!\u0003CA\u0011\"!\r\u0001\u0003\u0003%\t!a\r\t\u0013\u0005m\u0002!!A\u0005\u0002\u0005u\u0002\"CA\"\u0001\u0005\u0005I\u0011IA#\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002^\u0001\t\t\u0011\"\u0011\u0002`\u001dI\u0011Q\u0010\u0011\u0002\u0002#\u0005\u0011q\u0010\u0004\t?\u0001\n\t\u0011#\u0001\u0002\u0002\"1A*\u0007C\u0001\u0003\u001fC\u0011\"!%\u001a\u0003\u0003%)%a%\t\u0013\u0005U\u0015$!A\u0005\u0002\u0006]\u0005\"CAP3\u0005\u0005I\u0011QAQ\u0011%\ty+GA\u0001\n\u0013\t\tL\u0001\tQCJ\u001cX\rV8US6,7\u000f^1na*\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001]I*4\b\u0005\u00020a5\t\u0001%\u0003\u00022A\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0003\"aL!\n\u0005\t\u0003#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012A\u0012\t\u0004m\u001d\u0003\u0015B\u0001%8\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001d>\u0003\u0016\u000b\u0005\u00020\u0001!)ah\u0002a\u0001\u0001\")Ai\u0002a\u0001\r\")!j\u0002a\u0001\u0001R\u0019aj\u0015+\t\u000byB\u0001\u0019\u0001!\t\u000b\u0011C\u0001\u0019\u0001!\u0015\u000593\u0006\"\u0002 \n\u0001\u0004\u0001\u0015!\u00044mCR\f%oZ;nK:$8/F\u0001Z!\rQ&-\u001a\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014BA18\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0011%#XM]1u_JT!!Y\u001c\u0011\u0005Y2\u0017BA48\u0005\r\te._\u000b\u0002SB\u0011!N\u001c\b\u0003W2\u0004\"\u0001X\u001c\n\u00055<\u0014A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\u001c\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0005eCR\fG+\u001f9f+\u0005!\bCA;y\u001b\u00051(BA<%\u0003\u0015!\u0018\u0010]3t\u0013\tIhO\u0001\u0005ECR\fG+\u001f9f\u0003\u0011\u0019w\u000e]=\u0015\t9cXP \u0005\b}9\u0001\n\u00111\u0001A\u0011\u001d!e\u0002%AA\u0002\u0019CqA\u0013\b\u0011\u0002\u0003\u0007\u0001)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r!f\u0001!\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012]\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m!f\u0001$\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001\u00027b]\u001eT!!!\f\u0002\t)\fg/Y\u0005\u0004_\u0006\u001d\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001b!\r1\u0014qG\u0005\u0004\u0003s9$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002@!I\u0011\u0011\t\u000b\u0002\u0002\u0003\u0007\u0011QG\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0003#BA%\u0003\u001f*WBAA&\u0015\r\tieN\u0001\u000bG>dG.Z2uS>t\u0017bA2\u0002L\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002V\u0005m\u0003c\u0001\u001c\u0002X%\u0019\u0011\u0011L\u001c\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\t\f\u0002\u0002\u0003\u0007Q-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\n\t\u0007\u0003\u0005\u0002B]\t\t\u00111\u0001fQ=\u0001\u0011QMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0004cA\u0018\u0002h%\u0019\u0011\u0011\u000e\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qN\u0001\u0002R*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015uS6,7\u000f^1nanc\u0003EZ7u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u0002G/[7fgR\fW\u000e\u001d1!Kb\u0004(/Z:tS>t\u0007e^5uQ\u0002\"\b.\u001a\u0011aM6$\b\rI3yaJ,7o]5p]\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003%\u0019\u0011uS6,7\u000f^1na:\u0002#+\u001a;ve:\u001c\bE\\;mY\u0002:\u0018\u000e\u001e5!S:4\u0018\r\\5eA%t\u0007/\u001e;/A\tK\b\u0005Z3gCVdG\u000f\f\u0011ji\u00022w\u000e\u001c7poN\u00043-Y:uS:<\u0007E];mKN\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005I1!i&lWm\u001d;b[B\u0004\u0013N\u001a\u0011uQ\u0016\u0004\u0003MZ7uA\u0002J7\u000fI8nSR$X\r\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003k\n\u0011\u0011\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00172e5\u001a\u0014\u0007\t\u00191uE\u0012$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[E\u0012TfM\u0019!aAR\u0014G\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2O1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2AA\u0002$\b\r\u0019;aAR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003w\nQA\r\u00183]A\n\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u0011\u0005=J2\u0003B\r\u0002\u0004n\u0002\u0002\"!\"\u0002\f\u00023\u0005IT\u0007\u0003\u0003\u000fS1!!#8\u0003\u001d\u0011XO\u001c;j[\u0016LA!!$\u0002\b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005}\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0012!B1qa2LHc\u0002(\u0002\u001a\u0006m\u0015Q\u0014\u0005\u0006}q\u0001\r\u0001\u0011\u0005\u0006\tr\u0001\rA\u0012\u0005\u0006\u0015r\u0001\r\u0001Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019+a+\u0011\tY:\u0015Q\u0015\t\u0007m\u0005\u001d\u0006I\u0012!\n\u0007\u0005%vG\u0001\u0004UkBdWm\r\u0005\t\u0003[k\u0012\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003g\u0003B!!\n\u00026&!\u0011qWA\u0014\u0005\u0019y%M[3di\u0002")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestamp>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestamp(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new GetTimestamp(left, format, GetTimestamp$.MODULE$.apply$default$3()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

