/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011!y\u0005A!f\u0001\n\u0003A\u0005\u0002\u0003)\u0001\u0005#\u0005\u000b\u0011B%\t\u000bE\u0003A\u0011\u0001*\t\u000bE\u0003A\u0011A,\t\u000bE\u0003A\u0011A.\t\u000bu\u0003A\u0011\t0\t\u000b-\u0004A\u0011\t7\t\u000bQ\u0004A\u0011I;\t\u000be\u0004A\u0011\t>\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0013\t)\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013B\u0011\"a\u0018\u0001#\u0003%\t!!\u0013\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005%\u0003\"CA2\u0001\u0005\u0005I\u0011IA3\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0012\u0005\n\u0003/\u0003\u0011\u0011!C\u0001\u00033C\u0011\"a)\u0001\u0003\u0003%\t%!*\b\u0013\u0005u6%!A\t\u0002\u0005}f\u0001\u0003\u0012$\u0003\u0003E\t!!1\t\rEcB\u0011AAh\u0011%\t\t\u000eHA\u0001\n\u000b\n\u0019\u000eC\u0005\u0002Vr\t\t\u0011\"!\u0002X\"I\u0011q\u001c\u000f\u0002\u0002\u0013\u0005\u0015\u0011\u001d\u0005\n\u0003gd\u0012\u0011!C\u0005\u0003k\u00141b\u0015;sS:<Gk\\'ba*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001cUZd\b\u0012\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t1\u0014(D\u00018\u0015\tA4%A\u0004d_\u0012,w-\u001a8\n\u0005i:$aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005Ib\u0014BA\u001f$\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\b!J|G-^2u!\tyT)\u0003\u0002G\u0001\na1+\u001a:jC2L'0\u00192mK\u0006!A/\u001a=u+\u0005I\u0005C\u0001\u001aK\u0013\tY5E\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001^3yi\u0002\n\u0011\u0002]1je\u0012+G.[7\u0002\u0015A\f\u0017N\u001d#fY&l\u0007%A\u0007lKf4\u0016\r\\;f\t\u0016d\u0017.\\\u0001\u000fW\u0016Lh+\u00197vK\u0012+G.[7!\u0003\u0019a\u0014N\\5u}Q!1\u000bV+W!\t\u0011\u0004\u0001C\u0003H\u000f\u0001\u0007\u0011\nC\u0003N\u000f\u0001\u0007\u0011\nC\u0003P\u000f\u0001\u0007\u0011\nF\u0002T1jCQ!\u0017\u0005A\u0002%\u000bQa\u00195jY\u0012DQ!\u0014\u0005A\u0002%#\"a\u0015/\t\u000beK\u0001\u0019A%\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012a\u0018\t\u0004A\"LeBA1g\u001d\t\u0011W-D\u0001d\u0015\t!w&\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0011q\rQ\u0001\ba\u0006\u001c7.Y4f\u0013\tI'NA\u0002TKFT!a\u001a!\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001n!\r\u0001\u0007N\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u001e\nQ\u0001^=qKNL!a\u001d9\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003Y\u0004\"a\\<\n\u0005a\u0004(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003m\u0004\"\u0001`@\u000e\u0003uT!A`\u0013\u0002\u0011\u0005t\u0017\r\\=tSNL1!!\u0001~\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018AC7ba\n+\u0018\u000e\u001c3feV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\tYA\u0001\u000bBeJ\f\u0017PQ1tK\u0012l\u0015\r\u001d\"vS2$WM]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003/\ti\"!\t\u0002&A\u0019q(!\u0007\n\u0007\u0005m\u0001IA\u0002B]fDq!a\b\u0010\u0001\u0004\t9\"A\u0006j]B,Ho\u0015;sS:<\u0007bBA\u0012\u001f\u0001\u0007\u0011qC\u0001\u0010gR\u0014\u0018N\\4EK2LW.\u001b;fe\"9\u0011qE\bA\u0002\u0005]\u0011!E6fsZ\u000bG.^3EK2LW.\u001b;fe\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003oqA!!\r\u00024A\u0011!\rQ\u0005\u0004\u0003k\u0001\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u00026\u0001\u000bAaY8qsR91+!\u0011\u0002D\u0005\u0015\u0003bB$\u0012!\u0003\u0005\r!\u0013\u0005\b\u001bF\u0001\n\u00111\u0001J\u0011\u001dy\u0015\u0003%AA\u0002%\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002L)\u001a\u0011*!\u0014,\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0017A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n\u0019FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003c\nAA[1wC&!\u0011\u0011HA6\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\bE\u0002@\u0003wJ1!! A\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9\"a!\t\u0013\u0005\u0015u#!AA\u0002\u0005e\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fB1\u0011QRAJ\u0003/i!!a$\u000b\u0007\u0005E\u0005)\u0001\u0006d_2dWm\u0019;j_:LA!!&\u0002\u0010\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY*!)\u0011\u0007}\ni*C\u0002\u0002 \u0002\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0006f\t\t\u00111\u0001\u0002\u0018\u00051Q-];bYN$B!a'\u0002(\"I\u0011Q\u0011\u000e\u0002\u0002\u0003\u0007\u0011q\u0003\u0015\f\u0001\u0005-\u0016\u0011WAZ\u0003o\u000bI\fE\u00023\u0003[K1!a,$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!.\u0002\u0005/yf)\u0016(D?\"\"X\r\u001f;\\Y\u0001\u0002\u0018-\u001b:EK2LWn\u0017\u0017!W\u0016Lh+\u00197vK\u0012+G.[7^;&\u0002S\u0006I\"sK\u0006$Xm\u001d\u0011bA5\f\u0007\u000fI1gi\u0016\u0014\be\u001d9mSR$\u0018N\\4!i\",\u0007\u0005^3yi\u0002Jg\u000e^8!W\u0016LxF^1mk\u0016\u0004\u0003/Y5sg\u0002*8/\u001b8hA\u0011,G.[7ji\u0016\u00148O\f\u0011EK\u001a\fW\u000f\u001c;!I\u0016d\u0017.\\5uKJ\u001c\b%\u0019:fA\u001dbs\u0005\t4pe\u0002\u0002\u0007/Y5s\t\u0016d\u0017.\u001c1!C:$\u0007e\n\u001e(A\u0019|'\u000f\t1lKf4\u0016\r\\;f\t\u0016d\u0017.\u001c1/A\t{G\u000f\u001b\u0011aa\u0006L'\u000fR3mS6\u0004\u0007%\u00198eA\u0001\\W-\u001f,bYV,G)\u001a7j[\u0002\u0004\u0013M]3!iJ,\u0017\r^3eA\u0005\u001c\bE]3hk2\f'\u000fI3yaJ,7o]5p]Nt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005m\u0016!!\t\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'(\r\u0017cuIb3MO\u001a(Y\u0001:Cf\n\u0017!Oi:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#HI\u0019#Y\t\u0012'E\u000f\u00123E1\u00123M\t\u001e#g\tj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEirW\u000f\u001c7~\u0015\u0001\u0002\u0013aC*ue&tw\rV8NCB\u0004\"A\r\u000f\u0014\tq\t\u0019\r\u0012\t\t\u0003\u000b\fY-S%J'6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\u0004\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\f9MA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fM\u000bI.a7\u0002^\")qi\ba\u0001\u0013\")Qj\ba\u0001\u0013\")qj\ba\u0001\u0013\u00069QO\\1qa2LH\u0003BAr\u0003_\u0004RaPAs\u0003SL1!a:A\u0005\u0019y\u0005\u000f^5p]B1q(a;J\u0013&K1!!<A\u0005\u0019!V\u000f\u001d7fg!A\u0011\u0011\u001f\u0011\u0002\u0002\u0003\u00071+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001f\t\u0005\u0003S\nI0\u0003\u0003\u0002|\u0006-$AB(cU\u0016\u001cG\u000f")
public class StringToMap
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$26))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.text();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$26) {
        return !x$26.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

