/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u000f\u001f\u0001.B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0012)A\u0005w!Aq\b\u0001BK\u0002\u0013\u0005!\b\u0003\u0005A\u0001\tE\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015Y\u0006\u0001\"\u0011P\u0011\u0015a\u0006\u0001\"\u0011P\u0011!i\u0006\u0001#b\u0001\n\u0013q\u0006\"B6\u0001\t#b\u0007\"B9\u0001\t\u0003\u0012\bb\u0002<\u0001\u0003\u0003%\ta\u001e\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011!\ti\u0001AI\u0001\n\u0003Y\b\"CA\b\u0001\u0005\u0005I\u0011IA\t\u0011%\t\t\u0003AA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u00111\u0007\u0001\u0002\u0002\u0013\u0005\u0013Q\u0007\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\b\u0013\u0005%d$!A\t\u0002\u0005-d\u0001C\u000f\u001f\u0003\u0003E\t!!\u001c\t\r\u0005;B\u0011AA>\u0011%\tihFA\u0001\n\u000b\ny\bC\u0005\u0002\u0002^\t\t\u0011\"!\u0002\u0004\"I\u0011\u0011R\f\u0002\u0002\u0013\u0005\u00151\u0012\u0005\n\u00033;\u0012\u0011!C\u0005\u00037\u0013\u0001bU;ciJ\f7\r\u001e\u0006\u0003?\u0001\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011EI\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0005J\u0001\u0004gFd'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\f\u00197!\tic&D\u0001\u001f\u0013\tycD\u0001\tCS:\f'/_!sSRDW.\u001a;jGB\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t9\u0001K]8ek\u000e$\bCA\u00198\u0013\tA$G\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A\u001e\u0011\u00055b\u0014BA\u001f\u001f\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r\u0019E)\u0012\t\u0003[\u0001AQ!O\u0003A\u0002mBQaP\u0003A\u0002m\n\u0011\"\u001b8qkR$\u0016\u0010]3\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u0012\u0002\u000bQL\b/Z:\n\u00055S%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003\u0019\u0019\u00180\u001c2pYV\t\u0001\u000b\u0005\u0002R1:\u0011!K\u0016\t\u0003'Jj\u0011\u0001\u0016\u0006\u0003+*\na\u0001\u0010:p_Rt\u0014BA,3\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\u0013\u0014!\u00043fG&l\u0017\r\\'fi\"|G-\u0001\fdC2,g\u000eZ1s\u0013:$XM\u001d<bY6+G\u000f[8e\u0003\u001dqW/\\3sS\u000e,\u0012a\u0018\t\u0004A\u0016DgBA1d\u001d\t\u0019&-C\u00014\u0013\t!''A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019<'a\u0002(v[\u0016\u0014\u0018n\u0019\u0006\u0003IJ\u0002\"!M5\n\u0005)\u0014$aA!os\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001.\\8\t\u000b9\\\u0001\u0019\u00015\u0002\r%t\u0007/\u001e;2\u0011\u0015\u00018\u00021\u0001i\u0003\u0019Ig\u000e];ue\u0005yQ\r_1di6\u000bG\u000f['fi\"|G-F\u0001t!\r\tD\u000fU\u0005\u0003kJ\u0012aa\u00149uS>t\u0017\u0001B2paf$2a\u0011=z\u0011\u001dIT\u0002%AA\u0002mBqaP\u0007\u0011\u0002\u0003\u00071(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003qT#aO?,\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!C;oG\",7m[3e\u0015\r\t9AM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0006\u0003\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\tA\u0001\\1oO*\u0011\u0011QD\u0001\u0005U\u00064\u0018-C\u0002Z\u0003/\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\n\u0011\u0007E\n9#C\u0002\u0002*I\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001[A\u0018\u0011%\t\tDEA\u0001\u0002\u0004\t)#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0001R!!\u000f\u0002@!l!!a\u000f\u000b\u0007\u0005u\"'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0002<\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9%!\u0014\u0011\u0007E\nI%C\u0002\u0002LI\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u00022Q\t\t\u00111\u0001i\u0003\u0019)\u0017/^1mgR!\u0011qIA*\u0011!\t\t$FA\u0001\u0002\u0004A\u0007f\u0003\u0001\u0002X\u0005u\u0013qLA2\u0003K\u00022!LA-\u0013\r\tYF\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t'A\u0017fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!A\u0016D\bO]\u0019a[\u0001,\u0007\u0010\u001d:3A:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\nQG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00113A}3UKT\"`AEZ$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0006!A\u0005A1+\u001e2ue\u0006\u001cG\u000f\u0005\u0002./M!q#a\u001c7!\u001d\t\t(a\u001e<w\rk!!a\u001d\u000b\u0007\u0005U$'A\u0004sk:$\u0018.\\3\n\t\u0005e\u00141\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA6\u0003!!xn\u0015;sS:<GCAA\n\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u0015QQAD\u0011\u0015I$\u00041\u0001<\u0011\u0015y$\u00041\u0001<\u0003\u001d)h.\u00199qYf$B!!$\u0002\u0016B!\u0011\u0007^AH!\u0015\t\u0014\u0011S\u001e<\u0013\r\t\u0019J\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005]5$!AA\u0002\r\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0005\u0003BA\u000b\u0003?KA!!)\u0002\u0018\t1qJ\u00196fGR\u0004")
public class Subtract
extends BinaryArithmetic
implements Serializable {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(Subtract subtract) {
        return Subtract$.MODULE$.unapply(subtract);
    }

    public static Function1<Tuple2<Expression, Expression>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Subtract>> curried() {
        return Subtract$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public String calendarIntervalMethod() {
        return "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.checkOverflow());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return this.dataType() instanceof CalendarIntervalType ? ((CalendarInterval)input1).subtract((CalendarInterval)input2) : this.numeric().minus(input1, input2);
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    public Subtract copy(Expression left, Expression right) {
        return new Subtract(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

