/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(fmt, ts) - Returns timestamp `ts` truncated to the unit specified by the format model `fmt`.\n    `fmt` should be one of [\"MILLENNIUM\", \"CENTURY\", \"DECADE\", \"YEAR\", \"YYYY\", \"YY\",\n                            \"QUARTER\", \"MON\", \"MONTH\", \"MM\", \"WEEK\", \"DAY\", \"DD\",\n                            \"HOUR\", \"MINUTE\", \"SECOND\", \"MILLISECOND\", \"MICROSECOND\"]\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', '2015-03-05T09:32:05.359');\n       2015-01-01 00:00:00\n      > SELECT _FUNC_('MM', '2015-03-05T09:32:05.359');\n       2015-03-01 00:00:00\n      > SELECT _FUNC_('DD', '2015-03-05T09:32:05.359');\n       2015-03-05 00:00:00\n      > SELECT _FUNC_('HOUR', '2015-03-05T09:32:05.359');\n       2015-03-05 09:00:00\n      > SELECT _FUNC_('MILLISECOND', '2015-03-05T09:32:05.123456');\n       2015-03-05 09:32:05.123\n      > SELECT _FUNC_('DECADE', '2015-03-05T09:32:05.123456');\n       2010-01-01 00:00:00\n      > SELECT _FUNC_('CENTURY', '2015-03-05T09:32:05.123456');\n       2001-01-01 00:00:00\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003\t\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u001d\u0004A\u0011I%\t\u000b!\u0004A\u0011I%\t\u000b%\u0004A\u0011\t6\t\u000bi\u0004A\u0011I>\t\r}\u0004A\u0011IA\u0001\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003J\u0005bBA\u0003\u0001\u0001\u0006IA\u0013\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u0019\t\u0007\u0001\"\u0001\u0002\u000e!9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"!\u0015\u0001#\u0003%\t!a\u0015\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005M\u0003\"CA6\u0001E\u0005I\u0011AA7\u0011%\t\t\bAA\u0001\n\u0003\n\u0019\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/C\u0011\"!*\u0001\u0003\u0003%\t!a*\t\u0013\u0005E\u0006!!A\u0005B\u0005Mv!CAiO\u0005\u0005\t\u0012AAj\r!1s%!A\t\u0002\u0005U\u0007BB1\u001f\t\u0003\t\u0019\u000fC\u0005\u0002fz\t\t\u0011\"\u0012\u0002h\"I\u0011\u0011\u001e\u0010\u0002\u0002\u0013\u0005\u00151\u001e\u0005\n\u0003gt\u0012\u0013!C\u0001\u0003[B\u0011\"!>\u001f\u0003\u0003%\t)a>\t\u0013\t\u0015a$%A\u0005\u0002\u00055\u0004\"\u0003B\u0004=\u0005\u0005I\u0011\u0002B\u0005\u00059!&/\u001e8d)&lWm\u001d;b[BT!\u0001K\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003U-\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Y5\n1a]9m\u0015\tqs&A\u0003ta\u0006\u00148N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0007\u0001UJDhP#\u0011\u0005Y:T\"A\u0014\n\u0005a:#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t1$(\u0003\u0002<O\taAK];oG&s7\u000f^1oiB\u0011a'P\u0005\u0003}\u001d\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001IR\u0005\u0003\u000f\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016\faAZ8s[\u0006$X#\u0001&\u0011\u0005YZ\u0015B\u0001'(\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\bM>\u0014X.\u0019;!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u0006uS6,7\u000f^1na\u0002\n!\u0002^5nKj{g.Z%e+\u0005\u0011\u0006c\u0001!T+&\u0011A+\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YkfBA,\\!\tA\u0016)D\u0001Z\u0015\tQ6'\u0001\u0004=e>|GOP\u0005\u00039\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A,Q\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005G\u0012,g\r\u0005\u00027\u0001!)\u0001j\u0002a\u0001\u0015\")aj\u0002a\u0001\u0015\"9\u0001k\u0002I\u0001\u0002\u0004\u0011\u0016\u0001\u00027fMR\fQA]5hQR\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005Y\u0007c\u00017ri:\u0011Qn\u001c\b\u00031:L\u0011AQ\u0005\u0003a\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0002sg\n\u00191+Z9\u000b\u0005A\f\u0005CA;y\u001b\u00051(BA<,\u0003\u0015!\u0018\u0010]3t\u0013\tIhO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001}!\t)X0\u0003\u0002\u007fm\niA+[7fgR\fW\u000e\u001d+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005)\u0016aB5ogR\fg\u000e^\u0001\tS:\u001cH/\u00198uA\u0005aq/\u001b;i)&lWMW8oKR\u0019A(a\u0003\t\u000bA{\u0001\u0019A+\u0015\u000b\r\fy!!\u0005\t\u000b!\u0003\u0002\u0019\u0001&\t\u000b9\u0003\u0002\u0019\u0001&\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003/\ti\u0002E\u0002A\u00033I1!a\u0007B\u0005\r\te.\u001f\u0005\n\u0003?\t\u0002\u0013!a\u0001\u0003C\tQ!\u001b8qkR\u0004B!a\t\u0002&5\t\u0011&C\u0002\u0002(%\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003[\tI$a\u0011\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r(\u0003\u001d\u0019w\u000eZ3hK:LA!a\u000e\u00022\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002<I\u0001\r!!\u0010\u0002\u0007\r$\b\u0010\u0005\u0003\u00020\u0005}\u0012\u0002BA!\u0003c\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002FI\u0001\r!!\f\u0002\u0005\u00154\u0018\u0001B2paf$raYA&\u0003\u001b\ny\u0005C\u0004I'A\u0005\t\u0019\u0001&\t\u000f9\u001b\u0002\u0013!a\u0001\u0015\"9\u0001k\u0005I\u0001\u0002\u0004\u0011\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003+R3ASA,W\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyGK\u0002S\u0003/\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\nA\u0001\\1oO*\u0011\u0011qP\u0001\u0005U\u00064\u0018-C\u0002_\u0003s\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\"\u0011\u0007\u0001\u000bI)C\u0002\u0002\f\u0006\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0006\u0002\u0012\"I\u00111S\r\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0005CBAN\u0003C\u000b9\"\u0004\u0002\u0002\u001e*\u0019\u0011qT!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002$\u0006u%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!+\u00020B\u0019\u0001)a+\n\u0007\u00055\u0016IA\u0004C_>dW-\u00198\t\u0013\u0005M5$!AA\u0002\u0005]\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002*\u0006U\u0006\"CAJ9\u0005\u0005\t\u0019AA\fQ=\u0001\u0011\u0011XA`\u0003\u0003\f)-a2\u0002L\u00065\u0007c\u0001\u001c\u0002<&\u0019\u0011QX\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111Y\u0001\u0003R*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015g[Rd\u0003\u0005^:*A5\u0002#+\u001a;ve:\u001c\b\u0005^5nKN$\u0018-\u001c9!AR\u001c\b\r\t;sk:\u001c\u0017\r^3eAQ|\u0007\u0005\u001e5fAUt\u0017\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0012\u0017\u0010\t;iK\u00022wN]7bi\u0002jw\u000eZ3mA\u00014W\u000e\u001e1/\u0015\u0001\u0002\u0003\u0005\t1g[R\u0004\u0007e\u001d5pk2$\u0007EY3!_:,\u0007e\u001c4!7\nj\u0015\n\u0014'F\u001d:KU+\u0014\u0012-A\t\u001aUI\u0014+V%f\u0013C\u0006\t\u0012E\u000b\u000e\u000bE)\u0012\u0012-A\tJV)\u0011*#Y\u0001\u0012\u0013,W-ZE1\u0002#%W-#Y)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012\u0013+V!S)\u0016\u0013&\u0005\f\u0011#\u001b>s%\u0005\f\u0011#\u001b>sE\u000b\u0013\u0012-A\tjUJ\t\u0017!E]+Ui\u0013\u0012-A\t\"\u0015)\u0017\u0012-A\t\"EI\t\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E!{UK\u0015\u0012-A\tj\u0015JT+U\u000b\nb\u0003EI*F\u0007>sEI\t\u0017!E5KE\nT%T\u000b\u000e{e\n\u0012\u0012-A\tj\u0015j\u0011*P'\u0016\u001buJ\u0014##;*\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI-\u0001Cz\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013,R!SO1\u0002sE\r\u00192k5\u00024'\f\u00196)BJ$h\r\u001a;aUr3'N\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00196[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%T'(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aMj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C\tR\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002T\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dBu*\u0016*(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aMj\u0003'\u000e\u00111si\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":S*\u0013'M\u0013N+5i\u0014(EO1\u0002sE\r\u00192k5\u00024'\f\u00196)BJ$h\r\u001a;aUr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE*T\u0006M\u001a.aU\u0002\u0003'\u000f\u001e4ei\u0002TGL\u00193g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005R#D\u0003\u0012+u\u0005\f\u0011(eA\nT'\f\u00194[A*D\u000bM\u001d;gIR\u0004'\u000e\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3)\u0012(U+JKv\u0005\f\u0011(eA\nT'\f\u00194[A*D\u000bM\u001d;gIR\u0004'\u000e\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004\u0007M\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAh\u0003\u0015\u0011df\r\u00181\u00039!&/\u001e8d)&lWm\u001d;b[B\u0004\"A\u000e\u0010\u0014\ty\t9.\u0012\t\t\u00033\fyN\u0013&SG6\u0011\u00111\u001c\u0006\u0004\u0003;\f\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003C\fYNA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\r\fi/a<\u0002r\")\u0001*\ta\u0001\u0015\")a*\ta\u0001\u0015\"9\u0001+\tI\u0001\u0002\u0004\u0011\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011 B\u0001!\u0011\u00015+a?\u0011\r\u0001\u000biP\u0013&S\u0013\r\ty0\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t\r1%!AA\u0002\r\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0001\u0005\u0003\u0002x\t5\u0011\u0002\u0002B\b\u0003s\u0012aa\u00142kK\u000e$\b")
public class TruncTimestamp
extends BinaryExpression
implements TruncInstant,
TimeZoneAwareExpression,
scala.Serializable {
    private final Expression format;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private final Expression instant;
    private boolean resolved;
    private transient TimeZone timeZone;
    private transient ZoneId zoneId;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return TruncTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(TruncTimestamp truncTimestamp) {
        return TruncTimestamp$.MODULE$.unapply(truncTimestamp);
    }

    public static Option<String> apply$default$3() {
        return TruncTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, TruncTimestamp> tupled() {
        return TruncTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, TruncTimestamp>>> curried() {
        return TruncTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    private ZoneId zoneId$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.format();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, TimestampType$.MODULE$}));
    }

    @Override
    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "date_trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(t, level) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncTimestamp(BoxesRunTime.unboxToLong((Object)t), BoxesRunTime.unboxToInt((Object)level), this.timeZone())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), true, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(21).append("truncTimestamp(").append((String)date).append(", ").append((String)fmt).append(", ").append(tz).append(");").toString());
    }

    public TruncTimestamp copy(Expression format, Expression timestamp, Option<String> timeZoneId) {
        return new TruncTimestamp(format, timestamp, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.format();
    }

    public Expression copy$default$2() {
        return this.timestamp();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TruncTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.format();
                break;
            }
            case 1: {
                option = this.timestamp();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncTimestamp truncTimestamp = (TruncTimestamp)x$1;
        Expression expression = this.format();
        Expression expression2 = truncTimestamp.format();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = truncTimestamp.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = truncTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncTimestamp.canEqual(this)) return false;
        return true;
    }

    public TruncTimestamp(Expression format, Expression timestamp, Option<String> timeZoneId) {
        this.format = format;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        this.instant = timestamp;
    }

    public TruncTimestamp(Expression format, Expression timestamp) {
        this(format, timestamp, (Option<String>)None$.MODULE$);
    }
}

