/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.WeekOfYear$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(date) - Returns the week of the year of the given date. A week is considered to start on a Monday and week 1 is the first week with >3 days.", examples="\n    Examples:\n      > SELECT _FUNC_('2008-02-20');\n       8\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\f\u0019\u0001\u0016B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!)A\b\u0001C\u0001{!)\u0001\t\u0001C!\u0003\")A\u000b\u0001C!+\")\u0011\f\u0001C)5\")\u0001\r\u0001C!C\"9q\u000eAA\u0001\n\u0003\u0001\bb\u0002:\u0001#\u0003%\ta\u001d\u0005\b}\u0002\t\t\u0011\"\u0011\u0000\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002\u001c\u0001\t\t\u0011\"\u0001\u0002\u001e!I\u00111\u0005\u0001\u0002\u0002\u0013\u0005\u0013Q\u0005\u0005\n\u0003g\u0001\u0011\u0011!C\u0001\u0003kA\u0011\"a\u0010\u0001\u0003\u0003%\t%!\u0011\b\u0013\u0005}\u0003$!A\t\u0002\u0005\u0005d\u0001C\f\u0019\u0003\u0003E\t!a\u0019\t\rq\nB\u0011AA9\u0011%\t\u0019(EA\u0001\n\u000b\n)\bC\u0005\u0002xE\t\t\u0011\"!\u0002z!I\u0011QP\t\u0002\u0002\u0013\u0005\u0015q\u0010\u0005\n\u0003\u0017\u000b\u0012\u0011!C\u0005\u0003\u001b\u0013!bV3fW>3\u0017,Z1s\u0015\tI\"$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000e\u001d\u0003!\u0019\u0017\r^1msN$(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011#\u0002\u0001'U5\u001a\u0004CA\u0014)\u001b\u0005A\u0012BA\u0015\u0019\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u0014,\u0013\ta\u0003D\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\f\u001b\n\u0005Uz#\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001\u001d\u0011\u0005\u001dJ\u0014B\u0001\u001e\u0019\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\tqt\b\u0005\u0002(\u0001!)ag\u0001a\u0001q\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\t\u00032aQ&O\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002HI\u00051AH]8pizJ\u0011\u0001M\u0005\u0003\u0015>\nq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n\u00191+Z9\u000b\u0005){\u0003CA(S\u001b\u0005\u0001&BA)\u001d\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0006K\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001W!\tyu+\u0003\u0002Y!\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002\\=B\u0011a\u0006X\u0005\u0003;>\u00121!\u00118z\u0011\u0015yf\u00011\u0001\\\u0003\u0011!\u0017\r^3\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00012i[B\u00111MZ\u0007\u0002I*\u0011Q\rG\u0001\bG>$WmZ3o\u0013\t9GM\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015Iw\u00011\u0001k\u0003\r\u0019G\u000f\u001f\t\u0003G.L!\u0001\u001c3\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")an\u0002a\u0001E\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002?c\"9a\u0007\u0003I\u0001\u0002\u0004A\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002i*\u0012\u0001(^\u0016\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\nk:\u001c\u0007.Z2lK\u0012T!a_\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002~q\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\tAA[1wC&!\u0011qBA\u0003\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0003\t\u0004]\u0005]\u0011bAA\r_\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191,a\b\t\u0013\u0005\u0005B\"!AA\u0002\u0005U\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002(A)\u0011\u0011FA\u001876\u0011\u00111\u0006\u0006\u0004\u0003[y\u0013AC2pY2,7\r^5p]&!\u0011\u0011GA\u0016\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0012Q\b\t\u0004]\u0005e\u0012bAA\u001e_\t9!i\\8mK\u0006t\u0007\u0002CA\u0011\u001d\u0005\u0005\t\u0019A.\u0002\r\u0015\fX/\u00197t)\u0011\t9$a\u0011\t\u0011\u0005\u0005r\"!AA\u0002mCs\u0002AA$\u0003\u001b\ny%a\u0015\u0002V\u0005e\u00131\f\t\u0004O\u0005%\u0013bAA&1\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA)\u0003\u0005\u001drLR+O\u0007~CC-\u0019;fS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002:X-Z6!_\u001a\u0004C\u000f[3!s\u0016\f'\u000fI8gAQDW\rI4jm\u0016t\u0007\u0005Z1uK:\u0002\u0013\tI<fK.\u0004\u0013n\u001d\u0011d_:\u001c\u0018\u000eZ3sK\u0012\u0004Co\u001c\u0011ti\u0006\u0014H\u000fI8oA\u0005\u0004Sj\u001c8eCf\u0004\u0013M\u001c3!o\u0016,7\u000eI\u0019!SN\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011xK\u0016\\\u0007e^5uQ\u0002r4\u0007\t3bsNt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0013a\u0010\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0004\u0007O\u00171e5\u0012\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AaR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003;\nQ!\r\u00186]A\n!bV3fW>3\u0017,Z1s!\t9\u0013c\u0005\u0003\u0012\u0003K\u001a\u0004CBA4\u0003[Bd(\u0004\u0002\u0002j)\u0019\u00111N\u0018\u0002\u000fI,h\u000e^5nK&!\u0011qNA5\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003C\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\tQ!\u00199qYf$2APA>\u0011\u00151D\u00031\u00019\u0003\u001d)h.\u00199qYf$B!!!\u0002\bB!a&a!9\u0013\r\t)i\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005%U#!AA\u0002y\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0005\u0003BA\u0002\u0003#KA!a%\u0002\u0006\t1qJ\u00196fGR\u0004")
public class WeekOfYear
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(WeekOfYear weekOfYear) {
        return WeekOfYear$.MODULE$.unapply(weekOfYear);
    }

    public static <A> Function1<Expression, A> andThen(Function1<WeekOfYear, A> function1) {
        return WeekOfYear$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, WeekOfYear> compose(Function1<A, Expression> function1) {
        return WeekOfYear$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DateType$[]{DateType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object date) {
        LocalDate localDate = LocalDate.ofEpochDay(BoxesRunTime.unboxToInt((Object)date));
        return BoxesRunTime.boxToInteger((int)localDate.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)days -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n         |").append(ev.value()).append(" = java.time.LocalDate.ofEpochDay(").append((String)days).append(").get(\n         |  java.time.temporal.IsoFields.WEEK_OF_WEEK_BASED_YEAR);\n       ").toString())).stripMargin());
    }

    public WeekOfYear copy(Expression child) {
        return new WeekOfYear(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "WeekOfYear";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WeekOfYear;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WeekOfYear)) return false;
        boolean bl = true;
        if (!bl) return false;
        WeekOfYear weekOfYear = (WeekOfYear)x$1;
        Expression expression = this.child();
        Expression expression2 = weekOfYear.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!weekOfYear.canEqual(this)) return false;
        return true;
    }

    public WeekOfYear(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

