/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate percentile value of numeric\n      column `col` at the given percentage. The value of percentage must be between 0.0\n      and 1.0. The `accuracy` parameter (default: 10000) is a positive numeric literal which\n      controls approximation accuracy at the cost of memory. Higher value of `accuracy` yields\n      better accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10.0, array(0.5, 0.4, 0.1), 100);\n       [10.0,10.0,10.0]\n      > SELECT _FUNC_(10.0, 0.5, 100);\n       10\n  ", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\rMb\u0001B$I\u0001^C!\"!)\u0001\u0005+\u0007I\u0011AAx\u0011)\t\t\u0010\u0001B\tB\u0003%\u00111\u0015\u0005\u000b\u0003[\u0003!Q3A\u0005\u0002\u0005=\bBCAz\u0001\tE\t\u0015!\u0003\u0002$\"Q\u0011\u0011\u0017\u0001\u0003\u0016\u0004%\t!a<\t\u0015\u0005U\bA!E!\u0002\u0013\t\u0019\u000bC\u0005\u00026\u0002\u0011)\u001a!C!}\"I\u0011q\u001f\u0001\u0003\u0012\u0003\u0006Ia \u0005\n\u0003s\u0003!Q3A\u0005ByD\u0011\"!?\u0001\u0005#\u0005\u000b\u0011B@\t\rm\u0004A\u0011AA~\u0011\u0019Y\b\u0001\"\u0001\u0003\b!11\u0010\u0001C\u0001\u0005\u001fA\u0011B!\u0006\u0001\u0011\u000b\u0007I\u0011\u0002@\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!a\u0011q\u0005\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0003:!Q!\u0011\t\u0001\t\u0006\u0004%I!!\u0011\t\u0015\u0005\u001d\u0004\u0001#b\u0001\n\u0013\u0011\u0019\u0005C\u0004\u0003F\u0001!\tEa\u0012\t\u000f\tU\u0003\u0001\"\u0011\u0003X!9!\u0011\f\u0001\u0005B\tm\u0003bBA*\u0001\u0011\u0005#Q\u000e\u0005\b\u0005g\u0002A\u0011\tB;\u0011\u001d\u0011y\b\u0001C!\u0005\u0003CqAa\"\u0001\t\u0003\u0012I\tC\u0004\u0003\u000e\u0002!\tEa$\t\u000f\tM\u0005\u0001\"\u0011\u0002B!9!Q\u0013\u0001\u0005B\t]\u0005b\u0002BP\u0001\u0011\u0005#\u0011\u0015\u0005\b\u0003w\u0002A\u0011\tBZ\u0011\u001d\tY\t\u0001C!\u0005oC\u0011Ba/\u0001\u0003\u0003%\tA!0\t\u0013\t%\u0007!%A\u0005\u0002\t-\u0007\"\u0003Bq\u0001E\u0005I\u0011\u0001Bf\u0011%\u0011\u0019\u000fAI\u0001\n\u0003\u0011Y\rC\u0005\u0003f\u0002\t\n\u0011\"\u0001\u0003h\"I!1\u001e\u0001\u0012\u0002\u0013\u0005!q\u001d\u0005\n\u0005[\u0004\u0011\u0011!C!\u0005_D\u0001B!>\u0001\u0003\u0003%\tA \u0005\n\u0005o\u0004\u0011\u0011!C\u0001\u0005sD\u0011B!@\u0001\u0003\u0003%\tEa@\t\u0013\r5\u0001!!A\u0005\u0002\r=\u0001\"CB\n\u0001\u0005\u0005I\u0011IB\u000b\u000f\u0015y\u0007\n#\u0001q\r\u00159\u0005\n#\u0001r\u0011\u0015YX\u0006\"\u0001}\u0011\u001diXF1A\u0005\u0002yDq!!\u0002.A\u0003%qP\u0002\u0004\u0002\b5\u0002\u0011\u0011\u0002\u0005\u000b\u0003\u0017\t$\u00111A\u0005\n\u00055\u0001BCA\u000ec\t\u0005\r\u0011\"\u0003\u0002\u001e!Q\u0011\u0011F\u0019\u0003\u0002\u0003\u0006K!a\u0004\t\rm\fD\u0011AA\u0016\u0011\u0019Y\u0018\u0007\"\u0001\u00024!A\u0011qH\u0019\u0005\u00029\u000b\t\u0005C\u0004\u0002JE\"\t!!\u0004\t\u000f\u0005-\u0013\u0007\"\u0001\u0002N!9\u00111K\u0019\u0005\u0002\u0005U\u0003bBA.c\u0011\u0005\u0011Q\f\u0005\b\u0003S\nDQBA6\r\u0019\ti'\f\u0001\u0002p!110\u0010C\u0001\u0003cBq!!\u001e>\t\u001b\t9\bC\u0004\u0002|u\")!! \t\u000f\u0005-U\b\"\u0002\u0002\u000e\"I\u00111S\u0017C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003/k\u0003\u0015!\u0003\u0002t!I\u0011\u0011T\u0017\u0002\u0002\u0013\u0005\u00151\u0014\u0005\n\u0003wk\u0013\u0011!CA\u0003{C\u0011\"a4.\u0003\u0003%I!!5\u0003+\u0005\u0003\bO]8yS6\fG/\u001a)fe\u000e,g\u000e^5mK*\u0011\u0011JS\u0001\nC\u001e<'/Z4bi\u0016T!a\u0013'\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001b:\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001fB\u000b1a]9m\u0015\t\t&+A\u0003ta\u0006\u00148N\u0003\u0002T)\u00061\u0011\r]1dQ\u0016T\u0011!V\u0001\u0004_J<7\u0001A\n\b\u0001a\u000b\u0019/!;y!\rI&\fX\u0007\u0002\u0011&\u00111\f\u0013\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007CA/2\u001d\tqFF\u0004\u0002`]:\u0011\u0001-\u001c\b\u0003C2t!AY6\u000f\u0005\rTgB\u00013j\u001d\t)\u0007.D\u0001g\u0015\t9g+\u0001\u0004=e>|GOP\u0005\u0002+&\u00111\u000bV\u0005\u0003#JK!a\u0014)\n\u00055s\u0015BA&M\u0013\tI%*A\u000bBaB\u0014x\u000e_5nCR,\u0007+\u001a:dK:$\u0018\u000e\\3\u0011\u0005ek3cA\u0017sqB\u00111O^\u0007\u0002i*\tQ/A\u0003tG\u0006d\u0017-\u0003\u0002xi\n1\u0011I\\=SK\u001a\u0004\"a]=\n\u0005i$(\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001q\u0003m!UIR!V\u0019R{\u0006+\u0012*D\u000b:#\u0016\nT#`\u0003\u000e\u001bUKU!D3V\tq\u0010E\u0002t\u0003\u0003I1!a\u0001u\u0005\rIe\u000e^\u0001\u001d\t\u00163\u0015)\u0016'U?B+%kQ#O)&cUiX!D\u0007V\u0013\u0016iQ-!\u0005A\u0001VM]2f]RLG.\u001a#jO\u0016\u001cHo\u0005\u00022e\u0006I1/^7nCJLWm]\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+a\u0015\u0001B;uS2LA!!\u0007\u0002\u0014\t\t\u0012+^1oi&dWmU;n[\u0006\u0014\u0018.Z:\u0002\u001bM,X.\\1sS\u0016\u001cx\fJ3r)\u0011\ty\"!\n\u0011\u0007M\f\t#C\u0002\u0002$Q\u0014A!\u00168ji\"I\u0011qE\u001a\u0002\u0002\u0003\u0007\u0011qB\u0001\u0004q\u0012\n\u0014AC:v[6\f'/[3tAQ!\u0011QFA\u0019!\r\ty#M\u0007\u0002[!9\u00111B\u001bA\u0002\u0005=A\u0003BA\u0017\u0003kAq!a\u000e7\u0001\u0004\tI$A\u0007sK2\fG/\u001b<f\u000bJ\u0014xN\u001d\t\u0004g\u0006m\u0012bAA\u001fi\n1Ai\\;cY\u0016\fA\"[:D_6\u0004(/Z:tK\u0012,\"!a\u0011\u0011\u0007M\f)%C\u0002\u0002HQ\u0014qAQ8pY\u0016\fg.A\trk\u0006tG/\u001b7f'VlW.\u0019:jKN\f1!\u00193e)\u0011\ty\"a\u0014\t\u000f\u0005E\u0013\b1\u0001\u0002:\u0005)a/\u00197vK\u0006)Q.\u001a:hKR!\u0011qDA,\u0011\u001d\tIF\u000fa\u0001\u0003[\tQa\u001c;iKJ\fabZ3u!\u0016\u00148-\u001a8uS2,7\u000f\u0006\u0003\u0002`\u0005\u0015\u0004#B:\u0002b\u0005e\u0012bAA2i\n)\u0011I\u001d:bs\"9\u0011qM\u001eA\u0002\u0005}\u0013a\u00039fe\u000e,g\u000e^1hKN\f\u0001bY8naJ,7o\u001d\u000b\u0003\u0003?\u0011!\u0004U3sG\u0016tG/\u001b7f\t&<Wm\u001d;TKJL\u0017\r\\5{KJ\u001c\"!\u0010:\u0015\u0005\u0005M\u0004cAA\u0018{\u00051A.\u001a8hi\"$2a`A=\u0011\u001d\tYa\u0010a\u0001\u0003\u001f\t\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005}\u0014q\u0011\t\u0006g\u0006\u0005\u0014\u0011\u0011\t\u0004g\u0006\r\u0015bAACi\n!!)\u001f;f\u0011\u001d\tI\t\u0011a\u0001\u0003[\t1a\u001c2k\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\t\u00055\u0012q\u0012\u0005\b\u0003#\u000b\u0005\u0019AA@\u0003\u0015\u0011\u0017\u0010^3t\u0003)\u0019XM]5bY&TXM]\u000b\u0003\u0003g\n1b]3sS\u0006d\u0017N_3sA\u0005)\u0011\r\u001d9msRa\u0011QTAP\u0003W\u000by+a-\u00028B\u0011\u0011\f\u0001\u0005\b\u0003C#\u0005\u0019AAR\u0003\u0015\u0019\u0007.\u001b7e!\u0011\t)+a*\u000e\u0003)K1!!+K\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003[#\u0005\u0019AAR\u0003Q\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\"9\u0011\u0011\u0017#A\u0002\u0005\r\u0016AE1dGV\u0014\u0018mY=FqB\u0014Xm]:j_:Da!!.E\u0001\u0004y\u0018AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\r\u0005eF\t1\u0001\u0000\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069QO\\1qa2LH\u0003BA`\u0003\u0017\u0004Ra]Aa\u0003\u000bL1!a1u\u0005\u0019y\u0005\u000f^5p]BY1/a2\u0002$\u0006\r\u00161U@\u0000\u0013\r\tI\r\u001e\u0002\u0007)V\u0004H.Z\u001b\t\u0013\u00055W)!AA\u0002\u0005u\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u000e\u0005\u0003\u0002V\u0006}WBAAl\u0015\u0011\tI.a7\u0002\t1\fgn\u001a\u0006\u0003\u0003;\fAA[1wC&!\u0011\u0011]Al\u0005\u0019y%M[3diB!\u0011QUAs\u0013\r\t9O\u0013\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u00191/a;\n\u0007\u00055HOA\u0004Qe>$Wo\u0019;\u0016\u0005\u0005\r\u0016AB2iS2$\u0007%A\u000bqKJ\u001cWM\u001c;bO\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002'\u0005\u001c7-\u001e:bGf,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\t\u000b\r\u0003;\u000bi0a@\u0003\u0002\t\r!Q\u0001\u0005\b\u0003C[\u0001\u0019AAR\u0011\u001d\tik\u0003a\u0001\u0003GCq!!-\f\u0001\u0004\t\u0019\u000b\u0003\u0004\u00026.\u0001\ra \u0005\u0007\u0003s[\u0001\u0019A@\u0015\u0011\u0005u%\u0011\u0002B\u0006\u0005\u001bAq!!)\r\u0001\u0004\t\u0019\u000bC\u0004\u0002.2\u0001\r!a)\t\u000f\u0005EF\u00021\u0001\u0002$R1\u0011Q\u0014B\t\u0005'Aq!!)\u000e\u0001\u0004\t\u0019\u000bC\u0004\u0002.6\u0001\r!a)\u0002\u0011\u0005\u001c7-\u001e:bGf\f!\"\u001b8qkR$\u0016\u0010]3t+\t\u0011Y\u0002\u0005\u0004\u0003\u001e\t\u001d\"Q\u0006\b\u0005\u0005?\u0011\u0019CD\u0002f\u0005CI\u0011!^\u0005\u0004\u0005K!\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011YCA\u0002TKFT1A!\nu!\u0011\u0011yC!\u000e\u000e\u0005\tE\"b\u0001B\u001a\u001d\u0006)A/\u001f9fg&!!q\u0007B\u0019\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0006\u0002\u0003<A91O!\u0010\u0002D\u0005}\u0013b\u0001B i\n1A+\u001e9mKJ\nQC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u00170\u0006\u0002\u0002`\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011!\u0011\n\t\u0005\u0005\u0017\u0012\t&\u0004\u0002\u0003N)\u0019!q\n'\u0002\u0011\u0005t\u0017\r\\=tSNLAAa\u0015\u0003N\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\tA,\u0001\u0004va\u0012\fG/\u001a\u000b\u00069\nu#\u0011\r\u0005\u0007\u0005?*\u0002\u0019\u0001/\u0002\r\t,hMZ3s\u0011\u001d\u0011\u0019'\u0006a\u0001\u0005K\n\u0001\"\u001b8qkR\u0014vn\u001e\t\u0005\u0005O\u0012I'D\u0001M\u0013\r\u0011Y\u0007\u0014\u0002\f\u0013:$XM\u001d8bYJ{w\u000fF\u0003]\u0005_\u0012\t\b\u0003\u0004\u0003`Y\u0001\r\u0001\u0018\u0005\u0007\u000332\u0002\u0019\u0001/\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0005o\u0012i\bE\u0002t\u0005sJ1Aa\u001fu\u0005\r\te.\u001f\u0005\u0007\u0005?:\u0002\u0019\u0001/\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!(\u0003\u0004\"1!Q\u0011\rA\u0002}\f\u0011B\\3x\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\tiJa#\t\r\t\u0015\u0015\u00041\u0001\u0000\u0003!\u0019\u0007.\u001b7ee\u0016tWC\u0001BI!\u0019\u0011iBa\n\u0002$\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\t\u0011I\n\u0005\u0003\u00030\tm\u0015\u0002\u0002BO\u0005c\u0011\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,WC\u0001BR!\u0011\u0011)K!,\u000f\t\t\u001d&\u0011\u0016\t\u0003KRL1Aa+u\u0003\u0019\u0001&/\u001a3fM&!!q\u0016BY\u0005\u0019\u0019FO]5oO*\u0019!1\u0016;\u0015\t\u0005}$Q\u0017\u0005\u0007\u0003\u0013s\u0002\u0019\u0001/\u0015\u0007q\u0013I\fC\u0004\u0002\u0012~\u0001\r!a \u0002\t\r|\u0007/\u001f\u000b\r\u0003;\u0013yL!1\u0003D\n\u0015'q\u0019\u0005\n\u0003C\u0003\u0003\u0013!a\u0001\u0003GC\u0011\"!,!!\u0003\u0005\r!a)\t\u0013\u0005E\u0006\u0005%AA\u0002\u0005\r\u0006\u0002CA[AA\u0005\t\u0019A@\t\u0011\u0005e\u0006\u0005%AA\u0002}\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003N*\"\u00111\u0015BhW\t\u0011\t\u000e\u0005\u0003\u0003T\nuWB\u0001Bk\u0015\u0011\u00119N!7\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bni\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}'Q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!;+\u0007}\u0014y-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\t\u0010\u0005\u0003\u0002V\nM\u0018\u0002\u0002BX\u0003/\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003x\tm\b\u0002CA\u0014Q\u0005\u0005\t\u0019A@\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0001\u0011\r\r\r1\u0011\u0002B<\u001b\t\u0019)AC\u0002\u0004\bQ\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019Ya!\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\u001a\t\u0002C\u0005\u0002()\n\t\u00111\u0001\u0003x\u00051Q-];bYN$B!a\u0011\u0004\u0018!I\u0011qE\u0016\u0002\u0002\u0003\u0007!q\u000f\u0015\u0010\u0001\rm1\u0011EB\u0012\u0007O\u0019Ic!\f\u00040A!\u0011QUB\u000f\u0013\r\u0019yB\u0013\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0019)#AC \u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0003/\u001a:dK:$\u0018mZ3!72\u0002\u0013mY2ve\u0006\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA=4\u0007E\\;nKJL7M\u0003\u0011!A\u0001\u0002\u0003eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0018!)\",\u0007E^1mk\u0016\u0004sN\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004S.^:uA\t,\u0007EY3uo\u0016,g\u000e\t\u0019/a)\u0001\u0003\u0005\t\u0011!A\u0005tG\rI\u0019/a9\u0002C\u000b[3!A\u0006\u001c7-\u001e:bGf\u0004\u0007\u0005]1sC6,G/\u001a:!Q\u0011,g-Y;mij\u0002\u0013\u0007\r\u00191a%\u0002\u0013n\u001d\u0011bAA|7/\u001b;jm\u0016\u0004c.^7fe&\u001c\u0007\u0005\\5uKJ\fG\u000eI<iS\u000eD'\u0002\t\u0011!A\u0001\u00023m\u001c8ue>d7\u000fI1qaJ|\u00070[7bi&|g\u000eI1dGV\u0014\u0018mY=!CR\u0004C\u000f[3!G>\u001cH\u000fI8gA5,Wn\u001c:z]\u0001B\u0015n\u001a5fe\u00022\u0018\r\\;fA=4\u0007\u0005Y1dGV\u0014\u0018mY=aAeLW\r\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!E\u0016$H/\u001a:!C\u000e\u001cWO]1ds2\u0002\u0003-\r\u00181_\u0005\u001c7-\u001e:bGf\u0004\u0007%[:!i\",\u0007E]3mCRLg/\u001a\u0011feJ|'\u000fI8gAQDW\rI1qaJ|\u00070[7bi&|gN\f\u0006!A\u0001\u0002\u0003\u0005I,iK:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002J7\u000fI1oA\u0005\u0014(/Y=-A\u0015\f7\r\u001b\u0011wC2,X\rI8gAQDW\r\t9fe\u000e,g\u000e^1hK\u0002\n'O]1zA5,8\u000f\u001e\u0011cK\u0002\u0012W\r^<fK:\u0004\u0003G\f\u0019!C:$\u0007%\r\u00181])\u0001\u0003\u0005\t\u0011!A%s\u0007\u0005\u001e5jg\u0002\u001a\u0017m]3-AI,G/\u001e:og\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCR,\u0007\u0005]3sG\u0016tG/\u001b7fA\u0005\u0014(/Y=!_\u001a\u00043m\u001c7v[:\u0004\u0003mY8mA\u0002\nG\u000f\t;iK\u0002:\u0017N^3o\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0016\u00148-\u001a8uC\u001e,\u0007%\u0019:sCft#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#aa\u000b\u0002\u0003KQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0019/a1\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u0019/a1\n\u0004G\f\u0019-cAr\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cAr\u0003\u0007\f\u00111]Ub\u0003%\r\u00191SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\r\u0006!A\u0005)1/\u001b8dK\u0006\u00121\u0011G\u0001\u0006e9\nd\u0006\r")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
scala.Serializable {
    private int accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private int accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = BoxesRunTime.unboxToInt((Object)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private int accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, ArrayType$.MODULE$.apply(DoubleType$.MODULE$)})), IntegerType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        block10: {
            ApproximatePercentile approximatePercentile = this;
            synchronized (approximatePercentile) {
                boolean bl;
                double[] percentages;
                block12: {
                    Tuple2 tuple2;
                    block11: {
                        Tuple2 tuple22;
                        if ((byte)(this.bitmap$0 & 2) != 0) break block10;
                        Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                        if (object instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)object);
                            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                        } else if (object instanceof ArrayData) {
                            ArrayData arrayData = (ArrayData)object;
                            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                        } else {
                            throw new MatchError(object);
                        }
                        tuple2 = tuple22;
                        if (tuple2 == null) break block11;
                        boolean returnPercentileArray = tuple2._1$mcZ$sp();
                        percentages = (double[])tuple2._2();
                        bl = returnPercentileArray;
                        if (percentages != null) break block12;
                    }
                    throw new MatchError((Object)tuple2);
                }
                double[] dArray = percentages;
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)dArray);
                this.x$1 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The accuracy provided must be a positive integer literal (current value = ").append(this.accuracy()).append(")").toString()) : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("All percentage values must be between 0.0 and 1.0 ").append("(current = ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).mkString(", ")).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = numericType.numeric().toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Object object;
        double[] doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$3 -> (long)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$6 -> (int)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$7 -> (long)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = doubleResult;
        } else if (dataType instanceof DecimalType) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
            }
            throw new MatchError((Object)dataType);
        }
        Object result = object;
        return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
    }

    @Override
    public String prettyName() {
        return "percentile_approx";
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, x$3));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

