/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitOrAgg$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bitwise OR of all non-null input values, or null if none.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (3), (5) AS tab(col);\n       7\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u000b\u0017\u0001\u0016B\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001\u000e\u0005\ts\u0001\u0011\t\u0012)A\u0005k!)!\b\u0001C\u0001w!)a\b\u0001C!\u007f!)1\n\u0001C!\u0019\"9A\u000bAA\u0001\n\u0003)\u0006bB,\u0001#\u0003%\t\u0001\u0017\u0005\bG\u0002\t\t\u0011\"\u0011e\u0011\u001da\u0007!!A\u0005\u00025Dq!\u001d\u0001\u0002\u0002\u0013\u0005!\u000fC\u0004y\u0001\u0005\u0005I\u0011I=\t\u0013\u0005\u0005\u0001!!A\u0005\u0002\u0005\r\u0001\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u000f%\tiCFA\u0001\u0012\u0003\tyC\u0002\u0005\u0016-\u0005\u0005\t\u0012AA\u0019\u0011\u0019Qt\u0002\"\u0001\u0002@!I\u0011\u0011I\b\u0002\u0002\u0013\u0015\u00131\t\u0005\n\u0003\u000bz\u0011\u0011!CA\u0003\u000fB\u0011\"a\u0013\u0010\u0003\u0003%\t)!\u0014\t\u0013\u0005es\"!A\u0005\n\u0005m#\u0001\u0003\"ji>\u0013\u0018iZ4\u000b\u0005]A\u0012!C1hOJ,w-\u0019;f\u0015\tI\"$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000e\u001d\u0003!\u0019\u0017\r^1msN$(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011\u0003\u0002\u0001'UA\u0002\"a\n\u0015\u000e\u0003YI!!\u000b\f\u0003\u0019\tKG/Q4he\u0016<\u0017\r^3\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\u000fA\u0013x\u000eZ;diB\u00111&M\u0005\u0003e1\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012!\u000e\t\u0003m]j\u0011\u0001G\u0005\u0003qa\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"\u0001P\u001f\u0011\u0005\u001d\u0002\u0001\"B\u001a\u0004\u0001\u0004)\u0014\u0001\u00038pI\u0016t\u0015-\\3\u0016\u0003\u0001\u0003\"!\u0011%\u000f\u0005\t3\u0005CA\"-\u001b\u0005!%BA#%\u0003\u0019a$o\\8u}%\u0011q\tL\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002HY\u0005Y!-\u001b;Pa\u0016\u0014\u0018\r^8s)\ri\u0005K\u0015\t\u0003m9K!a\u0014\r\u0003!\tKg.\u0019:z\u0003JLG\u000f[7fi&\u001c\u0007\"B)\u0006\u0001\u0004)\u0014\u0001\u00027fMRDQaU\u0003A\u0002U\nQA]5hQR\fAaY8qsR\u0011AH\u0016\u0005\bg\u0019\u0001\n\u00111\u00016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u0017\u0016\u0003ki[\u0013a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0001d\u0013AC1o]>$\u0018\r^5p]&\u0011!-\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001f!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0003mC:<'\"\u00016\u0002\t)\fg/Y\u0005\u0003\u0013\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u001c\t\u0003W=L!\u0001\u001d\u0017\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005M4\bCA\u0016u\u0013\t)HFA\u0002B]fDqa\u001e\u0006\u0002\u0002\u0003\u0007a.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002uB\u00191P`:\u000e\u0003qT!! \u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u0000y\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)!a\u0003\u0011\u0007-\n9!C\u0002\u0002\n1\u0012qAQ8pY\u0016\fg\u000eC\u0004x\u0019\u0005\u0005\t\u0019A:\u0002\r\u0015\fX/\u00197t)\u0011\t)!!\u0005\t\u000f]l\u0011\u0011!a\u0001g\"z\u0001!!\u0006\u0002\u001c\u0005u\u0011\u0011EA\u0012\u0003O\tI\u0003E\u00027\u0003/I1!!\u0007\u0019\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\b\u0002)~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!E&$x/[:fA=\u0013\u0006e\u001c4!C2d\u0007E\\8o[9,H\u000e\u001c\u0011j]B,H\u000f\t<bYV,7\u000f\f\u0011pe\u0002rW\u000f\u001c7!S\u001a\u0004cn\u001c8f]\u0005AQ\r_1na2,7/\t\u0002\u0002&\u00059&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002cIU(NAY\u000bE*V#TA!\u001a\u0014\u0006\f\u0011)k%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001:$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005-\u0012!B\u001a/a9\u0002\u0014\u0001\u0003\"ji>\u0013\u0018iZ4\u0011\u0005\u001dz1\u0003B\b\u00024A\u0002b!!\u000e\u0002<UbTBAA\u001c\u0015\r\tI\u0004L\u0001\beVtG/[7f\u0013\u0011\ti$a\u000e\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u00020\u0005AAo\\*ue&tw\rF\u0001f\u0003\u0015\t\u0007\u000f\u001d7z)\ra\u0014\u0011\n\u0005\u0006gI\u0001\r!N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty%!\u0016\u0011\t-\n\t&N\u0005\u0004\u0003'b#AB(qi&|g\u000e\u0003\u0005\u0002XM\t\t\u00111\u0001=\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002^A\u0019a-a\u0018\n\u0007\u0005\u0005tM\u0001\u0004PE*,7\r\u001e")
public class BitOrAgg
extends BitAggregate {
    private final Expression child;

    public static Option<Expression> unapply(BitOrAgg bitOrAgg) {
        return BitOrAgg$.MODULE$.unapply(bitOrAgg);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitOrAgg, A> function1) {
        return BitOrAgg$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitOrAgg> compose(Function1<A, Expression> function1) {
        return BitOrAgg$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String nodeName() {
        return "bit_or";
    }

    @Override
    public BinaryArithmetic bitOperator(Expression left, Expression right) {
        return new BitwiseOr(left, right);
    }

    public BitOrAgg copy(Expression child) {
        return new BitOrAgg(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitOrAgg";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitOrAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitOrAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitOrAgg bitOrAgg = (BitOrAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitOrAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitOrAgg.canEqual(this)) return false;
        return true;
    }

    public BitOrAgg(Expression child) {
        this.child = child;
    }
}

