/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.MaxBy$;
import org.apache.spark.sql.catalyst.expressions.aggregate.MaxMinBy;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(x, y) - Returns the value of `x` associated with the maximum value of `y`.", examples="\n    Examples:\n      > SELECT _FUNC_(x, y) FROM VALUES (('a', 10)), (('b', 50)), (('c', 20)) AS tab(x, y);\n       b\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\r\u001b\u0001&B\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005s!Aa\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005@\u0001\tE\t\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015)\u0005\u0001\"\u0015G\u0011\u0015\u0011\u0006\u0001\"\u0015T\u0011\u0015A\u0006\u0001\"\u0015Z\u0011\u001da\u0006!!A\u0005\u0002uCq\u0001\u0019\u0001\u0012\u0002\u0013\u0005\u0011\rC\u0004m\u0001E\u0005I\u0011A1\t\u000f5\u0004\u0011\u0011!C!]\"9a\u000fAA\u0001\n\u00039\bbB>\u0001\u0003\u0003%\t\u0001 \u0005\n\u0003\u000b\u0001\u0011\u0011!C!\u0003\u000fA\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\t\u0013\u0005\u0005\u0002!!A\u0005B\u0005\rr!CA!5\u0005\u0005\t\u0012AA\"\r!I\"$!A\t\u0002\u0005\u0015\u0003B\u0002!\u0014\t\u0003\t\u0019\u0006C\u0005\u0002VM\t\t\u0011\"\u0012\u0002X!I\u0011\u0011L\n\u0002\u0002\u0013\u0005\u00151\f\u0005\n\u0003C\u001a\u0012\u0011!CA\u0003GB\u0011\"!\u001e\u0014\u0003\u0003%I!a\u001e\u0003\u000b5\u000b\u0007PQ=\u000b\u0005ma\u0012!C1hOJ,w-\u0019;f\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011\u0003\u0002\u0001+]Q\u0002\"a\u000b\u0017\u000e\u0003iI!!\f\u000e\u0003\u00115\u000b\u00070T5o\u0005f\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00020k%\u0011a\u0007\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\nm\u0006dW/Z#yaJ,\u0012!\u000f\t\u0003umj\u0011\u0001H\u0005\u0003yq\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003)1\u0018\r\\;f\u000bb\u0004(\u000fI\u0001\r_J$WM]5oO\u0016C\bO]\u0001\u000e_J$WM]5oO\u0016C\bO\u001d\u0011\u0002\rqJg.\u001b;?)\r\u00115\t\u0012\t\u0003W\u0001AQaN\u0003A\u0002eBQAP\u0003A\u0002e\n\u0001BZ;oG:\u000bW.Z\u000b\u0002\u000fB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u0019\u000e\u0003-S!\u0001\u0014\u0015\u0002\rq\u0012xn\u001c;?\u0013\tq\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(1\u0003%\u0001(/\u001a3jG\u0006$X\rF\u0002:)ZCQ!V\u0004A\u0002e\nqa\u001c7e\u000bb\u0004(\u000fC\u0003X\u000f\u0001\u0007\u0011(A\u0004oK^,\u0005\u0010\u001d:\u0002\u001f=\u0014H-\u001a:j]\u001e,\u0006\u000fZ1uKJ$2!\u000f.\\\u0011\u0015)\u0006\u00021\u0001:\u0011\u00159\u0006\u00021\u0001:\u0003\u0011\u0019w\u000e]=\u0015\u0007\tsv\fC\u00048\u0013A\u0005\t\u0019A\u001d\t\u000fyJ\u0001\u0013!a\u0001s\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00012+\u0005e\u001a7&\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017!C;oG\",7m[3e\u0015\tI\u0007'\u0001\u0006b]:|G/\u0019;j_:L!a\u001b4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011\u0001+]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002qB\u0011q&_\u0005\u0003uB\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!`A\u0001!\tyc0\u0003\u0002\u0000a\t\u0019\u0011I\\=\t\u0011\u0005\ra\"!AA\u0002a\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0005!\u0015\tY!!\u0005~\u001b\t\tiAC\u0002\u0002\u0010A\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00033\ty\u0002E\u00020\u00037I1!!\b1\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0001\u0011\u0003\u0003\u0005\r!`\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u0011Q\u0005\u0005\t\u0003\u0007\t\u0012\u0011!a\u0001{\"z\u0001!!\u000b\u00020\u0005E\u0012QGA\u001c\u0003w\ti\u0004E\u0002;\u0003WI1!!\f\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\r\u0002#~3UKT\"`Qad\u0003%_\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002\u0002\u0007\u0010\u0019\u0011bgN|7-[1uK\u0012\u0004s/\u001b;iAQDW\rI7bq&lW/\u001c\u0011wC2,X\rI8gA\u0001L\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011H\u0001w\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"BH\u0006I=*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)Q\u001d\nw\u0005\f\u00112a%JC\u0006\t\u0015)O\t<C\u0006I\u001b1S%b\u0003\u0005\u000b\u0015(G\u001eb\u0003E\r\u0019*S\u0001\n5\u000b\t;bE\"BH\u0006I=*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005}\u0012!B\u001a/a9\u0002\u0014!B'bq\nK\bCA\u0016\u0014'\u0011\u0019\u0012q\t\u001b\u0011\u000f\u0005%\u0013qJ\u001d:\u00056\u0011\u00111\n\u0006\u0004\u0003\u001b\u0002\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003#\nYEA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\\\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0005\u0006u\u0013q\f\u0005\u0006oY\u0001\r!\u000f\u0005\u0006}Y\u0001\r!O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)'!\u001d\u0011\u000b=\n9'a\u001b\n\u0007\u0005%\u0004G\u0001\u0004PaRLwN\u001c\t\u0006_\u00055\u0014(O\u0005\u0004\u0003_\u0002$A\u0002+va2,'\u0007\u0003\u0005\u0002t]\t\t\u00111\u0001C\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zA\u0019\u0001/a\u001f\n\u0007\u0005u\u0014O\u0001\u0004PE*,7\r\u001e")
public class MaxBy
extends MaxMinBy {
    private final Expression valueExpr;
    private final Expression orderingExpr;

    public static Option<Tuple2<Expression, Expression>> unapply(MaxBy maxBy) {
        return MaxBy$.MODULE$.unapply(maxBy);
    }

    public static Function1<Tuple2<Expression, Expression>, MaxBy> tupled() {
        return MaxBy$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MaxBy>> curried() {
        return MaxBy$.MODULE$.curried();
    }

    @Override
    public Expression valueExpr() {
        return this.valueExpr;
    }

    @Override
    public Expression orderingExpr() {
        return this.orderingExpr;
    }

    @Override
    public String funcName() {
        return "max_by";
    }

    @Override
    public Expression predicate(Expression oldExpr, Expression newExpr) {
        return (Expression)((Object)package$expressions$.MODULE$.DslExpression(oldExpr).$greater(newExpr));
    }

    @Override
    public Expression orderingUpdater(Expression oldExpr, Expression newExpr) {
        return package$expressions$.MODULE$.greatest((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{oldExpr, newExpr}));
    }

    public MaxBy copy(Expression valueExpr, Expression orderingExpr) {
        return new MaxBy(valueExpr, orderingExpr);
    }

    public Expression copy$default$1() {
        return this.valueExpr();
    }

    public Expression copy$default$2() {
        return this.orderingExpr();
    }

    @Override
    public String productPrefix() {
        return "MaxBy";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.valueExpr();
                break;
            }
            case 1: {
                expression = this.orderingExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MaxBy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MaxBy)) return false;
        boolean bl = true;
        if (!bl) return false;
        MaxBy maxBy = (MaxBy)x$1;
        Expression expression = this.valueExpr();
        Expression expression2 = maxBy.valueExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.orderingExpr();
        Expression expression4 = maxBy.orderingExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!maxBy.canEqual(this)) return false;
        return true;
    }

    public MaxBy(Expression valueExpr, Expression orderingExpr) {
        this.valueExpr = valueExpr;
        this.orderingExpr = orderingExpr;
    }
}

