/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class DateTimeUtils$ {
    public static DateTimeUtils$ MODULE$;
    private final long NANOS_PER_MICROS;
    private final long MICROS_PER_MILLIS;
    private final long MILLIS_PER_SECOND;
    private final long SECONDS_PER_DAY;
    private final long MICROS_PER_SECOND;
    private final long NANOS_PER_MILLIS;
    private final long NANOS_PER_SECOND;
    private final long MICROS_PER_DAY;
    private final long MILLIS_PER_MINUTE;
    private final long MILLIS_PER_HOUR;
    private final long MILLIS_PER_DAY;
    private final TimeZone TimeZoneGMT;
    private final TimeZone TimeZoneUTC;
    private final String TIMEZONE_OPTION;
    private final int SUNDAY;
    private final int MONDAY;
    private final int TUESDAY;
    private final int WEDNESDAY;
    private final int THURSDAY;
    private final int FRIDAY;
    private final int SATURDAY;
    private final int TRUNC_INVALID;
    private final int TRUNC_TO_MICROSECOND;
    private final int MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    private final int TRUNC_TO_MILLISECOND;
    private final int TRUNC_TO_SECOND;
    private final int TRUNC_TO_MINUTE;
    private final int TRUNC_TO_HOUR;
    private final int TRUNC_TO_DAY;
    private final int TRUNC_TO_WEEK;
    private final int MIN_LEVEL_OF_DATE_TRUNC;
    private final int TRUNC_TO_MONTH;
    private final int TRUNC_TO_QUARTER;
    private final int TRUNC_TO_YEAR;
    private final int TRUNC_TO_DECADE;
    private final int TRUNC_TO_CENTURY;
    private final int TRUNC_TO_MILLENNIUM;
    private final Regex specialValueRe;

    static {
        new DateTimeUtils$();
    }

    public final int JULIAN_DAY_OF_EPOCH() {
        return 2440588;
    }

    public final long NANOS_PER_MICROS() {
        return this.NANOS_PER_MICROS;
    }

    public final long MICROS_PER_MILLIS() {
        return this.MICROS_PER_MILLIS;
    }

    public final long MILLIS_PER_SECOND() {
        return this.MILLIS_PER_SECOND;
    }

    public final long SECONDS_PER_DAY() {
        return this.SECONDS_PER_DAY;
    }

    public final long MICROS_PER_SECOND() {
        return this.MICROS_PER_SECOND;
    }

    public final long NANOS_PER_MILLIS() {
        return this.NANOS_PER_MILLIS;
    }

    public final long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public final long MICROS_PER_DAY() {
        return this.MICROS_PER_DAY;
    }

    public final long MILLIS_PER_MINUTE() {
        return this.MILLIS_PER_MINUTE;
    }

    public final long MILLIS_PER_HOUR() {
        return this.MILLIS_PER_HOUR;
    }

    public final long MILLIS_PER_DAY() {
        return this.MILLIS_PER_DAY;
    }

    public final int to2001() {
        return -11323;
    }

    public final int YearZero() {
        return -17999;
    }

    public final int toYearZero() {
        return 7293527;
    }

    public final TimeZone TimeZoneGMT() {
        return this.TimeZoneGMT;
    }

    public final TimeZone TimeZoneUTC() {
        return this.TimeZoneUTC;
    }

    public String TIMEZONE_OPTION() {
        return this.TIMEZONE_OPTION;
    }

    public TimeZone defaultTimeZone() {
        return TimeZone.getDefault();
    }

    public ZoneId getZoneId(String timeZoneId) {
        return ZoneId.of(timeZoneId, ZoneId.SHORT_IDS);
    }

    public TimeZone getTimeZone(String timeZoneId) {
        return TimeZone.getTimeZone(this.getZoneId(timeZoneId));
    }

    public int millisToDays(long millisUtc) {
        return this.millisToDays(millisUtc, this.defaultTimeZone());
    }

    public int millisToDays(long millisUtc, TimeZone timeZone) {
        long millisLocal = millisUtc + (long)timeZone.getOffset(millisUtc);
        return (int)Math.floorDiv(millisLocal, this.MILLIS_PER_DAY());
    }

    public long daysToMillis(int days) {
        return this.daysToMillis(days, this.defaultTimeZone());
    }

    public long daysToMillis(int days, TimeZone timeZone) {
        long millisLocal = (long)days * this.MILLIS_PER_DAY();
        return millisLocal - this.getOffsetFromLocalMillis(millisLocal, timeZone);
    }

    public String timestampToString(TimestampFormatter tf, long us) {
        return tf.format(us);
    }

    public int fromJavaDate(Date date) {
        return this.millisToDays(date.getTime());
    }

    public Date toJavaDate(int daysSinceEpoch) {
        return new Date(this.daysToMillis(daysSinceEpoch));
    }

    public Timestamp toJavaTimestamp(long us) {
        return Timestamp.from(this.microsToInstant(us));
    }

    public long fromJavaTimestamp(Timestamp t) {
        return this.instantToMicros(t.toInstant());
    }

    public long fromJulianDay(int day, long nanoseconds) {
        long seconds = (long)(day - 2440588) * this.SECONDS_PER_DAY();
        return TimeUnit.SECONDS.toMicros(seconds) + TimeUnit.NANOSECONDS.toMicros(nanoseconds);
    }

    public Tuple2<Object, Object> toJulianDay(long us) {
        long julian_us = us + 2440588L * this.MICROS_PER_DAY();
        long day = julian_us / this.MICROS_PER_DAY();
        long micros = julian_us % this.MICROS_PER_DAY();
        return new Tuple2.mcIJ.sp((int)day, TimeUnit.MICROSECONDS.toNanos(micros));
    }

    public long toMillis(long us) {
        return Math.floorDiv(us, this.MICROS_PER_MILLIS());
    }

    public long fromMillis(long millis) {
        return TimeUnit.MILLISECONDS.toMicros(millis);
    }

    public int microsToEpochDays(long epochMicros, ZoneId zoneId) {
        return this.localDateToDays(this.microsToInstant(epochMicros).atZone(zoneId).toLocalDate());
    }

    public long epochDaysToMicros(int epochDays, ZoneId zoneId) {
        LocalDate localDate = LocalDate.ofEpochDay(epochDays);
        LocalTime zeroLocalTime = LocalTime.MIDNIGHT;
        LocalDateTime localDateTime = LocalDateTime.of(localDate, zeroLocalTime);
        return this.instantToMicros(localDateTime.atZone(zoneId).toInstant());
    }

    public Option<Object> stringToTimestamp(UTF8String s, ZoneId timeZoneId) {
        None$ none$;
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        None$ tz = None$.MODULE$;
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.trim().getBytes();
        Option<Object> specialTimestamp = this.convertSpecialTimestamp(bytes, timeZoneId);
        if (specialTimestamp.isDefined()) {
            return specialTimestamp;
        }
        int digitsMilli = 0;
        boolean justTime = false;
        for (j = 0; j < bytes.length; ++j) {
            byte b = bytes[j];
            int parsedValue = b - (byte)48;
            if (parsedValue < 0 || parsedValue > 9) {
                if (j == 0 && b == 84) {
                    justTime = true;
                    i += 3;
                    continue;
                }
                if (i < 2) {
                    if (b == 45) {
                        if (i == 0 && j != 4) {
                            return None$.MODULE$;
                        }
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        ++i;
                        continue;
                    }
                    if (i == 0 && b == 58) {
                        justTime = true;
                        segments[3] = currentSegmentValue;
                        currentSegmentValue = 0;
                        i = 4;
                        continue;
                    }
                    return None$.MODULE$;
                }
                if (i == 2) {
                    if (b == 32 || b == 84) {
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        ++i;
                        continue;
                    }
                    return None$.MODULE$;
                }
                if (i == 3 || i == 4) {
                    if (b == 58) {
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        ++i;
                        continue;
                    }
                    return None$.MODULE$;
                }
                if (i == 5 || i == 6) {
                    if (b == 90) {
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        ++i;
                        tz = new Some((Object)BoxesRunTime.boxToByte((byte)43));
                    } else if (b == 45 || b == 43) {
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        ++i;
                        tz = new Some((Object)BoxesRunTime.boxToByte((byte)b));
                    } else if (b == 46 && i == 5) {
                        segments[i] = currentSegmentValue;
                        currentSegmentValue = 0;
                        ++i;
                    } else {
                        return None$.MODULE$;
                    }
                    if (i != 6 || b == 46) continue;
                    ++i;
                    continue;
                }
                if (i < segments.length && (b == 58 || b == 32)) {
                    segments[i] = currentSegmentValue;
                    currentSegmentValue = 0;
                    ++i;
                    continue;
                }
                return None$.MODULE$;
            }
            if (i == 6) {
                ++digitsMilli;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        segments[i] = currentSegmentValue;
        if (!justTime && i == 0 && j != 4) {
            return None$.MODULE$;
        }
        while (digitsMilli < 6) {
            segments[6] = segments[6] * 10;
            ++digitsMilli;
        }
        while (digitsMilli > 6) {
            segments[6] = segments[6] / 10;
            --digitsMilli;
        }
        try {
            ZoneId zoneId;
            if (tz.isEmpty()) {
                zoneId = timeZoneId;
            } else {
                int sign = (char)BoxesRunTime.unboxToByte((Object)tz.get()) == '-' ? -1 : 1;
                zoneId = ZoneOffset.ofHoursMinutes(sign * segments[7], sign * segments[8]);
            }
            ZoneId zoneId2 = zoneId;
            long nanoseconds = TimeUnit.MICROSECONDS.toNanos(segments[6]);
            LocalTime localTime = LocalTime.of(segments[3], segments[4], segments[5], (int)nanoseconds);
            LocalDate localDate = justTime ? LocalDate.now(zoneId2) : LocalDate.of(segments[0], segments[1], segments[2]);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId2);
            Instant instant = Instant.from(zonedDateTime);
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)this.instantToMicros(instant)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public long instantToMicros(Instant instant) {
        long us = Math.multiplyExact(instant.getEpochSecond(), this.MICROS_PER_SECOND());
        long result = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
        return result;
    }

    public Instant microsToInstant(long us) {
        long secs = Math.floorDiv(us, this.MICROS_PER_SECOND());
        long mos = Math.floorMod(us, this.MICROS_PER_SECOND());
        return Instant.ofEpochSecond(secs, mos * this.NANOS_PER_MICROS());
    }

    public int instantToDays(Instant instant) {
        long seconds = instant.getEpochSecond();
        long days = Math.floorDiv(seconds, this.SECONDS_PER_DAY());
        return (int)days;
    }

    public int localDateToDays(LocalDate localDate) {
        return Math.toIntExact(localDate.toEpochDay());
    }

    public LocalDate daysToLocalDate(int days) {
        return LocalDate.ofEpochDay(days);
    }

    public Option<Object> stringToDate(UTF8String s, ZoneId zoneId) {
        Some some;
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.trim().getBytes();
        Option<Object> specialDate = this.convertSpecialDate(bytes, zoneId);
        if (specialDate.isDefined()) {
            return specialDate;
        }
        for (j = 0; j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84; ++j) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (i == 0 && j != 4) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                ++i;
                continue;
            }
            int parsedValue = b - (byte)48;
            if (parsedValue < 0 || parsedValue > 9) {
                return None$.MODULE$;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        if (i == 0 && j != 4) {
            return None$.MODULE$;
        }
        if (i < 2 && j < bytes.length) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        try {
            LocalDate localDate = LocalDate.of(segments[0], segments[1], segments[2]);
            some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localDateToDays(localDate)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private long absoluteMicroSecond(long microsec) {
        return microsec + 7293527L * this.MICROS_PER_DAY();
    }

    private long localTimestamp(long microsec, TimeZone timeZone) {
        long zoneOffsetUs = TimeUnit.MILLISECONDS.toMicros(timeZone.getOffset(TimeUnit.MICROSECONDS.toMillis(microsec)));
        return this.absoluteMicroSecond(microsec) + zoneOffsetUs;
    }

    public int getHours(long microsec, TimeZone timeZone) {
        return (int)(TimeUnit.MICROSECONDS.toHours(this.localTimestamp(microsec, timeZone)) % 24L);
    }

    public int getMinutes(long microsec, TimeZone timeZone) {
        return (int)(TimeUnit.MICROSECONDS.toMinutes(this.localTimestamp(microsec, timeZone)) % 60L);
    }

    public int getSeconds(long microsec, TimeZone timeZone) {
        return (int)(TimeUnit.MICROSECONDS.toSeconds(this.localTimestamp(microsec, timeZone)) % 60L);
    }

    public Decimal getSecondsWithFraction(long microsec, TimeZone timeZone) {
        long secFrac = this.localTimestamp(microsec, timeZone) % (this.MILLIS_PER_MINUTE() * this.MICROS_PER_MILLIS());
        return Decimal$.MODULE$.apply(secFrac, 8, 6);
    }

    public Decimal getMilliseconds(long timestamp, TimeZone timeZone) {
        return Decimal$.MODULE$.apply(this.getMicroseconds(timestamp, timeZone), 8, 3);
    }

    public int getMicroseconds(long timestamp, TimeZone timeZone) {
        return (int)Math.floorMod(this.localTimestamp(timestamp, timeZone), this.MICROS_PER_SECOND() * 60L);
    }

    public int getDayInYear(int date) {
        return LocalDate.ofEpochDay(date).getDayOfYear();
    }

    private int extractFromYear(int date, int divider) {
        int result;
        block1: {
            LocalDate localDate = this.daysToLocalDate(date);
            int yearOfEra = localDate.get(ChronoField.YEAR_OF_ERA);
            result = yearOfEra / divider;
            if (yearOfEra % divider != 0 || yearOfEra <= 1) {
                ++result;
            }
            if (localDate.get(ChronoField.ERA) != 0) break block1;
            result = -result;
        }
        return result;
    }

    public int getMillennium(int date) {
        return this.extractFromYear(date, 1000);
    }

    public int getCentury(int date) {
        return this.extractFromYear(date, 100);
    }

    public int getDecade(int date) {
        return Math.floorDiv(this.getYear(date), 10);
    }

    public int getYear(int date) {
        return LocalDate.ofEpochDay(date).getYear();
    }

    public int getIsoYear(int date) {
        return this.daysToLocalDate(date).get(IsoFields.WEEK_BASED_YEAR);
    }

    public int getQuarter(int date) {
        return LocalDate.ofEpochDay(date).get(IsoFields.QUARTER_OF_YEAR);
    }

    public Tuple4<Object, Object, Object, Object> splitDate(int date) {
        LocalDate ld = LocalDate.ofEpochDay(date);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)ld.getYear()), (Object)BoxesRunTime.boxToInteger((int)ld.getMonthValue()), (Object)BoxesRunTime.boxToInteger((int)ld.getDayOfMonth()), (Object)BoxesRunTime.boxToInteger((int)(ld.lengthOfMonth() - ld.getDayOfMonth())));
    }

    public int getMonth(int date) {
        return LocalDate.ofEpochDay(date).getMonthValue();
    }

    public int getDayOfMonth(int date) {
        return LocalDate.ofEpochDay(date).getDayOfMonth();
    }

    public int dateAddMonths(int days, int months) {
        return (int)LocalDate.ofEpochDay(days).plusMonths(months).toEpochDay();
    }

    public long timestampAddInterval(long start, int months, long microseconds, ZoneId zoneId) {
        ZonedDateTime resultTimestamp = this.microsToInstant(start).atZone(zoneId).plusMonths(months).plus(microseconds, ChronoUnit.MICROS);
        return this.instantToMicros(resultTimestamp.toInstant());
    }

    public double monthsBetween(long time1, long time2, boolean roundOff, TimeZone timeZone) {
        long millis1 = TimeUnit.MICROSECONDS.toMillis(time1);
        long millis2 = TimeUnit.MICROSECONDS.toMillis(time2);
        int date1 = this.millisToDays(millis1, timeZone);
        int date2 = this.millisToDays(millis2, timeZone);
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date1);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int year1 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int monthInYear1 = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int dayInMonth1 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int daysToMonthEnd1 = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year1), (Object)BoxesRunTime.boxToInteger((int)monthInYear1), (Object)BoxesRunTime.boxToInteger((int)dayInMonth1), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd1));
        Tuple4 tuple43 = tuple42;
        int year12 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int monthInYear12 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int dayInMonth12 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int daysToMonthEnd12 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        Tuple4<Object, Object, Object, Object> tuple44 = this.splitDate(date2);
        if (tuple44 == null) {
            throw new MatchError(tuple44);
        }
        int year2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
        int dayInMonth2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        Tuple4 tuple45 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear2), (Object)BoxesRunTime.boxToInteger((int)dayInMonth2), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd2));
        Tuple4 tuple46 = tuple45;
        int year22 = BoxesRunTime.unboxToInt((Object)tuple46._1());
        int monthInYear22 = BoxesRunTime.unboxToInt((Object)tuple46._2());
        int dayInMonth22 = BoxesRunTime.unboxToInt((Object)tuple46._3());
        int daysToMonthEnd22 = BoxesRunTime.unboxToInt((Object)tuple46._4());
        int months1 = year12 * 12 + monthInYear12;
        int months2 = year22 * 12 + monthInYear22;
        double monthDiff = months1 - months2;
        if (dayInMonth12 == dayInMonth22 || daysToMonthEnd12 == 0 && daysToMonthEnd22 == 0) {
            return monthDiff;
        }
        long secondsInDay1 = TimeUnit.MILLISECONDS.toSeconds(millis1 - this.daysToMillis(date1, timeZone));
        long secondsInDay2 = TimeUnit.MILLISECONDS.toSeconds(millis2 - this.daysToMillis(date2, timeZone));
        long secondsDiff = (long)(dayInMonth12 - dayInMonth22) * this.SECONDS_PER_DAY() + secondsInDay1 - secondsInDay2;
        long secondsInMonth = TimeUnit.DAYS.toSeconds(31L);
        double diff = monthDiff + (double)secondsDiff / (double)secondsInMonth;
        return roundOff ? (double)package$.MODULE$.round(diff * 1.0E8) / 1.0E8 : diff;
    }

    private int SUNDAY() {
        return this.SUNDAY;
    }

    private int MONDAY() {
        return this.MONDAY;
    }

    private int TUESDAY() {
        return this.TUESDAY;
    }

    private int WEDNESDAY() {
        return this.WEDNESDAY;
    }

    private int THURSDAY() {
        return this.THURSDAY;
    }

    private int FRIDAY() {
        return this.FRIDAY;
    }

    private int SATURDAY() {
        return this.SATURDAY;
    }

    public int getDayOfWeekFromString(UTF8String string) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        String dowString = string.toString().toUpperCase(Locale.ROOT);
        String string2 = dowString;
        boolean bl7 = "SU".equals(string2) ? true : ("SUN".equals(string2) ? true : "SUNDAY".equals(string2));
        int n = bl7 ? this.SUNDAY() : ((bl6 = "MO".equals(string2) ? true : ("MON".equals(string2) ? true : "MONDAY".equals(string2))) ? this.MONDAY() : ((bl5 = "TU".equals(string2) ? true : ("TUE".equals(string2) ? true : "TUESDAY".equals(string2))) ? this.TUESDAY() : ((bl4 = "WE".equals(string2) ? true : ("WED".equals(string2) ? true : "WEDNESDAY".equals(string2))) ? this.WEDNESDAY() : ((bl3 = "TH".equals(string2) ? true : ("THU".equals(string2) ? true : "THURSDAY".equals(string2))) ? this.THURSDAY() : ((bl2 = "FR".equals(string2) ? true : ("FRI".equals(string2) ? true : "FRIDAY".equals(string2))) ? this.FRIDAY() : ((bl = "SA".equals(string2) ? true : ("SAT".equals(string2) ? true : "SATURDAY".equals(string2))) ? this.SATURDAY() : -1))))));
        return n;
    }

    public int getNextDateForDayOfWeek(int startDate, int dayOfWeek) {
        return startDate + 1 + ((dayOfWeek - 1 - startDate) % 7 + 7) % 7;
    }

    public int getLastDayOfMonth(int date) {
        LocalDate localDate = LocalDate.ofEpochDay(date);
        return date - localDate.getDayOfMonth() + localDate.lengthOfMonth();
    }

    public int TRUNC_INVALID() {
        return this.TRUNC_INVALID;
    }

    public int TRUNC_TO_MICROSECOND() {
        return this.TRUNC_TO_MICROSECOND;
    }

    public int MIN_LEVEL_OF_TIMESTAMP_TRUNC() {
        return this.MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    }

    public int TRUNC_TO_MILLISECOND() {
        return this.TRUNC_TO_MILLISECOND;
    }

    public int TRUNC_TO_SECOND() {
        return this.TRUNC_TO_SECOND;
    }

    public int TRUNC_TO_MINUTE() {
        return this.TRUNC_TO_MINUTE;
    }

    public int TRUNC_TO_HOUR() {
        return this.TRUNC_TO_HOUR;
    }

    public int TRUNC_TO_DAY() {
        return this.TRUNC_TO_DAY;
    }

    public int TRUNC_TO_WEEK() {
        return this.TRUNC_TO_WEEK;
    }

    public int MIN_LEVEL_OF_DATE_TRUNC() {
        return this.MIN_LEVEL_OF_DATE_TRUNC;
    }

    public int TRUNC_TO_MONTH() {
        return this.TRUNC_TO_MONTH;
    }

    public int TRUNC_TO_QUARTER() {
        return this.TRUNC_TO_QUARTER;
    }

    public int TRUNC_TO_YEAR() {
        return this.TRUNC_TO_YEAR;
    }

    public int TRUNC_TO_DECADE() {
        return this.TRUNC_TO_DECADE;
    }

    public int TRUNC_TO_CENTURY() {
        return this.TRUNC_TO_CENTURY;
    }

    public int TRUNC_TO_MILLENNIUM() {
        return this.TRUNC_TO_MILLENNIUM;
    }

    public int truncDate(int d, int level) {
        int n;
        int n2 = level;
        if (this.TRUNC_TO_WEEK() == n2) {
            n = this.getNextDateForDayOfWeek(d - 7, this.MONDAY());
        } else if (this.TRUNC_TO_MONTH() == n2) {
            n = d - this.getDayOfMonth(d) + 1;
        } else if (this.TRUNC_TO_QUARTER() == n2) {
            n = this.localDateToDays(this.daysToLocalDate(d).with(IsoFields.DAY_OF_QUARTER, 1L));
        } else if (this.TRUNC_TO_YEAR() == n2) {
            n = d - this.getDayInYear(d) + 1;
        } else if (this.TRUNC_TO_DECADE() == n2) {
            n = this.truncToYearLevel$1(10, 0, d);
        } else if (this.TRUNC_TO_CENTURY() == n2) {
            n = this.truncToYearLevel$1(100, 1, d);
        } else if (this.TRUNC_TO_MILLENNIUM() == n2) {
            n = this.truncToYearLevel$1(1000, 1, d);
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(21).append("Invalid trunc level: ").append(level).toString());
        }
        return n;
    }

    public long truncTimestamp(long t, int level, TimeZone timeZone) {
        long l;
        if (level == this.TRUNC_TO_MICROSECOND()) {
            return t;
        }
        long millis = TimeUnit.MICROSECONDS.toMillis(t);
        int n = level;
        if (this.TRUNC_TO_MILLISECOND() == n) {
            l = millis;
        } else if (this.TRUNC_TO_SECOND() == n) {
            l = millis - millis % this.MILLIS_PER_SECOND();
        } else if (this.TRUNC_TO_MINUTE() == n) {
            l = millis - millis % this.MILLIS_PER_MINUTE();
        } else if (this.TRUNC_TO_HOUR() == n) {
            int offset = timeZone.getOffset(millis);
            l = (millis += (long)offset) - millis % this.MILLIS_PER_HOUR() - (long)offset;
        } else if (this.TRUNC_TO_DAY() == n) {
            int offset = timeZone.getOffset(millis);
            l = (millis += (long)offset) - millis % this.MILLIS_PER_DAY() - (long)offset;
        } else {
            int dDays = this.millisToDays(millis, timeZone);
            l = this.daysToMillis(this.truncDate(dDays, level), timeZone);
        }
        long truncated = l;
        return truncated * this.MICROS_PER_MILLIS();
    }

    public int parseTruncLevel(UTF8String format) {
        int n;
        if (format == null) {
            n = this.TRUNC_INVALID();
        } else {
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string = format.toString().toUpperCase(Locale.ROOT);
            int n2 = "MICROSECOND".equals(string) ? this.TRUNC_TO_MICROSECOND() : ("MILLISECOND".equals(string) ? this.TRUNC_TO_MILLISECOND() : ("SECOND".equals(string) ? this.TRUNC_TO_SECOND() : ("MINUTE".equals(string) ? this.TRUNC_TO_MINUTE() : ("HOUR".equals(string) ? this.TRUNC_TO_HOUR() : ((bl3 = "DAY".equals(string) ? true : "DD".equals(string)) ? this.TRUNC_TO_DAY() : ("WEEK".equals(string) ? this.TRUNC_TO_WEEK() : ((bl2 = "MON".equals(string) ? true : ("MONTH".equals(string) ? true : "MM".equals(string))) ? this.TRUNC_TO_MONTH() : ("QUARTER".equals(string) ? this.TRUNC_TO_QUARTER() : ((bl = "YEAR".equals(string) ? true : ("YYYY".equals(string) ? true : "YY".equals(string))) ? this.TRUNC_TO_YEAR() : ("DECADE".equals(string) ? this.TRUNC_TO_DECADE() : ("CENTURY".equals(string) ? this.TRUNC_TO_CENTURY() : ("MILLENNIUM".equals(string) ? this.TRUNC_TO_MILLENNIUM() : this.TRUNC_INVALID()))))))))))));
            n = n2;
        }
        return n;
    }

    public long getOffsetFromLocalMillis(long millisLocal, TimeZone tz) {
        int guess;
        block0: {
            guess = tz.getRawOffset();
            int offset = tz.getOffset(millisLocal - (long)guess);
            if (offset == guess || (guess = tz.getOffset(millisLocal - (long)offset)) == offset) break block0;
            LocalDate localDate = LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(millisLocal));
            LocalTime localTime = LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(Math.floorMod(millisLocal, this.MILLIS_PER_DAY())));
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            long millisEpoch = localDateTime.atZone(tz.toZoneId()).toInstant().toEpochMilli();
            guess = (int)(millisLocal - millisEpoch);
        }
        return guess;
    }

    public long convertTz(long ts, TimeZone fromZone, TimeZone toZone) {
        long l;
        long l2;
        TimeZone localZone = this.defaultTimeZone();
        String string = fromZone.getID();
        String string2 = localZone.getID();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            l2 = ts;
        } else {
            int localZoneOffsetMs = localZone.getOffset(TimeUnit.MICROSECONDS.toMillis(ts));
            long localTsUs = ts + TimeUnit.MILLISECONDS.toMicros(localZoneOffsetMs);
            long offsetFromLocalMs = this.getOffsetFromLocalMillis(TimeUnit.MICROSECONDS.toMillis(localTsUs), fromZone);
            l2 = localTsUs - TimeUnit.MILLISECONDS.toMicros(offsetFromLocalMs);
        }
        long utcTs = l2;
        String string3 = toZone.getID();
        String string4 = localZone.getID();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            l = utcTs;
        } else {
            int toZoneOffsetMs = toZone.getOffset(TimeUnit.MICROSECONDS.toMillis(utcTs));
            long localTsUs = utcTs + TimeUnit.MILLISECONDS.toMicros(toZoneOffsetMs);
            long offsetFromLocalMs = this.getOffsetFromLocalMillis(TimeUnit.MICROSECONDS.toMillis(localTsUs), localZone);
            l = localTsUs - TimeUnit.MILLISECONDS.toMicros(offsetFromLocalMs);
        }
        return l;
    }

    public long fromUTCTime(long time, String timeZone) {
        return this.convertTz(time, this.TimeZoneGMT(), this.getTimeZone(timeZone));
    }

    public long toUTCTime(long time, String timeZone) {
        return this.convertTz(time, this.getTimeZone(timeZone), this.TimeZoneGMT());
    }

    public Decimal getEpoch(long timestamp, ZoneId zoneId) {
        long offset = TimeUnit.SECONDS.toMicros(zoneId.getRules().getOffset(this.microsToInstant(timestamp)).getTotalSeconds());
        long sinceEpoch = timestamp + offset;
        return Decimal$.MODULE$.apply(sinceEpoch, 20, 6);
    }

    public long currentTimestamp() {
        return this.instantToMicros(Instant.now());
    }

    public int currentDate(ZoneId zoneId) {
        return this.localDateToDays(LocalDate.now(zoneId));
    }

    private ZonedDateTime today(ZoneId zoneId) {
        return Instant.now().atZone(zoneId).with(LocalTime.MIDNIGHT);
    }

    private Regex specialValueRe() {
        return this.specialValueRe;
    }

    private Option<String> extractSpecialValue(String input, ZoneId zoneId) {
        String z;
        String v;
        Predef$.MODULE$.assert(input.trim().length() == input.length());
        if (input.length() < 3 || !RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), 0)))) {
            return None$.MODULE$;
        }
        String string = input;
        Option option = this.specialValueRe().unapplySeq((CharSequence)string);
        Object object = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0 && this.isValid$1(v = (String)((LinearSeqOptimized)option.get()).apply(0), z = (String)((LinearSeqOptimized)option.get()).apply(1)) ? new Some((Object)v.toLowerCase(Locale.US)) : None$.MODULE$;
        return object;
    }

    public Option<Object> convertSpecialTimestamp(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input, zoneId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            Object object = "epoch".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)0L)) : ("now".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.currentTimestamp())) : ("today".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).toInstant()))) : ("tomorrow".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).plusDays(1L).toInstant()))) : ("yesterday".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).minusDays(1L).toInstant()))) : None$.MODULE$))));
            return object;
        });
    }

    private Option<Object> convertSpecialTimestamp(byte[] bytes, ZoneId zoneId) {
        return bytes.length > 0 && Character.isAlphabetic(bytes[0]) ? this.convertSpecialTimestamp(new String(bytes, StandardCharsets.UTF_8), zoneId) : None$.MODULE$;
    }

    public Option<Object> convertSpecialDate(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input, zoneId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl;
            String string = x0$1;
            Object object = "epoch".equals(string) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : ((bl = "now".equals(string) ? true : "today".equals(string)) ? new Some((Object)BoxesRunTime.boxToInteger((int)MODULE$.currentDate(zoneId))) : ("tomorrow".equals(string) ? new Some((Object)BoxesRunTime.boxToInteger((int)Math.addExact(MODULE$.currentDate(zoneId), 1))) : ("yesterday".equals(string) ? new Some((Object)BoxesRunTime.boxToInteger((int)Math.subtractExact(MODULE$.currentDate(zoneId), 1))) : None$.MODULE$)));
            return object;
        });
    }

    private Option<Object> convertSpecialDate(byte[] bytes, ZoneId zoneId) {
        return bytes.length > 0 && Character.isAlphabetic(bytes[0]) ? this.convertSpecialDate(new String(bytes, StandardCharsets.UTF_8), zoneId) : None$.MODULE$;
    }

    public CalendarInterval subtractDates(int endDate, int startDate) {
        Period period = Period.between(LocalDate.ofEpochDay(startDate), LocalDate.ofEpochDay(endDate));
        int months = period.getMonths() + 12 * period.getYears();
        long microseconds = (long)period.getDays() * this.MICROS_PER_DAY();
        return new CalendarInterval(months, microseconds);
    }

    private final int truncToYearLevel$1(int divider, int adjust, int d$1) {
        int oldYear = this.getYear(d$1);
        int newYear = Math.floorDiv(oldYear, divider);
        if (adjust > 0 && Math.floorMod(oldYear, divider) == 0) {
            --newYear;
        }
        newYear = newYear * divider + adjust;
        return this.localDateToDays(LocalDate.of(newYear, 1, 1));
    }

    private final boolean isValid$1(String value, String timeZoneId) {
        boolean bl;
        if (timeZoneId.isEmpty()) {
            return true;
        }
        if (value.compareToIgnoreCase("now") == 0) {
            return false;
        }
        try {
            this.getZoneId(timeZoneId);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private DateTimeUtils$() {
        MODULE$ = this;
        this.NANOS_PER_MICROS = 1000L;
        this.MICROS_PER_MILLIS = 1000L;
        this.MILLIS_PER_SECOND = 1000L;
        this.SECONDS_PER_DAY = 86400L;
        this.MICROS_PER_SECOND = this.MILLIS_PER_SECOND() * this.MICROS_PER_MILLIS();
        this.NANOS_PER_MILLIS = this.NANOS_PER_MICROS() * this.MICROS_PER_MILLIS();
        this.NANOS_PER_SECOND = this.NANOS_PER_MICROS() * this.MICROS_PER_SECOND();
        this.MICROS_PER_DAY = this.SECONDS_PER_DAY() * this.MICROS_PER_SECOND();
        this.MILLIS_PER_MINUTE = 60L * this.MILLIS_PER_SECOND();
        this.MILLIS_PER_HOUR = 60L * this.MILLIS_PER_MINUTE();
        this.MILLIS_PER_DAY = this.SECONDS_PER_DAY() * this.MILLIS_PER_SECOND();
        this.TimeZoneGMT = TimeZone.getTimeZone("GMT");
        this.TimeZoneUTC = TimeZone.getTimeZone("UTC");
        this.TIMEZONE_OPTION = "timeZone";
        this.SUNDAY = 3;
        this.MONDAY = 4;
        this.TUESDAY = 5;
        this.WEDNESDAY = 6;
        this.THURSDAY = 0;
        this.FRIDAY = 1;
        this.SATURDAY = 2;
        this.TRUNC_INVALID = -1;
        this.TRUNC_TO_MICROSECOND = 0;
        this.MIN_LEVEL_OF_TIMESTAMP_TRUNC = this.TRUNC_TO_MICROSECOND();
        this.TRUNC_TO_MILLISECOND = 1;
        this.TRUNC_TO_SECOND = 2;
        this.TRUNC_TO_MINUTE = 3;
        this.TRUNC_TO_HOUR = 4;
        this.TRUNC_TO_DAY = 5;
        this.TRUNC_TO_WEEK = 6;
        this.MIN_LEVEL_OF_DATE_TRUNC = this.TRUNC_TO_WEEK();
        this.TRUNC_TO_MONTH = 7;
        this.TRUNC_TO_QUARTER = 8;
        this.TRUNC_TO_YEAR = 9;
        this.TRUNC_TO_DECADE = 10;
        this.TRUNC_TO_CENTURY = 11;
        this.TRUNC_TO_MILLENNIUM = 12;
        this.specialValueRe = new StringOps(Predef$.MODULE$.augmentString("(\\p{Alpha}+)\\p{Blank}*(.*)")).r();
    }
}

