/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class IntervalUtils$ {
    public static IntervalUtils$ MODULE$;
    private final int MONTHS_PER_YEAR;
    private final byte MONTHS_PER_QUARTER;
    private final int YEARS_PER_MILLENNIUM;
    private final int YEARS_PER_CENTURY;
    private final int YEARS_PER_DECADE;
    private final long MICROS_PER_HOUR;
    private final long MICROS_PER_MINUTE;
    private final byte DAYS_PER_MONTH;
    private final long MICROS_PER_MONTH;
    private final long MICROS_PER_YEAR;
    private final Regex yearMonthPattern;
    private final Regex dayTimePattern;

    static {
        new IntervalUtils$();
    }

    public final int MONTHS_PER_YEAR() {
        return this.MONTHS_PER_YEAR;
    }

    public final byte MONTHS_PER_QUARTER() {
        return this.MONTHS_PER_QUARTER;
    }

    public final int YEARS_PER_MILLENNIUM() {
        return this.YEARS_PER_MILLENNIUM;
    }

    public final int YEARS_PER_CENTURY() {
        return this.YEARS_PER_CENTURY;
    }

    public final int YEARS_PER_DECADE() {
        return this.YEARS_PER_DECADE;
    }

    public final long MICROS_PER_HOUR() {
        return this.MICROS_PER_HOUR;
    }

    public final long MICROS_PER_MINUTE() {
        return this.MICROS_PER_MINUTE;
    }

    public final byte DAYS_PER_MONTH() {
        return this.DAYS_PER_MONTH;
    }

    public final long MICROS_PER_MONTH() {
        return this.MICROS_PER_MONTH;
    }

    public final long MICROS_PER_YEAR() {
        return this.MICROS_PER_YEAR;
    }

    public int getYears(CalendarInterval interval) {
        return interval.months / this.MONTHS_PER_YEAR();
    }

    public int getMillenniums(CalendarInterval interval) {
        return this.getYears(interval) / this.YEARS_PER_MILLENNIUM();
    }

    public int getCenturies(CalendarInterval interval) {
        return this.getYears(interval) / this.YEARS_PER_CENTURY();
    }

    public int getDecades(CalendarInterval interval) {
        return this.getYears(interval) / this.YEARS_PER_DECADE();
    }

    public byte getMonths(CalendarInterval interval) {
        return (byte)(interval.months % this.MONTHS_PER_YEAR());
    }

    public byte getQuarters(CalendarInterval interval) {
        return (byte)(this.getMonths(interval) / this.MONTHS_PER_QUARTER() + 1);
    }

    public long getDays(CalendarInterval interval) {
        return interval.microseconds / DateTimeUtils$.MODULE$.MICROS_PER_DAY();
    }

    public byte getHours(CalendarInterval interval) {
        return (byte)(interval.microseconds % DateTimeUtils$.MODULE$.MICROS_PER_DAY() / this.MICROS_PER_HOUR());
    }

    public byte getMinutes(CalendarInterval interval) {
        return (byte)(interval.microseconds % this.MICROS_PER_HOUR() / this.MICROS_PER_MINUTE());
    }

    public long getMicroseconds(CalendarInterval interval) {
        return interval.microseconds % this.MICROS_PER_MINUTE();
    }

    public Decimal getSeconds(CalendarInterval interval) {
        return Decimal$.MODULE$.apply(this.getMicroseconds(interval), 8, 6);
    }

    public Decimal getMilliseconds(CalendarInterval interval) {
        return Decimal$.MODULE$.apply(this.getMicroseconds(interval), 8, 3);
    }

    public Decimal getEpoch(CalendarInterval interval) {
        long result = interval.microseconds;
        result += this.MICROS_PER_YEAR() * (long)(interval.months / this.MONTHS_PER_YEAR());
        return Decimal$.MODULE$.apply(result += this.MICROS_PER_MONTH() * (long)(interval.months % this.MONTHS_PER_YEAR()), 18, 6);
    }

    public CalendarInterval fromString(String str) {
        CalendarInterval calendarInterval;
        if (str == null) {
            throw new IllegalArgumentException("Interval string cannot be null");
        }
        try {
            calendarInterval = CatalystSqlParser$.MODULE$.parseInterval(str);
        }
        catch (ParseException e) {
            IllegalArgumentException ex = new IllegalArgumentException(new StringBuilder(26).append("Invalid interval string: ").append(str).append("\n").append(e.message()).toString());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        return calendarInterval;
    }

    public CalendarInterval safeFromString(String str) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.fromString(str);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    private long toLongWithRange(String fieldName, String s, long minValue, long maxValue) {
        long result = s == null ? 0L : new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
        Predef$.MODULE$.require(minValue <= result && result <= maxValue, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(fieldName).append(" ").append(result).append(" outside range [").append(minValue).append(", ").append(maxValue).append("]").toString());
        return result;
    }

    private Regex yearMonthPattern() {
        return this.yearMonthPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarInterval fromYearMonthString(String input) {
        Option option;
        Predef$.MODULE$.require(input != null, (Function0 & Serializable & scala.Serializable)() -> "Interval year-month string must be not null");
        Predef$.MODULE$.assert(input.length() == input.trim().length());
        String string = input;
        Option option2 = this.yearMonthPattern().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String yearStr = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String monthStr = (String)((LinearSeqOptimized)option2.get()).apply(2);
            if ("-".equals(string2)) {
                return this.toInterval$1(yearStr, monthStr).negate();
            }
        }
        if ((option = this.yearMonthPattern().unapplySeq((CharSequence)string)).isEmpty()) throw new IllegalArgumentException(new StringBuilder(59).append("Interval string does not match year-month format of 'y-m': ").append(input).toString());
        if (option.get() == null) throw new IllegalArgumentException(new StringBuilder(59).append("Interval string does not match year-month format of 'y-m': ").append(input).toString());
        if (((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) throw new IllegalArgumentException(new StringBuilder(59).append("Interval string does not match year-month format of 'y-m': ").append(input).toString());
        String yearStr = (String)((LinearSeqOptimized)option.get()).apply(1);
        String monthStr = (String)((LinearSeqOptimized)option.get()).apply(2);
        return this.toInterval$1(yearStr, monthStr);
    }

    public CalendarInterval fromDayTimeString(String s) {
        return this.fromDayTimeString(s, "day", "second");
    }

    private Regex dayTimePattern() {
        return this.dayTimePattern;
    }

    /*
     * Unable to fully structure code
     */
    public CalendarInterval fromDayTimeString(String input, String from, String to) {
        Predef$.MODULE$.require(input != null, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromDayTimeString$1(), ()Ljava/lang/String;)());
        Predef$.MODULE$.assert(input.length() == input.trim().length());
        m = this.dayTimePattern().pattern().matcher(input);
        Predef$.MODULE$.require(m.matches(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromDayTimeString$2(java.lang.String ), ()Ljava/lang/String;)((String)input));
        try {
            if (m.group(1) == null) ** GOTO lbl-1000
            v0 = m.group(1);
            var7_5 = "-";
            if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
                v1 = -1;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 1;
            }
            sign = v1;
            days = m.group(2) == null ? 0L : this.toLongWithRange("day", m.group(3), 0L, 0x7FFFFFFFL);
            hours = 0L;
            minutes = 0L;
            seconds = 0L;
            if (m.group(5) != null) ** GOTO lbl-1000
            v2 = from;
            var16_11 = "minute";
            if (!(v2 != null ? v2.equals(var16_11) == false : var16_11 != null)) lbl-1000:
            // 2 sources

            {
                hours = this.toLongWithRange("hour", m.group(5), 0L, 23L);
                minutes = this.toLongWithRange("minute", m.group(6), 0L, 59L);
                seconds = this.toLongWithRange("second", m.group(7), 0L, 59L);
            } else if (m.group(8) != null) {
                minutes = this.toLongWithRange("minute", m.group(6), 0L, 59L);
                seconds = this.toLongWithRange("second", m.group(7), 0L, 59L);
            } else {
                hours = this.toLongWithRange("hour", m.group(6), 0L, 23L);
                minutes = this.toLongWithRange("second", m.group(7), 0L, 59L);
            }
            nanoStr = m.group(9) == null ? null : new StringBuilder(9).append(m.group(9)).append("000000000").toString().substring(0, 9);
            nanos = this.toLongWithRange("nanosecond", nanoStr, 0L, 999999999L);
            var20_14 = to;
            if ("hour".equals(var20_14)) {
                minutes = 0L;
                seconds = 0L;
                nanos = 0L;
                var4_15 = BoxedUnit.UNIT;
            } else if ("minute".equals(var20_14)) {
                seconds = 0L;
                nanos = 0L;
                var4_16 = BoxedUnit.UNIT;
            } else if ("second".equals(var20_14)) {
                var4_17 = BoxedUnit.UNIT;
            } else {
                throw new IllegalArgumentException(new StringBuilder(44).append("Cannot support (interval '").append(input).append("' ").append(from).append(" to ").append(to).append(") expression").toString());
            }
            micros = nanos / DateTimeUtils$.MODULE$.NANOS_PER_MICROS();
            micros = Math.addExact(micros, Math.multiplyExact(days, DateTimeUtils$.MODULE$.MICROS_PER_DAY()));
            micros = Math.addExact(micros, Math.multiplyExact(hours, this.MICROS_PER_HOUR()));
            micros = Math.addExact(micros, Math.multiplyExact(minutes, this.MICROS_PER_MINUTE()));
            micros = Math.addExact(micros, Math.multiplyExact(seconds, DateTimeUtils$.MODULE$.MICROS_PER_SECOND()));
            v3 = new CalendarInterval(0, (long)sign * micros);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Error parsing interval day-time string: ").append(e.getMessage()).toString(), e);
        }
        return v3;
    }

    public CalendarInterval fromUnitStrings(String[] units, String[] values) {
        Predef$.MODULE$.assert(units.length == values.length);
        int months = 0;
        long microseconds = 0L;
        for (int i = 0; i < units.length; ++i) {
            try {
                BoxedUnit boxedUnit;
                String string = units[i];
                if ("year".equals(string)) {
                    months = Math.addExact(months, Math.multiplyExact(new StringOps(Predef$.MODULE$.augmentString(values[i])).toInt(), 12));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("month".equals(string)) {
                    months = Math.addExact(months, new StringOps(Predef$.MODULE$.augmentString(values[i])).toInt());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("week".equals(string)) {
                    long weeksUs = Math.multiplyExact(new StringOps(Predef$.MODULE$.augmentString(values[i])).toLong(), 7L * DateTimeUtils$.MODULE$.MICROS_PER_DAY());
                    microseconds = Math.addExact(microseconds, weeksUs);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("day".equals(string)) {
                    long daysUs = Math.multiplyExact(new StringOps(Predef$.MODULE$.augmentString(values[i])).toLong(), DateTimeUtils$.MODULE$.MICROS_PER_DAY());
                    microseconds = Math.addExact(microseconds, daysUs);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("hour".equals(string)) {
                    long hoursUs = Math.multiplyExact(new StringOps(Predef$.MODULE$.augmentString(values[i])).toLong(), this.MICROS_PER_HOUR());
                    microseconds = Math.addExact(microseconds, hoursUs);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("minute".equals(string)) {
                    long minutesUs = Math.multiplyExact(new StringOps(Predef$.MODULE$.augmentString(values[i])).toLong(), this.MICROS_PER_MINUTE());
                    microseconds = Math.addExact(microseconds, minutesUs);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("second".equals(string)) {
                    microseconds = Math.addExact(microseconds, this.parseSecondNano(values[i]));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("millisecond".equals(string)) {
                    long millisUs = Math.multiplyExact(new StringOps(Predef$.MODULE$.augmentString(values[i])).toLong(), DateTimeUtils$.MODULE$.MICROS_PER_MILLIS());
                    microseconds = Math.addExact(microseconds, millisUs);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if ("microsecond".equals(string)) {
                    microseconds = Math.addExact(microseconds, new StringOps(Predef$.MODULE$.augmentString(values[i])).toLong());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)string);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Error parsing interval string: ").append(e.getMessage()).toString(), e);
            }
        }
        return new CalendarInterval(months, microseconds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long parseSecondNano(String secondNano) {
        Option option;
        String[] stringArray = secondNano.split("\\.");
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String secondsStr = (String)((SeqLike)option2.get()).apply(0);
            return this.parseSeconds$1(secondsStr);
        }
        Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option3.get()).apply(0);
            String nanosStr = (String)((SeqLike)option3.get()).apply(1);
            if ("".equals(string)) {
                return this.parseNanos$1(nanosStr);
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        if (option.get() == null) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        if (((SeqLike)option.get()).lengthCompare(2) != 0) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        String secondsStr = (String)((SeqLike)option.get()).apply(0);
        String nanosStr = (String)((SeqLike)option.get()).apply(1);
        return Math.addExact(this.parseSeconds$1(secondsStr), this.parseNanos$1(nanosStr));
    }

    private final CalendarInterval toInterval$1(String yearStr, String monthStr) {
        CalendarInterval calendarInterval;
        try {
            int years = (int)this.toLongWithRange("year", yearStr, 0L, Integer.MAX_VALUE);
            int months = (int)this.toLongWithRange("month", monthStr, 0L, 11L);
            int totalMonths = Math.addExact(Math.multiplyExact(years, 12), months);
            calendarInterval = new CalendarInterval(totalMonths, 0L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(42).append("Error parsing interval year-month string: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        return calendarInterval;
    }

    public static final /* synthetic */ String $anonfun$fromDayTimeString$1() {
        return "Interval day-time string must be not null";
    }

    public static final /* synthetic */ String $anonfun$fromDayTimeString$2(String input$1) {
        return new StringBuilder(59).append("Interval string must match day-time format of 'd h:m:s.n': ").append(input$1).toString();
    }

    private final long parseSeconds$1(String secondsStr) {
        return this.toLongWithRange("second", secondsStr, Long.MIN_VALUE / DateTimeUtils$.MODULE$.MICROS_PER_SECOND(), Long.MAX_VALUE / DateTimeUtils$.MODULE$.MICROS_PER_SECOND()) * DateTimeUtils$.MODULE$.MICROS_PER_SECOND();
    }

    private final long parseNanos$1(String nanosStr) {
        return this.toLongWithRange("nanosecond", nanosStr, 0L, 999999999L) / DateTimeUtils$.MODULE$.NANOS_PER_MICROS();
    }

    private IntervalUtils$() {
        MODULE$ = this;
        this.MONTHS_PER_YEAR = 12;
        this.MONTHS_PER_QUARTER = (byte)3;
        this.YEARS_PER_MILLENNIUM = 1000;
        this.YEARS_PER_CENTURY = 100;
        this.YEARS_PER_DECADE = 10;
        this.MICROS_PER_HOUR = DateTimeUtils$.MODULE$.MILLIS_PER_HOUR() * DateTimeUtils$.MODULE$.MICROS_PER_MILLIS();
        this.MICROS_PER_MINUTE = DateTimeUtils$.MODULE$.MILLIS_PER_MINUTE() * DateTimeUtils$.MODULE$.MICROS_PER_MILLIS();
        this.DAYS_PER_MONTH = (byte)30;
        this.MICROS_PER_MONTH = (long)this.DAYS_PER_MONTH() * DateTimeUtils$.MODULE$.MICROS_PER_DAY();
        this.MICROS_PER_YEAR = 36525L * DateTimeUtils$.MODULE$.MICROS_PER_DAY() / 100L;
        this.yearMonthPattern = new StringOps(Predef$.MODULE$.augmentString("^([+|-])?(\\d+)-(\\d+)$")).r();
        this.dayTimePattern = new StringOps(Predef$.MODULE$.augmentString("^([+|-])?((\\d+) )?((\\d+):)?(\\d+):(\\d+)(\\.(\\d+))?$")).r();
    }
}

