/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m3A\u0001C\u0005\u0001-!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!I\u0004A!A!\u0002\u0013Q\u0004\"B \u0001\t\u0003\u0001\u0005\u0002C#\u0001\u0011\u000b\u0007I\u0011\u0003$\t\u000bE\u0003A\u0011\t*\t\u000b)\u0003A\u0011\t-\u00033%\u001bx\u000e\u000f\u001c1cQKW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\u0006\u0003\u0015-\tA!\u001e;jY*\u0011A\"D\u0001\tG\u0006$\u0018\r\\=ti*\u0011abD\u0001\u0004gFd'B\u0001\t\u0012\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M!\u0001aF\u000f\"!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adH\u0007\u0002\u0013%\u0011\u0001%\u0003\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'\u000f\u0005\u0002\u001fE%\u00111%\u0003\u0002\u0018\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b*\u001a7qKJ\fq\u0001]1ui\u0016\u0014h\u000e\u0005\u0002'[9\u0011qe\u000b\t\u0003Qei\u0011!\u000b\u0006\u0003UU\ta\u0001\u0010:p_Rt\u0014B\u0001\u0017\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0012A\u0002>p]\u0016LE\r\u0005\u00023o5\t1G\u0003\u00025k\u0005!A/[7f\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\ri{g.Z%e\u0003\u0019awnY1mKB\u00111(P\u0007\u0002y)\u0011!\"N\u0005\u0003}q\u0012a\u0001T8dC2,\u0017A\u0002\u001fj]&$h\b\u0006\u0003B\u0005\u000e#\u0005C\u0001\u0010\u0001\u0011\u0015!C\u00011\u0001&\u0011\u0015\u0001D\u00011\u00012\u0011\u0015ID\u00011\u0001;\u0003%1wN]7biR,'/F\u0001H!\tA5*D\u0001J\u0015\tQ5'\u0001\u0004g_Jl\u0017\r^\u0005\u0003\u0019&\u0013\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3sQ\t)a\n\u0005\u0002\u0019\u001f&\u0011\u0001+\u0007\u0002\niJ\fgn]5f]R\fQ\u0001]1sg\u0016$\"a\u0015,\u0011\u0005a!\u0016BA+\u001a\u0005\u0011auN\\4\t\u000b]3\u0001\u0019A\u0013\u0002\u0003M$\"!J-\t\u000bi;\u0001\u0019A*\u0002\u0005U\u001c\b")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public ZonedDateTime toZonedDateTime(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toZonedDateTime$(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        return !this.bitmap$trans$0 ? this.formatter$lzycompute() : this.formatter;
    }

    @Override
    public long parse(String s) {
        Option<Object> specialDate = DateTimeUtils$.MODULE$.convertSpecialTimestamp(s.trim(), this.zoneId);
        return BoxesRunTime.unboxToLong((Object)specialDate.getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> {
            TemporalAccessor parsed = this.formatter().parse(s);
            ZoneId parsedZoneId = parsed.query(TemporalQueries.zone());
            ZoneId timeZoneId = parsedZoneId == null ? $this.zoneId : parsedZoneId;
            ZonedDateTime zonedDateTime = this.toZonedDateTime(parsed, timeZoneId);
            long epochSeconds = zonedDateTime.toEpochSecond();
            int microsOfSecond = zonedDateTime.get(ChronoField.MICRO_OF_SECOND);
            return Math.addExact(TimeUnit.SECONDS.toMicros(epochSeconds), (long)microsOfSecond);
        }));
    }

    @Override
    public String format(long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        return this.formatter().withZone(this.zoneId).format(instant);
    }

    public Iso8601TimestampFormatter(String pattern, ZoneId zoneId, Locale locale) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
        DateTimeFormatterHelper.$init$(this);
    }
}

