/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Catalogs;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc!B\u000f\u001f\u0001\tR\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u000b\")Q\n\u0001C\u0001\u001d\"91\u000b\u0001b\u0001\n\u0013!\u0006B\u00025\u0001A\u0003%Q\u000bC\u0003 \u0001\u0011\u0005\u0011\u000eC\u0003m\u0001\u0011%Q\u000eC\u0003r\u0001\u0011%!\u000fC\u0003t\u0001\u0011%A\u000fC\u0003v\u0001\u0011%a\u000fC\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003;\u0001\u0001\u0015)\u0003\u0002\f!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\n\u0003W\u0001\u0001\u0019!C\u0005\u0003[A\u0011\"!\r\u0001\u0001\u0004%I!a\r\t\u0011\u0005]\u0002\u0001)Q\u0005\u0003_Aa!!\u000f\u0001\t\u0003!\bbBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\t\u0003\u0007\u0002A\u0011\u0001\u0012\u0002F\u001dA\u0011q\t\u0010\t\u0002\t\nIEB\u0004\u001e=!\u0005!%a\u0013\t\r5KB\u0011AA'\u0011%\ty%\u0007b\u0001\n\u0003\t\t\u0006C\u0004\u0002Te\u0001\u000b\u0011B/\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe*\u0011q\u0004I\u0001\bG\u0006$\u0018\r\\8h\u0015\t\t#%A\u0005d_:tWm\u0019;pe*\u00111\u0005J\u0001\u0004gFd'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0014\u0007\u0001Y\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003eUj\u0011a\r\u0006\u0003i\u0011\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003mM\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003uqj\u0011a\u000f\u0006\u0003i\tJ!!P\u001e\u0003\u000fM\u000bFjQ8oM\u0006)B-\u001a4bk2$8+Z:tS>t7)\u0019;bY><\u0007C\u0001!B\u001b\u0005q\u0012B\u0001\"\u001f\u00055\u0019\u0015\r^1m_\u001e\u0004F.^4j]\u0006\u0001b/M*fgNLwN\\\"bi\u0006dwnZ\u000b\u0002\u000bB\u0011aIS\u0007\u0002\u000f*\u0011q\u0004\u0013\u0006\u0003\u0013\n\n\u0001bY1uC2L8\u000f^\u0005\u0003\u0017\u001e\u0013abU3tg&|gnQ1uC2|w-A\twcM+7o]5p]\u000e\u000bG/\u00197pO\u0002\na\u0001P5oSRtD\u0003B(Q#J\u0003\"\u0001\u0011\u0001\t\u000b]*\u0001\u0019A\u001d\t\u000by*\u0001\u0019A \t\u000b\r+\u0001\u0019A#\u0002\u0011\r\fG/\u00197pON,\u0012!\u0016\t\u0005-nkv(D\u0001X\u0015\tA\u0016,A\u0004nkR\f'\r\\3\u000b\u0005ik\u0013AC2pY2,7\r^5p]&\u0011Al\u0016\u0002\b\u0011\u0006\u001c\b.T1q!\tqVM\u0004\u0002`GB\u0011\u0001-L\u0007\u0002C*\u0011!\rO\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011l\u0013A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z\u0017\u0002\u0013\r\fG/\u00197pON\u0004CCA k\u0011\u0015Y\u0007\u00021\u0001^\u0003\u0011q\u0017-\\3\u0002\u001d\u0011,g-Y;mi\u000e\u000bG/\u00197pOV\ta\u000eE\u0002-_~J!\u0001]\u0017\u0003\r=\u0003H/[8o\u0003Qaw.\u00193WeM+7o]5p]\u000e\u000bG/\u00197pOR\tq(\u0001\tweM+7o]5p]\u000e\u000bG/\u00197pOV\tq(A\nhKR$UMZ1vYRt\u0015-\\3ta\u0006\u001cW\rF\u0002x\u0003\u0007\u00012\u0001\f={\u0013\tIXFA\u0003BeJ\f\u0017\u0010E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fA\u0001\\1oO*\tq0\u0001\u0003kCZ\f\u0017B\u00014}\u0011\u0019\t)\u0001\u0004a\u0001\u007f\u0005\t1-A\t`GV\u0014(/\u001a8u\u001d\u0006lWm\u001d9bG\u0016,\"!a\u0003\u0011\t1z\u0017Q\u0002\t\u0004Yal\u0016!F0dkJ\u0014XM\u001c;OC6,7\u000f]1dK~#S-\u001d\u000b\u0005\u0003'\tI\u0002E\u0002-\u0003+I1!a\u0006.\u0005\u0011)f.\u001b;\t\u0013\u0005ma\"!AA\u0002\u0005-\u0011a\u0001=%c\u0005\u0011rlY;se\u0016tGOT1nKN\u0004\u0018mY3!\u0003A\u0019WO\u001d:f]Rt\u0015-\\3ta\u0006\u001cW-\u0006\u0002\u0002\u000e\u0005\u00192/\u001a;DkJ\u0014XM\u001c;OC6,7\u000f]1dKR!\u00111CA\u0014\u0011\u001d\tI#\u0005a\u0001\u0003\u001b\t\u0011B\\1nKN\u0004\u0018mY3\u0002'}\u001bWO\u001d:f]R\u001c\u0015\r^1m_\u001et\u0015-\\3\u0016\u0005\u0005=\u0002c\u0001\u0017p;\u00069rlY;se\u0016tGoQ1uC2|wMT1nK~#S-\u001d\u000b\u0005\u0003'\t)\u0004C\u0005\u0002\u001cM\t\t\u00111\u0001\u00020\u0005!rlY;se\u0016tGoQ1uC2|wMT1nK\u0002\nabY;se\u0016tGoQ1uC2|w-A\ttKR\u001cUO\u001d:f]R\u001c\u0015\r^1m_\u001e$B!a\u0005\u0002@!1\u0011\u0011\t\fA\u0002u\u000b1bY1uC2|wMT1nK\u0006)!/Z:fiR\u0011\u00111C\u0001\u000f\u0007\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s!\t\u0001\u0015d\u0005\u0002\u001aWQ\u0011\u0011\u0011J\u0001\u0015'\u0016\u001b6+S(O?\u000e\u000bE+\u0011'P\u000f~s\u0015)T#\u0016\u0003u\u000bQcU#T'&{ejX\"B)\u0006cujR0O\u00036+\u0005\u0005")
public class CatalogManager
implements Logging {
    private final SQLConf conf;
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public synchronized CatalogPlugin catalog(String name) {
        return name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) ? this.v2SessionCatalog() : (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable & scala.Serializable)() -> Catalogs.load(name, $this.conf));
    }

    private Option<CatalogPlugin> defaultCatalog() {
        return this.conf.defaultV2Catalog().flatMap((Function1 & Serializable & scala.Serializable)catalogName -> {
            Some some;
            try {
                some = new Some((Object)this.catalog((String)catalogName));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Cannot load default v2 catalog: ").append((String)catalogName).toString(), e);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        });
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin;
        CatalogPlugin catalogPlugin2 = Catalogs.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf);
        if (catalogPlugin2 instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin2;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            catalogPlugin = catalogExtension;
        } else {
            catalogPlugin = catalogPlugin2;
        }
        return catalogPlugin;
    }

    private CatalogPlugin v2SessionCatalog() {
        return (CatalogPlugin)this.conf.getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).map((Function1 & Serializable & scala.Serializable)customV2SessionCatalog -> {
            CatalogPlugin catalogPlugin;
            try {
                catalogPlugin = (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable & scala.Serializable)() -> this.loadV2SessionCatalog());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Fail to instantiate the custom v2 session catalog: ").append((String)customV2SessionCatalog).toString());
                CatalogPlugin catalogPlugin2 = $this.defaultSessionCatalog;
                catalogPlugin = catalogPlugin2;
            }
            return catalogPlugin;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultSessionCatalog);
    }

    private String[] getDefaultNamespace(CatalogPlugin c) {
        String[] stringArray;
        CatalogPlugin catalogPlugin = c;
        if (catalogPlugin instanceof SupportsNamespaces) {
            SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalogPlugin;
            stringArray = supportsNamespaces.defaultNamespace();
        } else {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public synchronized String[] currentNamespace() {
        return (String[])this._currentNamespace().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = this.currentCatalog().name();
            String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            return !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.getDefaultNamespace(this.currentCatalog());
        });
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (namespace.length != 1) {
                throw new NoSuchNamespaceException(namespace);
            }
            this.v1SessionCatalog().setCurrentDatabase((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head());
        } else {
            this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
        }
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return (CatalogPlugin)this._currentCatalogName().map((Function1 & Serializable & scala.Serializable)catalogName -> this.catalog((String)catalogName)).orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultCatalog()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.v2SessionCatalog());
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        block0: {
            String string = this.currentCatalog().name();
            String string2 = catalogName;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
        }
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
    }

    public CatalogManager(SQLConf conf, CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.conf = conf;
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

