/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Private;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils;
import scala.collection.JavaConverters;

@Private
public class Catalogs {
    private Catalogs() {
    }

    public static CatalogPlugin load(String name, SQLConf conf) throws CatalogNotFoundException, SparkException {
        String pluginClassName;
        try {
            pluginClassName = conf.getConfString("spark.sql.catalog." + name);
        }
        catch (NoSuchElementException e) {
            throw new CatalogNotFoundException(String.format("Catalog '%s' plugin class not found: spark.sql.catalog.%s is not defined", name, name));
        }
        ClassLoader loader = Utils.getContextOrSparkClassLoader();
        try {
            Class<?> pluginClass = loader.loadClass(pluginClassName);
            if (!CatalogPlugin.class.isAssignableFrom(pluginClass)) {
                throw new SparkException(String.format("Plugin class for catalog '%s' does not implement CatalogPlugin: %s", name, pluginClassName));
            }
            CatalogPlugin plugin = (CatalogPlugin)CatalogPlugin.class.cast(pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            plugin.initialize(name, Catalogs.catalogOptions(name, conf));
            return plugin;
        }
        catch (ClassNotFoundException e) {
            throw new SparkException(String.format("Cannot find catalog plugin class for catalog '%s': %s", name, pluginClassName));
        }
        catch (NoSuchMethodException e) {
            throw new SparkException(String.format("Failed to find public no-arg constructor for catalog '%s': %s", name, pluginClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SparkException(String.format("Failed to call public no-arg constructor for catalog '%s': %s", name, pluginClassName), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SparkException(String.format("Cannot instantiate abstract catalog plugin class for catalog '%s': %s", name, pluginClassName), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new SparkException(String.format("Failed during instantiating constructor for catalog '%s': %s", name, pluginClassName), e.getCause());
        }
    }

    private static CaseInsensitiveStringMap catalogOptions(String name, SQLConf conf) {
        Map allConfs = (Map)JavaConverters.mapAsJavaMapConverter(conf.getAllConfs()).asJava();
        Pattern prefix = Pattern.compile("^spark\\.sql\\.catalog\\." + name + "\\.(.+)");
        HashMap<String, String> options = new HashMap<String, String>();
        for (Map.Entry entry : allConfs.entrySet()) {
            Matcher matcher = prefix.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || matcher.groupCount() <= 0) continue;
            options.put(matcher.group(1), (String)entry.getValue());
        }
        return new CaseInsensitiveStringMap(options);
    }
}

