/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.sparkproject.guava.base.Preconditions;

@Experimental
class IdentifierImpl
implements Identifier {
    private String[] namespace;
    private String name;

    IdentifierImpl(String[] namespace, String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Identifier namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Identifier name cannot be null");
        this.namespace = namespace;
        this.name = name;
    }

    @Override
    public String[] namespace() {
        return this.namespace;
    }

    @Override
    public String name() {
        return this.name;
    }

    private String escapeQuote(String part) {
        if (part.contains("`")) {
            return part.replace("`", "``");
        }
        return part;
    }

    public String toString() {
        return Stream.concat(Stream.of(this.namespace), Stream.of(this.name)).map(part -> '`' + this.escapeQuote((String)part) + '`').collect(Collectors.joining("."));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierImpl that = (IdentifierImpl)o;
        return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.namespace), this.name);
    }
}

