/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;

@Experimental
public interface TableCatalog
extends CatalogPlugin {
    public Identifier[] listTables(String[] var1) throws NoSuchNamespaceException;

    public Table loadTable(Identifier var1) throws NoSuchTableException;

    default public void invalidateTable(Identifier ident) {
    }

    default public boolean tableExists(Identifier ident) {
        try {
            return this.loadTable(ident) != null;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public Table createTable(Identifier var1, StructType var2, Transform[] var3, Map<String, String> var4) throws TableAlreadyExistsException, NoSuchNamespaceException;

    public Table alterTable(Identifier var1, TableChange ... var2) throws NoSuchTableException;

    public boolean dropTable(Identifier var1);

    public void renameTable(Identifier var1, Identifier var2) throws NoSuchTableException, TableAlreadyExistsException;
}

